#!/bin/bash

echo ""

rm -f test_nonsym_density_serial.dat test_nonsym_density_1_vec.dat test_nonsym_density_2_vec.dat test_nonsym_force_1_vec.dat test_nonsym_force_2_vec.dat

echo "Running ./testInteractions"

./testInteractions

if [ $? != 0 ]; then
  echo "testInteractions is redundant when vectorisation is disabled"
else
  if [ -e test_nonsym_density_serial.dat ]
  then
    if python3 ./difffloat.py test_nonsym_density_serial.dat test_nonsym_density_1_vec.dat ./tolerance_testInteractions.dat
    then
      echo "Calculating density using 1 vector accuracy test passed"
    else
      echo "Calculating density using 1 vector accuracy test failed"
      exit 1
    fi
    if python3 ./difffloat.py test_nonsym_density_serial.dat test_nonsym_density_2_vec.dat ./tolerance_testInteractions.dat
    then
      echo "Calculating density using 2 vectors accuracy test passed"
    else
      echo "Calculating density using 2 vectors accuracy test failed"
      exit 1
    fi
  else
    echo "Error Missing density test output file"
    exit 1
  fi
  if [ -e test_nonsym_force_serial.dat ]
  then
    if python3 ./difffloat.py test_nonsym_force_serial.dat test_nonsym_force_1_vec.dat ./tolerance_testInteractions.dat
    then
      echo "Calculating force using 1 vector accuracy test passed"
    else
      echo "Calculating force using 1 vector accuracy test failed"
      exit 1
    fi
    if python3 ./difffloat.py test_nonsym_force_serial.dat test_nonsym_force_2_vec.dat ./tolerance_testInteractions.dat
    then
      echo "Calculating force using 2 vectors accuracy test passed"
    else
      echo "Calculating force using 2 vectors accuracy test failed"
      exit 1
    fi
  else
    echo "Error Missing force test output file"
    exit 1
  fi
fi

echo "------------"
