#!/bin/bash

# Test for particles with the same smoothing length
for v in {0..3}
do
    echo ""

    rm -f brute_force_27_perturbed.dat swift_dopair_27_perturbed.dat

    echo "Running ./test27cells -n 6 -r 1 -d 0.1 -f perturbed -v $v"
    ./test27cells -n 6 -r 1 -d 0.1 -f perturbed -v $v

    if [ -e brute_force_27_perturbed.dat ]
    then
	if python3 ./difffloat.py brute_force_27_perturbed.dat swift_dopair_27_perturbed.dat ./tolerance_27_perturbed.dat 6
	then
	    echo "Accuracy test passed"
	else
	    echo "Accuracy test failed"
	    exit 1
	fi
    else
	echo "Error Missing test output file"
	exit 1
    fi

    echo "------------"

done

# Test for particles with random smoothing lengths
for v in {0..3}
do
    echo ""

    rm -f brute_force_27_perturbed.dat swift_dopair_27_perturbed.dat

    echo "Running ./test27cells -n 6 -r 1 -d 0.1 -f perturbed -v $v -p 1.1"
    ./test27cells -n 6 -r 1 -d 0.1 -f perturbed -v $v -p 1.1

    if [ -e brute_force_27_perturbed.dat ]
    then
	if python3 ./difffloat.py brute_force_27_perturbed.dat swift_dopair_27_perturbed.dat ./tolerance_27_perturbed_h.dat 6
	then
	    echo "Accuracy test passed"
	else
	    echo "Accuracy test failed"
	    exit 1
	fi
    else
	echo "Error Missing test output file"
	exit 1
    fi

    echo "------------"

done

# Test for particles with random smoothing lengths
for v in {0..3}
do
    echo ""

    rm -f brute_force_27_perturbed.dat swift_dopair_27_perturbed.dat

    echo "Running ./test27cells -n 6 -r 1 -d 0.1 -f perturbed -v $v -p 1.3"
    ./test27cells -n 6 -r 1 -d 0.1 -f perturbed -v $v -p 1.3

    if [ -e brute_force_27_perturbed.dat ]
    then
	if python3 ./difffloat.py brute_force_27_perturbed.dat swift_dopair_27_perturbed.dat ./tolerance_27_perturbed_h2.dat 6
	then
	    echo "Accuracy test passed"
	else
	    echo "Accuracy test failed"
	    exit 1
	fi
    else
	echo "Error Missing test output file"
	exit 1
    fi

    echo "------------"

done
exit $?
