/*******************************************************************************
 * This file is part of SWIFT.
 * Copyright (c) 2021 Mladen Ivkovic (mladen.ivkovic@hotmail.com)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

#ifndef RT_RIEMANN_HLL_EIGENVALUES_H
#define RT_RIEMANN_HLL_EIGENVALUES_H

/**
 * @file src/rt/GEAR/rt_riemann_HLL_eigenvalues.h
 * @brief Contains the tabulated eigenvalues for the
 * HLL RT Riemann solver following Gonzalez et al 2007
 * (ui.adsabs.harvard.edu/abs/2007A%26A...464..429G).
 *
 * For more details on how these eigenvalues are computed, look
 * into /theory/RadiativeTransfer/HLLRiemannSolverEigenvalues
 * */

/* We store the minimal and maximal eigenvalues for
 * RT_RIEMANN_HLL_NPOINTS different values of
 * 0 < f < 1 and 0 < theta < pi.
 *
 * First index:   f
 * Second index:  theta
 * [f][theta][0]: min eigenvalue
 * [f][theta][1]: max eigenvalue
 * */
static float rt_riemann_HLL_eigenvals
    [RT_RIEMANN_HLL_NPOINTS][RT_RIEMANN_HLL_NPOINTS][2] = {
        {
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
            {-.577350E+00, 0.577350E+00}, {-.577350E+00, 0.577350E+00},
        },
        {
            {-.572277E+00, 0.582379E+00}, {-.572280E+00, 0.582376E+00},
            {-.572288E+00, 0.582369E+00}, {-.572300E+00, 0.582356E+00},
            {-.572318E+00, 0.582338E+00}, {-.572341E+00, 0.582316E+00},
            {-.572369E+00, 0.582288E+00}, {-.572402E+00, 0.582255E+00},
            {-.572440E+00, 0.582218E+00}, {-.572483E+00, 0.582175E+00},
            {-.572531E+00, 0.582128E+00}, {-.572583E+00, 0.582076E+00},
            {-.572641E+00, 0.582019E+00}, {-.572703E+00, 0.581957E+00},
            {-.572770E+00, 0.581891E+00}, {-.572841E+00, 0.581820E+00},
            {-.572917E+00, 0.581744E+00}, {-.572998E+00, 0.581665E+00},
            {-.573082E+00, 0.581580E+00}, {-.573172E+00, 0.581492E+00},
            {-.573265E+00, 0.581399E+00}, {-.573362E+00, 0.581303E+00},
            {-.573464E+00, 0.581202E+00}, {-.573569E+00, 0.581097E+00},
            {-.573678E+00, 0.580989E+00}, {-.573791E+00, 0.580877E+00},
            {-.573907E+00, 0.580761E+00}, {-.574027E+00, 0.580642E+00},
            {-.574150E+00, 0.580520E+00}, {-.574276E+00, 0.580394E+00},
            {-.574406E+00, 0.580265E+00}, {-.574538E+00, 0.580134E+00},
            {-.574673E+00, 0.579999E+00}, {-.574811E+00, 0.579862E+00},
            {-.574951E+00, 0.579722E+00}, {-.575094E+00, 0.579580E+00},
            {-.575239E+00, 0.579435E+00}, {-.575386E+00, 0.579289E+00},
            {-.575535E+00, 0.579140E+00}, {-.575686E+00, 0.578990E+00},
            {-.575839E+00, 0.578838E+00}, {-.575993E+00, 0.578684E+00},
            {-.576148E+00, 0.578529E+00}, {-.576304E+00, 0.578373E+00},
            {-.576462E+00, 0.578216E+00}, {-.576620E+00, 0.578058E+00},
            {-.576779E+00, 0.577899E+00}, {-.576939E+00, 0.577739E+00},
            {-.577099E+00, 0.577580E+00}, {-.577259E+00, 0.577419E+00},
            {-.577419E+00, 0.577259E+00}, {-.577580E+00, 0.577099E+00},
            {-.577739E+00, 0.576939E+00}, {-.577899E+00, 0.576779E+00},
            {-.578058E+00, 0.576620E+00}, {-.578216E+00, 0.576462E+00},
            {-.578373E+00, 0.576304E+00}, {-.578529E+00, 0.576148E+00},
            {-.578684E+00, 0.575993E+00}, {-.578838E+00, 0.575839E+00},
            {-.578990E+00, 0.575686E+00}, {-.579140E+00, 0.575535E+00},
            {-.579289E+00, 0.575386E+00}, {-.579435E+00, 0.575239E+00},
            {-.579580E+00, 0.575094E+00}, {-.579722E+00, 0.574951E+00},
            {-.579862E+00, 0.574811E+00}, {-.579999E+00, 0.574673E+00},
            {-.580134E+00, 0.574538E+00}, {-.580265E+00, 0.574406E+00},
            {-.580394E+00, 0.574276E+00}, {-.580520E+00, 0.574150E+00},
            {-.580642E+00, 0.574027E+00}, {-.580761E+00, 0.573907E+00},
            {-.580877E+00, 0.573791E+00}, {-.580989E+00, 0.573678E+00},
            {-.581097E+00, 0.573569E+00}, {-.581202E+00, 0.573464E+00},
            {-.581303E+00, 0.573362E+00}, {-.581399E+00, 0.573265E+00},
            {-.581492E+00, 0.573172E+00}, {-.581580E+00, 0.573082E+00},
            {-.581665E+00, 0.572998E+00}, {-.581744E+00, 0.572917E+00},
            {-.581820E+00, 0.572841E+00}, {-.581891E+00, 0.572770E+00},
            {-.581957E+00, 0.572703E+00}, {-.582019E+00, 0.572641E+00},
            {-.582076E+00, 0.572583E+00}, {-.582128E+00, 0.572531E+00},
            {-.582175E+00, 0.572483E+00}, {-.582218E+00, 0.572440E+00},
            {-.582255E+00, 0.572402E+00}, {-.582288E+00, 0.572369E+00},
            {-.582316E+00, 0.572341E+00}, {-.582338E+00, 0.572318E+00},
            {-.582356E+00, 0.572300E+00}, {-.582369E+00, 0.572288E+00},
            {-.582376E+00, 0.572280E+00}, {-.582379E+00, 0.572277E+00},
        },
        {
            {-.567159E+00, 0.587364E+00}, {-.567164E+00, 0.587359E+00},
            {-.567180E+00, 0.587344E+00}, {-.567205E+00, 0.587319E+00},
            {-.567241E+00, 0.587284E+00}, {-.567287E+00, 0.587239E+00},
            {-.567343E+00, 0.587183E+00}, {-.567410E+00, 0.587118E+00},
            {-.567486E+00, 0.587043E+00}, {-.567572E+00, 0.586959E+00},
            {-.567668E+00, 0.586864E+00}, {-.567774E+00, 0.586760E+00},
            {-.567889E+00, 0.586647E+00}, {-.568014E+00, 0.586524E+00},
            {-.568148E+00, 0.586392E+00}, {-.568292E+00, 0.586251E+00},
            {-.568444E+00, 0.586100E+00}, {-.568606E+00, 0.585941E+00},
            {-.568776E+00, 0.585774E+00}, {-.568955E+00, 0.585597E+00},
            {-.569142E+00, 0.585413E+00}, {-.569338E+00, 0.585220E+00},
            {-.569541E+00, 0.585019E+00}, {-.569752E+00, 0.584811E+00},
            {-.569971E+00, 0.584594E+00}, {-.570198E+00, 0.584371E+00},
            {-.570431E+00, 0.584140E+00}, {-.570671E+00, 0.583903E+00},
            {-.570918E+00, 0.583659E+00}, {-.571172E+00, 0.583408E+00},
            {-.571431E+00, 0.583151E+00}, {-.571697E+00, 0.582889E+00},
            {-.571967E+00, 0.582620E+00}, {-.572244E+00, 0.582346E+00},
            {-.572525E+00, 0.582067E+00}, {-.572811E+00, 0.581784E+00},
            {-.573102E+00, 0.581495E+00}, {-.573396E+00, 0.581203E+00},
            {-.573695E+00, 0.580906E+00}, {-.573997E+00, 0.580606E+00},
            {-.574303E+00, 0.580302E+00}, {-.574611E+00, 0.579995E+00},
            {-.574922E+00, 0.579685E+00}, {-.575235E+00, 0.579373E+00},
            {-.575550E+00, 0.579059E+00}, {-.575867E+00, 0.578743E+00},
            {-.576186E+00, 0.578425E+00}, {-.576505E+00, 0.578106E+00},
            {-.576825E+00, 0.577787E+00}, {-.577146E+00, 0.577466E+00},
            {-.577466E+00, 0.577146E+00}, {-.577787E+00, 0.576825E+00},
            {-.578106E+00, 0.576505E+00}, {-.578425E+00, 0.576186E+00},
            {-.578743E+00, 0.575867E+00}, {-.579059E+00, 0.575550E+00},
            {-.579373E+00, 0.575235E+00}, {-.579685E+00, 0.574922E+00},
            {-.579995E+00, 0.574611E+00}, {-.580302E+00, 0.574303E+00},
            {-.580606E+00, 0.573997E+00}, {-.580906E+00, 0.573695E+00},
            {-.581203E+00, 0.573396E+00}, {-.581495E+00, 0.573102E+00},
            {-.581784E+00, 0.572811E+00}, {-.582067E+00, 0.572525E+00},
            {-.582346E+00, 0.572244E+00}, {-.582620E+00, 0.571967E+00},
            {-.582889E+00, 0.571697E+00}, {-.583151E+00, 0.571431E+00},
            {-.583408E+00, 0.571172E+00}, {-.583659E+00, 0.570918E+00},
            {-.583903E+00, 0.570671E+00}, {-.584140E+00, 0.570431E+00},
            {-.584371E+00, 0.570198E+00}, {-.584594E+00, 0.569971E+00},
            {-.584811E+00, 0.569752E+00}, {-.585019E+00, 0.569541E+00},
            {-.585220E+00, 0.569338E+00}, {-.585413E+00, 0.569142E+00},
            {-.585597E+00, 0.568955E+00}, {-.585774E+00, 0.568776E+00},
            {-.585941E+00, 0.568606E+00}, {-.586100E+00, 0.568444E+00},
            {-.586251E+00, 0.568292E+00}, {-.586392E+00, 0.568148E+00},
            {-.586524E+00, 0.568014E+00}, {-.586647E+00, 0.567889E+00},
            {-.586760E+00, 0.567774E+00}, {-.586864E+00, 0.567668E+00},
            {-.586959E+00, 0.567572E+00}, {-.587043E+00, 0.567486E+00},
            {-.587118E+00, 0.567410E+00}, {-.587183E+00, 0.567343E+00},
            {-.587239E+00, 0.567287E+00}, {-.587284E+00, 0.567241E+00},
            {-.587319E+00, 0.567205E+00}, {-.587344E+00, 0.567180E+00},
            {-.587359E+00, 0.567164E+00}, {-.587364E+00, 0.567159E+00},
        },
        {
            {-.561995E+00, 0.592308E+00}, {-.562002E+00, 0.592301E+00},
            {-.562026E+00, 0.592278E+00}, {-.562064E+00, 0.592240E+00},
            {-.562118E+00, 0.592188E+00}, {-.562187E+00, 0.592120E+00},
            {-.562272E+00, 0.592038E+00}, {-.562372E+00, 0.591941E+00},
            {-.562487E+00, 0.591829E+00}, {-.562616E+00, 0.591702E+00},
            {-.562761E+00, 0.591561E+00}, {-.562920E+00, 0.591406E+00},
            {-.563094E+00, 0.591236E+00}, {-.563282E+00, 0.591053E+00},
            {-.563484E+00, 0.590855E+00}, {-.563700E+00, 0.590644E+00},
            {-.563930E+00, 0.590420E+00}, {-.564173E+00, 0.590182E+00},
            {-.564430E+00, 0.589931E+00}, {-.564699E+00, 0.589668E+00},
            {-.564981E+00, 0.589392E+00}, {-.565275E+00, 0.589103E+00},
            {-.565582E+00, 0.588803E+00}, {-.565900E+00, 0.588491E+00},
            {-.566229E+00, 0.588168E+00}, {-.566570E+00, 0.587834E+00},
            {-.566921E+00, 0.587489E+00}, {-.567283E+00, 0.587134E+00},
            {-.567654E+00, 0.586768E+00}, {-.568035E+00, 0.586393E+00},
            {-.568426E+00, 0.586009E+00}, {-.568825E+00, 0.585616E+00},
            {-.569232E+00, 0.585214E+00}, {-.569648E+00, 0.584804E+00},
            {-.570071E+00, 0.584387E+00}, {-.570501E+00, 0.583962E+00},
            {-.570937E+00, 0.583530E+00}, {-.571380E+00, 0.583092E+00},
            {-.571829E+00, 0.582647E+00}, {-.572283E+00, 0.582197E+00},
            {-.572742E+00, 0.581742E+00}, {-.573205E+00, 0.581283E+00},
            {-.573672E+00, 0.580819E+00}, {-.574142E+00, 0.580351E+00},
            {-.574616E+00, 0.579880E+00}, {-.575092E+00, 0.579406E+00},
            {-.575570E+00, 0.578930E+00}, {-.576049E+00, 0.578451E+00},
            {-.576529E+00, 0.577972E+00}, {-.577010E+00, 0.577491E+00},
            {-.577491E+00, 0.577010E+00}, {-.577972E+00, 0.576529E+00},
            {-.578451E+00, 0.576049E+00}, {-.578930E+00, 0.575570E+00},
            {-.579406E+00, 0.575092E+00}, {-.579880E+00, 0.574616E+00},
            {-.580351E+00, 0.574142E+00}, {-.580819E+00, 0.573672E+00},
            {-.581283E+00, 0.573205E+00}, {-.581742E+00, 0.572742E+00},
            {-.582197E+00, 0.572283E+00}, {-.582647E+00, 0.571829E+00},
            {-.583092E+00, 0.571380E+00}, {-.583530E+00, 0.570937E+00},
            {-.583962E+00, 0.570501E+00}, {-.584387E+00, 0.570071E+00},
            {-.584804E+00, 0.569648E+00}, {-.585214E+00, 0.569232E+00},
            {-.585616E+00, 0.568825E+00}, {-.586009E+00, 0.568426E+00},
            {-.586393E+00, 0.568035E+00}, {-.586768E+00, 0.567654E+00},
            {-.587134E+00, 0.567283E+00}, {-.587489E+00, 0.566921E+00},
            {-.587834E+00, 0.566570E+00}, {-.588168E+00, 0.566229E+00},
            {-.588491E+00, 0.565900E+00}, {-.588803E+00, 0.565582E+00},
            {-.589103E+00, 0.565275E+00}, {-.589392E+00, 0.564981E+00},
            {-.589668E+00, 0.564699E+00}, {-.589931E+00, 0.564430E+00},
            {-.590182E+00, 0.564173E+00}, {-.590420E+00, 0.563930E+00},
            {-.590644E+00, 0.563700E+00}, {-.590855E+00, 0.563484E+00},
            {-.591053E+00, 0.563282E+00}, {-.591236E+00, 0.563094E+00},
            {-.591406E+00, 0.562920E+00}, {-.591561E+00, 0.562761E+00},
            {-.591702E+00, 0.562616E+00}, {-.591829E+00, 0.562487E+00},
            {-.591941E+00, 0.562372E+00}, {-.592038E+00, 0.562272E+00},
            {-.592120E+00, 0.562187E+00}, {-.592188E+00, 0.562118E+00},
            {-.592240E+00, 0.562064E+00}, {-.592278E+00, 0.562026E+00},
            {-.592301E+00, 0.562002E+00}, {-.592308E+00, 0.561995E+00},
        },
        {
            {-.556782E+00, 0.597211E+00}, {-.556792E+00, 0.597201E+00},
            {-.556824E+00, 0.597171E+00}, {-.556875E+00, 0.597121E+00},
            {-.556948E+00, 0.597051E+00}, {-.557040E+00, 0.596961E+00},
            {-.557154E+00, 0.596852E+00}, {-.557287E+00, 0.596723E+00},
            {-.557441E+00, 0.596574E+00}, {-.557615E+00, 0.596406E+00},
            {-.557809E+00, 0.596219E+00}, {-.558022E+00, 0.596013E+00},
            {-.558255E+00, 0.595787E+00}, {-.558506E+00, 0.595544E+00},
            {-.558777E+00, 0.595281E+00}, {-.559066E+00, 0.595001E+00},
            {-.559374E+00, 0.594703E+00}, {-.559700E+00, 0.594387E+00},
            {-.560043E+00, 0.594054E+00}, {-.560403E+00, 0.593704E+00},
            {-.560781E+00, 0.593337E+00}, {-.561174E+00, 0.592954E+00},
            {-.561584E+00, 0.592555E+00}, {-.562010E+00, 0.592140E+00},
            {-.562451E+00, 0.591711E+00}, {-.562906E+00, 0.591266E+00},
            {-.563376E+00, 0.590808E+00}, {-.563860E+00, 0.590335E+00},
            {-.564357E+00, 0.589849E+00}, {-.564866E+00, 0.589351E+00},
            {-.565388E+00, 0.588839E+00}, {-.565922E+00, 0.588316E+00},
            {-.566467E+00, 0.587782E+00}, {-.567022E+00, 0.587236E+00},
            {-.567587E+00, 0.586681E+00}, {-.568162E+00, 0.586115E+00},
            {-.568745E+00, 0.585540E+00}, {-.569337E+00, 0.584957E+00},
            {-.569937E+00, 0.584365E+00}, {-.570543E+00, 0.583766E+00},
            {-.571156E+00, 0.583160E+00}, {-.571774E+00, 0.582547E+00},
            {-.572398E+00, 0.581929E+00}, {-.573026E+00, 0.581306E+00},
            {-.573658E+00, 0.580678E+00}, {-.574293E+00, 0.580047E+00},
            {-.574931E+00, 0.579412E+00}, {-.575570E+00, 0.578774E+00},
            {-.576211E+00, 0.578135E+00}, {-.576853E+00, 0.577494E+00},
            {-.577494E+00, 0.576853E+00}, {-.578135E+00, 0.576211E+00},
            {-.578774E+00, 0.575570E+00}, {-.579412E+00, 0.574931E+00},
            {-.580047E+00, 0.574293E+00}, {-.580678E+00, 0.573658E+00},
            {-.581306E+00, 0.573026E+00}, {-.581929E+00, 0.572398E+00},
            {-.582547E+00, 0.571774E+00}, {-.583160E+00, 0.571156E+00},
            {-.583766E+00, 0.570543E+00}, {-.584365E+00, 0.569937E+00},
            {-.584957E+00, 0.569337E+00}, {-.585540E+00, 0.568745E+00},
            {-.586115E+00, 0.568162E+00}, {-.586681E+00, 0.567587E+00},
            {-.587236E+00, 0.567022E+00}, {-.587782E+00, 0.566467E+00},
            {-.588316E+00, 0.565922E+00}, {-.588839E+00, 0.565388E+00},
            {-.589351E+00, 0.564866E+00}, {-.589849E+00, 0.564357E+00},
            {-.590335E+00, 0.563860E+00}, {-.590808E+00, 0.563376E+00},
            {-.591266E+00, 0.562906E+00}, {-.591711E+00, 0.562451E+00},
            {-.592140E+00, 0.562010E+00}, {-.592555E+00, 0.561584E+00},
            {-.592954E+00, 0.561174E+00}, {-.593337E+00, 0.560781E+00},
            {-.593704E+00, 0.560403E+00}, {-.594054E+00, 0.560043E+00},
            {-.594387E+00, 0.559700E+00}, {-.594703E+00, 0.559374E+00},
            {-.595001E+00, 0.559066E+00}, {-.595281E+00, 0.558777E+00},
            {-.595544E+00, 0.558506E+00}, {-.595787E+00, 0.558255E+00},
            {-.596013E+00, 0.558022E+00}, {-.596219E+00, 0.557809E+00},
            {-.596406E+00, 0.557615E+00}, {-.596574E+00, 0.557441E+00},
            {-.596723E+00, 0.557287E+00}, {-.596852E+00, 0.557154E+00},
            {-.596961E+00, 0.557040E+00}, {-.597051E+00, 0.556948E+00},
            {-.597121E+00, 0.556875E+00}, {-.597171E+00, 0.556824E+00},
            {-.597201E+00, 0.556792E+00}, {-.597211E+00, 0.556782E+00},
        },
        {
            {-.551521E+00, 0.602074E+00}, {-.551534E+00, 0.602061E+00},
            {-.551573E+00, 0.602024E+00}, {-.551637E+00, 0.601962E+00},
            {-.551728E+00, 0.601875E+00}, {-.551845E+00, 0.601763E+00},
            {-.551987E+00, 0.601627E+00}, {-.552155E+00, 0.601466E+00},
            {-.552348E+00, 0.601281E+00}, {-.552566E+00, 0.601072E+00},
            {-.552809E+00, 0.600839E+00}, {-.553077E+00, 0.600582E+00},
            {-.553369E+00, 0.600302E+00}, {-.553685E+00, 0.599998E+00},
            {-.554025E+00, 0.599671E+00}, {-.554388E+00, 0.599322E+00},
            {-.554775E+00, 0.598951E+00}, {-.555183E+00, 0.598557E+00},
            {-.555614E+00, 0.598142E+00}, {-.556066E+00, 0.597706E+00},
            {-.556540E+00, 0.597249E+00}, {-.557034E+00, 0.596772E+00},
            {-.557548E+00, 0.596275E+00}, {-.558082E+00, 0.595758E+00},
            {-.558635E+00, 0.595223E+00}, {-.559207E+00, 0.594669E+00},
            {-.559796E+00, 0.594097E+00}, {-.560402E+00, 0.593508E+00},
            {-.561025E+00, 0.592902E+00}, {-.561664E+00, 0.592280E+00},
            {-.562319E+00, 0.591643E+00}, {-.562988E+00, 0.590990E+00},
            {-.563670E+00, 0.590323E+00}, {-.564366E+00, 0.589643E+00},
            {-.565075E+00, 0.588949E+00}, {-.565795E+00, 0.588244E+00},
            {-.566526E+00, 0.587526E+00}, {-.567267E+00, 0.586798E+00},
            {-.568018E+00, 0.586059E+00}, {-.568777E+00, 0.585311E+00},
            {-.569544E+00, 0.584554E+00}, {-.570318E+00, 0.583790E+00},
            {-.571099E+00, 0.583018E+00}, {-.571885E+00, 0.582239E+00},
            {-.572676E+00, 0.581455E+00}, {-.573471E+00, 0.580665E+00},
            {-.574269E+00, 0.579872E+00}, {-.575069E+00, 0.579075E+00},
            {-.575870E+00, 0.578276E+00}, {-.576673E+00, 0.577475E+00},
            {-.577475E+00, 0.576673E+00}, {-.578276E+00, 0.575870E+00},
            {-.579075E+00, 0.575069E+00}, {-.579872E+00, 0.574269E+00},
            {-.580665E+00, 0.573471E+00}, {-.581455E+00, 0.572676E+00},
            {-.582239E+00, 0.571885E+00}, {-.583018E+00, 0.571099E+00},
            {-.583790E+00, 0.570318E+00}, {-.584554E+00, 0.569544E+00},
            {-.585311E+00, 0.568777E+00}, {-.586059E+00, 0.568018E+00},
            {-.586798E+00, 0.567267E+00}, {-.587526E+00, 0.566526E+00},
            {-.588244E+00, 0.565795E+00}, {-.588949E+00, 0.565075E+00},
            {-.589643E+00, 0.564366E+00}, {-.590323E+00, 0.563670E+00},
            {-.590990E+00, 0.562988E+00}, {-.591643E+00, 0.562319E+00},
            {-.592280E+00, 0.561664E+00}, {-.592902E+00, 0.561025E+00},
            {-.593508E+00, 0.560402E+00}, {-.594097E+00, 0.559796E+00},
            {-.594669E+00, 0.559207E+00}, {-.595223E+00, 0.558635E+00},
            {-.595758E+00, 0.558082E+00}, {-.596275E+00, 0.557548E+00},
            {-.596772E+00, 0.557034E+00}, {-.597249E+00, 0.556540E+00},
            {-.597706E+00, 0.556066E+00}, {-.598142E+00, 0.555614E+00},
            {-.598557E+00, 0.555183E+00}, {-.598951E+00, 0.554775E+00},
            {-.599322E+00, 0.554388E+00}, {-.599671E+00, 0.554025E+00},
            {-.599998E+00, 0.553685E+00}, {-.600302E+00, 0.553369E+00},
            {-.600582E+00, 0.553077E+00}, {-.600839E+00, 0.552809E+00},
            {-.601072E+00, 0.552566E+00}, {-.601281E+00, 0.552348E+00},
            {-.601466E+00, 0.552155E+00}, {-.601627E+00, 0.551987E+00},
            {-.601763E+00, 0.551845E+00}, {-.601875E+00, 0.551728E+00},
            {-.601962E+00, 0.551637E+00}, {-.602024E+00, 0.551573E+00},
            {-.602061E+00, 0.551534E+00}, {-.602074E+00, 0.551521E+00},
        },
        {
            {-.546209E+00, 0.606898E+00}, {-.546224E+00, 0.606883E+00},
            {-.546271E+00, 0.606839E+00}, {-.546350E+00, 0.606764E+00},
            {-.546459E+00, 0.606660E+00}, {-.546600E+00, 0.606527E+00},
            {-.546771E+00, 0.606364E+00}, {-.546973E+00, 0.606172E+00},
            {-.547206E+00, 0.605951E+00}, {-.547469E+00, 0.605701E+00},
            {-.547762E+00, 0.605422E+00}, {-.548085E+00, 0.605115E+00},
            {-.548437E+00, 0.604780E+00}, {-.548818E+00, 0.604417E+00},
            {-.549228E+00, 0.604026E+00}, {-.549665E+00, 0.603609E+00},
            {-.550131E+00, 0.603164E+00}, {-.550623E+00, 0.602694E+00},
            {-.551142E+00, 0.602198E+00}, {-.551687E+00, 0.601676E+00},
            {-.552258E+00, 0.601129E+00}, {-.552853E+00, 0.600558E+00},
            {-.553472E+00, 0.599963E+00}, {-.554116E+00, 0.599345E+00},
            {-.554781E+00, 0.598705E+00}, {-.555470E+00, 0.598042E+00},
            {-.556179E+00, 0.597358E+00}, {-.556909E+00, 0.596653E+00},
            {-.557659E+00, 0.595927E+00}, {-.558428E+00, 0.595183E+00},
            {-.559216E+00, 0.594419E+00}, {-.560021E+00, 0.593638E+00},
            {-.560842E+00, 0.592840E+00}, {-.561680E+00, 0.592025E+00},
            {-.562532E+00, 0.591194E+00}, {-.563398E+00, 0.590348E+00},
            {-.564277E+00, 0.589489E+00}, {-.565169E+00, 0.588616E+00},
            {-.566071E+00, 0.587731E+00}, {-.566984E+00, 0.586834E+00},
            {-.567907E+00, 0.585927E+00}, {-.568837E+00, 0.585010E+00},
            {-.569775E+00, 0.584084E+00}, {-.570720E+00, 0.583150E+00},
            {-.571670E+00, 0.582209E+00}, {-.572625E+00, 0.581262E+00},
            {-.573583E+00, 0.580310E+00}, {-.574544E+00, 0.579354E+00},
            {-.575507E+00, 0.578395E+00}, {-.576470E+00, 0.577433E+00},
            {-.577433E+00, 0.576470E+00}, {-.578395E+00, 0.575507E+00},
            {-.579354E+00, 0.574544E+00}, {-.580310E+00, 0.573583E+00},
            {-.581262E+00, 0.572625E+00}, {-.582209E+00, 0.571670E+00},
            {-.583150E+00, 0.570720E+00}, {-.584084E+00, 0.569775E+00},
            {-.585010E+00, 0.568837E+00}, {-.585927E+00, 0.567907E+00},
            {-.586834E+00, 0.566984E+00}, {-.587731E+00, 0.566071E+00},
            {-.588616E+00, 0.565169E+00}, {-.589489E+00, 0.564277E+00},
            {-.590348E+00, 0.563398E+00}, {-.591194E+00, 0.562532E+00},
            {-.592025E+00, 0.561680E+00}, {-.592840E+00, 0.560842E+00},
            {-.593638E+00, 0.560021E+00}, {-.594419E+00, 0.559216E+00},
            {-.595183E+00, 0.558428E+00}, {-.595927E+00, 0.557659E+00},
            {-.596653E+00, 0.556909E+00}, {-.597358E+00, 0.556179E+00},
            {-.598042E+00, 0.555470E+00}, {-.598705E+00, 0.554781E+00},
            {-.599345E+00, 0.554116E+00}, {-.599963E+00, 0.553472E+00},
            {-.600558E+00, 0.552853E+00}, {-.601129E+00, 0.552258E+00},
            {-.601676E+00, 0.551687E+00}, {-.602198E+00, 0.551142E+00},
            {-.602694E+00, 0.550623E+00}, {-.603164E+00, 0.550131E+00},
            {-.603609E+00, 0.549665E+00}, {-.604026E+00, 0.549228E+00},
            {-.604417E+00, 0.548818E+00}, {-.604780E+00, 0.548437E+00},
            {-.605115E+00, 0.548085E+00}, {-.605422E+00, 0.547762E+00},
            {-.605701E+00, 0.547469E+00}, {-.605951E+00, 0.547206E+00},
            {-.606172E+00, 0.546973E+00}, {-.606364E+00, 0.546771E+00},
            {-.606527E+00, 0.546600E+00}, {-.606660E+00, 0.546459E+00},
            {-.606764E+00, 0.546350E+00}, {-.606839E+00, 0.546271E+00},
            {-.606883E+00, 0.546224E+00}, {-.606898E+00, 0.546209E+00},
        },
        {
            {-.540845E+00, 0.611685E+00}, {-.540863E+00, 0.611668E+00},
            {-.540918E+00, 0.611616E+00}, {-.541010E+00, 0.611529E+00},
            {-.541138E+00, 0.611409E+00}, {-.541303E+00, 0.611253E+00},
            {-.541504E+00, 0.611064E+00}, {-.541741E+00, 0.610841E+00},
            {-.542014E+00, 0.610584E+00}, {-.542323E+00, 0.610293E+00},
            {-.542666E+00, 0.609969E+00}, {-.543044E+00, 0.609612E+00},
            {-.543457E+00, 0.609223E+00}, {-.543903E+00, 0.608801E+00},
            {-.544383E+00, 0.608347E+00}, {-.544896E+00, 0.607861E+00},
            {-.545441E+00, 0.607345E+00}, {-.546018E+00, 0.606798E+00},
            {-.546626E+00, 0.606221E+00}, {-.547265E+00, 0.605614E+00},
            {-.547933E+00, 0.604978E+00}, {-.548630E+00, 0.604314E+00},
            {-.549356E+00, 0.603622E+00}, {-.550109E+00, 0.602903E+00},
            {-.550889E+00, 0.602158E+00}, {-.551694E+00, 0.601387E+00},
            {-.552525E+00, 0.600590E+00}, {-.553380E+00, 0.599770E+00},
            {-.554257E+00, 0.598926E+00}, {-.555158E+00, 0.598059E+00},
            {-.556079E+00, 0.597170E+00}, {-.557021E+00, 0.596261E+00},
            {-.557982E+00, 0.595331E+00}, {-.558962E+00, 0.594382E+00},
            {-.559958E+00, 0.593414E+00}, {-.560972E+00, 0.592429E+00},
            {-.562000E+00, 0.591428E+00}, {-.563042E+00, 0.590411E+00},
            {-.564097E+00, 0.589379E+00}, {-.565165E+00, 0.588334E+00},
            {-.566243E+00, 0.587276E+00}, {-.567330E+00, 0.586207E+00},
            {-.568427E+00, 0.585128E+00}, {-.569530E+00, 0.584039E+00},
            {-.570640E+00, 0.582942E+00}, {-.571756E+00, 0.581837E+00},
            {-.572875E+00, 0.580727E+00}, {-.573997E+00, 0.579611E+00},
            {-.575121E+00, 0.578491E+00}, {-.576245E+00, 0.577369E+00},
            {-.577369E+00, 0.576245E+00}, {-.578491E+00, 0.575121E+00},
            {-.579611E+00, 0.573997E+00}, {-.580727E+00, 0.572875E+00},
            {-.581837E+00, 0.571756E+00}, {-.582942E+00, 0.570640E+00},
            {-.584039E+00, 0.569530E+00}, {-.585128E+00, 0.568427E+00},
            {-.586207E+00, 0.567330E+00}, {-.587276E+00, 0.566243E+00},
            {-.588334E+00, 0.565165E+00}, {-.589379E+00, 0.564097E+00},
            {-.590411E+00, 0.563042E+00}, {-.591428E+00, 0.562000E+00},
            {-.592429E+00, 0.560972E+00}, {-.593414E+00, 0.559958E+00},
            {-.594382E+00, 0.558962E+00}, {-.595331E+00, 0.557982E+00},
            {-.596261E+00, 0.557021E+00}, {-.597170E+00, 0.556079E+00},
            {-.598059E+00, 0.555158E+00}, {-.598926E+00, 0.554257E+00},
            {-.599770E+00, 0.553380E+00}, {-.600590E+00, 0.552525E+00},
            {-.601387E+00, 0.551694E+00}, {-.602158E+00, 0.550889E+00},
            {-.602903E+00, 0.550109E+00}, {-.603622E+00, 0.549356E+00},
            {-.604314E+00, 0.548630E+00}, {-.604978E+00, 0.547933E+00},
            {-.605614E+00, 0.547265E+00}, {-.606221E+00, 0.546626E+00},
            {-.606798E+00, 0.546018E+00}, {-.607345E+00, 0.545441E+00},
            {-.607861E+00, 0.544896E+00}, {-.608347E+00, 0.544383E+00},
            {-.608801E+00, 0.543903E+00}, {-.609223E+00, 0.543457E+00},
            {-.609612E+00, 0.543044E+00}, {-.609969E+00, 0.542666E+00},
            {-.610293E+00, 0.542323E+00}, {-.610584E+00, 0.542014E+00},
            {-.610841E+00, 0.541741E+00}, {-.611064E+00, 0.541504E+00},
            {-.611253E+00, 0.541303E+00}, {-.611409E+00, 0.541138E+00},
            {-.611529E+00, 0.541010E+00}, {-.611616E+00, 0.540918E+00},
            {-.611668E+00, 0.540863E+00}, {-.611685E+00, 0.540845E+00},
        },
        {
            {-.535428E+00, 0.616435E+00}, {-.535449E+00, 0.616415E+00},
            {-.535512E+00, 0.616356E+00}, {-.535618E+00, 0.616258E+00},
            {-.535765E+00, 0.616120E+00}, {-.535954E+00, 0.615944E+00},
            {-.536185E+00, 0.615728E+00}, {-.536458E+00, 0.615474E+00},
            {-.536771E+00, 0.615181E+00}, {-.537125E+00, 0.614850E+00},
            {-.537519E+00, 0.614481E+00}, {-.537954E+00, 0.614075E+00},
            {-.538427E+00, 0.613631E+00}, {-.538940E+00, 0.613151E+00},
            {-.539491E+00, 0.612634E+00}, {-.540079E+00, 0.612081E+00},
            {-.540705E+00, 0.611493E+00}, {-.541367E+00, 0.610870E+00},
            {-.542065E+00, 0.610212E+00}, {-.542798E+00, 0.609521E+00},
            {-.543565E+00, 0.608797E+00}, {-.544365E+00, 0.608040E+00},
            {-.545197E+00, 0.607252E+00}, {-.546061E+00, 0.606432E+00},
            {-.546955E+00, 0.605583E+00}, {-.547879E+00, 0.604704E+00},
            {-.548832E+00, 0.603796E+00}, {-.549812E+00, 0.602860E+00},
            {-.550819E+00, 0.601898E+00}, {-.551851E+00, 0.600910E+00},
            {-.552908E+00, 0.599896E+00}, {-.553987E+00, 0.598858E+00},
            {-.555089E+00, 0.597798E+00}, {-.556211E+00, 0.596715E+00},
            {-.557354E+00, 0.595611E+00}, {-.558514E+00, 0.594487E+00},
            {-.559692E+00, 0.593344E+00}, {-.560886E+00, 0.592183E+00},
            {-.562095E+00, 0.591005E+00}, {-.563317E+00, 0.589812E+00},
            {-.564552E+00, 0.588604E+00}, {-.565797E+00, 0.587383E+00},
            {-.567052E+00, 0.586150E+00}, {-.568315E+00, 0.584906E+00},
            {-.569586E+00, 0.583652E+00}, {-.570862E+00, 0.582390E+00},
            {-.572142E+00, 0.581121E+00}, {-.573426E+00, 0.579846E+00},
            {-.574712E+00, 0.578566E+00}, {-.575998E+00, 0.577283E+00},
            {-.577283E+00, 0.575998E+00}, {-.578566E+00, 0.574712E+00},
            {-.579846E+00, 0.573426E+00}, {-.581121E+00, 0.572142E+00},
            {-.582390E+00, 0.570862E+00}, {-.583652E+00, 0.569586E+00},
            {-.584906E+00, 0.568315E+00}, {-.586150E+00, 0.567052E+00},
            {-.587383E+00, 0.565797E+00}, {-.588604E+00, 0.564552E+00},
            {-.589812E+00, 0.563317E+00}, {-.591005E+00, 0.562095E+00},
            {-.592183E+00, 0.560886E+00}, {-.593344E+00, 0.559692E+00},
            {-.594487E+00, 0.558514E+00}, {-.595611E+00, 0.557354E+00},
            {-.596715E+00, 0.556211E+00}, {-.597798E+00, 0.555089E+00},
            {-.598858E+00, 0.553987E+00}, {-.599896E+00, 0.552908E+00},
            {-.600910E+00, 0.551851E+00}, {-.601898E+00, 0.550819E+00},
            {-.602860E+00, 0.549812E+00}, {-.603796E+00, 0.548832E+00},
            {-.604704E+00, 0.547879E+00}, {-.605583E+00, 0.546955E+00},
            {-.606432E+00, 0.546061E+00}, {-.607252E+00, 0.545197E+00},
            {-.608040E+00, 0.544365E+00}, {-.608797E+00, 0.543565E+00},
            {-.609521E+00, 0.542798E+00}, {-.610212E+00, 0.542065E+00},
            {-.610870E+00, 0.541367E+00}, {-.611493E+00, 0.540705E+00},
            {-.612081E+00, 0.540079E+00}, {-.612634E+00, 0.539491E+00},
            {-.613151E+00, 0.538940E+00}, {-.613631E+00, 0.538427E+00},
            {-.614075E+00, 0.537954E+00}, {-.614481E+00, 0.537519E+00},
            {-.614850E+00, 0.537125E+00}, {-.615181E+00, 0.536771E+00},
            {-.615474E+00, 0.536458E+00}, {-.615728E+00, 0.536185E+00},
            {-.615944E+00, 0.535954E+00}, {-.616120E+00, 0.535765E+00},
            {-.616258E+00, 0.535618E+00}, {-.616356E+00, 0.535512E+00},
            {-.616415E+00, 0.535449E+00}, {-.616435E+00, 0.535428E+00},
        },
        {
            {-.529957E+00, 0.621149E+00}, {-.529980E+00, 0.621127E+00},
            {-.530052E+00, 0.621060E+00}, {-.530171E+00, 0.620950E+00},
            {-.530338E+00, 0.620796E+00}, {-.530552E+00, 0.620598E+00},
            {-.530813E+00, 0.620357E+00}, {-.531120E+00, 0.620072E+00},
            {-.531475E+00, 0.619744E+00}, {-.531875E+00, 0.619373E+00},
            {-.532321E+00, 0.618960E+00}, {-.532811E+00, 0.618504E+00},
            {-.533347E+00, 0.618007E+00}, {-.533926E+00, 0.617468E+00},
            {-.534549E+00, 0.616889E+00}, {-.535214E+00, 0.616269E+00},
            {-.535921E+00, 0.615609E+00}, {-.536669E+00, 0.614910E+00},
            {-.537457E+00, 0.614173E+00}, {-.538285E+00, 0.613398E+00},
            {-.539151E+00, 0.612586E+00}, {-.540055E+00, 0.611737E+00},
            {-.540995E+00, 0.610852E+00}, {-.541971E+00, 0.609933E+00},
            {-.542981E+00, 0.608980E+00}, {-.544024E+00, 0.607993E+00},
            {-.545100E+00, 0.606975E+00}, {-.546207E+00, 0.605925E+00},
            {-.547343E+00, 0.604845E+00}, {-.548508E+00, 0.603735E+00},
            {-.549700E+00, 0.602597E+00}, {-.550919E+00, 0.601432E+00},
            {-.552162E+00, 0.600241E+00}, {-.553428E+00, 0.599024E+00},
            {-.554717E+00, 0.597784E+00}, {-.556026E+00, 0.596521E+00},
            {-.557355E+00, 0.595237E+00}, {-.558701E+00, 0.593933E+00},
            {-.560064E+00, 0.592609E+00}, {-.561442E+00, 0.591268E+00},
            {-.562833E+00, 0.589910E+00}, {-.564237E+00, 0.588537E+00},
            {-.565651E+00, 0.587151E+00}, {-.567075E+00, 0.585751E+00},
            {-.568506E+00, 0.584341E+00}, {-.569944E+00, 0.582922E+00},
            {-.571386E+00, 0.581493E+00}, {-.572832E+00, 0.580059E+00},
            {-.574279E+00, 0.578618E+00}, {-.575727E+00, 0.577174E+00},
            {-.577174E+00, 0.575727E+00}, {-.578618E+00, 0.574279E+00},
            {-.580059E+00, 0.572832E+00}, {-.581493E+00, 0.571386E+00},
            {-.582922E+00, 0.569944E+00}, {-.584341E+00, 0.568506E+00},
            {-.585751E+00, 0.567075E+00}, {-.587151E+00, 0.565651E+00},
            {-.588537E+00, 0.564237E+00}, {-.589910E+00, 0.562833E+00},
            {-.591268E+00, 0.561442E+00}, {-.592609E+00, 0.560064E+00},
            {-.593933E+00, 0.558701E+00}, {-.595237E+00, 0.557355E+00},
            {-.596521E+00, 0.556026E+00}, {-.597784E+00, 0.554717E+00},
            {-.599024E+00, 0.553428E+00}, {-.600241E+00, 0.552162E+00},
            {-.601432E+00, 0.550919E+00}, {-.602597E+00, 0.549700E+00},
            {-.603735E+00, 0.548508E+00}, {-.604845E+00, 0.547343E+00},
            {-.605925E+00, 0.546207E+00}, {-.606975E+00, 0.545100E+00},
            {-.607993E+00, 0.544024E+00}, {-.608980E+00, 0.542981E+00},
            {-.609933E+00, 0.541971E+00}, {-.610852E+00, 0.540995E+00},
            {-.611737E+00, 0.540055E+00}, {-.612586E+00, 0.539151E+00},
            {-.613398E+00, 0.538285E+00}, {-.614173E+00, 0.537457E+00},
            {-.614910E+00, 0.536669E+00}, {-.615609E+00, 0.535921E+00},
            {-.616269E+00, 0.535214E+00}, {-.616889E+00, 0.534549E+00},
            {-.617468E+00, 0.533926E+00}, {-.618007E+00, 0.533347E+00},
            {-.618504E+00, 0.532811E+00}, {-.618960E+00, 0.532321E+00},
            {-.619373E+00, 0.531875E+00}, {-.619744E+00, 0.531475E+00},
            {-.620072E+00, 0.531120E+00}, {-.620357E+00, 0.530813E+00},
            {-.620598E+00, 0.530552E+00}, {-.620796E+00, 0.530338E+00},
            {-.620950E+00, 0.530171E+00}, {-.621060E+00, 0.530052E+00},
            {-.621127E+00, 0.529980E+00}, {-.621149E+00, 0.529957E+00},
        },
        {
            {-.524429E+00, 0.625828E+00}, {-.524456E+00, 0.625803E+00},
            {-.524536E+00, 0.625730E+00}, {-.524669E+00, 0.625608E+00},
            {-.524855E+00, 0.625438E+00}, {-.525094E+00, 0.625219E+00},
            {-.525385E+00, 0.624951E+00}, {-.525729E+00, 0.624636E+00},
            {-.526124E+00, 0.624273E+00}, {-.526571E+00, 0.623862E+00},
            {-.527069E+00, 0.623405E+00}, {-.527617E+00, 0.622900E+00},
            {-.528214E+00, 0.622350E+00}, {-.528861E+00, 0.621753E+00},
            {-.529556E+00, 0.621111E+00}, {-.530298E+00, 0.620425E+00},
            {-.531087E+00, 0.619695E+00}, {-.531922E+00, 0.618921E+00},
            {-.532802E+00, 0.618104E+00}, {-.533726E+00, 0.617246E+00},
            {-.534692E+00, 0.616346E+00}, {-.535700E+00, 0.615405E+00},
            {-.536749E+00, 0.614425E+00}, {-.537838E+00, 0.613407E+00},
            {-.538964E+00, 0.612350E+00}, {-.540128E+00, 0.611257E+00},
            {-.541328E+00, 0.610128E+00}, {-.542562E+00, 0.608964E+00},
            {-.543829E+00, 0.607766E+00}, {-.545127E+00, 0.606536E+00},
            {-.546457E+00, 0.605274E+00}, {-.547815E+00, 0.603981E+00},
            {-.549200E+00, 0.602660E+00}, {-.550611E+00, 0.601311E+00},
            {-.552047E+00, 0.599935E+00}, {-.553506E+00, 0.598534E+00},
            {-.554986E+00, 0.597108E+00}, {-.556485E+00, 0.595660E+00},
            {-.558003E+00, 0.594191E+00}, {-.559538E+00, 0.592702E+00},
            {-.561087E+00, 0.591194E+00}, {-.562650E+00, 0.589670E+00},
            {-.564224E+00, 0.588130E+00}, {-.565808E+00, 0.586575E+00},
            {-.567401E+00, 0.585009E+00}, {-.569001E+00, 0.583431E+00},
            {-.570605E+00, 0.581844E+00}, {-.572213E+00, 0.580249E+00},
            {-.573823E+00, 0.578648E+00}, {-.575434E+00, 0.577042E+00},
            {-.577042E+00, 0.575434E+00}, {-.578648E+00, 0.573823E+00},
            {-.580249E+00, 0.572213E+00}, {-.581844E+00, 0.570605E+00},
            {-.583431E+00, 0.569001E+00}, {-.585009E+00, 0.567401E+00},
            {-.586575E+00, 0.565808E+00}, {-.588130E+00, 0.564224E+00},
            {-.589670E+00, 0.562650E+00}, {-.591194E+00, 0.561087E+00},
            {-.592702E+00, 0.559538E+00}, {-.594191E+00, 0.558003E+00},
            {-.595660E+00, 0.556485E+00}, {-.597108E+00, 0.554986E+00},
            {-.598534E+00, 0.553506E+00}, {-.599935E+00, 0.552047E+00},
            {-.601311E+00, 0.550611E+00}, {-.602660E+00, 0.549200E+00},
            {-.603981E+00, 0.547815E+00}, {-.605274E+00, 0.546457E+00},
            {-.606536E+00, 0.545127E+00}, {-.607766E+00, 0.543829E+00},
            {-.608964E+00, 0.542562E+00}, {-.610128E+00, 0.541328E+00},
            {-.611257E+00, 0.540128E+00}, {-.612350E+00, 0.538964E+00},
            {-.613407E+00, 0.537838E+00}, {-.614425E+00, 0.536749E+00},
            {-.615405E+00, 0.535700E+00}, {-.616346E+00, 0.534692E+00},
            {-.617246E+00, 0.533726E+00}, {-.618104E+00, 0.532802E+00},
            {-.618921E+00, 0.531922E+00}, {-.619695E+00, 0.531087E+00},
            {-.620425E+00, 0.530298E+00}, {-.621111E+00, 0.529556E+00},
            {-.621753E+00, 0.528861E+00}, {-.622350E+00, 0.528214E+00},
            {-.622900E+00, 0.527617E+00}, {-.623405E+00, 0.527069E+00},
            {-.623862E+00, 0.526571E+00}, {-.624273E+00, 0.526124E+00},
            {-.624636E+00, 0.525729E+00}, {-.624951E+00, 0.525385E+00},
            {-.625219E+00, 0.525094E+00}, {-.625438E+00, 0.524855E+00},
            {-.625608E+00, 0.524669E+00}, {-.625730E+00, 0.524536E+00},
            {-.625803E+00, 0.524456E+00}, {-.625828E+00, 0.524429E+00},
        },
        {
            {-.518844E+00, 0.630473E+00}, {-.518874E+00, 0.630446E+00},
            {-.518962E+00, 0.630366E+00}, {-.519109E+00, 0.630233E+00},
            {-.519315E+00, 0.630046E+00}, {-.519579E+00, 0.629806E+00},
            {-.519901E+00, 0.629513E+00}, {-.520281E+00, 0.629167E+00},
            {-.520718E+00, 0.628769E+00}, {-.521212E+00, 0.628319E+00},
            {-.521762E+00, 0.627817E+00}, {-.522368E+00, 0.627265E+00},
            {-.523028E+00, 0.626661E+00}, {-.523743E+00, 0.626007E+00},
            {-.524511E+00, 0.625304E+00}, {-.525331E+00, 0.624551E+00},
            {-.526203E+00, 0.623750E+00}, {-.527126E+00, 0.622902E+00},
            {-.528098E+00, 0.622006E+00}, {-.529118E+00, 0.621064E+00},
            {-.530186E+00, 0.620077E+00}, {-.531299E+00, 0.619046E+00},
            {-.532458E+00, 0.617971E+00}, {-.533660E+00, 0.616853E+00},
            {-.534904E+00, 0.615694E+00}, {-.536189E+00, 0.614494E+00},
            {-.537514E+00, 0.613255E+00}, {-.538876E+00, 0.611978E+00},
            {-.540275E+00, 0.610663E+00}, {-.541708E+00, 0.609312E+00},
            {-.543175E+00, 0.607927E+00}, {-.544674E+00, 0.606508E+00},
            {-.546203E+00, 0.605056E+00}, {-.547760E+00, 0.603574E+00},
            {-.549344E+00, 0.602063E+00}, {-.550953E+00, 0.600523E+00},
            {-.552585E+00, 0.598957E+00}, {-.554239E+00, 0.597366E+00},
            {-.555912E+00, 0.595751E+00}, {-.557604E+00, 0.594114E+00},
            {-.559312E+00, 0.592457E+00}, {-.561034E+00, 0.590781E+00},
            {-.562769E+00, 0.589087E+00}, {-.564515E+00, 0.587378E+00},
            {-.566270E+00, 0.585654E+00}, {-.568032E+00, 0.583919E+00},
            {-.569800E+00, 0.582173E+00}, {-.571571E+00, 0.580418E+00},
            {-.573344E+00, 0.578656E+00}, {-.575117E+00, 0.576888E+00},
            {-.576888E+00, 0.575117E+00}, {-.578656E+00, 0.573344E+00},
            {-.580418E+00, 0.571571E+00}, {-.582173E+00, 0.569800E+00},
            {-.583919E+00, 0.568032E+00}, {-.585654E+00, 0.566270E+00},
            {-.587378E+00, 0.564515E+00}, {-.589087E+00, 0.562769E+00},
            {-.590781E+00, 0.561034E+00}, {-.592457E+00, 0.559312E+00},
            {-.594114E+00, 0.557604E+00}, {-.595751E+00, 0.555912E+00},
            {-.597366E+00, 0.554239E+00}, {-.598957E+00, 0.552585E+00},
            {-.600523E+00, 0.550953E+00}, {-.602063E+00, 0.549344E+00},
            {-.603574E+00, 0.547760E+00}, {-.605056E+00, 0.546203E+00},
            {-.606508E+00, 0.544674E+00}, {-.607927E+00, 0.543175E+00},
            {-.609312E+00, 0.541708E+00}, {-.610663E+00, 0.540275E+00},
            {-.611978E+00, 0.538876E+00}, {-.613255E+00, 0.537514E+00},
            {-.614494E+00, 0.536189E+00}, {-.615694E+00, 0.534904E+00},
            {-.616853E+00, 0.533660E+00}, {-.617971E+00, 0.532458E+00},
            {-.619046E+00, 0.531299E+00}, {-.620077E+00, 0.530186E+00},
            {-.621064E+00, 0.529118E+00}, {-.622006E+00, 0.528098E+00},
            {-.622902E+00, 0.527126E+00}, {-.623750E+00, 0.526203E+00},
            {-.624551E+00, 0.525331E+00}, {-.625304E+00, 0.524511E+00},
            {-.626007E+00, 0.523743E+00}, {-.626661E+00, 0.523028E+00},
            {-.627265E+00, 0.522368E+00}, {-.627817E+00, 0.521762E+00},
            {-.628319E+00, 0.521212E+00}, {-.628769E+00, 0.520718E+00},
            {-.629167E+00, 0.520281E+00}, {-.629513E+00, 0.519901E+00},
            {-.629806E+00, 0.519579E+00}, {-.630046E+00, 0.519315E+00},
            {-.630233E+00, 0.519109E+00}, {-.630366E+00, 0.518962E+00},
            {-.630446E+00, 0.518874E+00}, {-.630473E+00, 0.518844E+00},
        },
        {
            {-.513200E+00, 0.635086E+00}, {-.513232E+00, 0.635056E+00},
            {-.513329E+00, 0.634969E+00}, {-.513490E+00, 0.634824E+00},
            {-.513716E+00, 0.634621E+00}, {-.514006E+00, 0.634360E+00},
            {-.514359E+00, 0.634042E+00}, {-.514775E+00, 0.633666E+00},
            {-.515254E+00, 0.633233E+00}, {-.515796E+00, 0.632744E+00},
            {-.516399E+00, 0.632199E+00}, {-.517063E+00, 0.631598E+00},
            {-.517787E+00, 0.630942E+00}, {-.518570E+00, 0.630231E+00},
            {-.519412E+00, 0.629466E+00}, {-.520311E+00, 0.628647E+00},
            {-.521267E+00, 0.627777E+00}, {-.522278E+00, 0.626854E+00},
            {-.523343E+00, 0.625880E+00}, {-.524461E+00, 0.624855E+00},
            {-.525631E+00, 0.623782E+00}, {-.526851E+00, 0.622659E+00},
            {-.528120E+00, 0.621490E+00}, {-.529437E+00, 0.620274E+00},
            {-.530800E+00, 0.619012E+00}, {-.532207E+00, 0.617707E+00},
            {-.533657E+00, 0.616358E+00}, {-.535149E+00, 0.614967E+00},
            {-.536680E+00, 0.613536E+00}, {-.538250E+00, 0.612065E+00},
            {-.539856E+00, 0.610556E+00}, {-.541496E+00, 0.609011E+00},
            {-.543169E+00, 0.607430E+00}, {-.544873E+00, 0.605816E+00},
            {-.546606E+00, 0.604169E+00}, {-.548366E+00, 0.602491E+00},
            {-.550152E+00, 0.600785E+00}, {-.551961E+00, 0.599050E+00},
            {-.553791E+00, 0.597290E+00}, {-.555641E+00, 0.595506E+00},
            {-.557508E+00, 0.593698E+00}, {-.559391E+00, 0.591870E+00},
            {-.561288E+00, 0.590023E+00}, {-.563196E+00, 0.588159E+00},
            {-.565113E+00, 0.586279E+00}, {-.567039E+00, 0.584385E+00},
            {-.568970E+00, 0.582479E+00}, {-.570905E+00, 0.580564E+00},
            {-.572841E+00, 0.578640E+00}, {-.574777E+00, 0.576711E+00},
            {-.576711E+00, 0.574777E+00}, {-.578640E+00, 0.572841E+00},
            {-.580564E+00, 0.570905E+00}, {-.582479E+00, 0.568970E+00},
            {-.584385E+00, 0.567039E+00}, {-.586279E+00, 0.565113E+00},
            {-.588159E+00, 0.563196E+00}, {-.590023E+00, 0.561288E+00},
            {-.591870E+00, 0.559391E+00}, {-.593698E+00, 0.557508E+00},
            {-.595506E+00, 0.555641E+00}, {-.597290E+00, 0.553791E+00},
            {-.599050E+00, 0.551961E+00}, {-.600785E+00, 0.550152E+00},
            {-.602491E+00, 0.548366E+00}, {-.604169E+00, 0.546606E+00},
            {-.605816E+00, 0.544873E+00}, {-.607430E+00, 0.543169E+00},
            {-.609011E+00, 0.541496E+00}, {-.610556E+00, 0.539856E+00},
            {-.612065E+00, 0.538250E+00}, {-.613536E+00, 0.536680E+00},
            {-.614967E+00, 0.535149E+00}, {-.616358E+00, 0.533657E+00},
            {-.617707E+00, 0.532207E+00}, {-.619012E+00, 0.530800E+00},
            {-.620274E+00, 0.529437E+00}, {-.621490E+00, 0.528120E+00},
            {-.622659E+00, 0.526851E+00}, {-.623782E+00, 0.525631E+00},
            {-.624855E+00, 0.524461E+00}, {-.625880E+00, 0.523343E+00},
            {-.626854E+00, 0.522278E+00}, {-.627777E+00, 0.521267E+00},
            {-.628647E+00, 0.520311E+00}, {-.629466E+00, 0.519412E+00},
            {-.630231E+00, 0.518570E+00}, {-.630942E+00, 0.517787E+00},
            {-.631598E+00, 0.517063E+00}, {-.632199E+00, 0.516399E+00},
            {-.632744E+00, 0.515796E+00}, {-.633233E+00, 0.515254E+00},
            {-.633666E+00, 0.514775E+00}, {-.634042E+00, 0.514359E+00},
            {-.634360E+00, 0.514006E+00}, {-.634621E+00, 0.513716E+00},
            {-.634824E+00, 0.513490E+00}, {-.634969E+00, 0.513329E+00},
            {-.635056E+00, 0.513232E+00}, {-.635086E+00, 0.513200E+00},
        },
        {
            {-.507495E+00, 0.639666E+00}, {-.507530E+00, 0.639634E+00},
            {-.507636E+00, 0.639540E+00}, {-.507811E+00, 0.639383E+00},
            {-.508057E+00, 0.639164E+00}, {-.508372E+00, 0.638883E+00},
            {-.508757E+00, 0.638539E+00}, {-.509210E+00, 0.638133E+00},
            {-.509732E+00, 0.637666E+00}, {-.510322E+00, 0.637138E+00},
            {-.510978E+00, 0.636550E+00}, {-.511701E+00, 0.635901E+00},
            {-.512489E+00, 0.635192E+00}, {-.513342E+00, 0.634425E+00},
            {-.514258E+00, 0.633599E+00}, {-.515237E+00, 0.632715E+00},
            {-.516277E+00, 0.631774E+00}, {-.517377E+00, 0.630778E+00},
            {-.518537E+00, 0.629726E+00}, {-.519753E+00, 0.628619E+00},
            {-.521026E+00, 0.627459E+00}, {-.522354E+00, 0.626247E+00},
            {-.523734E+00, 0.624983E+00}, {-.525167E+00, 0.623669E+00},
            {-.526649E+00, 0.622305E+00}, {-.528180E+00, 0.620894E+00},
            {-.529757E+00, 0.619436E+00}, {-.531379E+00, 0.617933E+00},
            {-.533045E+00, 0.616385E+00}, {-.534751E+00, 0.614795E+00},
            {-.536497E+00, 0.613163E+00}, {-.538280E+00, 0.611491E+00},
            {-.540098E+00, 0.609782E+00}, {-.541950E+00, 0.608035E+00},
            {-.543833E+00, 0.606253E+00}, {-.545745E+00, 0.604438E+00},
            {-.547685E+00, 0.602591E+00}, {-.549650E+00, 0.600713E+00},
            {-.551638E+00, 0.598808E+00}, {-.553647E+00, 0.596876E+00},
            {-.555675E+00, 0.594919E+00}, {-.557719E+00, 0.592939E+00},
            {-.559778E+00, 0.590938E+00}, {-.561849E+00, 0.588918E+00},
            {-.563930E+00, 0.586881E+00}, {-.566019E+00, 0.584829E+00},
            {-.568114E+00, 0.582764E+00}, {-.570213E+00, 0.580688E+00},
            {-.572314E+00, 0.578602E+00}, {-.574413E+00, 0.576510E+00},
            {-.576510E+00, 0.574413E+00}, {-.578602E+00, 0.572314E+00},
            {-.580688E+00, 0.570213E+00}, {-.582764E+00, 0.568114E+00},
            {-.584829E+00, 0.566019E+00}, {-.586881E+00, 0.563930E+00},
            {-.588918E+00, 0.561849E+00}, {-.590938E+00, 0.559778E+00},
            {-.592939E+00, 0.557719E+00}, {-.594919E+00, 0.555675E+00},
            {-.596876E+00, 0.553647E+00}, {-.598808E+00, 0.551638E+00},
            {-.600713E+00, 0.549650E+00}, {-.602591E+00, 0.547685E+00},
            {-.604438E+00, 0.545745E+00}, {-.606253E+00, 0.543833E+00},
            {-.608035E+00, 0.541950E+00}, {-.609782E+00, 0.540098E+00},
            {-.611491E+00, 0.538280E+00}, {-.613163E+00, 0.536497E+00},
            {-.614795E+00, 0.534751E+00}, {-.616385E+00, 0.533045E+00},
            {-.617933E+00, 0.531379E+00}, {-.619436E+00, 0.529757E+00},
            {-.620894E+00, 0.528180E+00}, {-.622305E+00, 0.526649E+00},
            {-.623669E+00, 0.525167E+00}, {-.624983E+00, 0.523734E+00},
            {-.626247E+00, 0.522354E+00}, {-.627459E+00, 0.521026E+00},
            {-.628619E+00, 0.519753E+00}, {-.629726E+00, 0.518537E+00},
            {-.630778E+00, 0.517377E+00}, {-.631774E+00, 0.516277E+00},
            {-.632715E+00, 0.515237E+00}, {-.633599E+00, 0.514258E+00},
            {-.634425E+00, 0.513342E+00}, {-.635192E+00, 0.512489E+00},
            {-.635901E+00, 0.511701E+00}, {-.636550E+00, 0.510978E+00},
            {-.637138E+00, 0.510322E+00}, {-.637666E+00, 0.509732E+00},
            {-.638133E+00, 0.509210E+00}, {-.638539E+00, 0.508757E+00},
            {-.638883E+00, 0.508372E+00}, {-.639164E+00, 0.508057E+00},
            {-.639383E+00, 0.507811E+00}, {-.639540E+00, 0.507636E+00},
            {-.639634E+00, 0.507530E+00}, {-.639666E+00, 0.507495E+00},
        },
        {
            {-.501728E+00, 0.644215E+00}, {-.501766E+00, 0.644181E+00},
            {-.501880E+00, 0.644080E+00}, {-.502070E+00, 0.643912E+00},
            {-.502336E+00, 0.643677E+00}, {-.502677E+00, 0.643374E+00},
            {-.503094E+00, 0.643006E+00}, {-.503585E+00, 0.642570E+00},
            {-.504149E+00, 0.642069E+00}, {-.504788E+00, 0.641503E+00},
            {-.505498E+00, 0.640871E+00}, {-.506280E+00, 0.640174E+00},
            {-.507134E+00, 0.639414E+00}, {-.508056E+00, 0.638590E+00},
            {-.509048E+00, 0.637703E+00}, {-.510107E+00, 0.636754E+00},
            {-.511233E+00, 0.635745E+00}, {-.512423E+00, 0.634674E+00},
            {-.513677E+00, 0.633545E+00}, {-.514993E+00, 0.632356E+00},
            {-.516370E+00, 0.631111E+00}, {-.517806E+00, 0.629808E+00},
            {-.519300E+00, 0.628451E+00}, {-.520849E+00, 0.627039E+00},
            {-.522452E+00, 0.625574E+00}, {-.524107E+00, 0.624058E+00},
            {-.525812E+00, 0.622491E+00}, {-.527566E+00, 0.620875E+00},
            {-.529366E+00, 0.619211E+00}, {-.531210E+00, 0.617502E+00},
            {-.533097E+00, 0.615747E+00}, {-.535024E+00, 0.613950E+00},
            {-.536989E+00, 0.612111E+00}, {-.538989E+00, 0.610233E+00},
            {-.541024E+00, 0.608316E+00}, {-.543090E+00, 0.606363E+00},
            {-.545185E+00, 0.604376E+00}, {-.547306E+00, 0.602355E+00},
            {-.549453E+00, 0.600304E+00}, {-.551622E+00, 0.598225E+00},
            {-.553811E+00, 0.596118E+00}, {-.556017E+00, 0.593986E+00},
            {-.558239E+00, 0.591832E+00}, {-.560474E+00, 0.589656E+00},
            {-.562720E+00, 0.587462E+00}, {-.564973E+00, 0.585251E+00},
            {-.567233E+00, 0.583026E+00}, {-.569497E+00, 0.580789E+00},
            {-.571762E+00, 0.578542E+00}, {-.574026E+00, 0.576286E+00},
            {-.576286E+00, 0.574026E+00}, {-.578542E+00, 0.571762E+00},
            {-.580789E+00, 0.569497E+00}, {-.583026E+00, 0.567233E+00},
            {-.585251E+00, 0.564973E+00}, {-.587462E+00, 0.562720E+00},
            {-.589656E+00, 0.560474E+00}, {-.591832E+00, 0.558239E+00},
            {-.593986E+00, 0.556017E+00}, {-.596118E+00, 0.553811E+00},
            {-.598225E+00, 0.551622E+00}, {-.600304E+00, 0.549453E+00},
            {-.602355E+00, 0.547306E+00}, {-.604376E+00, 0.545185E+00},
            {-.606363E+00, 0.543090E+00}, {-.608316E+00, 0.541024E+00},
            {-.610233E+00, 0.538989E+00}, {-.612111E+00, 0.536989E+00},
            {-.613950E+00, 0.535024E+00}, {-.615747E+00, 0.533097E+00},
            {-.617502E+00, 0.531210E+00}, {-.619211E+00, 0.529366E+00},
            {-.620875E+00, 0.527566E+00}, {-.622491E+00, 0.525812E+00},
            {-.624058E+00, 0.524107E+00}, {-.625574E+00, 0.522452E+00},
            {-.627039E+00, 0.520849E+00}, {-.628451E+00, 0.519300E+00},
            {-.629808E+00, 0.517806E+00}, {-.631111E+00, 0.516370E+00},
            {-.632356E+00, 0.514993E+00}, {-.633545E+00, 0.513677E+00},
            {-.634674E+00, 0.512423E+00}, {-.635745E+00, 0.511233E+00},
            {-.636754E+00, 0.510107E+00}, {-.637703E+00, 0.509048E+00},
            {-.638590E+00, 0.508056E+00}, {-.639414E+00, 0.507134E+00},
            {-.640174E+00, 0.506280E+00}, {-.640871E+00, 0.505498E+00},
            {-.641503E+00, 0.504788E+00}, {-.642069E+00, 0.504149E+00},
            {-.642570E+00, 0.503585E+00}, {-.643006E+00, 0.503094E+00},
            {-.643374E+00, 0.502677E+00}, {-.643677E+00, 0.502336E+00},
            {-.643912E+00, 0.502070E+00}, {-.644080E+00, 0.501880E+00},
            {-.644181E+00, 0.501766E+00}, {-.644215E+00, 0.501728E+00},
        },
        {
            {-.495897E+00, 0.648733E+00}, {-.495938E+00, 0.648697E+00},
            {-.496061E+00, 0.648589E+00}, {-.496265E+00, 0.648410E+00},
            {-.496552E+00, 0.648159E+00}, {-.496919E+00, 0.647836E+00},
            {-.497368E+00, 0.647442E+00}, {-.497896E+00, 0.646978E+00},
            {-.498505E+00, 0.646443E+00}, {-.499192E+00, 0.645837E+00},
            {-.499957E+00, 0.645163E+00}, {-.500800E+00, 0.644419E+00},
            {-.501718E+00, 0.643607E+00}, {-.502712E+00, 0.642727E+00},
            {-.503780E+00, 0.641780E+00}, {-.504920E+00, 0.640767E+00},
            {-.506132E+00, 0.639688E+00}, {-.507413E+00, 0.638544E+00},
            {-.508763E+00, 0.637337E+00}, {-.510180E+00, 0.636068E+00},
            {-.511662E+00, 0.634737E+00}, {-.513207E+00, 0.633345E+00},
            {-.514814E+00, 0.631894E+00}, {-.516481E+00, 0.630385E+00},
            {-.518206E+00, 0.628819E+00}, {-.519987E+00, 0.627198E+00},
            {-.521821E+00, 0.625522E+00}, {-.523708E+00, 0.623794E+00},
            {-.525644E+00, 0.622015E+00}, {-.527627E+00, 0.620187E+00},
            {-.529656E+00, 0.618310E+00}, {-.531728E+00, 0.616387E+00},
            {-.533840E+00, 0.614420E+00}, {-.535991E+00, 0.612409E+00},
            {-.538178E+00, 0.610358E+00}, {-.540398E+00, 0.608267E+00},
            {-.542649E+00, 0.606140E+00}, {-.544929E+00, 0.603977E+00},
            {-.547235E+00, 0.601780E+00}, {-.549565E+00, 0.599553E+00},
            {-.551916E+00, 0.597296E+00}, {-.554286E+00, 0.595012E+00},
            {-.556671E+00, 0.592704E+00}, {-.559071E+00, 0.590373E+00},
            {-.561482E+00, 0.588021E+00}, {-.563901E+00, 0.585652E+00},
            {-.566326E+00, 0.583266E+00}, {-.568755E+00, 0.580867E+00},
            {-.571185E+00, 0.578457E+00}, {-.573614E+00, 0.576039E+00},
            {-.576039E+00, 0.573614E+00}, {-.578457E+00, 0.571185E+00},
            {-.580867E+00, 0.568755E+00}, {-.583266E+00, 0.566326E+00},
            {-.585652E+00, 0.563901E+00}, {-.588021E+00, 0.561482E+00},
            {-.590373E+00, 0.559071E+00}, {-.592704E+00, 0.556671E+00},
            {-.595012E+00, 0.554286E+00}, {-.597296E+00, 0.551916E+00},
            {-.599553E+00, 0.549565E+00}, {-.601780E+00, 0.547235E+00},
            {-.603977E+00, 0.544929E+00}, {-.606140E+00, 0.542649E+00},
            {-.608267E+00, 0.540398E+00}, {-.610358E+00, 0.538178E+00},
            {-.612409E+00, 0.535991E+00}, {-.614420E+00, 0.533840E+00},
            {-.616387E+00, 0.531728E+00}, {-.618310E+00, 0.529656E+00},
            {-.620187E+00, 0.527627E+00}, {-.622015E+00, 0.525644E+00},
            {-.623794E+00, 0.523708E+00}, {-.625522E+00, 0.521821E+00},
            {-.627198E+00, 0.519987E+00}, {-.628819E+00, 0.518206E+00},
            {-.630385E+00, 0.516481E+00}, {-.631894E+00, 0.514814E+00},
            {-.633345E+00, 0.513207E+00}, {-.634737E+00, 0.511662E+00},
            {-.636068E+00, 0.510180E+00}, {-.637337E+00, 0.508763E+00},
            {-.638544E+00, 0.507413E+00}, {-.639688E+00, 0.506132E+00},
            {-.640767E+00, 0.504920E+00}, {-.641780E+00, 0.503780E+00},
            {-.642727E+00, 0.502712E+00}, {-.643607E+00, 0.501718E+00},
            {-.644419E+00, 0.500800E+00}, {-.645163E+00, 0.499957E+00},
            {-.645837E+00, 0.499192E+00}, {-.646443E+00, 0.498505E+00},
            {-.646978E+00, 0.497896E+00}, {-.647442E+00, 0.497368E+00},
            {-.647836E+00, 0.496919E+00}, {-.648159E+00, 0.496552E+00},
            {-.648410E+00, 0.496265E+00}, {-.648589E+00, 0.496061E+00},
            {-.648697E+00, 0.495938E+00}, {-.648733E+00, 0.495897E+00},
        },
        {
            {-.489999E+00, 0.653222E+00}, {-.490043E+00, 0.653184E+00},
            {-.490175E+00, 0.653069E+00}, {-.490395E+00, 0.652879E+00},
            {-.490702E+00, 0.652612E+00}, {-.491096E+00, 0.652269E+00},
            {-.491577E+00, 0.651850E+00}, {-.492144E+00, 0.651356E+00},
            {-.492796E+00, 0.650787E+00}, {-.493533E+00, 0.650144E+00},
            {-.494353E+00, 0.649427E+00}, {-.495257E+00, 0.648636E+00},
            {-.496242E+00, 0.647772E+00}, {-.497307E+00, 0.646837E+00},
            {-.498451E+00, 0.645830E+00}, {-.499674E+00, 0.644752E+00},
            {-.500973E+00, 0.643605E+00}, {-.502346E+00, 0.642389E+00},
            {-.503793E+00, 0.641105E+00}, {-.505311E+00, 0.639754E+00},
            {-.506899E+00, 0.638338E+00}, {-.508555E+00, 0.636857E+00},
            {-.510277E+00, 0.635313E+00}, {-.512063E+00, 0.633707E+00},
            {-.513911E+00, 0.632041E+00}, {-.515818E+00, 0.630315E+00},
            {-.517783E+00, 0.628531E+00}, {-.519803E+00, 0.626692E+00},
            {-.521877E+00, 0.624797E+00}, {-.524000E+00, 0.622850E+00},
            {-.526172E+00, 0.620851E+00}, {-.528390E+00, 0.618803E+00},
            {-.530651E+00, 0.616707E+00}, {-.532953E+00, 0.614565E+00},
            {-.535293E+00, 0.612379E+00}, {-.537669E+00, 0.610151E+00},
            {-.540078E+00, 0.607883E+00}, {-.542517E+00, 0.605577E+00},
            {-.544984E+00, 0.603235E+00}, {-.547475E+00, 0.600860E+00},
            {-.549989E+00, 0.598454E+00}, {-.552523E+00, 0.596018E+00},
            {-.555074E+00, 0.593555E+00}, {-.557639E+00, 0.591068E+00},
            {-.560216E+00, 0.588559E+00}, {-.562801E+00, 0.586030E+00},
            {-.565393E+00, 0.583484E+00}, {-.567988E+00, 0.580923E+00},
            {-.570584E+00, 0.578350E+00}, {-.573178E+00, 0.575767E+00},
            {-.575767E+00, 0.573178E+00}, {-.578350E+00, 0.570584E+00},
            {-.580923E+00, 0.567988E+00}, {-.583484E+00, 0.565393E+00},
            {-.586030E+00, 0.562801E+00}, {-.588559E+00, 0.560216E+00},
            {-.591068E+00, 0.557639E+00}, {-.593555E+00, 0.555074E+00},
            {-.596018E+00, 0.552523E+00}, {-.598454E+00, 0.549989E+00},
            {-.600860E+00, 0.547475E+00}, {-.603235E+00, 0.544984E+00},
            {-.605577E+00, 0.542517E+00}, {-.607883E+00, 0.540078E+00},
            {-.610151E+00, 0.537669E+00}, {-.612379E+00, 0.535293E+00},
            {-.614565E+00, 0.532953E+00}, {-.616707E+00, 0.530651E+00},
            {-.618803E+00, 0.528390E+00}, {-.620851E+00, 0.526172E+00},
            {-.622850E+00, 0.524000E+00}, {-.624797E+00, 0.521877E+00},
            {-.626692E+00, 0.519803E+00}, {-.628531E+00, 0.517783E+00},
            {-.630315E+00, 0.515818E+00}, {-.632041E+00, 0.513911E+00},
            {-.633707E+00, 0.512063E+00}, {-.635313E+00, 0.510277E+00},
            {-.636857E+00, 0.508555E+00}, {-.638338E+00, 0.506899E+00},
            {-.639754E+00, 0.505311E+00}, {-.641105E+00, 0.503793E+00},
            {-.642389E+00, 0.502346E+00}, {-.643605E+00, 0.500973E+00},
            {-.644752E+00, 0.499674E+00}, {-.645830E+00, 0.498451E+00},
            {-.646837E+00, 0.497307E+00}, {-.647772E+00, 0.496242E+00},
            {-.648636E+00, 0.495257E+00}, {-.649427E+00, 0.494353E+00},
            {-.650144E+00, 0.493533E+00}, {-.650787E+00, 0.492796E+00},
            {-.651356E+00, 0.492144E+00}, {-.651850E+00, 0.491577E+00},
            {-.652269E+00, 0.491096E+00}, {-.652612E+00, 0.490702E+00},
            {-.652879E+00, 0.490395E+00}, {-.653069E+00, 0.490175E+00},
            {-.653184E+00, 0.490043E+00}, {-.653222E+00, 0.489999E+00},
        },
        {
            {-.484034E+00, 0.657682E+00}, {-.484081E+00, 0.657642E+00},
            {-.484222E+00, 0.657521E+00}, {-.484457E+00, 0.657319E+00},
            {-.484785E+00, 0.657036E+00}, {-.485206E+00, 0.656673E+00},
            {-.485720E+00, 0.656230E+00}, {-.486325E+00, 0.655707E+00},
            {-.487022E+00, 0.655104E+00}, {-.487809E+00, 0.654423E+00},
            {-.488685E+00, 0.653663E+00}, {-.489650E+00, 0.652826E+00},
            {-.490702E+00, 0.651911E+00}, {-.491840E+00, 0.650920E+00},
            {-.493062E+00, 0.649853E+00}, {-.494367E+00, 0.648712E+00},
            {-.495754E+00, 0.647496E+00}, {-.497221E+00, 0.646208E+00},
            {-.498765E+00, 0.644847E+00}, {-.500386E+00, 0.643416E+00},
            {-.502081E+00, 0.641915E+00}, {-.503849E+00, 0.640346E+00},
            {-.505687E+00, 0.638709E+00}, {-.507593E+00, 0.637006E+00},
            {-.509564E+00, 0.635239E+00}, {-.511600E+00, 0.633410E+00},
            {-.513696E+00, 0.631518E+00}, {-.515852E+00, 0.629567E+00},
            {-.518063E+00, 0.627557E+00}, {-.520329E+00, 0.625492E+00},
            {-.522645E+00, 0.623371E+00}, {-.525010E+00, 0.621197E+00},
            {-.527421E+00, 0.618973E+00}, {-.529876E+00, 0.616700E+00},
            {-.532370E+00, 0.614379E+00}, {-.534903E+00, 0.612014E+00},
            {-.537470E+00, 0.609606E+00}, {-.540069E+00, 0.607157E+00},
            {-.542698E+00, 0.604670E+00}, {-.545352E+00, 0.602147E+00},
            {-.548031E+00, 0.599590E+00}, {-.550730E+00, 0.597002E+00},
            {-.553446E+00, 0.594385E+00}, {-.556178E+00, 0.591742E+00},
            {-.558921E+00, 0.589075E+00}, {-.561673E+00, 0.586386E+00},
            {-.564432E+00, 0.583679E+00}, {-.567194E+00, 0.580956E+00},
            {-.569957E+00, 0.578219E+00}, {-.572717E+00, 0.575472E+00},
            {-.575472E+00, 0.572717E+00}, {-.578219E+00, 0.569957E+00},
            {-.580956E+00, 0.567194E+00}, {-.583679E+00, 0.564432E+00},
            {-.586386E+00, 0.561673E+00}, {-.589075E+00, 0.558921E+00},
            {-.591742E+00, 0.556178E+00}, {-.594385E+00, 0.553446E+00},
            {-.597002E+00, 0.550730E+00}, {-.599590E+00, 0.548031E+00},
            {-.602147E+00, 0.545352E+00}, {-.604670E+00, 0.542698E+00},
            {-.607157E+00, 0.540069E+00}, {-.609606E+00, 0.537470E+00},
            {-.612014E+00, 0.534903E+00}, {-.614379E+00, 0.532370E+00},
            {-.616700E+00, 0.529876E+00}, {-.618973E+00, 0.527421E+00},
            {-.621197E+00, 0.525010E+00}, {-.623371E+00, 0.522645E+00},
            {-.625492E+00, 0.520329E+00}, {-.627557E+00, 0.518063E+00},
            {-.629567E+00, 0.515852E+00}, {-.631518E+00, 0.513696E+00},
            {-.633410E+00, 0.511600E+00}, {-.635239E+00, 0.509564E+00},
            {-.637006E+00, 0.507593E+00}, {-.638709E+00, 0.505687E+00},
            {-.640346E+00, 0.503849E+00}, {-.641915E+00, 0.502081E+00},
            {-.643416E+00, 0.500386E+00}, {-.644847E+00, 0.498765E+00},
            {-.646208E+00, 0.497221E+00}, {-.647496E+00, 0.495754E+00},
            {-.648712E+00, 0.494367E+00}, {-.649853E+00, 0.493062E+00},
            {-.650920E+00, 0.491840E+00}, {-.651911E+00, 0.490702E+00},
            {-.652826E+00, 0.489650E+00}, {-.653663E+00, 0.488685E+00},
            {-.654423E+00, 0.487809E+00}, {-.655104E+00, 0.487022E+00},
            {-.655707E+00, 0.486325E+00}, {-.656230E+00, 0.485720E+00},
            {-.656673E+00, 0.485206E+00}, {-.657036E+00, 0.484785E+00},
            {-.657319E+00, 0.484457E+00}, {-.657521E+00, 0.484222E+00},
            {-.657642E+00, 0.484081E+00}, {-.657682E+00, 0.484034E+00},
        },
        {
            {-.478000E+00, 0.662115E+00}, {-.478050E+00, 0.662072E+00},
            {-.478200E+00, 0.661944E+00}, {-.478449E+00, 0.661731E+00},
            {-.478799E+00, 0.661432E+00}, {-.479247E+00, 0.661049E+00},
            {-.479794E+00, 0.660582E+00}, {-.480439E+00, 0.660030E+00},
            {-.481180E+00, 0.659394E+00}, {-.482018E+00, 0.658675E+00},
            {-.482951E+00, 0.657873E+00}, {-.483978E+00, 0.656989E+00},
            {-.485097E+00, 0.656024E+00}, {-.486308E+00, 0.654978E+00},
            {-.487609E+00, 0.653851E+00}, {-.488998E+00, 0.652646E+00},
            {-.490474E+00, 0.651363E+00}, {-.492035E+00, 0.650002E+00},
            {-.493678E+00, 0.648566E+00}, {-.495403E+00, 0.647054E+00},
            {-.497206E+00, 0.645469E+00}, {-.499087E+00, 0.643811E+00},
            {-.501042E+00, 0.642082E+00}, {-.503069E+00, 0.640283E+00},
            {-.505166E+00, 0.638416E+00}, {-.507330E+00, 0.636482E+00},
            {-.509560E+00, 0.634483E+00}, {-.511851E+00, 0.632421E+00},
            {-.514203E+00, 0.630297E+00}, {-.516611E+00, 0.628113E+00},
            {-.519073E+00, 0.625870E+00}, {-.521587E+00, 0.623572E+00},
            {-.524149E+00, 0.621219E+00}, {-.526757E+00, 0.618814E+00},
            {-.529407E+00, 0.616359E+00}, {-.532097E+00, 0.613857E+00},
            {-.534824E+00, 0.611309E+00}, {-.537585E+00, 0.608717E+00},
            {-.540376E+00, 0.606084E+00}, {-.543195E+00, 0.603413E+00},
            {-.546039E+00, 0.600706E+00}, {-.548904E+00, 0.597966E+00},
            {-.551787E+00, 0.595194E+00}, {-.554686E+00, 0.592394E+00},
            {-.557597E+00, 0.589568E+00}, {-.560518E+00, 0.586720E+00},
            {-.563444E+00, 0.583851E+00}, {-.566374E+00, 0.580965E+00},
            {-.569304E+00, 0.578064E+00}, {-.572231E+00, 0.575152E+00},
            {-.575152E+00, 0.572231E+00}, {-.578064E+00, 0.569304E+00},
            {-.580965E+00, 0.566374E+00}, {-.583851E+00, 0.563444E+00},
            {-.586720E+00, 0.560518E+00}, {-.589568E+00, 0.557597E+00},
            {-.592394E+00, 0.554686E+00}, {-.595194E+00, 0.551787E+00},
            {-.597966E+00, 0.548904E+00}, {-.600706E+00, 0.546039E+00},
            {-.603413E+00, 0.543195E+00}, {-.606084E+00, 0.540376E+00},
            {-.608717E+00, 0.537585E+00}, {-.611309E+00, 0.534824E+00},
            {-.613857E+00, 0.532097E+00}, {-.616359E+00, 0.529407E+00},
            {-.618814E+00, 0.526757E+00}, {-.621219E+00, 0.524149E+00},
            {-.623572E+00, 0.521587E+00}, {-.625870E+00, 0.519073E+00},
            {-.628113E+00, 0.516611E+00}, {-.630297E+00, 0.514203E+00},
            {-.632421E+00, 0.511851E+00}, {-.634483E+00, 0.509560E+00},
            {-.636482E+00, 0.507330E+00}, {-.638416E+00, 0.505166E+00},
            {-.640283E+00, 0.503069E+00}, {-.642082E+00, 0.501042E+00},
            {-.643811E+00, 0.499087E+00}, {-.645469E+00, 0.497206E+00},
            {-.647054E+00, 0.495403E+00}, {-.648566E+00, 0.493678E+00},
            {-.650002E+00, 0.492035E+00}, {-.651363E+00, 0.490474E+00},
            {-.652646E+00, 0.488998E+00}, {-.653851E+00, 0.487609E+00},
            {-.654978E+00, 0.486308E+00}, {-.656024E+00, 0.485097E+00},
            {-.656989E+00, 0.483978E+00}, {-.657873E+00, 0.482951E+00},
            {-.658675E+00, 0.482018E+00}, {-.659394E+00, 0.481180E+00},
            {-.660030E+00, 0.480439E+00}, {-.660582E+00, 0.479794E+00},
            {-.661049E+00, 0.479247E+00}, {-.661432E+00, 0.478799E+00},
            {-.661731E+00, 0.478449E+00}, {-.661944E+00, 0.478200E+00},
            {-.662072E+00, 0.478050E+00}, {-.662115E+00, 0.478000E+00},
        },
        {
            {-.471893E+00, 0.666520E+00}, {-.471947E+00, 0.666475E+00},
            {-.472106E+00, 0.666340E+00}, {-.472371E+00, 0.666116E+00},
            {-.472742E+00, 0.665802E+00}, {-.473217E+00, 0.665399E+00},
            {-.473798E+00, 0.664907E+00}, {-.474482E+00, 0.664326E+00},
            {-.475269E+00, 0.663657E+00}, {-.476158E+00, 0.662901E+00},
            {-.477148E+00, 0.662057E+00}, {-.478238E+00, 0.661127E+00},
            {-.479426E+00, 0.660111E+00}, {-.480711E+00, 0.659010E+00},
            {-.482092E+00, 0.657825E+00}, {-.483566E+00, 0.656556E+00},
            {-.485131E+00, 0.655205E+00}, {-.486787E+00, 0.653773E+00},
            {-.488530E+00, 0.652261E+00}, {-.490360E+00, 0.650669E+00},
            {-.492273E+00, 0.649000E+00}, {-.494267E+00, 0.647254E+00},
            {-.496340E+00, 0.645433E+00}, {-.498490E+00, 0.643538E+00},
            {-.500714E+00, 0.641571E+00}, {-.503008E+00, 0.639534E+00},
            {-.505372E+00, 0.637427E+00}, {-.507801E+00, 0.635254E+00},
            {-.510293E+00, 0.633015E+00}, {-.512845E+00, 0.630713E+00},
            {-.515455E+00, 0.628349E+00}, {-.518118E+00, 0.625926E+00},
            {-.520833E+00, 0.623445E+00}, {-.523596E+00, 0.620909E+00},
            {-.526403E+00, 0.618320E+00}, {-.529253E+00, 0.615680E+00},
            {-.532140E+00, 0.612991E+00}, {-.535064E+00, 0.610257E+00},
            {-.538019E+00, 0.607478E+00}, {-.541003E+00, 0.604659E+00},
            {-.544013E+00, 0.601802E+00}, {-.547045E+00, 0.598908E+00},
            {-.550097E+00, 0.595982E+00}, {-.553164E+00, 0.593025E+00},
            {-.556244E+00, 0.590040E+00}, {-.559333E+00, 0.587031E+00},
            {-.562428E+00, 0.584000E+00}, {-.565527E+00, 0.580951E+00},
            {-.568624E+00, 0.577885E+00}, {-.571719E+00, 0.574807E+00},
            {-.574807E+00, 0.571719E+00}, {-.577885E+00, 0.568624E+00},
            {-.580951E+00, 0.565527E+00}, {-.584000E+00, 0.562428E+00},
            {-.587031E+00, 0.559333E+00}, {-.590040E+00, 0.556244E+00},
            {-.593025E+00, 0.553164E+00}, {-.595982E+00, 0.550097E+00},
            {-.598908E+00, 0.547045E+00}, {-.601802E+00, 0.544013E+00},
            {-.604659E+00, 0.541003E+00}, {-.607478E+00, 0.538019E+00},
            {-.610257E+00, 0.535064E+00}, {-.612991E+00, 0.532140E+00},
            {-.615680E+00, 0.529253E+00}, {-.618320E+00, 0.526403E+00},
            {-.620909E+00, 0.523596E+00}, {-.623445E+00, 0.520833E+00},
            {-.625926E+00, 0.518118E+00}, {-.628349E+00, 0.515455E+00},
            {-.630713E+00, 0.512845E+00}, {-.633015E+00, 0.510293E+00},
            {-.635254E+00, 0.507801E+00}, {-.637427E+00, 0.505372E+00},
            {-.639534E+00, 0.503008E+00}, {-.641571E+00, 0.500714E+00},
            {-.643538E+00, 0.498490E+00}, {-.645433E+00, 0.496340E+00},
            {-.647254E+00, 0.494267E+00}, {-.649000E+00, 0.492273E+00},
            {-.650669E+00, 0.490360E+00}, {-.652261E+00, 0.488530E+00},
            {-.653773E+00, 0.486787E+00}, {-.655205E+00, 0.485131E+00},
            {-.656556E+00, 0.483566E+00}, {-.657825E+00, 0.482092E+00},
            {-.659010E+00, 0.480711E+00}, {-.660111E+00, 0.479426E+00},
            {-.661127E+00, 0.478238E+00}, {-.662057E+00, 0.477148E+00},
            {-.662901E+00, 0.476158E+00}, {-.663657E+00, 0.475269E+00},
            {-.664326E+00, 0.474482E+00}, {-.664907E+00, 0.473798E+00},
            {-.665399E+00, 0.473217E+00}, {-.665802E+00, 0.472742E+00},
            {-.666116E+00, 0.472371E+00}, {-.666340E+00, 0.472106E+00},
            {-.666475E+00, 0.471947E+00}, {-.666520E+00, 0.471893E+00},
        },
        {
            {-.465714E+00, 0.670898E+00}, {-.465770E+00, 0.670851E+00},
            {-.465938E+00, 0.670710E+00}, {-.466219E+00, 0.670475E+00},
            {-.466611E+00, 0.670146E+00}, {-.467115E+00, 0.669723E+00},
            {-.467729E+00, 0.669206E+00}, {-.468454E+00, 0.668597E+00},
            {-.469287E+00, 0.667895E+00}, {-.470228E+00, 0.667102E+00},
            {-.471276E+00, 0.666216E+00}, {-.472429E+00, 0.665240E+00},
            {-.473687E+00, 0.664174E+00}, {-.475047E+00, 0.663018E+00},
            {-.476507E+00, 0.661774E+00}, {-.478067E+00, 0.660443E+00},
            {-.479724E+00, 0.659024E+00}, {-.481475E+00, 0.657521E+00},
            {-.483320E+00, 0.655933E+00}, {-.485255E+00, 0.654261E+00},
            {-.487279E+00, 0.652508E+00}, {-.489388E+00, 0.650674E+00},
            {-.491581E+00, 0.648762E+00}, {-.493854E+00, 0.646771E+00},
            {-.496206E+00, 0.644705E+00}, {-.498632E+00, 0.642564E+00},
            {-.501131E+00, 0.640351E+00}, {-.503699E+00, 0.638067E+00},
            {-.506334E+00, 0.635714E+00}, {-.509031E+00, 0.633293E+00},
            {-.511789E+00, 0.630808E+00}, {-.514604E+00, 0.628260E+00},
            {-.517472E+00, 0.625651E+00}, {-.520391E+00, 0.622984E+00},
            {-.523357E+00, 0.620260E+00}, {-.526367E+00, 0.617483E+00},
            {-.529417E+00, 0.614654E+00}, {-.532504E+00, 0.611776E+00},
            {-.535625E+00, 0.608852E+00}, {-.538775E+00, 0.605885E+00},
            {-.541953E+00, 0.602876E+00}, {-.545153E+00, 0.599830E+00},
            {-.548374E+00, 0.596748E+00}, {-.551610E+00, 0.593634E+00},
            {-.554860E+00, 0.590490E+00}, {-.558119E+00, 0.587320E+00},
            {-.561384E+00, 0.584126E+00}, {-.564652E+00, 0.580913E+00},
            {-.567919E+00, 0.577682E+00}, {-.571181E+00, 0.574437E+00},
            {-.574437E+00, 0.571181E+00}, {-.577682E+00, 0.567919E+00},
            {-.580913E+00, 0.564652E+00}, {-.584126E+00, 0.561384E+00},
            {-.587320E+00, 0.558119E+00}, {-.590490E+00, 0.554860E+00},
            {-.593634E+00, 0.551610E+00}, {-.596748E+00, 0.548374E+00},
            {-.599830E+00, 0.545153E+00}, {-.602876E+00, 0.541953E+00},
            {-.605885E+00, 0.538775E+00}, {-.608852E+00, 0.535625E+00},
            {-.611776E+00, 0.532504E+00}, {-.614654E+00, 0.529417E+00},
            {-.617483E+00, 0.526367E+00}, {-.620260E+00, 0.523357E+00},
            {-.622984E+00, 0.520391E+00}, {-.625651E+00, 0.517472E+00},
            {-.628260E+00, 0.514604E+00}, {-.630808E+00, 0.511789E+00},
            {-.633293E+00, 0.509031E+00}, {-.635714E+00, 0.506334E+00},
            {-.638067E+00, 0.503699E+00}, {-.640351E+00, 0.501131E+00},
            {-.642564E+00, 0.498632E+00}, {-.644705E+00, 0.496206E+00},
            {-.646771E+00, 0.493854E+00}, {-.648762E+00, 0.491581E+00},
            {-.650674E+00, 0.489388E+00}, {-.652508E+00, 0.487279E+00},
            {-.654261E+00, 0.485255E+00}, {-.655933E+00, 0.483320E+00},
            {-.657521E+00, 0.481475E+00}, {-.659024E+00, 0.479724E+00},
            {-.660443E+00, 0.478067E+00}, {-.661774E+00, 0.476507E+00},
            {-.663018E+00, 0.475047E+00}, {-.664174E+00, 0.473687E+00},
            {-.665240E+00, 0.472429E+00}, {-.666216E+00, 0.471276E+00},
            {-.667102E+00, 0.470228E+00}, {-.667895E+00, 0.469287E+00},
            {-.668597E+00, 0.468454E+00}, {-.669206E+00, 0.467729E+00},
            {-.669723E+00, 0.467115E+00}, {-.670146E+00, 0.466611E+00},
            {-.670475E+00, 0.466219E+00}, {-.670710E+00, 0.465938E+00},
            {-.670851E+00, 0.465770E+00}, {-.670898E+00, 0.465714E+00},
        },
        {
            {-.459458E+00, 0.675252E+00}, {-.459517E+00, 0.675202E+00},
            {-.459695E+00, 0.675054E+00}, {-.459992E+00, 0.674808E+00},
            {-.460406E+00, 0.674464E+00}, {-.460938E+00, 0.674021E+00},
            {-.461587E+00, 0.673481E+00}, {-.462352E+00, 0.672843E+00},
            {-.463231E+00, 0.672108E+00}, {-.464225E+00, 0.671278E+00},
            {-.465332E+00, 0.670351E+00}, {-.466549E+00, 0.669329E+00},
            {-.467877E+00, 0.668213E+00}, {-.469312E+00, 0.667003E+00},
            {-.470854E+00, 0.665700E+00}, {-.472501E+00, 0.664306E+00},
            {-.474249E+00, 0.662821E+00}, {-.476098E+00, 0.661246E+00},
            {-.478045E+00, 0.659582E+00}, {-.480087E+00, 0.657832E+00},
            {-.482223E+00, 0.655995E+00}, {-.484449E+00, 0.654074E+00},
            {-.486762E+00, 0.652070E+00}, {-.489161E+00, 0.649984E+00},
            {-.491641E+00, 0.647818E+00}, {-.494201E+00, 0.645575E+00},
            {-.496836E+00, 0.643254E+00}, {-.499545E+00, 0.640860E+00},
            {-.502323E+00, 0.638392E+00}, {-.505167E+00, 0.635854E+00},
            {-.508075E+00, 0.633248E+00}, {-.511042E+00, 0.630575E+00},
            {-.514066E+00, 0.627838E+00}, {-.517142E+00, 0.625039E+00},
            {-.520268E+00, 0.622181E+00}, {-.523440E+00, 0.619266E+00},
            {-.526653E+00, 0.616297E+00}, {-.529905E+00, 0.613276E+00},
            {-.533192E+00, 0.610206E+00}, {-.536511E+00, 0.607090E+00},
            {-.539857E+00, 0.603931E+00}, {-.543227E+00, 0.600730E+00},
            {-.546618E+00, 0.597493E+00}, {-.550025E+00, 0.594221E+00},
            {-.553445E+00, 0.590917E+00}, {-.556875E+00, 0.587586E+00},
            {-.560311E+00, 0.584229E+00}, {-.563749E+00, 0.580850E+00},
            {-.567186E+00, 0.577453E+00}, {-.570618E+00, 0.574041E+00},
            {-.574041E+00, 0.570618E+00}, {-.577453E+00, 0.567186E+00},
            {-.580850E+00, 0.563749E+00}, {-.584229E+00, 0.560311E+00},
            {-.587586E+00, 0.556875E+00}, {-.590917E+00, 0.553445E+00},
            {-.594221E+00, 0.550025E+00}, {-.597493E+00, 0.546618E+00},
            {-.600730E+00, 0.543227E+00}, {-.603931E+00, 0.539857E+00},
            {-.607090E+00, 0.536511E+00}, {-.610206E+00, 0.533192E+00},
            {-.613276E+00, 0.529905E+00}, {-.616297E+00, 0.526653E+00},
            {-.619266E+00, 0.523440E+00}, {-.622181E+00, 0.520268E+00},
            {-.625039E+00, 0.517142E+00}, {-.627838E+00, 0.514066E+00},
            {-.630575E+00, 0.511042E+00}, {-.633248E+00, 0.508075E+00},
            {-.635854E+00, 0.505167E+00}, {-.638392E+00, 0.502323E+00},
            {-.640860E+00, 0.499545E+00}, {-.643254E+00, 0.496836E+00},
            {-.645575E+00, 0.494201E+00}, {-.647818E+00, 0.491641E+00},
            {-.649984E+00, 0.489161E+00}, {-.652070E+00, 0.486762E+00},
            {-.654074E+00, 0.484449E+00}, {-.655995E+00, 0.482223E+00},
            {-.657832E+00, 0.480087E+00}, {-.659582E+00, 0.478045E+00},
            {-.661246E+00, 0.476098E+00}, {-.662821E+00, 0.474249E+00},
            {-.664306E+00, 0.472501E+00}, {-.665700E+00, 0.470854E+00},
            {-.667003E+00, 0.469312E+00}, {-.668213E+00, 0.467877E+00},
            {-.669329E+00, 0.466549E+00}, {-.670351E+00, 0.465332E+00},
            {-.671278E+00, 0.464225E+00}, {-.672108E+00, 0.463231E+00},
            {-.672843E+00, 0.462352E+00}, {-.673481E+00, 0.461587E+00},
            {-.674021E+00, 0.460938E+00}, {-.674464E+00, 0.460406E+00},
            {-.674808E+00, 0.459992E+00}, {-.675054E+00, 0.459695E+00},
            {-.675202E+00, 0.459517E+00}, {-.675252E+00, 0.459458E+00},
        },
        {
            {-.453124E+00, 0.679580E+00}, {-.453187E+00, 0.679528E+00},
            {-.453375E+00, 0.679374E+00}, {-.453687E+00, 0.679117E+00},
            {-.454123E+00, 0.678757E+00}, {-.454684E+00, 0.678295E+00},
            {-.455368E+00, 0.677731E+00}, {-.456173E+00, 0.677065E+00},
            {-.457100E+00, 0.676297E+00}, {-.458147E+00, 0.675430E+00},
            {-.459313E+00, 0.674462E+00}, {-.460596E+00, 0.673394E+00},
            {-.461994E+00, 0.672228E+00}, {-.463507E+00, 0.670964E+00},
            {-.465131E+00, 0.669603E+00}, {-.466865E+00, 0.668146E+00},
            {-.468707E+00, 0.666595E+00}, {-.470654E+00, 0.664949E+00},
            {-.472704E+00, 0.663210E+00}, {-.474855E+00, 0.661381E+00},
            {-.477103E+00, 0.659461E+00}, {-.479447E+00, 0.657453E+00},
            {-.481882E+00, 0.655357E+00}, {-.484407E+00, 0.653176E+00},
            {-.487018E+00, 0.650912E+00}, {-.489712E+00, 0.648565E+00},
            {-.492486E+00, 0.646138E+00}, {-.495336E+00, 0.643633E+00},
            {-.498259E+00, 0.641051E+00}, {-.501252E+00, 0.638396E+00},
            {-.504311E+00, 0.635668E+00}, {-.507432E+00, 0.632870E+00},
            {-.510612E+00, 0.630005E+00}, {-.513848E+00, 0.627075E+00},
            {-.517135E+00, 0.624083E+00}, {-.520469E+00, 0.621030E+00},
            {-.523848E+00, 0.617921E+00}, {-.527266E+00, 0.614756E+00},
            {-.530721E+00, 0.611540E+00}, {-.534209E+00, 0.608275E+00},
            {-.537725E+00, 0.604964E+00}, {-.541266E+00, 0.601610E+00},
            {-.544828E+00, 0.598216E+00}, {-.548406E+00, 0.594786E+00},
            {-.551999E+00, 0.591322E+00}, {-.555600E+00, 0.587828E+00},
            {-.559208E+00, 0.584308E+00}, {-.562817E+00, 0.580764E+00},
            {-.566425E+00, 0.577200E+00}, {-.570027E+00, 0.573620E+00},
            {-.573620E+00, 0.570027E+00}, {-.577200E+00, 0.566425E+00},
            {-.580764E+00, 0.562817E+00}, {-.584308E+00, 0.559208E+00},
            {-.587828E+00, 0.555600E+00}, {-.591322E+00, 0.551999E+00},
            {-.594786E+00, 0.548406E+00}, {-.598216E+00, 0.544828E+00},
            {-.601610E+00, 0.541266E+00}, {-.604964E+00, 0.537725E+00},
            {-.608275E+00, 0.534209E+00}, {-.611540E+00, 0.530721E+00},
            {-.614756E+00, 0.527266E+00}, {-.617921E+00, 0.523848E+00},
            {-.621030E+00, 0.520469E+00}, {-.624083E+00, 0.517135E+00},
            {-.627075E+00, 0.513848E+00}, {-.630005E+00, 0.510612E+00},
            {-.632870E+00, 0.507432E+00}, {-.635668E+00, 0.504311E+00},
            {-.638396E+00, 0.501252E+00}, {-.641051E+00, 0.498259E+00},
            {-.643633E+00, 0.495336E+00}, {-.646138E+00, 0.492486E+00},
            {-.648565E+00, 0.489712E+00}, {-.650912E+00, 0.487018E+00},
            {-.653176E+00, 0.484407E+00}, {-.655357E+00, 0.481882E+00},
            {-.657453E+00, 0.479447E+00}, {-.659461E+00, 0.477103E+00},
            {-.661381E+00, 0.474855E+00}, {-.663210E+00, 0.472704E+00},
            {-.664949E+00, 0.470654E+00}, {-.666595E+00, 0.468707E+00},
            {-.668146E+00, 0.466865E+00}, {-.669603E+00, 0.465131E+00},
            {-.670964E+00, 0.463507E+00}, {-.672228E+00, 0.461994E+00},
            {-.673394E+00, 0.460596E+00}, {-.674462E+00, 0.459313E+00},
            {-.675430E+00, 0.458147E+00}, {-.676297E+00, 0.457100E+00},
            {-.677065E+00, 0.456173E+00}, {-.677731E+00, 0.455368E+00},
            {-.678295E+00, 0.454684E+00}, {-.678757E+00, 0.454123E+00},
            {-.679117E+00, 0.453687E+00}, {-.679374E+00, 0.453375E+00},
            {-.679528E+00, 0.453187E+00}, {-.679580E+00, 0.453124E+00},
        },
        {
            {-.446711E+00, 0.683884E+00}, {-.446776E+00, 0.683830E+00},
            {-.446974E+00, 0.683669E+00}, {-.447302E+00, 0.683401E+00},
            {-.447761E+00, 0.683027E+00}, {-.448351E+00, 0.682545E+00},
            {-.449070E+00, 0.681957E+00}, {-.449917E+00, 0.681263E+00},
            {-.450892E+00, 0.680463E+00}, {-.451992E+00, 0.679559E+00},
            {-.453218E+00, 0.678550E+00}, {-.454567E+00, 0.677437E+00},
            {-.456037E+00, 0.676221E+00}, {-.457627E+00, 0.674903E+00},
            {-.459334E+00, 0.673485E+00}, {-.461157E+00, 0.671965E+00},
            {-.463093E+00, 0.670347E+00}, {-.465140E+00, 0.668631E+00},
            {-.467295E+00, 0.666818E+00}, {-.469555E+00, 0.664909E+00},
            {-.471918E+00, 0.662906E+00}, {-.474380E+00, 0.660811E+00},
            {-.476939E+00, 0.658625E+00}, {-.479592E+00, 0.656349E+00},
            {-.482335E+00, 0.653985E+00}, {-.485165E+00, 0.651536E+00},
            {-.488078E+00, 0.649002E+00}, {-.491071E+00, 0.646387E+00},
            {-.494141E+00, 0.643691E+00}, {-.497284E+00, 0.640918E+00},
            {-.500495E+00, 0.638069E+00}, {-.503772E+00, 0.635147E+00},
            {-.507110E+00, 0.632154E+00}, {-.510506E+00, 0.629093E+00},
            {-.513955E+00, 0.625965E+00}, {-.517455E+00, 0.622775E+00},
            {-.520999E+00, 0.619525E+00}, {-.524586E+00, 0.616217E+00},
            {-.528210E+00, 0.612854E+00}, {-.531868E+00, 0.609440E+00},
            {-.535555E+00, 0.605977E+00}, {-.539268E+00, 0.602469E+00},
            {-.543003E+00, 0.598918E+00}, {-.546755E+00, 0.595329E+00},
            {-.550520E+00, 0.591705E+00}, {-.554295E+00, 0.588048E+00},
            {-.558075E+00, 0.584363E+00}, {-.561857E+00, 0.580653E+00},
            {-.565636E+00, 0.576921E+00}, {-.569409E+00, 0.573172E+00},
            {-.573172E+00, 0.569409E+00}, {-.576921E+00, 0.565636E+00},
            {-.580653E+00, 0.561857E+00}, {-.584363E+00, 0.558075E+00},
            {-.588048E+00, 0.554295E+00}, {-.591705E+00, 0.550520E+00},
            {-.595329E+00, 0.546755E+00}, {-.598918E+00, 0.543003E+00},
            {-.602469E+00, 0.539268E+00}, {-.605977E+00, 0.535555E+00},
            {-.609440E+00, 0.531868E+00}, {-.612854E+00, 0.528210E+00},
            {-.616217E+00, 0.524586E+00}, {-.619525E+00, 0.520999E+00},
            {-.622775E+00, 0.517455E+00}, {-.625965E+00, 0.513955E+00},
            {-.629093E+00, 0.510506E+00}, {-.632154E+00, 0.507110E+00},
            {-.635147E+00, 0.503772E+00}, {-.638069E+00, 0.500495E+00},
            {-.640918E+00, 0.497284E+00}, {-.643691E+00, 0.494141E+00},
            {-.646387E+00, 0.491071E+00}, {-.649002E+00, 0.488078E+00},
            {-.651536E+00, 0.485165E+00}, {-.653985E+00, 0.482335E+00},
            {-.656349E+00, 0.479592E+00}, {-.658625E+00, 0.476939E+00},
            {-.660811E+00, 0.474380E+00}, {-.662906E+00, 0.471918E+00},
            {-.664909E+00, 0.469555E+00}, {-.666818E+00, 0.467295E+00},
            {-.668631E+00, 0.465140E+00}, {-.670347E+00, 0.463093E+00},
            {-.671965E+00, 0.461157E+00}, {-.673485E+00, 0.459334E+00},
            {-.674903E+00, 0.457627E+00}, {-.676221E+00, 0.456037E+00},
            {-.677437E+00, 0.454567E+00}, {-.678550E+00, 0.453218E+00},
            {-.679559E+00, 0.451992E+00}, {-.680463E+00, 0.450892E+00},
            {-.681263E+00, 0.449917E+00}, {-.681957E+00, 0.449070E+00},
            {-.682545E+00, 0.448351E+00}, {-.683027E+00, 0.447761E+00},
            {-.683401E+00, 0.447302E+00}, {-.683669E+00, 0.446974E+00},
            {-.683830E+00, 0.446776E+00}, {-.683884E+00, 0.446711E+00},
        },
        {
            {-.440214E+00, 0.688165E+00}, {-.440283E+00, 0.688109E+00},
            {-.440491E+00, 0.687942E+00}, {-.440835E+00, 0.687663E+00},
            {-.441317E+00, 0.687273E+00}, {-.441936E+00, 0.686772E+00},
            {-.442690E+00, 0.686160E+00}, {-.443580E+00, 0.685438E+00},
            {-.444603E+00, 0.684606E+00}, {-.445758E+00, 0.683665E+00},
            {-.447045E+00, 0.682615E+00}, {-.448460E+00, 0.681457E+00},
            {-.450003E+00, 0.680192E+00}, {-.451672E+00, 0.678821E+00},
            {-.453463E+00, 0.677344E+00}, {-.455376E+00, 0.675763E+00},
            {-.457407E+00, 0.674079E+00}, {-.459555E+00, 0.672292E+00},
            {-.461815E+00, 0.670404E+00}, {-.464186E+00, 0.668417E+00},
            {-.466665E+00, 0.666332E+00}, {-.469247E+00, 0.664150E+00},
            {-.471931E+00, 0.661872E+00}, {-.474713E+00, 0.659502E+00},
            {-.477590E+00, 0.657040E+00}, {-.480557E+00, 0.654488E+00},
            {-.483611E+00, 0.651848E+00}, {-.486749E+00, 0.649122E+00},
            {-.489967E+00, 0.646313E+00}, {-.493261E+00, 0.643422E+00},
            {-.496626E+00, 0.640452E+00}, {-.500060E+00, 0.637405E+00},
            {-.503558E+00, 0.634284E+00}, {-.507116E+00, 0.631091E+00},
            {-.510729E+00, 0.627829E+00}, {-.514395E+00, 0.624501E+00},
            {-.518107E+00, 0.621109E+00}, {-.521863E+00, 0.617657E+00},
            {-.525658E+00, 0.614148E+00}, {-.529487E+00, 0.610584E+00},
            {-.533347E+00, 0.606969E+00}, {-.537234E+00, 0.603306E+00},
            {-.541142E+00, 0.599599E+00}, {-.545068E+00, 0.595850E+00},
            {-.549008E+00, 0.592064E+00}, {-.552957E+00, 0.588244E+00},
            {-.556911E+00, 0.584393E+00}, {-.560866E+00, 0.580516E+00},
            {-.564818E+00, 0.576616E+00}, {-.568763E+00, 0.572697E+00},
            {-.572697E+00, 0.568763E+00}, {-.576616E+00, 0.564818E+00},
            {-.580516E+00, 0.560866E+00}, {-.584393E+00, 0.556911E+00},
            {-.588244E+00, 0.552957E+00}, {-.592064E+00, 0.549008E+00},
            {-.595850E+00, 0.545068E+00}, {-.599599E+00, 0.541142E+00},
            {-.603306E+00, 0.537234E+00}, {-.606969E+00, 0.533347E+00},
            {-.610584E+00, 0.529487E+00}, {-.614148E+00, 0.525658E+00},
            {-.617657E+00, 0.521863E+00}, {-.621109E+00, 0.518107E+00},
            {-.624501E+00, 0.514395E+00}, {-.627829E+00, 0.510729E+00},
            {-.631091E+00, 0.507116E+00}, {-.634284E+00, 0.503558E+00},
            {-.637405E+00, 0.500060E+00}, {-.640452E+00, 0.496626E+00},
            {-.643422E+00, 0.493261E+00}, {-.646313E+00, 0.489967E+00},
            {-.649122E+00, 0.486749E+00}, {-.651848E+00, 0.483611E+00},
            {-.654488E+00, 0.480557E+00}, {-.657040E+00, 0.477590E+00},
            {-.659502E+00, 0.474713E+00}, {-.661872E+00, 0.471931E+00},
            {-.664150E+00, 0.469247E+00}, {-.666332E+00, 0.466665E+00},
            {-.668417E+00, 0.464186E+00}, {-.670404E+00, 0.461815E+00},
            {-.672292E+00, 0.459555E+00}, {-.674079E+00, 0.457407E+00},
            {-.675763E+00, 0.455376E+00}, {-.677344E+00, 0.453463E+00},
            {-.678821E+00, 0.451672E+00}, {-.680192E+00, 0.450003E+00},
            {-.681457E+00, 0.448460E+00}, {-.682615E+00, 0.447045E+00},
            {-.683665E+00, 0.445758E+00}, {-.684606E+00, 0.444603E+00},
            {-.685438E+00, 0.443580E+00}, {-.686160E+00, 0.442690E+00},
            {-.686772E+00, 0.441936E+00}, {-.687273E+00, 0.441317E+00},
            {-.687663E+00, 0.440835E+00}, {-.687942E+00, 0.440491E+00},
            {-.688109E+00, 0.440283E+00}, {-.688165E+00, 0.440214E+00},
        },
        {
            {-.433633E+00, 0.692423E+00}, {-.433706E+00, 0.692365E+00},
            {-.433923E+00, 0.692191E+00}, {-.434284E+00, 0.691902E+00},
            {-.434789E+00, 0.691497E+00}, {-.435437E+00, 0.690976E+00},
            {-.436228E+00, 0.690341E+00}, {-.437160E+00, 0.689591E+00},
            {-.438232E+00, 0.688727E+00}, {-.439443E+00, 0.687750E+00},
            {-.440791E+00, 0.686659E+00}, {-.442274E+00, 0.685456E+00},
            {-.443890E+00, 0.684142E+00}, {-.445638E+00, 0.682718E+00},
            {-.447515E+00, 0.681183E+00}, {-.449519E+00, 0.679540E+00},
            {-.451647E+00, 0.677790E+00}, {-.453896E+00, 0.675933E+00},
            {-.456263E+00, 0.673971E+00}, {-.458747E+00, 0.671906E+00},
            {-.461342E+00, 0.669738E+00}, {-.464047E+00, 0.667469E+00},
            {-.466857E+00, 0.665101E+00}, {-.469769E+00, 0.662636E+00},
            {-.472781E+00, 0.660075E+00}, {-.475887E+00, 0.657421E+00},
            {-.479084E+00, 0.654675E+00}, {-.482368E+00, 0.651839E+00},
            {-.485735E+00, 0.648916E+00}, {-.489182E+00, 0.645907E+00},
            {-.492703E+00, 0.642816E+00}, {-.496296E+00, 0.639645E+00},
            {-.499955E+00, 0.636395E+00}, {-.503676E+00, 0.633071E+00},
            {-.507455E+00, 0.629674E+00}, {-.511288E+00, 0.626208E+00},
            {-.515170E+00, 0.622675E+00}, {-.519097E+00, 0.619079E+00},
            {-.523064E+00, 0.615422E+00}, {-.527066E+00, 0.611708E+00},
            {-.531100E+00, 0.607940E+00}, {-.535161E+00, 0.604122E+00},
            {-.539245E+00, 0.600257E+00}, {-.543347E+00, 0.596348E+00},
            {-.547462E+00, 0.592400E+00}, {-.551586E+00, 0.588416E+00},
            {-.555715E+00, 0.584399E+00}, {-.559845E+00, 0.580354E+00},
            {-.563971E+00, 0.576285E+00}, {-.568089E+00, 0.572195E+00},
            {-.572195E+00, 0.568089E+00}, {-.576285E+00, 0.563971E+00},
            {-.580354E+00, 0.559845E+00}, {-.584399E+00, 0.555715E+00},
            {-.588416E+00, 0.551586E+00}, {-.592400E+00, 0.547462E+00},
            {-.596348E+00, 0.543347E+00}, {-.600257E+00, 0.539245E+00},
            {-.604122E+00, 0.535161E+00}, {-.607940E+00, 0.531100E+00},
            {-.611708E+00, 0.527066E+00}, {-.615422E+00, 0.523064E+00},
            {-.619079E+00, 0.519097E+00}, {-.622675E+00, 0.515170E+00},
            {-.626208E+00, 0.511288E+00}, {-.629674E+00, 0.507455E+00},
            {-.633071E+00, 0.503676E+00}, {-.636395E+00, 0.499955E+00},
            {-.639645E+00, 0.496296E+00}, {-.642816E+00, 0.492703E+00},
            {-.645907E+00, 0.489182E+00}, {-.648916E+00, 0.485735E+00},
            {-.651839E+00, 0.482368E+00}, {-.654675E+00, 0.479084E+00},
            {-.657421E+00, 0.475887E+00}, {-.660075E+00, 0.472781E+00},
            {-.662636E+00, 0.469769E+00}, {-.665101E+00, 0.466857E+00},
            {-.667469E+00, 0.464047E+00}, {-.669738E+00, 0.461342E+00},
            {-.671906E+00, 0.458747E+00}, {-.673971E+00, 0.456263E+00},
            {-.675933E+00, 0.453896E+00}, {-.677790E+00, 0.451647E+00},
            {-.679540E+00, 0.449519E+00}, {-.681183E+00, 0.447515E+00},
            {-.682718E+00, 0.445638E+00}, {-.684142E+00, 0.443890E+00},
            {-.685456E+00, 0.442274E+00}, {-.686659E+00, 0.440791E+00},
            {-.687750E+00, 0.439443E+00}, {-.688727E+00, 0.438232E+00},
            {-.689591E+00, 0.437160E+00}, {-.690341E+00, 0.436228E+00},
            {-.690976E+00, 0.435437E+00}, {-.691497E+00, 0.434789E+00},
            {-.691902E+00, 0.434284E+00}, {-.692191E+00, 0.433923E+00},
            {-.692365E+00, 0.433706E+00}, {-.692423E+00, 0.433633E+00},
        },
        {
            {-.426965E+00, 0.696659E+00}, {-.427040E+00, 0.696599E+00},
            {-.427267E+00, 0.696419E+00}, {-.427645E+00, 0.696119E+00},
            {-.428174E+00, 0.695699E+00}, {-.428852E+00, 0.695159E+00},
            {-.429680E+00, 0.694500E+00}, {-.430655E+00, 0.693723E+00},
            {-.431776E+00, 0.692827E+00}, {-.433043E+00, 0.691813E+00},
            {-.434453E+00, 0.690682E+00}, {-.436005E+00, 0.689435E+00},
            {-.437696E+00, 0.688072E+00}, {-.439525E+00, 0.686594E+00},
            {-.441488E+00, 0.685002E+00}, {-.443584E+00, 0.683298E+00},
            {-.445809E+00, 0.681481E+00}, {-.448161E+00, 0.679555E+00},
            {-.450637E+00, 0.677519E+00}, {-.453234E+00, 0.675375E+00},
            {-.455948E+00, 0.673125E+00}, {-.458776E+00, 0.670770E+00},
            {-.461714E+00, 0.668312E+00}, {-.464758E+00, 0.665752E+00},
            {-.467906E+00, 0.663093E+00}, {-.471152E+00, 0.660336E+00},
            {-.474494E+00, 0.657484E+00}, {-.477926E+00, 0.654538E+00},
            {-.481444E+00, 0.651501E+00}, {-.485045E+00, 0.648375E+00},
            {-.488724E+00, 0.645163E+00}, {-.492477E+00, 0.641866E+00},
            {-.496299E+00, 0.638489E+00}, {-.500185E+00, 0.635032E+00},
            {-.504132E+00, 0.631501E+00}, {-.508134E+00, 0.627896E+00},
            {-.512186E+00, 0.624221E+00}, {-.516285E+00, 0.620480E+00},
            {-.520426E+00, 0.616676E+00}, {-.524603E+00, 0.612812E+00},
            {-.528813E+00, 0.608891E+00}, {-.533050E+00, 0.604917E+00},
            {-.537310E+00, 0.600893E+00}, {-.541589E+00, 0.596824E+00},
            {-.545881E+00, 0.592713E+00}, {-.550182E+00, 0.588564E+00},
            {-.554488E+00, 0.584380E+00}, {-.558793E+00, 0.580167E+00},
            {-.563094E+00, 0.575927E+00}, {-.567387E+00, 0.571666E+00},
            {-.571666E+00, 0.567387E+00}, {-.575927E+00, 0.563094E+00},
            {-.580167E+00, 0.558793E+00}, {-.584380E+00, 0.554488E+00},
            {-.588564E+00, 0.550182E+00}, {-.592713E+00, 0.545881E+00},
            {-.596824E+00, 0.541589E+00}, {-.600893E+00, 0.537310E+00},
            {-.604917E+00, 0.533050E+00}, {-.608891E+00, 0.528813E+00},
            {-.612812E+00, 0.524603E+00}, {-.616676E+00, 0.520426E+00},
            {-.620480E+00, 0.516285E+00}, {-.624221E+00, 0.512186E+00},
            {-.627896E+00, 0.508134E+00}, {-.631501E+00, 0.504132E+00},
            {-.635032E+00, 0.500185E+00}, {-.638489E+00, 0.496299E+00},
            {-.641866E+00, 0.492477E+00}, {-.645163E+00, 0.488724E+00},
            {-.648375E+00, 0.485045E+00}, {-.651501E+00, 0.481444E+00},
            {-.654538E+00, 0.477926E+00}, {-.657484E+00, 0.474494E+00},
            {-.660336E+00, 0.471152E+00}, {-.663093E+00, 0.467906E+00},
            {-.665752E+00, 0.464758E+00}, {-.668312E+00, 0.461714E+00},
            {-.670770E+00, 0.458776E+00}, {-.673125E+00, 0.455948E+00},
            {-.675375E+00, 0.453234E+00}, {-.677519E+00, 0.450637E+00},
            {-.679555E+00, 0.448161E+00}, {-.681481E+00, 0.445809E+00},
            {-.683298E+00, 0.443584E+00}, {-.685002E+00, 0.441488E+00},
            {-.686594E+00, 0.439525E+00}, {-.688072E+00, 0.437696E+00},
            {-.689435E+00, 0.436005E+00}, {-.690682E+00, 0.434453E+00},
            {-.691813E+00, 0.433043E+00}, {-.692827E+00, 0.431776E+00},
            {-.693723E+00, 0.430655E+00}, {-.694500E+00, 0.429680E+00},
            {-.695159E+00, 0.428852E+00}, {-.695699E+00, 0.428174E+00},
            {-.696119E+00, 0.427645E+00}, {-.696419E+00, 0.427267E+00},
            {-.696599E+00, 0.427040E+00}, {-.696659E+00, 0.426965E+00},
        },
        {
            {-.420206E+00, 0.700874E+00}, {-.420285E+00, 0.700812E+00},
            {-.420522E+00, 0.700625E+00}, {-.420917E+00, 0.700314E+00},
            {-.421469E+00, 0.699880E+00}, {-.422178E+00, 0.699321E+00},
            {-.423043E+00, 0.698639E+00}, {-.424062E+00, 0.697834E+00},
            {-.425234E+00, 0.696906E+00}, {-.426557E+00, 0.695856E+00},
            {-.428030E+00, 0.694685E+00}, {-.429651E+00, 0.693393E+00},
            {-.431418E+00, 0.691981E+00}, {-.433328E+00, 0.690451E+00},
            {-.435379E+00, 0.688802E+00}, {-.437568E+00, 0.687036E+00},
            {-.439892E+00, 0.685154E+00}, {-.442349E+00, 0.683158E+00},
            {-.444935E+00, 0.681048E+00}, {-.447646E+00, 0.678826E+00},
            {-.450480E+00, 0.676494E+00}, {-.453432E+00, 0.674053E+00},
            {-.456500E+00, 0.671504E+00}, {-.459678E+00, 0.668850E+00},
            {-.462964E+00, 0.666093E+00}, {-.466352E+00, 0.663234E+00},
            {-.469839E+00, 0.660275E+00}, {-.473421E+00, 0.657219E+00},
            {-.477092E+00, 0.654069E+00}, {-.480850E+00, 0.650825E+00},
            {-.484688E+00, 0.647491E+00}, {-.488602E+00, 0.644070E+00},
            {-.492588E+00, 0.640564E+00}, {-.496642E+00, 0.636976E+00},
            {-.500757E+00, 0.633308E+00}, {-.504930E+00, 0.629565E+00},
            {-.509155E+00, 0.625749E+00}, {-.513428E+00, 0.621863E+00},
            {-.517744E+00, 0.617910E+00}, {-.522098E+00, 0.613895E+00},
            {-.526484E+00, 0.609820E+00}, {-.530899E+00, 0.605690E+00},
            {-.535337E+00, 0.601507E+00}, {-.539794E+00, 0.597277E+00},
            {-.544264E+00, 0.593002E+00}, {-.548744E+00, 0.588687E+00},
            {-.553227E+00, 0.584336E+00}, {-.557709E+00, 0.579952E+00},
            {-.562187E+00, 0.575542E+00}, {-.566654E+00, 0.571107E+00},
            {-.571107E+00, 0.566654E+00}, {-.575542E+00, 0.562187E+00},
            {-.579952E+00, 0.557709E+00}, {-.584336E+00, 0.553227E+00},
            {-.588687E+00, 0.548744E+00}, {-.593002E+00, 0.544264E+00},
            {-.597277E+00, 0.539794E+00}, {-.601507E+00, 0.535337E+00},
            {-.605690E+00, 0.530899E+00}, {-.609820E+00, 0.526484E+00},
            {-.613895E+00, 0.522098E+00}, {-.617910E+00, 0.517744E+00},
            {-.621863E+00, 0.513428E+00}, {-.625749E+00, 0.509155E+00},
            {-.629565E+00, 0.504930E+00}, {-.633308E+00, 0.500757E+00},
            {-.636976E+00, 0.496642E+00}, {-.640564E+00, 0.492588E+00},
            {-.644070E+00, 0.488602E+00}, {-.647491E+00, 0.484688E+00},
            {-.650825E+00, 0.480850E+00}, {-.654069E+00, 0.477092E+00},
            {-.657219E+00, 0.473421E+00}, {-.660275E+00, 0.469839E+00},
            {-.663234E+00, 0.466352E+00}, {-.666093E+00, 0.462964E+00},
            {-.668850E+00, 0.459678E+00}, {-.671504E+00, 0.456500E+00},
            {-.674053E+00, 0.453432E+00}, {-.676494E+00, 0.450480E+00},
            {-.678826E+00, 0.447646E+00}, {-.681048E+00, 0.444935E+00},
            {-.683158E+00, 0.442349E+00}, {-.685154E+00, 0.439892E+00},
            {-.687036E+00, 0.437568E+00}, {-.688802E+00, 0.435379E+00},
            {-.690451E+00, 0.433328E+00}, {-.691981E+00, 0.431418E+00},
            {-.693393E+00, 0.429651E+00}, {-.694685E+00, 0.428030E+00},
            {-.695856E+00, 0.426557E+00}, {-.696906E+00, 0.425234E+00},
            {-.697834E+00, 0.424062E+00}, {-.698639E+00, 0.423043E+00},
            {-.699321E+00, 0.422178E+00}, {-.699880E+00, 0.421469E+00},
            {-.700314E+00, 0.420917E+00}, {-.700625E+00, 0.420522E+00},
            {-.700812E+00, 0.420285E+00}, {-.700874E+00, 0.420206E+00},
        },
        {
            {-.413354E+00, 0.705068E+00}, {-.413437E+00, 0.705004E+00},
            {-.413684E+00, 0.704811E+00}, {-.414096E+00, 0.704490E+00},
            {-.414673E+00, 0.704040E+00}, {-.415413E+00, 0.703462E+00},
            {-.416315E+00, 0.702757E+00}, {-.417378E+00, 0.701925E+00},
            {-.418601E+00, 0.700965E+00}, {-.419982E+00, 0.699879E+00},
            {-.421519E+00, 0.698668E+00}, {-.423210E+00, 0.697332E+00},
            {-.425054E+00, 0.695872E+00}, {-.427046E+00, 0.694288E+00},
            {-.429186E+00, 0.692582E+00}, {-.431469E+00, 0.690755E+00},
            {-.433894E+00, 0.688808E+00}, {-.436456E+00, 0.686742E+00},
            {-.439153E+00, 0.684559E+00}, {-.441981E+00, 0.682259E+00},
            {-.444936E+00, 0.679845E+00}, {-.448015E+00, 0.677318E+00},
            {-.451213E+00, 0.674679E+00}, {-.454527E+00, 0.671931E+00},
            {-.457952E+00, 0.669075E+00}, {-.461484E+00, 0.666114E+00},
            {-.465119E+00, 0.663049E+00}, {-.468851E+00, 0.659884E+00},
            {-.472678E+00, 0.656619E+00}, {-.476593E+00, 0.653258E+00},
            {-.480592E+00, 0.649802E+00}, {-.484670E+00, 0.646256E+00},
            {-.488822E+00, 0.642621E+00}, {-.493044E+00, 0.638901E+00},
            {-.497330E+00, 0.635098E+00}, {-.501675E+00, 0.631216E+00},
            {-.506075E+00, 0.627257E+00}, {-.510523E+00, 0.623226E+00},
            {-.515016E+00, 0.619125E+00}, {-.519548E+00, 0.614958E+00},
            {-.524113E+00, 0.610729E+00}, {-.528707E+00, 0.606441E+00},
            {-.533325E+00, 0.602099E+00}, {-.537961E+00, 0.597706E+00},
            {-.542611E+00, 0.593267E+00}, {-.547270E+00, 0.588785E+00},
            {-.551932E+00, 0.584265E+00}, {-.556593E+00, 0.579711E+00},
            {-.561248E+00, 0.575128E+00}, {-.565892E+00, 0.570520E+00},
            {-.570520E+00, 0.565892E+00}, {-.575128E+00, 0.561248E+00},
            {-.579711E+00, 0.556593E+00}, {-.584265E+00, 0.551932E+00},
            {-.588785E+00, 0.547270E+00}, {-.593267E+00, 0.542611E+00},
            {-.597706E+00, 0.537961E+00}, {-.602099E+00, 0.533325E+00},
            {-.606441E+00, 0.528707E+00}, {-.610729E+00, 0.524113E+00},
            {-.614958E+00, 0.519548E+00}, {-.619125E+00, 0.515016E+00},
            {-.623226E+00, 0.510523E+00}, {-.627257E+00, 0.506075E+00},
            {-.631216E+00, 0.501675E+00}, {-.635098E+00, 0.497330E+00},
            {-.638901E+00, 0.493044E+00}, {-.642621E+00, 0.488822E+00},
            {-.646256E+00, 0.484670E+00}, {-.649802E+00, 0.480592E+00},
            {-.653258E+00, 0.476593E+00}, {-.656619E+00, 0.472678E+00},
            {-.659884E+00, 0.468851E+00}, {-.663049E+00, 0.465119E+00},
            {-.666114E+00, 0.461484E+00}, {-.669075E+00, 0.457952E+00},
            {-.671931E+00, 0.454527E+00}, {-.674679E+00, 0.451213E+00},
            {-.677318E+00, 0.448015E+00}, {-.679845E+00, 0.444936E+00},
            {-.682259E+00, 0.441981E+00}, {-.684559E+00, 0.439153E+00},
            {-.686742E+00, 0.436456E+00}, {-.688808E+00, 0.433894E+00},
            {-.690755E+00, 0.431469E+00}, {-.692582E+00, 0.429186E+00},
            {-.694288E+00, 0.427046E+00}, {-.695872E+00, 0.425054E+00},
            {-.697332E+00, 0.423210E+00}, {-.698668E+00, 0.421519E+00},
            {-.699879E+00, 0.419982E+00}, {-.700965E+00, 0.418601E+00},
            {-.701925E+00, 0.417378E+00}, {-.702757E+00, 0.416315E+00},
            {-.703462E+00, 0.415413E+00}, {-.704040E+00, 0.414673E+00},
            {-.704490E+00, 0.414096E+00}, {-.704811E+00, 0.413684E+00},
            {-.705004E+00, 0.413437E+00}, {-.705068E+00, 0.413354E+00},
        },
        {
            {-.406407E+00, 0.709243E+00}, {-.406493E+00, 0.709176E+00},
            {-.406751E+00, 0.708977E+00}, {-.407181E+00, 0.708645E+00},
            {-.407781E+00, 0.708181E+00}, {-.408552E+00, 0.707584E+00},
            {-.409493E+00, 0.706856E+00}, {-.410601E+00, 0.705996E+00},
            {-.411875E+00, 0.705005E+00}, {-.413315E+00, 0.703884E+00},
            {-.414917E+00, 0.702632E+00}, {-.416679E+00, 0.701252E+00},
            {-.418600E+00, 0.699743E+00}, {-.420677E+00, 0.698107E+00},
            {-.422906E+00, 0.696345E+00}, {-.425285E+00, 0.694457E+00},
            {-.427811E+00, 0.692444E+00}, {-.430481E+00, 0.690309E+00},
            {-.433290E+00, 0.688052E+00}, {-.436236E+00, 0.685675E+00},
            {-.439314E+00, 0.683179E+00}, {-.442520E+00, 0.680565E+00},
            {-.445851E+00, 0.677837E+00}, {-.449302E+00, 0.674995E+00},
            {-.452868E+00, 0.672041E+00}, {-.456546E+00, 0.668978E+00},
            {-.460330E+00, 0.665807E+00}, {-.464216E+00, 0.662531E+00},
            {-.468198E+00, 0.659152E+00}, {-.472273E+00, 0.655673E+00},
            {-.476434E+00, 0.652097E+00}, {-.480678E+00, 0.648425E+00},
            {-.484998E+00, 0.644661E+00}, {-.489390E+00, 0.640808E+00},
            {-.493849E+00, 0.636869E+00}, {-.498368E+00, 0.632848E+00},
            {-.502944E+00, 0.628746E+00}, {-.507570E+00, 0.624569E+00},
            {-.512241E+00, 0.620319E+00}, {-.516952E+00, 0.616000E+00},
            {-.521698E+00, 0.611616E+00}, {-.526473E+00, 0.607171E+00},
            {-.531272E+00, 0.602668E+00}, {-.536089E+00, 0.598112E+00},
            {-.540921E+00, 0.593508E+00}, {-.545760E+00, 0.588858E+00},
            {-.550603E+00, 0.584169E+00}, {-.555443E+00, 0.579443E+00},
            {-.560277E+00, 0.574687E+00}, {-.565099E+00, 0.569904E+00},
            {-.569904E+00, 0.565099E+00}, {-.574687E+00, 0.560277E+00},
            {-.579443E+00, 0.555443E+00}, {-.584169E+00, 0.550603E+00},
            {-.588858E+00, 0.545760E+00}, {-.593508E+00, 0.540921E+00},
            {-.598112E+00, 0.536089E+00}, {-.602668E+00, 0.531272E+00},
            {-.607171E+00, 0.526473E+00}, {-.611616E+00, 0.521698E+00},
            {-.616000E+00, 0.516952E+00}, {-.620319E+00, 0.512241E+00},
            {-.624569E+00, 0.507570E+00}, {-.628746E+00, 0.502944E+00},
            {-.632848E+00, 0.498368E+00}, {-.636869E+00, 0.493849E+00},
            {-.640808E+00, 0.489390E+00}, {-.644661E+00, 0.484998E+00},
            {-.648425E+00, 0.480678E+00}, {-.652097E+00, 0.476434E+00},
            {-.655673E+00, 0.472273E+00}, {-.659152E+00, 0.468198E+00},
            {-.662531E+00, 0.464216E+00}, {-.665807E+00, 0.460330E+00},
            {-.668978E+00, 0.456546E+00}, {-.672041E+00, 0.452868E+00},
            {-.674995E+00, 0.449302E+00}, {-.677837E+00, 0.445851E+00},
            {-.680565E+00, 0.442520E+00}, {-.683179E+00, 0.439314E+00},
            {-.685675E+00, 0.436236E+00}, {-.688052E+00, 0.433290E+00},
            {-.690309E+00, 0.430481E+00}, {-.692444E+00, 0.427811E+00},
            {-.694457E+00, 0.425285E+00}, {-.696345E+00, 0.422906E+00},
            {-.698107E+00, 0.420677E+00}, {-.699743E+00, 0.418600E+00},
            {-.701252E+00, 0.416679E+00}, {-.702632E+00, 0.414917E+00},
            {-.703884E+00, 0.413315E+00}, {-.705005E+00, 0.411875E+00},
            {-.705996E+00, 0.410601E+00}, {-.706856E+00, 0.409493E+00},
            {-.707584E+00, 0.408552E+00}, {-.708181E+00, 0.407781E+00},
            {-.708645E+00, 0.407181E+00}, {-.708977E+00, 0.406751E+00},
            {-.709176E+00, 0.406493E+00}, {-.709243E+00, 0.406407E+00},
        },
        {
            {-.399361E+00, 0.713398E+00}, {-.399450E+00, 0.713329E+00},
            {-.399719E+00, 0.713124E+00}, {-.400167E+00, 0.712782E+00},
            {-.400792E+00, 0.712303E+00}, {-.401595E+00, 0.711687E+00},
            {-.402574E+00, 0.710936E+00}, {-.403728E+00, 0.710049E+00},
            {-.405054E+00, 0.709026E+00}, {-.406553E+00, 0.707869E+00},
            {-.408221E+00, 0.706578E+00}, {-.410055E+00, 0.705154E+00},
            {-.412055E+00, 0.703597E+00}, {-.414216E+00, 0.701908E+00},
            {-.416537E+00, 0.700089E+00}, {-.419013E+00, 0.698140E+00},
            {-.421642E+00, 0.696063E+00}, {-.424420E+00, 0.693859E+00},
            {-.427343E+00, 0.691528E+00}, {-.430408E+00, 0.689073E+00},
            {-.433611E+00, 0.686496E+00}, {-.436947E+00, 0.683797E+00},
            {-.440412E+00, 0.680978E+00}, {-.444001E+00, 0.678042E+00},
            {-.447711E+00, 0.674990E+00}, {-.451535E+00, 0.671825E+00},
            {-.455471E+00, 0.668548E+00}, {-.459511E+00, 0.665162E+00},
            {-.463652E+00, 0.661669E+00}, {-.467888E+00, 0.658072E+00},
            {-.472214E+00, 0.654374E+00}, {-.476625E+00, 0.650577E+00},
            {-.481115E+00, 0.646684E+00}, {-.485679E+00, 0.642698E+00},
            {-.490312E+00, 0.638623E+00}, {-.495008E+00, 0.634461E+00},
            {-.499761E+00, 0.630217E+00}, {-.504566E+00, 0.625893E+00},
            {-.509418E+00, 0.621493E+00}, {-.514310E+00, 0.617021E+00},
            {-.519238E+00, 0.612482E+00}, {-.524195E+00, 0.607878E+00},
            {-.529177E+00, 0.603214E+00}, {-.534177E+00, 0.598494E+00},
            {-.539191E+00, 0.593723E+00}, {-.544213E+00, 0.588905E+00},
            {-.549238E+00, 0.584045E+00}, {-.554259E+00, 0.579147E+00},
            {-.559273E+00, 0.574216E+00}, {-.564274E+00, 0.569257E+00},
            {-.569257E+00, 0.564274E+00}, {-.574216E+00, 0.559273E+00},
            {-.579147E+00, 0.554259E+00}, {-.584045E+00, 0.549238E+00},
            {-.588905E+00, 0.544213E+00}, {-.593723E+00, 0.539191E+00},
            {-.598494E+00, 0.534177E+00}, {-.603214E+00, 0.529177E+00},
            {-.607878E+00, 0.524195E+00}, {-.612482E+00, 0.519238E+00},
            {-.617021E+00, 0.514310E+00}, {-.621493E+00, 0.509418E+00},
            {-.625893E+00, 0.504566E+00}, {-.630217E+00, 0.499761E+00},
            {-.634461E+00, 0.495008E+00}, {-.638623E+00, 0.490312E+00},
            {-.642698E+00, 0.485679E+00}, {-.646684E+00, 0.481115E+00},
            {-.650577E+00, 0.476625E+00}, {-.654374E+00, 0.472214E+00},
            {-.658072E+00, 0.467888E+00}, {-.661669E+00, 0.463652E+00},
            {-.665162E+00, 0.459511E+00}, {-.668548E+00, 0.455471E+00},
            {-.671825E+00, 0.451535E+00}, {-.674990E+00, 0.447711E+00},
            {-.678042E+00, 0.444001E+00}, {-.680978E+00, 0.440412E+00},
            {-.683797E+00, 0.436947E+00}, {-.686496E+00, 0.433611E+00},
            {-.689073E+00, 0.430408E+00}, {-.691528E+00, 0.427343E+00},
            {-.693859E+00, 0.424420E+00}, {-.696063E+00, 0.421642E+00},
            {-.698140E+00, 0.419013E+00}, {-.700089E+00, 0.416537E+00},
            {-.701908E+00, 0.414216E+00}, {-.703597E+00, 0.412055E+00},
            {-.705154E+00, 0.410055E+00}, {-.706578E+00, 0.408221E+00},
            {-.707869E+00, 0.406553E+00}, {-.709026E+00, 0.405054E+00},
            {-.710049E+00, 0.403728E+00}, {-.710936E+00, 0.402574E+00},
            {-.711687E+00, 0.401595E+00}, {-.712303E+00, 0.400792E+00},
            {-.712782E+00, 0.400167E+00}, {-.713124E+00, 0.399719E+00},
            {-.713329E+00, 0.399450E+00}, {-.713398E+00, 0.399361E+00},
        },
        {
            {-.392213E+00, 0.717535E+00}, {-.392306E+00, 0.717464E+00},
            {-.392586E+00, 0.717252E+00}, {-.393051E+00, 0.716900E+00},
            {-.393702E+00, 0.716406E+00}, {-.394537E+00, 0.715772E+00},
            {-.395555E+00, 0.714998E+00}, {-.396755E+00, 0.714083E+00},
            {-.398135E+00, 0.713030E+00}, {-.399693E+00, 0.711837E+00},
            {-.401428E+00, 0.710506E+00}, {-.403336E+00, 0.709038E+00},
            {-.405415E+00, 0.707433E+00}, {-.407663E+00, 0.705692E+00},
            {-.410075E+00, 0.703817E+00}, {-.412650E+00, 0.701807E+00},
            {-.415383E+00, 0.699665E+00}, {-.418271E+00, 0.697392E+00},
            {-.421310E+00, 0.694988E+00}, {-.424496E+00, 0.692456E+00},
            {-.427825E+00, 0.689797E+00}, {-.431292E+00, 0.687012E+00},
            {-.434893E+00, 0.684103E+00}, {-.438623E+00, 0.681073E+00},
            {-.442477E+00, 0.677923E+00}, {-.446451E+00, 0.674656E+00},
            {-.450539E+00, 0.671272E+00}, {-.454736E+00, 0.667776E+00},
            {-.459037E+00, 0.664169E+00}, {-.463436E+00, 0.660454E+00},
            {-.467929E+00, 0.656634E+00}, {-.472509E+00, 0.652711E+00},
            {-.477171E+00, 0.648689E+00}, {-.481909E+00, 0.644570E+00},
            {-.486718E+00, 0.640358E+00}, {-.491592E+00, 0.636056E+00},
            {-.496524E+00, 0.631668E+00}, {-.501511E+00, 0.627197E+00},
            {-.506544E+00, 0.622647E+00}, {-.511620E+00, 0.618022E+00},
            {-.516731E+00, 0.613326E+00}, {-.521873E+00, 0.608563E+00},
            {-.527039E+00, 0.603737E+00}, {-.532224E+00, 0.598852E+00},
            {-.537423E+00, 0.593914E+00}, {-.542628E+00, 0.588926E+00},
            {-.547836E+00, 0.583894E+00}, {-.553041E+00, 0.578822E+00},
            {-.558236E+00, 0.573715E+00}, {-.563417E+00, 0.568579E+00},
            {-.568579E+00, 0.563417E+00}, {-.573715E+00, 0.558236E+00},
            {-.578822E+00, 0.553041E+00}, {-.583894E+00, 0.547836E+00},
            {-.588926E+00, 0.542628E+00}, {-.593914E+00, 0.537423E+00},
            {-.598852E+00, 0.532224E+00}, {-.603737E+00, 0.527039E+00},
            {-.608563E+00, 0.521873E+00}, {-.613326E+00, 0.516731E+00},
            {-.618022E+00, 0.511620E+00}, {-.622647E+00, 0.506544E+00},
            {-.627197E+00, 0.501511E+00}, {-.631668E+00, 0.496524E+00},
            {-.636056E+00, 0.491592E+00}, {-.640358E+00, 0.486718E+00},
            {-.644570E+00, 0.481909E+00}, {-.648689E+00, 0.477171E+00},
            {-.652711E+00, 0.472509E+00}, {-.656634E+00, 0.467929E+00},
            {-.660454E+00, 0.463436E+00}, {-.664169E+00, 0.459037E+00},
            {-.667776E+00, 0.454736E+00}, {-.671272E+00, 0.450539E+00},
            {-.674656E+00, 0.446451E+00}, {-.677923E+00, 0.442477E+00},
            {-.681073E+00, 0.438623E+00}, {-.684103E+00, 0.434893E+00},
            {-.687012E+00, 0.431292E+00}, {-.689797E+00, 0.427825E+00},
            {-.692456E+00, 0.424496E+00}, {-.694988E+00, 0.421310E+00},
            {-.697392E+00, 0.418271E+00}, {-.699665E+00, 0.415383E+00},
            {-.701807E+00, 0.412650E+00}, {-.703817E+00, 0.410075E+00},
            {-.705692E+00, 0.407663E+00}, {-.707433E+00, 0.405415E+00},
            {-.709038E+00, 0.403336E+00}, {-.710506E+00, 0.401428E+00},
            {-.711837E+00, 0.399693E+00}, {-.713030E+00, 0.398135E+00},
            {-.714083E+00, 0.396755E+00}, {-.714998E+00, 0.395555E+00},
            {-.715772E+00, 0.394537E+00}, {-.716406E+00, 0.393702E+00},
            {-.716900E+00, 0.393051E+00}, {-.717252E+00, 0.392586E+00},
            {-.717464E+00, 0.392306E+00}, {-.717535E+00, 0.392213E+00},
        },
        {
            {-.384961E+00, 0.721654E+00}, {-.385058E+00, 0.721581E+00},
            {-.385348E+00, 0.721363E+00}, {-.385832E+00, 0.721000E+00},
            {-.386508E+00, 0.720492E+00}, {-.387375E+00, 0.719839E+00},
            {-.388433E+00, 0.719042E+00}, {-.389680E+00, 0.718101E+00},
            {-.391114E+00, 0.717016E+00}, {-.392733E+00, 0.715788E+00},
            {-.394535E+00, 0.714418E+00}, {-.396518E+00, 0.712906E+00},
            {-.398678E+00, 0.711253E+00}, {-.401013E+00, 0.709460E+00},
            {-.403519E+00, 0.707528E+00}, {-.406193E+00, 0.705458E+00},
            {-.409032E+00, 0.703251E+00}, {-.412032E+00, 0.700909E+00},
            {-.415188E+00, 0.698432E+00}, {-.418496E+00, 0.695822E+00},
            {-.421953E+00, 0.693082E+00}, {-.425553E+00, 0.690211E+00},
            {-.429291E+00, 0.687213E+00}, {-.433164E+00, 0.684089E+00},
            {-.437165E+00, 0.680841E+00}, {-.441289E+00, 0.677471E+00},
            {-.445532E+00, 0.673981E+00}, {-.449888E+00, 0.670375E+00},
            {-.454351E+00, 0.666654E+00}, {-.458916E+00, 0.662820E+00},
            {-.463577E+00, 0.658878E+00}, {-.468328E+00, 0.654829E+00},
            {-.473164E+00, 0.650677E+00}, {-.478078E+00, 0.646424E+00},
            {-.483065E+00, 0.642075E+00}, {-.488118E+00, 0.637632E+00},
            {-.493233E+00, 0.633100E+00}, {-.498402E+00, 0.628481E+00},
            {-.503619E+00, 0.623781E+00}, {-.508880E+00, 0.619001E+00},
            {-.514177E+00, 0.614148E+00}, {-.519505E+00, 0.609225E+00},
            {-.524857E+00, 0.604236E+00}, {-.530229E+00, 0.599186E+00},
            {-.535613E+00, 0.594079E+00}, {-.541004E+00, 0.588921E+00},
            {-.546397E+00, 0.583716E+00}, {-.551786E+00, 0.578468E+00},
            {-.557164E+00, 0.573185E+00}, {-.562527E+00, 0.567869E+00},
            {-.567869E+00, 0.562527E+00}, {-.573185E+00, 0.557164E+00},
            {-.578468E+00, 0.551786E+00}, {-.583716E+00, 0.546397E+00},
            {-.588921E+00, 0.541004E+00}, {-.594079E+00, 0.535613E+00},
            {-.599186E+00, 0.530229E+00}, {-.604236E+00, 0.524857E+00},
            {-.609225E+00, 0.519505E+00}, {-.614148E+00, 0.514177E+00},
            {-.619001E+00, 0.508880E+00}, {-.623781E+00, 0.503619E+00},
            {-.628481E+00, 0.498402E+00}, {-.633100E+00, 0.493233E+00},
            {-.637632E+00, 0.488118E+00}, {-.642075E+00, 0.483065E+00},
            {-.646424E+00, 0.478078E+00}, {-.650677E+00, 0.473164E+00},
            {-.654829E+00, 0.468328E+00}, {-.658878E+00, 0.463577E+00},
            {-.662820E+00, 0.458916E+00}, {-.666654E+00, 0.454351E+00},
            {-.670375E+00, 0.449888E+00}, {-.673981E+00, 0.445532E+00},
            {-.677471E+00, 0.441289E+00}, {-.680841E+00, 0.437165E+00},
            {-.684089E+00, 0.433164E+00}, {-.687213E+00, 0.429291E+00},
            {-.690211E+00, 0.425553E+00}, {-.693082E+00, 0.421953E+00},
            {-.695822E+00, 0.418496E+00}, {-.698432E+00, 0.415188E+00},
            {-.700909E+00, 0.412032E+00}, {-.703251E+00, 0.409032E+00},
            {-.705458E+00, 0.406193E+00}, {-.707528E+00, 0.403519E+00},
            {-.709460E+00, 0.401013E+00}, {-.711253E+00, 0.398678E+00},
            {-.712906E+00, 0.396518E+00}, {-.714418E+00, 0.394535E+00},
            {-.715788E+00, 0.392733E+00}, {-.717016E+00, 0.391114E+00},
            {-.718101E+00, 0.389680E+00}, {-.719042E+00, 0.388433E+00},
            {-.719839E+00, 0.387375E+00}, {-.720492E+00, 0.386508E+00},
            {-.721000E+00, 0.385832E+00}, {-.721363E+00, 0.385348E+00},
            {-.721581E+00, 0.385058E+00}, {-.721654E+00, 0.384961E+00},
        },
        {
            {-.377600E+00, 0.725756E+00}, {-.377701E+00, 0.725681E+00},
            {-.378002E+00, 0.725457E+00}, {-.378504E+00, 0.725083E+00},
            {-.379206E+00, 0.724561E+00}, {-.380107E+00, 0.723889E+00},
            {-.381206E+00, 0.723069E+00}, {-.382500E+00, 0.722101E+00},
            {-.383989E+00, 0.720985E+00}, {-.385669E+00, 0.719722E+00},
            {-.387540E+00, 0.718312E+00}, {-.389598E+00, 0.716757E+00},
            {-.391840E+00, 0.715056E+00}, {-.394263E+00, 0.713211E+00},
            {-.396865E+00, 0.711223E+00}, {-.399640E+00, 0.709093E+00},
            {-.402586E+00, 0.706822E+00}, {-.405699E+00, 0.704410E+00},
            {-.408974E+00, 0.701861E+00}, {-.412406E+00, 0.699174E+00},
            {-.415992E+00, 0.696352E+00}, {-.419727E+00, 0.693395E+00},
            {-.423605E+00, 0.690307E+00}, {-.427621E+00, 0.687089E+00},
            {-.431771E+00, 0.683743E+00}, {-.436049E+00, 0.680271E+00},
            {-.440448E+00, 0.676675E+00}, {-.444965E+00, 0.672958E+00},
            {-.449592E+00, 0.669122E+00}, {-.454324E+00, 0.665170E+00},
            {-.459155E+00, 0.661105E+00}, {-.464080E+00, 0.656930E+00},
            {-.469091E+00, 0.652648E+00}, {-.474184E+00, 0.648261E+00},
            {-.479351E+00, 0.643774E+00}, {-.484586E+00, 0.639190E+00},
            {-.489884E+00, 0.634513E+00}, {-.495238E+00, 0.629746E+00},
            {-.500642E+00, 0.624894E+00}, {-.506089E+00, 0.619959E+00},
            {-.511574E+00, 0.614948E+00}, {-.517089E+00, 0.609864E+00},
            {-.522630E+00, 0.604711E+00}, {-.528189E+00, 0.599494E+00},
            {-.533761E+00, 0.594218E+00}, {-.539340E+00, 0.588888E+00},
            {-.544919E+00, 0.583508E+00}, {-.550494E+00, 0.578085E+00},
            {-.556057E+00, 0.572623E+00}, {-.561603E+00, 0.567127E+00},
            {-.567127E+00, 0.561603E+00}, {-.572623E+00, 0.556057E+00},
            {-.578085E+00, 0.550494E+00}, {-.583508E+00, 0.544919E+00},
            {-.588888E+00, 0.539340E+00}, {-.594218E+00, 0.533761E+00},
            {-.599494E+00, 0.528189E+00}, {-.604711E+00, 0.522630E+00},
            {-.609864E+00, 0.517089E+00}, {-.614948E+00, 0.511574E+00},
            {-.619959E+00, 0.506089E+00}, {-.624894E+00, 0.500642E+00},
            {-.629746E+00, 0.495238E+00}, {-.634513E+00, 0.489884E+00},
            {-.639190E+00, 0.484586E+00}, {-.643774E+00, 0.479351E+00},
            {-.648261E+00, 0.474184E+00}, {-.652648E+00, 0.469091E+00},
            {-.656930E+00, 0.464080E+00}, {-.661105E+00, 0.459155E+00},
            {-.665170E+00, 0.454324E+00}, {-.669122E+00, 0.449592E+00},
            {-.672958E+00, 0.444965E+00}, {-.676675E+00, 0.440448E+00},
            {-.680271E+00, 0.436049E+00}, {-.683743E+00, 0.431771E+00},
            {-.687089E+00, 0.427621E+00}, {-.690307E+00, 0.423605E+00},
            {-.693395E+00, 0.419727E+00}, {-.696352E+00, 0.415992E+00},
            {-.699174E+00, 0.412406E+00}, {-.701861E+00, 0.408974E+00},
            {-.704410E+00, 0.405699E+00}, {-.706822E+00, 0.402586E+00},
            {-.709093E+00, 0.399640E+00}, {-.711223E+00, 0.396865E+00},
            {-.713211E+00, 0.394263E+00}, {-.715056E+00, 0.391840E+00},
            {-.716757E+00, 0.389598E+00}, {-.718312E+00, 0.387540E+00},
            {-.719722E+00, 0.385669E+00}, {-.720985E+00, 0.383989E+00},
            {-.722101E+00, 0.382500E+00}, {-.723069E+00, 0.381206E+00},
            {-.723889E+00, 0.380107E+00}, {-.724561E+00, 0.379206E+00},
            {-.725083E+00, 0.378504E+00}, {-.725457E+00, 0.378002E+00},
            {-.725681E+00, 0.377701E+00}, {-.725756E+00, 0.377600E+00},
        },
        {
            {-.370128E+00, 0.729841E+00}, {-.370232E+00, 0.729764E+00},
            {-.370545E+00, 0.729534E+00}, {-.371066E+00, 0.729150E+00},
            {-.371794E+00, 0.728613E+00}, {-.372729E+00, 0.727923E+00},
            {-.373868E+00, 0.727080E+00}, {-.375211E+00, 0.726085E+00},
            {-.376755E+00, 0.724939E+00}, {-.378498E+00, 0.723640E+00},
            {-.380439E+00, 0.722191E+00}, {-.382573E+00, 0.720592E+00},
            {-.384898E+00, 0.718844E+00}, {-.387411E+00, 0.716947E+00},
            {-.390109E+00, 0.714903E+00}, {-.392987E+00, 0.712713E+00},
            {-.396042E+00, 0.710377E+00}, {-.399269E+00, 0.707897E+00},
            {-.402664E+00, 0.705274E+00}, {-.406223E+00, 0.702510E+00},
            {-.409941E+00, 0.699607E+00}, {-.413812E+00, 0.696565E+00},
            {-.417831E+00, 0.693387E+00}, {-.421994E+00, 0.690075E+00},
            {-.426294E+00, 0.686630E+00}, {-.430726E+00, 0.683056E+00},
            {-.435285E+00, 0.679353E+00}, {-.439964E+00, 0.675526E+00},
            {-.444757E+00, 0.671575E+00}, {-.449659E+00, 0.667504E+00},
            {-.454663E+00, 0.663317E+00}, {-.459763E+00, 0.659015E+00},
            {-.464952E+00, 0.654602E+00}, {-.470224E+00, 0.650081E+00},
            {-.475574E+00, 0.645456E+00}, {-.480993E+00, 0.640730E+00},
            {-.486477E+00, 0.635907E+00}, {-.492018E+00, 0.630991E+00},
            {-.497609E+00, 0.625986E+00}, {-.503246E+00, 0.620896E+00},
            {-.508920E+00, 0.615726E+00}, {-.514625E+00, 0.610479E+00},
            {-.520356E+00, 0.605161E+00}, {-.526105E+00, 0.599777E+00},
            {-.531867E+00, 0.594330E+00}, {-.537634E+00, 0.588827E+00},
            {-.543402E+00, 0.583272E+00}, {-.549164E+00, 0.577671E+00},
            {-.554913E+00, 0.572029E+00}, {-.560644E+00, 0.566351E+00},
            {-.566351E+00, 0.560644E+00}, {-.572029E+00, 0.554913E+00},
            {-.577671E+00, 0.549164E+00}, {-.583272E+00, 0.543402E+00},
            {-.588827E+00, 0.537634E+00}, {-.594330E+00, 0.531867E+00},
            {-.599777E+00, 0.526105E+00}, {-.605161E+00, 0.520356E+00},
            {-.610479E+00, 0.514625E+00}, {-.615726E+00, 0.508920E+00},
            {-.620896E+00, 0.503246E+00}, {-.625986E+00, 0.497609E+00},
            {-.630991E+00, 0.492018E+00}, {-.635907E+00, 0.486477E+00},
            {-.640730E+00, 0.480993E+00}, {-.645456E+00, 0.475574E+00},
            {-.650081E+00, 0.470224E+00}, {-.654602E+00, 0.464952E+00},
            {-.659015E+00, 0.459763E+00}, {-.663317E+00, 0.454663E+00},
            {-.667504E+00, 0.449659E+00}, {-.671575E+00, 0.444757E+00},
            {-.675526E+00, 0.439964E+00}, {-.679353E+00, 0.435285E+00},
            {-.683056E+00, 0.430726E+00}, {-.686630E+00, 0.426294E+00},
            {-.690075E+00, 0.421994E+00}, {-.693387E+00, 0.417831E+00},
            {-.696565E+00, 0.413812E+00}, {-.699607E+00, 0.409941E+00},
            {-.702510E+00, 0.406223E+00}, {-.705274E+00, 0.402664E+00},
            {-.707897E+00, 0.399269E+00}, {-.710377E+00, 0.396042E+00},
            {-.712713E+00, 0.392987E+00}, {-.714903E+00, 0.390109E+00},
            {-.716947E+00, 0.387411E+00}, {-.718844E+00, 0.384898E+00},
            {-.720592E+00, 0.382573E+00}, {-.722191E+00, 0.380439E+00},
            {-.723640E+00, 0.378498E+00}, {-.724939E+00, 0.376755E+00},
            {-.726085E+00, 0.375211E+00}, {-.727080E+00, 0.373868E+00},
            {-.727923E+00, 0.372729E+00}, {-.728613E+00, 0.371794E+00},
            {-.729150E+00, 0.371066E+00}, {-.729534E+00, 0.370545E+00},
            {-.729764E+00, 0.370232E+00}, {-.729841E+00, 0.370128E+00},
        },
        {
            {-.362540E+00, 0.733910E+00}, {-.362649E+00, 0.733831E+00},
            {-.362973E+00, 0.733595E+00}, {-.363513E+00, 0.733201E+00},
            {-.364268E+00, 0.732650E+00}, {-.365236E+00, 0.731941E+00},
            {-.366417E+00, 0.731076E+00}, {-.367809E+00, 0.730054E+00},
            {-.369410E+00, 0.728877E+00}, {-.371217E+00, 0.727543E+00},
            {-.373228E+00, 0.726055E+00}, {-.375439E+00, 0.724413E+00},
            {-.377849E+00, 0.722617E+00}, {-.380454E+00, 0.720669E+00},
            {-.383249E+00, 0.718569E+00}, {-.386231E+00, 0.716318E+00},
            {-.389396E+00, 0.713918E+00}, {-.392740E+00, 0.711369E+00},
            {-.396257E+00, 0.708673E+00}, {-.399944E+00, 0.705832E+00},
            {-.403794E+00, 0.702847E+00}, {-.407804E+00, 0.699720E+00},
            {-.411967E+00, 0.696452E+00}, {-.416277E+00, 0.693046E+00},
            {-.420730E+00, 0.689503E+00}, {-.425320E+00, 0.685826E+00},
            {-.430039E+00, 0.682017E+00}, {-.434883E+00, 0.678078E+00},
            {-.439845E+00, 0.674013E+00}, {-.444918E+00, 0.669823E+00},
            {-.450097E+00, 0.665512E+00}, {-.455374E+00, 0.661083E+00},
            {-.460743E+00, 0.656539E+00}, {-.466198E+00, 0.651883E+00},
            {-.471732E+00, 0.647119E+00}, {-.477338E+00, 0.642251E+00},
            {-.483009E+00, 0.637281E+00}, {-.488739E+00, 0.632216E+00},
            {-.494521E+00, 0.627057E+00}, {-.500348E+00, 0.621811E+00},
            {-.506213E+00, 0.616481E+00}, {-.512111E+00, 0.611071E+00},
            {-.518033E+00, 0.605587E+00}, {-.523974E+00, 0.600033E+00},
            {-.529927E+00, 0.594415E+00}, {-.535886E+00, 0.588738E+00},
            {-.541844E+00, 0.583006E+00}, {-.547795E+00, 0.577226E+00},
            {-.553732E+00, 0.571402E+00}, {-.559650E+00, 0.565542E+00},
            {-.565542E+00, 0.559650E+00}, {-.571402E+00, 0.553732E+00},
            {-.577226E+00, 0.547795E+00}, {-.583006E+00, 0.541844E+00},
            {-.588738E+00, 0.535886E+00}, {-.594415E+00, 0.529927E+00},
            {-.600033E+00, 0.523974E+00}, {-.605587E+00, 0.518033E+00},
            {-.611071E+00, 0.512111E+00}, {-.616481E+00, 0.506213E+00},
            {-.621811E+00, 0.500348E+00}, {-.627057E+00, 0.494521E+00},
            {-.632216E+00, 0.488739E+00}, {-.637281E+00, 0.483009E+00},
            {-.642251E+00, 0.477338E+00}, {-.647119E+00, 0.471732E+00},
            {-.651883E+00, 0.466198E+00}, {-.656539E+00, 0.460743E+00},
            {-.661083E+00, 0.455374E+00}, {-.665512E+00, 0.450097E+00},
            {-.669823E+00, 0.444918E+00}, {-.674013E+00, 0.439845E+00},
            {-.678078E+00, 0.434883E+00}, {-.682017E+00, 0.430039E+00},
            {-.685826E+00, 0.425320E+00}, {-.689503E+00, 0.420730E+00},
            {-.693046E+00, 0.416277E+00}, {-.696452E+00, 0.411967E+00},
            {-.699720E+00, 0.407804E+00}, {-.702847E+00, 0.403794E+00},
            {-.705832E+00, 0.399944E+00}, {-.708673E+00, 0.396257E+00},
            {-.711369E+00, 0.392740E+00}, {-.713918E+00, 0.389396E+00},
            {-.716318E+00, 0.386231E+00}, {-.718569E+00, 0.383249E+00},
            {-.720669E+00, 0.380454E+00}, {-.722617E+00, 0.377849E+00},
            {-.724413E+00, 0.375439E+00}, {-.726055E+00, 0.373228E+00},
            {-.727543E+00, 0.371217E+00}, {-.728877E+00, 0.369410E+00},
            {-.730054E+00, 0.367809E+00}, {-.731076E+00, 0.366417E+00},
            {-.731941E+00, 0.365236E+00}, {-.732650E+00, 0.364268E+00},
            {-.733201E+00, 0.363513E+00}, {-.733595E+00, 0.362973E+00},
            {-.733831E+00, 0.362649E+00}, {-.733910E+00, 0.362540E+00},
        },
        {
            {-.354834E+00, 0.737964E+00}, {-.354946E+00, 0.737884E+00},
            {-.355282E+00, 0.737641E+00}, {-.355841E+00, 0.737237E+00},
            {-.356623E+00, 0.736671E+00}, {-.357626E+00, 0.735944E+00},
            {-.358850E+00, 0.735057E+00}, {-.360291E+00, 0.734008E+00},
            {-.361949E+00, 0.732800E+00}, {-.363821E+00, 0.731432E+00},
            {-.365903E+00, 0.729904E+00}, {-.368194E+00, 0.728219E+00},
            {-.370690E+00, 0.726376E+00}, {-.373387E+00, 0.724376E+00},
            {-.376281E+00, 0.722220E+00}, {-.379369E+00, 0.719909E+00},
            {-.382646E+00, 0.717444E+00}, {-.386108E+00, 0.714827E+00},
            {-.389749E+00, 0.712059E+00}, {-.393565E+00, 0.709141E+00},
            {-.397551E+00, 0.706074E+00}, {-.401701E+00, 0.702861E+00},
            {-.406009E+00, 0.699504E+00}, {-.410470E+00, 0.696003E+00},
            {-.415077E+00, 0.692362E+00}, {-.419826E+00, 0.688582E+00},
            {-.424708E+00, 0.684666E+00}, {-.429719E+00, 0.680616E+00},
            {-.434851E+00, 0.676435E+00}, {-.440099E+00, 0.672126E+00},
            {-.445454E+00, 0.667692E+00}, {-.450911E+00, 0.663135E+00},
            {-.456463E+00, 0.658459E+00}, {-.462102E+00, 0.653668E+00},
            {-.467823E+00, 0.648764E+00}, {-.473617E+00, 0.643753E+00},
            {-.479478E+00, 0.638637E+00}, {-.485400E+00, 0.633420E+00},
            {-.491374E+00, 0.628108E+00}, {-.497394E+00, 0.622704E+00},
            {-.503453E+00, 0.617212E+00}, {-.509544E+00, 0.611639E+00},
            {-.515661E+00, 0.605987E+00}, {-.521796E+00, 0.600264E+00},
            {-.527942E+00, 0.594472E+00}, {-.534094E+00, 0.588619E+00},
            {-.540244E+00, 0.582709E+00}, {-.546385E+00, 0.576749E+00},
            {-.552512E+00, 0.570743E+00}, {-.558618E+00, 0.564697E+00},
            {-.564697E+00, 0.558618E+00}, {-.570743E+00, 0.552512E+00},
            {-.576749E+00, 0.546385E+00}, {-.582709E+00, 0.540244E+00},
            {-.588619E+00, 0.534094E+00}, {-.594472E+00, 0.527942E+00},
            {-.600264E+00, 0.521796E+00}, {-.605987E+00, 0.515661E+00},
            {-.611639E+00, 0.509544E+00}, {-.617212E+00, 0.503453E+00},
            {-.622704E+00, 0.497394E+00}, {-.628108E+00, 0.491374E+00},
            {-.633420E+00, 0.485400E+00}, {-.638637E+00, 0.479478E+00},
            {-.643753E+00, 0.473617E+00}, {-.648764E+00, 0.467823E+00},
            {-.653668E+00, 0.462102E+00}, {-.658459E+00, 0.456463E+00},
            {-.663135E+00, 0.450911E+00}, {-.667692E+00, 0.445454E+00},
            {-.672126E+00, 0.440099E+00}, {-.676435E+00, 0.434851E+00},
            {-.680616E+00, 0.429719E+00}, {-.684666E+00, 0.424708E+00},
            {-.688582E+00, 0.419826E+00}, {-.692362E+00, 0.415077E+00},
            {-.696003E+00, 0.410470E+00}, {-.699504E+00, 0.406009E+00},
            {-.702861E+00, 0.401701E+00}, {-.706074E+00, 0.397551E+00},
            {-.709141E+00, 0.393565E+00}, {-.712059E+00, 0.389749E+00},
            {-.714827E+00, 0.386108E+00}, {-.717444E+00, 0.382646E+00},
            {-.719909E+00, 0.379369E+00}, {-.722220E+00, 0.376281E+00},
            {-.724376E+00, 0.373387E+00}, {-.726376E+00, 0.370690E+00},
            {-.728219E+00, 0.368194E+00}, {-.729904E+00, 0.365903E+00},
            {-.731432E+00, 0.363821E+00}, {-.732800E+00, 0.361949E+00},
            {-.734008E+00, 0.360291E+00}, {-.735057E+00, 0.358850E+00},
            {-.735944E+00, 0.357626E+00}, {-.736671E+00, 0.356623E+00},
            {-.737237E+00, 0.355841E+00}, {-.737641E+00, 0.355282E+00},
            {-.737884E+00, 0.354946E+00}, {-.737964E+00, 0.354834E+00},
        },
        {
            {-.347004E+00, 0.742004E+00}, {-.347120E+00, 0.741921E+00},
            {-.347468E+00, 0.741672E+00}, {-.348047E+00, 0.741258E+00},
            {-.348856E+00, 0.740678E+00}, {-.349895E+00, 0.739933E+00},
            {-.351161E+00, 0.739023E+00}, {-.352654E+00, 0.737948E+00},
            {-.354369E+00, 0.736709E+00}, {-.356307E+00, 0.735306E+00},
            {-.358462E+00, 0.733740E+00}, {-.360833E+00, 0.732011E+00},
            {-.363416E+00, 0.730121E+00}, {-.366207E+00, 0.728069E+00},
            {-.369202E+00, 0.725857E+00}, {-.372397E+00, 0.723487E+00},
            {-.375788E+00, 0.720958E+00}, {-.379369E+00, 0.718272E+00},
            {-.383136E+00, 0.715431E+00}, {-.387084E+00, 0.712436E+00},
            {-.391207E+00, 0.709288E+00}, {-.395499E+00, 0.705989E+00},
            {-.399954E+00, 0.702542E+00}, {-.404568E+00, 0.698947E+00},
            {-.409332E+00, 0.695207E+00}, {-.414242E+00, 0.691324E+00},
            {-.419290E+00, 0.687301E+00}, {-.424470E+00, 0.683140E+00},
            {-.429775E+00, 0.678843E+00}, {-.435199E+00, 0.674414E+00},
            {-.440733E+00, 0.669856E+00}, {-.446373E+00, 0.665171E+00},
            {-.452109E+00, 0.660363E+00}, {-.457935E+00, 0.655435E+00},
            {-.463845E+00, 0.650392E+00}, {-.469830E+00, 0.645236E+00},
            {-.475883E+00, 0.639972E+00}, {-.481998E+00, 0.634604E+00},
            {-.488167E+00, 0.629137E+00}, {-.494382E+00, 0.623574E+00},
            {-.500637E+00, 0.617921E+00}, {-.506925E+00, 0.612182E+00},
            {-.513237E+00, 0.606362E+00}, {-.519568E+00, 0.600467E+00},
            {-.525910E+00, 0.594501E+00}, {-.532257E+00, 0.588471E+00},
            {-.538600E+00, 0.582381E+00}, {-.544935E+00, 0.576238E+00},
            {-.551253E+00, 0.570048E+00}, {-.557549E+00, 0.563816E+00},
            {-.563816E+00, 0.557549E+00}, {-.570048E+00, 0.551253E+00},
            {-.576238E+00, 0.544935E+00}, {-.582381E+00, 0.538600E+00},
            {-.588471E+00, 0.532257E+00}, {-.594501E+00, 0.525910E+00},
            {-.600467E+00, 0.519568E+00}, {-.606362E+00, 0.513237E+00},
            {-.612182E+00, 0.506925E+00}, {-.617921E+00, 0.500637E+00},
            {-.623574E+00, 0.494382E+00}, {-.629137E+00, 0.488167E+00},
            {-.634604E+00, 0.481998E+00}, {-.639972E+00, 0.475883E+00},
            {-.645236E+00, 0.469830E+00}, {-.650392E+00, 0.463845E+00},
            {-.655435E+00, 0.457935E+00}, {-.660363E+00, 0.452109E+00},
            {-.665171E+00, 0.446373E+00}, {-.669856E+00, 0.440733E+00},
            {-.674414E+00, 0.435199E+00}, {-.678843E+00, 0.429775E+00},
            {-.683140E+00, 0.424470E+00}, {-.687301E+00, 0.419290E+00},
            {-.691324E+00, 0.414242E+00}, {-.695207E+00, 0.409332E+00},
            {-.698947E+00, 0.404568E+00}, {-.702542E+00, 0.399954E+00},
            {-.705989E+00, 0.395499E+00}, {-.709288E+00, 0.391207E+00},
            {-.712436E+00, 0.387084E+00}, {-.715431E+00, 0.383136E+00},
            {-.718272E+00, 0.379369E+00}, {-.720958E+00, 0.375788E+00},
            {-.723487E+00, 0.372397E+00}, {-.725857E+00, 0.369202E+00},
            {-.728069E+00, 0.366207E+00}, {-.730121E+00, 0.363416E+00},
            {-.732011E+00, 0.360833E+00}, {-.733740E+00, 0.358462E+00},
            {-.735306E+00, 0.356307E+00}, {-.736709E+00, 0.354369E+00},
            {-.737948E+00, 0.352654E+00}, {-.739023E+00, 0.351161E+00},
            {-.739933E+00, 0.349895E+00}, {-.740678E+00, 0.348856E+00},
            {-.741258E+00, 0.348047E+00}, {-.741672E+00, 0.347468E+00},
            {-.741921E+00, 0.347120E+00}, {-.742004E+00, 0.347004E+00},
        },
        {
            {-.339048E+00, 0.746030E+00}, {-.339168E+00, 0.745945E+00},
            {-.339528E+00, 0.745690E+00}, {-.340127E+00, 0.745266E+00},
            {-.340964E+00, 0.744672E+00}, {-.342038E+00, 0.743908E+00},
            {-.343348E+00, 0.742976E+00}, {-.344892E+00, 0.741874E+00},
            {-.346667E+00, 0.740604E+00}, {-.348670E+00, 0.739167E+00},
            {-.350900E+00, 0.737562E+00}, {-.353352E+00, 0.735790E+00},
            {-.356023E+00, 0.733852E+00}, {-.358910E+00, 0.731749E+00},
            {-.362007E+00, 0.729482E+00}, {-.365311E+00, 0.727051E+00},
            {-.368817E+00, 0.724458E+00}, {-.372520E+00, 0.721704E+00},
            {-.376415E+00, 0.718790E+00}, {-.380496E+00, 0.715718E+00},
            {-.384758E+00, 0.712489E+00}, {-.389195E+00, 0.709104E+00},
            {-.393800E+00, 0.705567E+00}, {-.398568E+00, 0.701877E+00},
            {-.403492E+00, 0.698039E+00}, {-.408565E+00, 0.694053E+00},
            {-.413781E+00, 0.689922E+00}, {-.419133E+00, 0.685649E+00},
            {-.424613E+00, 0.681236E+00}, {-.430215E+00, 0.676687E+00},
            {-.435931E+00, 0.672004E+00}, {-.441755E+00, 0.667191E+00},
            {-.447678E+00, 0.662250E+00}, {-.453694E+00, 0.657185E+00},
            {-.459795E+00, 0.652001E+00}, {-.465973E+00, 0.646700E+00},
            {-.472221E+00, 0.641288E+00}, {-.478532E+00, 0.635768E+00},
            {-.484898E+00, 0.630144E+00}, {-.491311E+00, 0.624421E+00},
            {-.497764E+00, 0.618605E+00}, {-.504250E+00, 0.612700E+00},
            {-.510761E+00, 0.606710E+00}, {-.517289E+00, 0.600642E+00},
            {-.523829E+00, 0.594501E+00}, {-.530372E+00, 0.588292E+00},
            {-.536912E+00, 0.582021E+00}, {-.543441E+00, 0.575695E+00},
            {-.549953E+00, 0.569318E+00}, {-.556441E+00, 0.562898E+00},
            {-.562898E+00, 0.556441E+00}, {-.569318E+00, 0.549953E+00},
            {-.575695E+00, 0.543441E+00}, {-.582021E+00, 0.536912E+00},
            {-.588292E+00, 0.530372E+00}, {-.594501E+00, 0.523829E+00},
            {-.600642E+00, 0.517289E+00}, {-.606710E+00, 0.510761E+00},
            {-.612700E+00, 0.504250E+00}, {-.618605E+00, 0.497764E+00},
            {-.624421E+00, 0.491311E+00}, {-.630144E+00, 0.484898E+00},
            {-.635768E+00, 0.478532E+00}, {-.641288E+00, 0.472221E+00},
            {-.646700E+00, 0.465973E+00}, {-.652001E+00, 0.459795E+00},
            {-.657185E+00, 0.453694E+00}, {-.662250E+00, 0.447678E+00},
            {-.667191E+00, 0.441755E+00}, {-.672004E+00, 0.435931E+00},
            {-.676687E+00, 0.430215E+00}, {-.681236E+00, 0.424613E+00},
            {-.685649E+00, 0.419133E+00}, {-.689922E+00, 0.413781E+00},
            {-.694053E+00, 0.408565E+00}, {-.698039E+00, 0.403492E+00},
            {-.701877E+00, 0.398568E+00}, {-.705567E+00, 0.393800E+00},
            {-.709104E+00, 0.389195E+00}, {-.712489E+00, 0.384758E+00},
            {-.715718E+00, 0.380496E+00}, {-.718790E+00, 0.376415E+00},
            {-.721704E+00, 0.372520E+00}, {-.724458E+00, 0.368817E+00},
            {-.727051E+00, 0.365311E+00}, {-.729482E+00, 0.362007E+00},
            {-.731749E+00, 0.358910E+00}, {-.733852E+00, 0.356023E+00},
            {-.735790E+00, 0.353352E+00}, {-.737562E+00, 0.350900E+00},
            {-.739167E+00, 0.348670E+00}, {-.740604E+00, 0.346667E+00},
            {-.741874E+00, 0.344892E+00}, {-.742976E+00, 0.343348E+00},
            {-.743908E+00, 0.342038E+00}, {-.744672E+00, 0.340964E+00},
            {-.745266E+00, 0.340127E+00}, {-.745690E+00, 0.339528E+00},
            {-.745945E+00, 0.339168E+00}, {-.746030E+00, 0.339048E+00},
        },
        {
            {-.330960E+00, 0.750042E+00}, {-.331084E+00, 0.749955E+00},
            {-.331456E+00, 0.749695E+00}, {-.332075E+00, 0.749260E+00},
            {-.332941E+00, 0.748652E+00}, {-.334052E+00, 0.747870E+00},
            {-.335406E+00, 0.746915E+00}, {-.337002E+00, 0.745787E+00},
            {-.338837E+00, 0.744487E+00}, {-.340908E+00, 0.743015E+00},
            {-.343213E+00, 0.741371E+00}, {-.345748E+00, 0.739556E+00},
            {-.348509E+00, 0.737572E+00}, {-.351492E+00, 0.735417E+00},
            {-.354694E+00, 0.733094E+00}, {-.358108E+00, 0.730604E+00},
            {-.361732E+00, 0.727947E+00}, {-.365558E+00, 0.725124E+00},
            {-.369583E+00, 0.722137E+00}, {-.373799E+00, 0.718988E+00},
            {-.378203E+00, 0.715677E+00}, {-.382786E+00, 0.712207E+00},
            {-.387543E+00, 0.708579E+00}, {-.392468E+00, 0.704795E+00},
            {-.397553E+00, 0.700857E+00}, {-.402792E+00, 0.696768E+00},
            {-.408178E+00, 0.692529E+00}, {-.413704E+00, 0.688144E+00},
            {-.419362E+00, 0.683615E+00}, {-.425145E+00, 0.678945E+00},
            {-.431045E+00, 0.674137E+00}, {-.437056E+00, 0.669194E+00},
            {-.443169E+00, 0.664120E+00}, {-.449377E+00, 0.658918E+00},
            {-.455671E+00, 0.653592E+00}, {-.462045E+00, 0.648146E+00},
            {-.468491E+00, 0.642584E+00}, {-.474999E+00, 0.636910E+00},
            {-.481564E+00, 0.631129E+00}, {-.488177E+00, 0.625246E+00},
            {-.494831E+00, 0.619265E+00}, {-.501517E+00, 0.613192E+00},
            {-.508229E+00, 0.607031E+00}, {-.514958E+00, 0.600789E+00},
            {-.521698E+00, 0.594471E+00}, {-.528440E+00, 0.588082E+00},
            {-.535178E+00, 0.581628E+00}, {-.541904E+00, 0.575116E+00},
            {-.548611E+00, 0.568552E+00}, {-.555293E+00, 0.561942E+00},
            {-.561942E+00, 0.555293E+00}, {-.568552E+00, 0.548611E+00},
            {-.575116E+00, 0.541904E+00}, {-.581628E+00, 0.535178E+00},
            {-.588082E+00, 0.528440E+00}, {-.594471E+00, 0.521698E+00},
            {-.600789E+00, 0.514958E+00}, {-.607031E+00, 0.508229E+00},
            {-.613192E+00, 0.501517E+00}, {-.619265E+00, 0.494831E+00},
            {-.625246E+00, 0.488177E+00}, {-.631129E+00, 0.481564E+00},
            {-.636910E+00, 0.474999E+00}, {-.642584E+00, 0.468491E+00},
            {-.648146E+00, 0.462045E+00}, {-.653592E+00, 0.455671E+00},
            {-.658918E+00, 0.449377E+00}, {-.664120E+00, 0.443169E+00},
            {-.669194E+00, 0.437056E+00}, {-.674137E+00, 0.431045E+00},
            {-.678945E+00, 0.425145E+00}, {-.683615E+00, 0.419362E+00},
            {-.688144E+00, 0.413704E+00}, {-.692529E+00, 0.408178E+00},
            {-.696768E+00, 0.402792E+00}, {-.700857E+00, 0.397553E+00},
            {-.704795E+00, 0.392468E+00}, {-.708579E+00, 0.387543E+00},
            {-.712207E+00, 0.382786E+00}, {-.715677E+00, 0.378203E+00},
            {-.718988E+00, 0.373799E+00}, {-.722137E+00, 0.369583E+00},
            {-.725124E+00, 0.365558E+00}, {-.727947E+00, 0.361732E+00},
            {-.730604E+00, 0.358108E+00}, {-.733094E+00, 0.354694E+00},
            {-.735417E+00, 0.351492E+00}, {-.737572E+00, 0.348509E+00},
            {-.739556E+00, 0.345748E+00}, {-.741371E+00, 0.343213E+00},
            {-.743015E+00, 0.340908E+00}, {-.744487E+00, 0.338837E+00},
            {-.745787E+00, 0.337002E+00}, {-.746915E+00, 0.335406E+00},
            {-.747870E+00, 0.334052E+00}, {-.748652E+00, 0.332941E+00},
            {-.749260E+00, 0.332075E+00}, {-.749695E+00, 0.331456E+00},
            {-.749955E+00, 0.331084E+00}, {-.750042E+00, 0.330960E+00},
        },
        {
            {-.322736E+00, 0.754042E+00}, {-.322864E+00, 0.753953E+00},
            {-.323249E+00, 0.753686E+00}, {-.323889E+00, 0.753242E+00},
            {-.324783E+00, 0.752619E+00}, {-.325931E+00, 0.751820E+00},
            {-.327331E+00, 0.750842E+00}, {-.328980E+00, 0.749688E+00},
            {-.330876E+00, 0.748358E+00}, {-.333016E+00, 0.746851E+00},
            {-.335397E+00, 0.745168E+00}, {-.338016E+00, 0.743311E+00},
            {-.340868E+00, 0.741279E+00}, {-.343950E+00, 0.739073E+00},
            {-.347257E+00, 0.736695E+00}, {-.350784E+00, 0.734144E+00},
            {-.354526E+00, 0.731423E+00}, {-.358478E+00, 0.728532E+00},
            {-.362635E+00, 0.725472E+00}, {-.366989E+00, 0.722246E+00},
            {-.371536E+00, 0.718853E+00}, {-.376268E+00, 0.715297E+00},
            {-.381179E+00, 0.711579E+00}, {-.386263E+00, 0.707700E+00},
            {-.391512E+00, 0.703663E+00}, {-.396920E+00, 0.699470E+00},
            {-.402478E+00, 0.695123E+00}, {-.408180E+00, 0.690626E+00},
            {-.414019E+00, 0.685980E+00}, {-.419985E+00, 0.681188E+00},
            {-.426073E+00, 0.676255E+00}, {-.432273E+00, 0.671182E+00},
            {-.438578E+00, 0.665974E+00}, {-.444980E+00, 0.660633E+00},
            {-.451471E+00, 0.655165E+00}, {-.458043E+00, 0.649572E+00},
            {-.464688E+00, 0.643859E+00}, {-.471398E+00, 0.638031E+00},
            {-.478165E+00, 0.632092E+00}, {-.484980E+00, 0.626047E+00},
            {-.491837E+00, 0.619900E+00}, {-.498726E+00, 0.613658E+00},
            {-.505641E+00, 0.607325E+00}, {-.512573E+00, 0.600907E+00},
            {-.519514E+00, 0.594410E+00}, {-.526458E+00, 0.587839E+00},
            {-.533396E+00, 0.581201E+00}, {-.540321E+00, 0.574502E+00},
            {-.547226E+00, 0.567748E+00}, {-.554103E+00, 0.560946E+00},
            {-.560946E+00, 0.554103E+00}, {-.567748E+00, 0.547226E+00},
            {-.574502E+00, 0.540321E+00}, {-.581201E+00, 0.533396E+00},
            {-.587839E+00, 0.526458E+00}, {-.594410E+00, 0.519514E+00},
            {-.600907E+00, 0.512573E+00}, {-.607325E+00, 0.505641E+00},
            {-.613658E+00, 0.498726E+00}, {-.619900E+00, 0.491837E+00},
            {-.626047E+00, 0.484980E+00}, {-.632092E+00, 0.478165E+00},
            {-.638031E+00, 0.471398E+00}, {-.643859E+00, 0.464688E+00},
            {-.649572E+00, 0.458043E+00}, {-.655165E+00, 0.451471E+00},
            {-.660633E+00, 0.444980E+00}, {-.665974E+00, 0.438578E+00},
            {-.671182E+00, 0.432273E+00}, {-.676255E+00, 0.426073E+00},
            {-.681188E+00, 0.419985E+00}, {-.685980E+00, 0.414019E+00},
            {-.690626E+00, 0.408180E+00}, {-.695123E+00, 0.402478E+00},
            {-.699470E+00, 0.396920E+00}, {-.703663E+00, 0.391512E+00},
            {-.707700E+00, 0.386263E+00}, {-.711579E+00, 0.381179E+00},
            {-.715297E+00, 0.376268E+00}, {-.718853E+00, 0.371536E+00},
            {-.722246E+00, 0.366989E+00}, {-.725472E+00, 0.362635E+00},
            {-.728532E+00, 0.358478E+00}, {-.731423E+00, 0.354526E+00},
            {-.734144E+00, 0.350784E+00}, {-.736695E+00, 0.347257E+00},
            {-.739073E+00, 0.343950E+00}, {-.741279E+00, 0.340868E+00},
            {-.743311E+00, 0.338016E+00}, {-.745168E+00, 0.335397E+00},
            {-.746851E+00, 0.333016E+00}, {-.748358E+00, 0.330876E+00},
            {-.749688E+00, 0.328980E+00}, {-.750842E+00, 0.327331E+00},
            {-.751820E+00, 0.325931E+00}, {-.752619E+00, 0.324783E+00},
            {-.753242E+00, 0.323889E+00}, {-.753686E+00, 0.323249E+00},
            {-.753953E+00, 0.322864E+00}, {-.754042E+00, 0.322736E+00},
        },
        {
            {-.314372E+00, 0.758030E+00}, {-.314504E+00, 0.757939E+00},
            {-.314901E+00, 0.757666E+00}, {-.315562E+00, 0.757212E+00},
            {-.316486E+00, 0.756575E+00}, {-.317672E+00, 0.755757E+00},
            {-.319117E+00, 0.754758E+00}, {-.320820E+00, 0.753578E+00},
            {-.322778E+00, 0.752217E+00}, {-.324988E+00, 0.750675E+00},
            {-.327447E+00, 0.748954E+00}, {-.330151E+00, 0.747054E+00},
            {-.333097E+00, 0.744975E+00}, {-.336279E+00, 0.742718E+00},
            {-.339693E+00, 0.740284E+00}, {-.343334E+00, 0.737674E+00},
            {-.347198E+00, 0.734888E+00}, {-.351277E+00, 0.731929E+00},
            {-.355567E+00, 0.728796E+00}, {-.360061E+00, 0.725492E+00},
            {-.364753E+00, 0.722018E+00}, {-.369637E+00, 0.718376E+00},
            {-.374705E+00, 0.714567E+00}, {-.379950E+00, 0.710593E+00},
            {-.385366E+00, 0.706456E+00}, {-.390944E+00, 0.702159E+00},
            {-.396678E+00, 0.697704E+00}, {-.402559E+00, 0.693094E+00},
            {-.408580E+00, 0.688330E+00}, {-.414733E+00, 0.683417E+00},
            {-.421010E+00, 0.678357E+00}, {-.427402E+00, 0.673154E+00},
            {-.433902E+00, 0.667810E+00}, {-.440502E+00, 0.662331E+00},
            {-.447192E+00, 0.656719E+00}, {-.453965E+00, 0.650979E+00},
            {-.460812E+00, 0.645114E+00}, {-.467725E+00, 0.639131E+00},
            {-.474696E+00, 0.633032E+00}, {-.481717E+00, 0.626824E+00},
            {-.488779E+00, 0.620510E+00}, {-.495874E+00, 0.614097E+00},
            {-.502994E+00, 0.607590E+00}, {-.510131E+00, 0.600995E+00},
            {-.517277E+00, 0.594317E+00}, {-.524424E+00, 0.587563E+00},
            {-.531565E+00, 0.580739E+00}, {-.538691E+00, 0.573851E+00},
            {-.545795E+00, 0.566906E+00}, {-.552871E+00, 0.559910E+00},
            {-.559910E+00, 0.552871E+00}, {-.566906E+00, 0.545795E+00},
            {-.573851E+00, 0.538691E+00}, {-.580739E+00, 0.531565E+00},
            {-.587563E+00, 0.524424E+00}, {-.594317E+00, 0.517277E+00},
            {-.600995E+00, 0.510131E+00}, {-.607590E+00, 0.502994E+00},
            {-.614097E+00, 0.495874E+00}, {-.620510E+00, 0.488779E+00},
            {-.626824E+00, 0.481717E+00}, {-.633032E+00, 0.474696E+00},
            {-.639131E+00, 0.467725E+00}, {-.645114E+00, 0.460812E+00},
            {-.650979E+00, 0.453965E+00}, {-.656719E+00, 0.447192E+00},
            {-.662331E+00, 0.440502E+00}, {-.667810E+00, 0.433902E+00},
            {-.673154E+00, 0.427402E+00}, {-.678357E+00, 0.421010E+00},
            {-.683417E+00, 0.414733E+00}, {-.688330E+00, 0.408580E+00},
            {-.693094E+00, 0.402559E+00}, {-.697704E+00, 0.396678E+00},
            {-.702159E+00, 0.390944E+00}, {-.706456E+00, 0.385366E+00},
            {-.710593E+00, 0.379950E+00}, {-.714567E+00, 0.374705E+00},
            {-.718376E+00, 0.369637E+00}, {-.722018E+00, 0.364753E+00},
            {-.725492E+00, 0.360061E+00}, {-.728796E+00, 0.355567E+00},
            {-.731929E+00, 0.351277E+00}, {-.734888E+00, 0.347198E+00},
            {-.737674E+00, 0.343334E+00}, {-.740284E+00, 0.339693E+00},
            {-.742718E+00, 0.336279E+00}, {-.744975E+00, 0.333097E+00},
            {-.747054E+00, 0.330151E+00}, {-.748954E+00, 0.327447E+00},
            {-.750675E+00, 0.324988E+00}, {-.752217E+00, 0.322778E+00},
            {-.753578E+00, 0.320820E+00}, {-.754758E+00, 0.319117E+00},
            {-.755757E+00, 0.317672E+00}, {-.756575E+00, 0.316486E+00},
            {-.757212E+00, 0.315562E+00}, {-.757666E+00, 0.314901E+00},
            {-.757939E+00, 0.314504E+00}, {-.758030E+00, 0.314372E+00},
        },
        {
            {-.305862E+00, 0.762007E+00}, {-.305999E+00, 0.761914E+00},
            {-.306409E+00, 0.761635E+00}, {-.307091E+00, 0.761170E+00},
            {-.308045E+00, 0.760520E+00}, {-.309269E+00, 0.759684E+00},
            {-.310761E+00, 0.758662E+00}, {-.312519E+00, 0.757456E+00},
            {-.314540E+00, 0.756064E+00}, {-.316821E+00, 0.754489E+00},
            {-.319359E+00, 0.752729E+00}, {-.322150E+00, 0.750786E+00},
            {-.325190E+00, 0.748660E+00}, {-.328474E+00, 0.746352E+00},
            {-.331997E+00, 0.743862E+00}, {-.335755E+00, 0.741192E+00},
            {-.339741E+00, 0.738343E+00}, {-.343950E+00, 0.735314E+00},
            {-.348376E+00, 0.732109E+00}, {-.353012E+00, 0.728728E+00},
            {-.357852E+00, 0.725172E+00}, {-.362889E+00, 0.721443E+00},
            {-.368116E+00, 0.717543E+00}, {-.373526E+00, 0.713474E+00},
            {-.379110E+00, 0.709238E+00}, {-.384862E+00, 0.704836E+00},
            {-.390774E+00, 0.700272E+00}, {-.396837E+00, 0.695548E+00},
            {-.403044E+00, 0.690667E+00}, {-.409385E+00, 0.685631E+00},
            {-.415854E+00, 0.680444E+00}, {-.422442E+00, 0.675109E+00},
            {-.429139E+00, 0.669630E+00}, {-.435938E+00, 0.664011E+00},
            {-.442830E+00, 0.658254E+00}, {-.449807E+00, 0.652366E+00},
            {-.456859E+00, 0.646349E+00}, {-.463979E+00, 0.640208E+00},
            {-.471157E+00, 0.633949E+00}, {-.478385E+00, 0.627576E+00},
            {-.485655E+00, 0.621094E+00}, {-.492959E+00, 0.614509E+00},
            {-.500287E+00, 0.607827E+00}, {-.507631E+00, 0.601053E+00},
            {-.514984E+00, 0.594193E+00}, {-.522337E+00, 0.587253E+00},
            {-.529683E+00, 0.580241E+00}, {-.537012E+00, 0.573162E+00},
            {-.544319E+00, 0.566023E+00}, {-.551594E+00, 0.558832E+00},
            {-.558832E+00, 0.551594E+00}, {-.566023E+00, 0.544319E+00},
            {-.573162E+00, 0.537012E+00}, {-.580241E+00, 0.529683E+00},
            {-.587253E+00, 0.522337E+00}, {-.594193E+00, 0.514984E+00},
            {-.601053E+00, 0.507631E+00}, {-.607827E+00, 0.500287E+00},
            {-.614509E+00, 0.492959E+00}, {-.621094E+00, 0.485655E+00},
            {-.627576E+00, 0.478385E+00}, {-.633949E+00, 0.471157E+00},
            {-.640208E+00, 0.463979E+00}, {-.646349E+00, 0.456859E+00},
            {-.652366E+00, 0.449807E+00}, {-.658254E+00, 0.442830E+00},
            {-.664011E+00, 0.435938E+00}, {-.669630E+00, 0.429139E+00},
            {-.675109E+00, 0.422442E+00}, {-.680444E+00, 0.415854E+00},
            {-.685631E+00, 0.409385E+00}, {-.690667E+00, 0.403044E+00},
            {-.695548E+00, 0.396837E+00}, {-.700272E+00, 0.390774E+00},
            {-.704836E+00, 0.384862E+00}, {-.709238E+00, 0.379110E+00},
            {-.713474E+00, 0.373526E+00}, {-.717543E+00, 0.368116E+00},
            {-.721443E+00, 0.362889E+00}, {-.725172E+00, 0.357852E+00},
            {-.728728E+00, 0.353012E+00}, {-.732109E+00, 0.348376E+00},
            {-.735314E+00, 0.343950E+00}, {-.738343E+00, 0.339741E+00},
            {-.741192E+00, 0.335755E+00}, {-.743862E+00, 0.331997E+00},
            {-.746352E+00, 0.328474E+00}, {-.748660E+00, 0.325190E+00},
            {-.750786E+00, 0.322150E+00}, {-.752729E+00, 0.319359E+00},
            {-.754489E+00, 0.316821E+00}, {-.756064E+00, 0.314540E+00},
            {-.757456E+00, 0.312519E+00}, {-.758662E+00, 0.310761E+00},
            {-.759684E+00, 0.309269E+00}, {-.760520E+00, 0.308045E+00},
            {-.761170E+00, 0.307091E+00}, {-.761635E+00, 0.306409E+00},
            {-.761914E+00, 0.305999E+00}, {-.762007E+00, 0.305862E+00},
        },
        {
            {-.297202E+00, 0.765973E+00}, {-.297343E+00, 0.765878E+00},
            {-.297766E+00, 0.765593E+00}, {-.298470E+00, 0.765118E+00},
            {-.299454E+00, 0.764454E+00}, {-.300717E+00, 0.763600E+00},
            {-.302257E+00, 0.762556E+00}, {-.304070E+00, 0.761324E+00},
            {-.306156E+00, 0.759902E+00}, {-.308509E+00, 0.758292E+00},
            {-.311128E+00, 0.756494E+00}, {-.314007E+00, 0.754508E+00},
            {-.317143E+00, 0.752335E+00}, {-.320530E+00, 0.749975E+00},
            {-.324165E+00, 0.747430E+00}, {-.328040E+00, 0.744701E+00},
            {-.332151E+00, 0.741787E+00}, {-.336492E+00, 0.738690E+00},
            {-.341056E+00, 0.735412E+00}, {-.345837E+00, 0.731953E+00},
            {-.350828E+00, 0.728315E+00}, {-.356021E+00, 0.724500E+00},
            {-.361409E+00, 0.720509E+00}, {-.366985E+00, 0.716344E+00},
            {-.372742E+00, 0.712007E+00}, {-.378670E+00, 0.707501E+00},
            {-.384762E+00, 0.702827E+00}, {-.391010E+00, 0.697989E+00},
            {-.397405E+00, 0.692989E+00}, {-.403938E+00, 0.687831E+00},
            {-.410602E+00, 0.682516E+00}, {-.417388E+00, 0.677049E+00},
            {-.424286E+00, 0.671434E+00}, {-.431287E+00, 0.665673E+00},
            {-.438384E+00, 0.659771E+00}, {-.445567E+00, 0.653733E+00},
            {-.452827E+00, 0.647562E+00}, {-.460156E+00, 0.641263E+00},
            {-.467544E+00, 0.634842E+00}, {-.474983E+00, 0.628303E+00},
            {-.482464E+00, 0.621651E+00}, {-.489978E+00, 0.614893E+00},
            {-.497516E+00, 0.608033E+00}, {-.505071E+00, 0.601079E+00},
            {-.512633E+00, 0.594035E+00}, {-.520195E+00, 0.586908E+00},
            {-.527748E+00, 0.579706E+00}, {-.535284E+00, 0.572434E+00},
            {-.542794E+00, 0.565099E+00}, {-.550272E+00, 0.557710E+00},
            {-.557710E+00, 0.550272E+00}, {-.565099E+00, 0.542794E+00},
            {-.572434E+00, 0.535284E+00}, {-.579706E+00, 0.527748E+00},
            {-.586908E+00, 0.520195E+00}, {-.594035E+00, 0.512633E+00},
            {-.601079E+00, 0.505071E+00}, {-.608033E+00, 0.497516E+00},
            {-.614893E+00, 0.489978E+00}, {-.621651E+00, 0.482464E+00},
            {-.628303E+00, 0.474983E+00}, {-.634842E+00, 0.467544E+00},
            {-.641263E+00, 0.460156E+00}, {-.647562E+00, 0.452827E+00},
            {-.653733E+00, 0.445567E+00}, {-.659771E+00, 0.438384E+00},
            {-.665673E+00, 0.431287E+00}, {-.671434E+00, 0.424286E+00},
            {-.677049E+00, 0.417388E+00}, {-.682516E+00, 0.410602E+00},
            {-.687831E+00, 0.403938E+00}, {-.692989E+00, 0.397405E+00},
            {-.697989E+00, 0.391010E+00}, {-.702827E+00, 0.384762E+00},
            {-.707501E+00, 0.378670E+00}, {-.712007E+00, 0.372742E+00},
            {-.716344E+00, 0.366985E+00}, {-.720509E+00, 0.361409E+00},
            {-.724500E+00, 0.356021E+00}, {-.728315E+00, 0.350828E+00},
            {-.731953E+00, 0.345837E+00}, {-.735412E+00, 0.341056E+00},
            {-.738690E+00, 0.336492E+00}, {-.741787E+00, 0.332151E+00},
            {-.744701E+00, 0.328040E+00}, {-.747430E+00, 0.324165E+00},
            {-.749975E+00, 0.320530E+00}, {-.752335E+00, 0.317143E+00},
            {-.754508E+00, 0.314007E+00}, {-.756494E+00, 0.311128E+00},
            {-.758292E+00, 0.308509E+00}, {-.759902E+00, 0.306156E+00},
            {-.761324E+00, 0.304070E+00}, {-.762556E+00, 0.302257E+00},
            {-.763600E+00, 0.300717E+00}, {-.764454E+00, 0.299454E+00},
            {-.765118E+00, 0.298470E+00}, {-.765593E+00, 0.297766E+00},
            {-.765878E+00, 0.297343E+00}, {-.765973E+00, 0.297202E+00},
        },
        {
            {-.288386E+00, 0.769929E+00}, {-.288531E+00, 0.769832E+00},
            {-.288967E+00, 0.769541E+00}, {-.289694E+00, 0.769056E+00},
            {-.290709E+00, 0.768378E+00}, {-.292011E+00, 0.767506E+00},
            {-.293599E+00, 0.766440E+00}, {-.295470E+00, 0.765181E+00},
            {-.297620E+00, 0.763730E+00}, {-.300048E+00, 0.762085E+00},
            {-.302748E+00, 0.760249E+00}, {-.305717E+00, 0.758220E+00},
            {-.308951E+00, 0.756000E+00}, {-.312444E+00, 0.753590E+00},
            {-.316191E+00, 0.750989E+00}, {-.320186E+00, 0.748199E+00},
            {-.324425E+00, 0.745221E+00}, {-.328900E+00, 0.742056E+00},
            {-.333604E+00, 0.738704E+00}, {-.338532E+00, 0.735168E+00},
            {-.343675E+00, 0.731448E+00}, {-.349027E+00, 0.727546E+00},
            {-.354580E+00, 0.723463E+00}, {-.360325E+00, 0.719202E+00},
            {-.366256E+00, 0.714765E+00}, {-.372363E+00, 0.710154E+00},
            {-.378639E+00, 0.705370E+00}, {-.385074E+00, 0.700418E+00},
            {-.391660E+00, 0.695299E+00}, {-.398389E+00, 0.690016E+00},
            {-.405250E+00, 0.684573E+00}, {-.412236E+00, 0.678973E+00},
            {-.419338E+00, 0.673220E+00}, {-.426545E+00, 0.667317E+00},
            {-.433850E+00, 0.661269E+00}, {-.441242E+00, 0.655080E+00},
            {-.448713E+00, 0.648754E+00}, {-.456254E+00, 0.642296E+00},
            {-.463855E+00, 0.635711E+00}, {-.471507E+00, 0.629004E+00},
            {-.479201E+00, 0.622181E+00}, {-.486929E+00, 0.615248E+00},
            {-.494681E+00, 0.608209E+00}, {-.502449E+00, 0.601072E+00},
            {-.510223E+00, 0.593842E+00}, {-.517996E+00, 0.586527E+00},
            {-.525759E+00, 0.579132E+00}, {-.533503E+00, 0.571665E+00},
            {-.541220E+00, 0.564133E+00}, {-.548903E+00, 0.556543E+00},
            {-.556543E+00, 0.548903E+00}, {-.564133E+00, 0.541220E+00},
            {-.571665E+00, 0.533503E+00}, {-.579132E+00, 0.525759E+00},
            {-.586527E+00, 0.517996E+00}, {-.593842E+00, 0.510223E+00},
            {-.601072E+00, 0.502449E+00}, {-.608209E+00, 0.494681E+00},
            {-.615248E+00, 0.486929E+00}, {-.622181E+00, 0.479201E+00},
            {-.629004E+00, 0.471507E+00}, {-.635711E+00, 0.463855E+00},
            {-.642296E+00, 0.456254E+00}, {-.648754E+00, 0.448713E+00},
            {-.655080E+00, 0.441242E+00}, {-.661269E+00, 0.433850E+00},
            {-.667317E+00, 0.426545E+00}, {-.673220E+00, 0.419338E+00},
            {-.678973E+00, 0.412236E+00}, {-.684573E+00, 0.405250E+00},
            {-.690016E+00, 0.398389E+00}, {-.695299E+00, 0.391660E+00},
            {-.700418E+00, 0.385074E+00}, {-.705370E+00, 0.378639E+00},
            {-.710154E+00, 0.372363E+00}, {-.714765E+00, 0.366256E+00},
            {-.719202E+00, 0.360325E+00}, {-.723463E+00, 0.354580E+00},
            {-.727546E+00, 0.349027E+00}, {-.731448E+00, 0.343675E+00},
            {-.735168E+00, 0.338532E+00}, {-.738704E+00, 0.333604E+00},
            {-.742056E+00, 0.328900E+00}, {-.745221E+00, 0.324425E+00},
            {-.748199E+00, 0.320186E+00}, {-.750989E+00, 0.316191E+00},
            {-.753590E+00, 0.312444E+00}, {-.756000E+00, 0.308951E+00},
            {-.758220E+00, 0.305717E+00}, {-.760249E+00, 0.302748E+00},
            {-.762085E+00, 0.300048E+00}, {-.763730E+00, 0.297620E+00},
            {-.765181E+00, 0.295470E+00}, {-.766440E+00, 0.293599E+00},
            {-.767506E+00, 0.292011E+00}, {-.768378E+00, 0.290709E+00},
            {-.769056E+00, 0.289694E+00}, {-.769541E+00, 0.288967E+00},
            {-.769832E+00, 0.288531E+00}, {-.769929E+00, 0.288386E+00},
        },
        {
            {-.279408E+00, 0.773876E+00}, {-.279557E+00, 0.773777E+00},
            {-.280007E+00, 0.773480E+00}, {-.280756E+00, 0.772985E+00},
            {-.281803E+00, 0.772293E+00}, {-.283146E+00, 0.771403E+00},
            {-.284783E+00, 0.770315E+00}, {-.286711E+00, 0.769030E+00},
            {-.288928E+00, 0.767548E+00}, {-.291431E+00, 0.765870E+00},
            {-.294214E+00, 0.763994E+00}, {-.297275E+00, 0.761923E+00},
            {-.300608E+00, 0.759657E+00}, {-.304208E+00, 0.757195E+00},
            {-.308070E+00, 0.754539E+00}, {-.312188E+00, 0.751689E+00},
            {-.316556E+00, 0.748647E+00}, {-.321167E+00, 0.745412E+00},
            {-.326015E+00, 0.741988E+00}, {-.331091E+00, 0.738373E+00},
            {-.336390E+00, 0.734571E+00}, {-.341903E+00, 0.730582E+00},
            {-.347623E+00, 0.726408E+00}, {-.353541E+00, 0.722050E+00},
            {-.359649E+00, 0.717512E+00}, {-.365938E+00, 0.712795E+00},
            {-.372400E+00, 0.707901E+00}, {-.379025E+00, 0.702833E+00},
            {-.385806E+00, 0.697594E+00}, {-.392732E+00, 0.692187E+00},
            {-.399795E+00, 0.686614E+00}, {-.406985E+00, 0.680881E+00},
            {-.414293E+00, 0.674989E+00}, {-.421709E+00, 0.668943E+00},
            {-.429224E+00, 0.662747E+00}, {-.436829E+00, 0.656406E+00},
            {-.444514E+00, 0.649923E+00}, {-.452269E+00, 0.643305E+00},
            {-.460086E+00, 0.636555E+00}, {-.467954E+00, 0.629679E+00},
            {-.475865E+00, 0.622683E+00}, {-.483810E+00, 0.615573E+00},
            {-.491778E+00, 0.608353E+00}, {-.499761E+00, 0.601032E+00},
            {-.507751E+00, 0.593614E+00}, {-.515738E+00, 0.586108E+00},
            {-.523713E+00, 0.578519E+00}, {-.531668E+00, 0.570855E+00},
            {-.539595E+00, 0.563122E+00}, {-.547485E+00, 0.555330E+00},
            {-.555330E+00, 0.547485E+00}, {-.563122E+00, 0.539595E+00},
            {-.570855E+00, 0.531668E+00}, {-.578519E+00, 0.523713E+00},
            {-.586108E+00, 0.515738E+00}, {-.593614E+00, 0.507751E+00},
            {-.601032E+00, 0.499761E+00}, {-.608353E+00, 0.491778E+00},
            {-.615573E+00, 0.483810E+00}, {-.622683E+00, 0.475865E+00},
            {-.629679E+00, 0.467954E+00}, {-.636555E+00, 0.460086E+00},
            {-.643305E+00, 0.452269E+00}, {-.649923E+00, 0.444514E+00},
            {-.656406E+00, 0.436829E+00}, {-.662747E+00, 0.429224E+00},
            {-.668943E+00, 0.421709E+00}, {-.674989E+00, 0.414293E+00},
            {-.680881E+00, 0.406985E+00}, {-.686614E+00, 0.399795E+00},
            {-.692187E+00, 0.392732E+00}, {-.697594E+00, 0.385806E+00},
            {-.702833E+00, 0.379025E+00}, {-.707901E+00, 0.372400E+00},
            {-.712795E+00, 0.365938E+00}, {-.717512E+00, 0.359649E+00},
            {-.722050E+00, 0.353541E+00}, {-.726408E+00, 0.347623E+00},
            {-.730582E+00, 0.341903E+00}, {-.734571E+00, 0.336390E+00},
            {-.738373E+00, 0.331091E+00}, {-.741988E+00, 0.326015E+00},
            {-.745412E+00, 0.321167E+00}, {-.748647E+00, 0.316556E+00},
            {-.751689E+00, 0.312188E+00}, {-.754539E+00, 0.308070E+00},
            {-.757195E+00, 0.304208E+00}, {-.759657E+00, 0.300608E+00},
            {-.761923E+00, 0.297275E+00}, {-.763994E+00, 0.294214E+00},
            {-.765870E+00, 0.291431E+00}, {-.767548E+00, 0.288928E+00},
            {-.769030E+00, 0.286711E+00}, {-.770315E+00, 0.284783E+00},
            {-.771403E+00, 0.283146E+00}, {-.772293E+00, 0.281803E+00},
            {-.772985E+00, 0.280756E+00}, {-.773480E+00, 0.280007E+00},
            {-.773777E+00, 0.279557E+00}, {-.773876E+00, 0.279408E+00},
        },
        {
            {-.270262E+00, 0.777814E+00}, {-.270416E+00, 0.777713E+00},
            {-.270880E+00, 0.777410E+00}, {-.271652E+00, 0.776905E+00},
            {-.272730E+00, 0.776199E+00}, {-.274115E+00, 0.775291E+00},
            {-.275802E+00, 0.774181E+00}, {-.277789E+00, 0.772871E+00},
            {-.280074E+00, 0.771359E+00}, {-.282653E+00, 0.769646E+00},
            {-.285522E+00, 0.767732E+00}, {-.288675E+00, 0.765618E+00},
            {-.292110E+00, 0.763304E+00}, {-.295819E+00, 0.760792E+00},
            {-.299798E+00, 0.758080E+00}, {-.304040E+00, 0.755170E+00},
            {-.308540E+00, 0.752063E+00}, {-.313289E+00, 0.748760E+00},
            {-.318282E+00, 0.745262E+00}, {-.323511E+00, 0.741570E+00},
            {-.328968E+00, 0.737684E+00}, {-.334645E+00, 0.733608E+00},
            {-.340534E+00, 0.729342E+00}, {-.346627E+00, 0.724888E+00},
            {-.352915E+00, 0.720248E+00}, {-.359389E+00, 0.715424E+00},
            {-.366041E+00, 0.710419E+00}, {-.372860E+00, 0.705236E+00},
            {-.379838E+00, 0.699876E+00}, {-.386965E+00, 0.694343E+00},
            {-.394232E+00, 0.688641E+00}, {-.401629E+00, 0.682772E+00},
            {-.409146E+00, 0.676741E+00}, {-.416774E+00, 0.670550E+00},
            {-.424504E+00, 0.664206E+00}, {-.432324E+00, 0.657711E+00},
            {-.440226E+00, 0.651071E+00}, {-.448200E+00, 0.644290E+00},
            {-.456235E+00, 0.637373E+00}, {-.464323E+00, 0.630327E+00},
            {-.472454E+00, 0.623156E+00}, {-.480618E+00, 0.615867E+00},
            {-.488805E+00, 0.608465E+00}, {-.497007E+00, 0.600957E+00},
            {-.505214E+00, 0.593350E+00}, {-.513418E+00, 0.585650E+00},
            {-.521608E+00, 0.577864E+00}, {-.529777E+00, 0.570001E+00},
            {-.537916E+00, 0.562066E+00}, {-.546016E+00, 0.554068E+00},
            {-.554068E+00, 0.546016E+00}, {-.562066E+00, 0.537916E+00},
            {-.570001E+00, 0.529777E+00}, {-.577864E+00, 0.521608E+00},
            {-.585650E+00, 0.513418E+00}, {-.593350E+00, 0.505214E+00},
            {-.600957E+00, 0.497007E+00}, {-.608465E+00, 0.488805E+00},
            {-.615867E+00, 0.480618E+00}, {-.623156E+00, 0.472454E+00},
            {-.630327E+00, 0.464323E+00}, {-.637373E+00, 0.456235E+00},
            {-.644290E+00, 0.448200E+00}, {-.651071E+00, 0.440226E+00},
            {-.657711E+00, 0.432324E+00}, {-.664206E+00, 0.424504E+00},
            {-.670550E+00, 0.416774E+00}, {-.676741E+00, 0.409146E+00},
            {-.682772E+00, 0.401629E+00}, {-.688641E+00, 0.394232E+00},
            {-.694343E+00, 0.386965E+00}, {-.699876E+00, 0.379838E+00},
            {-.705236E+00, 0.372860E+00}, {-.710419E+00, 0.366041E+00},
            {-.715424E+00, 0.359389E+00}, {-.720248E+00, 0.352915E+00},
            {-.724888E+00, 0.346627E+00}, {-.729342E+00, 0.340534E+00},
            {-.733608E+00, 0.334645E+00}, {-.737684E+00, 0.328968E+00},
            {-.741570E+00, 0.323511E+00}, {-.745262E+00, 0.318282E+00},
            {-.748760E+00, 0.313289E+00}, {-.752063E+00, 0.308540E+00},
            {-.755170E+00, 0.304040E+00}, {-.758080E+00, 0.299798E+00},
            {-.760792E+00, 0.295819E+00}, {-.763304E+00, 0.292110E+00},
            {-.765618E+00, 0.288675E+00}, {-.767732E+00, 0.285522E+00},
            {-.769646E+00, 0.282653E+00}, {-.771359E+00, 0.280074E+00},
            {-.772871E+00, 0.277789E+00}, {-.774181E+00, 0.275802E+00},
            {-.775291E+00, 0.274115E+00}, {-.776199E+00, 0.272730E+00},
            {-.776905E+00, 0.271652E+00}, {-.777410E+00, 0.270880E+00},
            {-.777713E+00, 0.270416E+00}, {-.777814E+00, 0.270262E+00},
        },
        {
            {-.260942E+00, 0.781744E+00}, {-.261101E+00, 0.781641E+00},
            {-.261579E+00, 0.781332E+00}, {-.262374E+00, 0.780818E+00},
            {-.263486E+00, 0.780097E+00}, {-.264912E+00, 0.779171E+00},
            {-.266650E+00, 0.778040E+00}, {-.268698E+00, 0.776703E+00},
            {-.271052E+00, 0.775161E+00}, {-.273708E+00, 0.773414E+00},
            {-.276663E+00, 0.771462E+00}, {-.279912E+00, 0.769305E+00},
            {-.283449E+00, 0.766945E+00}, {-.287270E+00, 0.764380E+00},
            {-.291368E+00, 0.761613E+00}, {-.295737E+00, 0.758644E+00},
            {-.300370E+00, 0.755472E+00}, {-.305261E+00, 0.752100E+00},
            {-.310402E+00, 0.748528E+00}, {-.315785E+00, 0.744757E+00},
            {-.321403E+00, 0.740789E+00}, {-.327247E+00, 0.736625E+00},
            {-.333309E+00, 0.732266E+00}, {-.339580E+00, 0.727715E+00},
            {-.346051E+00, 0.722973E+00}, {-.352713E+00, 0.718043E+00},
            {-.359557E+00, 0.712926E+00}, {-.366573E+00, 0.707626E+00},
            {-.373752E+00, 0.702144E+00}, {-.381083E+00, 0.696485E+00},
            {-.388557E+00, 0.690652E+00}, {-.396165E+00, 0.684647E+00},
            {-.403895E+00, 0.678475E+00}, {-.411738E+00, 0.672139E+00},
            {-.419685E+00, 0.665644E+00}, {-.427724E+00, 0.658995E+00},
            {-.435846E+00, 0.652195E+00}, {-.444041E+00, 0.645250E+00},
            {-.452299E+00, 0.638166E+00}, {-.460610E+00, 0.630947E+00},
            {-.468963E+00, 0.623600E+00}, {-.477350E+00, 0.616129E+00},
            {-.485759E+00, 0.608543E+00}, {-.494183E+00, 0.600847E+00},
            {-.502611E+00, 0.593047E+00}, {-.511034E+00, 0.585152E+00},
            {-.519443E+00, 0.577168E+00}, {-.527828E+00, 0.569102E+00},
            {-.536182E+00, 0.560962E+00}, {-.544494E+00, 0.552757E+00},
            {-.552757E+00, 0.544494E+00}, {-.560962E+00, 0.536182E+00},
            {-.569102E+00, 0.527828E+00}, {-.577168E+00, 0.519443E+00},
            {-.585152E+00, 0.511034E+00}, {-.593047E+00, 0.502611E+00},
            {-.600847E+00, 0.494183E+00}, {-.608543E+00, 0.485759E+00},
            {-.616129E+00, 0.477350E+00}, {-.623600E+00, 0.468963E+00},
            {-.630947E+00, 0.460610E+00}, {-.638166E+00, 0.452299E+00},
            {-.645250E+00, 0.444041E+00}, {-.652195E+00, 0.435846E+00},
            {-.658995E+00, 0.427724E+00}, {-.665644E+00, 0.419685E+00},
            {-.672139E+00, 0.411738E+00}, {-.678475E+00, 0.403895E+00},
            {-.684647E+00, 0.396165E+00}, {-.690652E+00, 0.388557E+00},
            {-.696485E+00, 0.381083E+00}, {-.702144E+00, 0.373752E+00},
            {-.707626E+00, 0.366573E+00}, {-.712926E+00, 0.359557E+00},
            {-.718043E+00, 0.352713E+00}, {-.722973E+00, 0.346051E+00},
            {-.727715E+00, 0.339580E+00}, {-.732266E+00, 0.333309E+00},
            {-.736625E+00, 0.327247E+00}, {-.740789E+00, 0.321403E+00},
            {-.744757E+00, 0.315785E+00}, {-.748528E+00, 0.310402E+00},
            {-.752100E+00, 0.305261E+00}, {-.755472E+00, 0.300370E+00},
            {-.758644E+00, 0.295737E+00}, {-.761613E+00, 0.291368E+00},
            {-.764380E+00, 0.287270E+00}, {-.766945E+00, 0.283449E+00},
            {-.769305E+00, 0.279912E+00}, {-.771462E+00, 0.276663E+00},
            {-.773414E+00, 0.273708E+00}, {-.775161E+00, 0.271052E+00},
            {-.776703E+00, 0.268698E+00}, {-.778040E+00, 0.266650E+00},
            {-.779171E+00, 0.264912E+00}, {-.780097E+00, 0.263486E+00},
            {-.780818E+00, 0.262374E+00}, {-.781332E+00, 0.261579E+00},
            {-.781641E+00, 0.261101E+00}, {-.781744E+00, 0.260942E+00},
        },
        {
            {-.251442E+00, 0.785666E+00}, {-.251606E+00, 0.785561E+00},
            {-.252098E+00, 0.785247E+00}, {-.252917E+00, 0.784722E+00},
            {-.254062E+00, 0.783988E+00}, {-.255530E+00, 0.783045E+00},
            {-.257321E+00, 0.781891E+00}, {-.259430E+00, 0.780528E+00},
            {-.261854E+00, 0.778956E+00}, {-.264590E+00, 0.777175E+00},
            {-.267633E+00, 0.775184E+00}, {-.270978E+00, 0.772985E+00},
            {-.274621E+00, 0.770578E+00}, {-.278555E+00, 0.767962E+00},
            {-.282774E+00, 0.765139E+00}, {-.287272E+00, 0.762109E+00},
            {-.292042E+00, 0.758873E+00}, {-.297076E+00, 0.755432E+00},
            {-.302368E+00, 0.751786E+00}, {-.307909E+00, 0.747937E+00},
            {-.313690E+00, 0.743885E+00}, {-.319704E+00, 0.739633E+00},
            {-.325942E+00, 0.735182E+00}, {-.332394E+00, 0.730533E+00},
            {-.339051E+00, 0.725688E+00}, {-.345905E+00, 0.720650E+00},
            {-.352944E+00, 0.715421E+00}, {-.360160E+00, 0.710003E+00},
            {-.367543E+00, 0.704399E+00}, {-.375082E+00, 0.698613E+00},
            {-.382767E+00, 0.692647E+00}, {-.390588E+00, 0.686505E+00},
            {-.398535E+00, 0.680191E+00}, {-.406597E+00, 0.673709E+00},
            {-.414764E+00, 0.667063E+00}, {-.423025E+00, 0.660257E+00},
            {-.431371E+00, 0.653296E+00}, {-.439791E+00, 0.646186E+00},
            {-.448274E+00, 0.638932E+00}, {-.456811E+00, 0.631538E+00},
            {-.465390E+00, 0.624012E+00}, {-.474003E+00, 0.616359E+00},
            {-.482638E+00, 0.608586E+00}, {-.491287E+00, 0.600699E+00},
            {-.499939E+00, 0.592706E+00}, {-.508584E+00, 0.584612E+00},
            {-.517214E+00, 0.576427E+00}, {-.525819E+00, 0.568157E+00},
            {-.534390E+00, 0.559810E+00}, {-.542918E+00, 0.551394E+00},
            {-.551394E+00, 0.542918E+00}, {-.559810E+00, 0.534390E+00},
            {-.568157E+00, 0.525819E+00}, {-.576427E+00, 0.517214E+00},
            {-.584612E+00, 0.508584E+00}, {-.592706E+00, 0.499939E+00},
            {-.600699E+00, 0.491287E+00}, {-.608586E+00, 0.482638E+00},
            {-.616359E+00, 0.474003E+00}, {-.624012E+00, 0.465390E+00},
            {-.631538E+00, 0.456811E+00}, {-.638932E+00, 0.448274E+00},
            {-.646186E+00, 0.439791E+00}, {-.653296E+00, 0.431371E+00},
            {-.660257E+00, 0.423025E+00}, {-.667063E+00, 0.414764E+00},
            {-.673709E+00, 0.406597E+00}, {-.680191E+00, 0.398535E+00},
            {-.686505E+00, 0.390588E+00}, {-.692647E+00, 0.382767E+00},
            {-.698613E+00, 0.375082E+00}, {-.704399E+00, 0.367543E+00},
            {-.710003E+00, 0.360160E+00}, {-.715421E+00, 0.352944E+00},
            {-.720650E+00, 0.345905E+00}, {-.725688E+00, 0.339051E+00},
            {-.730533E+00, 0.332394E+00}, {-.735182E+00, 0.325942E+00},
            {-.739633E+00, 0.319704E+00}, {-.743885E+00, 0.313690E+00},
            {-.747937E+00, 0.307909E+00}, {-.751786E+00, 0.302368E+00},
            {-.755432E+00, 0.297076E+00}, {-.758873E+00, 0.292042E+00},
            {-.762109E+00, 0.287272E+00}, {-.765139E+00, 0.282774E+00},
            {-.767962E+00, 0.278555E+00}, {-.770578E+00, 0.274621E+00},
            {-.772985E+00, 0.270978E+00}, {-.775184E+00, 0.267633E+00},
            {-.777175E+00, 0.264590E+00}, {-.778956E+00, 0.261854E+00},
            {-.780528E+00, 0.259430E+00}, {-.781891E+00, 0.257321E+00},
            {-.783045E+00, 0.255530E+00}, {-.783988E+00, 0.254062E+00},
            {-.784722E+00, 0.252917E+00}, {-.785247E+00, 0.252098E+00},
            {-.785561E+00, 0.251606E+00}, {-.785666E+00, 0.251442E+00},
        },
        {
            {-.241754E+00, 0.789582E+00}, {-.241923E+00, 0.789475E+00},
            {-.242430E+00, 0.789155E+00}, {-.243273E+00, 0.788621E+00},
            {-.244452E+00, 0.787873E+00}, {-.245964E+00, 0.786911E+00},
            {-.247808E+00, 0.785736E+00}, {-.249979E+00, 0.784347E+00},
            {-.252475E+00, 0.782745E+00}, {-.255292E+00, 0.780929E+00},
            {-.258425E+00, 0.778900E+00}, {-.261868E+00, 0.776658E+00},
            {-.265618E+00, 0.774204E+00}, {-.269667E+00, 0.771537E+00},
            {-.274010E+00, 0.768658E+00}, {-.278639E+00, 0.765568E+00},
            {-.283548E+00, 0.762267E+00}, {-.288729E+00, 0.758757E+00},
            {-.294174E+00, 0.755037E+00}, {-.299875E+00, 0.751108E+00},
            {-.305824E+00, 0.746973E+00}, {-.312011E+00, 0.742633E+00},
            {-.318427E+00, 0.738088E+00}, {-.325064E+00, 0.733340E+00},
            {-.331911E+00, 0.728393E+00}, {-.338959E+00, 0.723246E+00},
            {-.346197E+00, 0.717904E+00}, {-.353617E+00, 0.712368E+00},
            {-.361207E+00, 0.706641E+00}, {-.368956E+00, 0.700726E+00},
            {-.376856E+00, 0.694627E+00}, {-.384894E+00, 0.688347E+00},
            {-.393061E+00, 0.681890E+00}, {-.401345E+00, 0.675259E+00},
            {-.409737E+00, 0.668460E+00}, {-.418224E+00, 0.661496E+00},
            {-.426797E+00, 0.654373E+00}, {-.435445E+00, 0.647096E+00},
            {-.444157E+00, 0.639669E+00}, {-.452923E+00, 0.632100E+00},
            {-.461732E+00, 0.624393E+00}, {-.470574E+00, 0.616556E+00},
            {-.479438E+00, 0.608594E+00}, {-.488315E+00, 0.600514E+00},
            {-.497194E+00, 0.592323E+00}, {-.506066E+00, 0.584030E+00},
            {-.514920E+00, 0.575640E+00}, {-.523748E+00, 0.567163E+00},
            {-.532539E+00, 0.558606E+00}, {-.541285E+00, 0.549977E+00},
            {-.549977E+00, 0.541285E+00}, {-.558606E+00, 0.532539E+00},
            {-.567163E+00, 0.523748E+00}, {-.575640E+00, 0.514920E+00},
            {-.584030E+00, 0.506066E+00}, {-.592323E+00, 0.497194E+00},
            {-.600514E+00, 0.488315E+00}, {-.608594E+00, 0.479438E+00},
            {-.616556E+00, 0.470574E+00}, {-.624393E+00, 0.461732E+00},
            {-.632100E+00, 0.452923E+00}, {-.639669E+00, 0.444157E+00},
            {-.647096E+00, 0.435445E+00}, {-.654373E+00, 0.426797E+00},
            {-.661496E+00, 0.418224E+00}, {-.668460E+00, 0.409737E+00},
            {-.675259E+00, 0.401345E+00}, {-.681890E+00, 0.393061E+00},
            {-.688347E+00, 0.384894E+00}, {-.694627E+00, 0.376856E+00},
            {-.700726E+00, 0.368956E+00}, {-.706641E+00, 0.361207E+00},
            {-.712368E+00, 0.353617E+00}, {-.717904E+00, 0.346197E+00},
            {-.723246E+00, 0.338959E+00}, {-.728393E+00, 0.331911E+00},
            {-.733340E+00, 0.325064E+00}, {-.738088E+00, 0.318427E+00},
            {-.742633E+00, 0.312011E+00}, {-.746973E+00, 0.305824E+00},
            {-.751108E+00, 0.299875E+00}, {-.755037E+00, 0.294174E+00},
            {-.758757E+00, 0.288729E+00}, {-.762267E+00, 0.283548E+00},
            {-.765568E+00, 0.278639E+00}, {-.768658E+00, 0.274010E+00},
            {-.771537E+00, 0.269667E+00}, {-.774204E+00, 0.265618E+00},
            {-.776658E+00, 0.261868E+00}, {-.778900E+00, 0.258425E+00},
            {-.780929E+00, 0.255292E+00}, {-.782745E+00, 0.252475E+00},
            {-.784347E+00, 0.249979E+00}, {-.785736E+00, 0.247808E+00},
            {-.786911E+00, 0.245964E+00}, {-.787873E+00, 0.244452E+00},
            {-.788621E+00, 0.243273E+00}, {-.789155E+00, 0.242430E+00},
            {-.789475E+00, 0.241923E+00}, {-.789582E+00, 0.241754E+00},
        },
        {
            {-.231872E+00, 0.793492E+00}, {-.232046E+00, 0.793383E+00},
            {-.232567E+00, 0.793057E+00}, {-.233435E+00, 0.792513E+00},
            {-.234649E+00, 0.791751E+00}, {-.236206E+00, 0.790772E+00},
            {-.238103E+00, 0.789574E+00}, {-.240338E+00, 0.788160E+00},
            {-.242908E+00, 0.786527E+00}, {-.245807E+00, 0.784678E+00},
            {-.249031E+00, 0.782610E+00}, {-.252575E+00, 0.780326E+00},
            {-.256434E+00, 0.777824E+00}, {-.260601E+00, 0.775106E+00},
            {-.265070E+00, 0.772172E+00}, {-.269833E+00, 0.769021E+00},
            {-.274883E+00, 0.765655E+00}, {-.280214E+00, 0.762075E+00},
            {-.285815E+00, 0.758280E+00}, {-.291679E+00, 0.754273E+00},
            {-.297797E+00, 0.750054E+00}, {-.304160E+00, 0.745624E+00},
            {-.310759E+00, 0.740985E+00}, {-.317583E+00, 0.736139E+00},
            {-.324623E+00, 0.731087E+00}, {-.331869E+00, 0.725832E+00},
            {-.339311E+00, 0.720376E+00}, {-.346937E+00, 0.714720E+00},
            {-.354738E+00, 0.708869E+00}, {-.362702E+00, 0.702825E+00},
            {-.370820E+00, 0.696592E+00}, {-.379079E+00, 0.690172E+00},
            {-.387469E+00, 0.683570E+00}, {-.395980E+00, 0.676790E+00},
            {-.404599E+00, 0.669836E+00}, {-.413316E+00, 0.662713E+00},
            {-.422120E+00, 0.655425E+00}, {-.430999E+00, 0.647979E+00},
            {-.439944E+00, 0.640379E+00}, {-.448943E+00, 0.632631E+00},
            {-.457985E+00, 0.624742E+00}, {-.467060E+00, 0.616717E+00},
            {-.476156E+00, 0.608563E+00}, {-.485265E+00, 0.600288E+00},
            {-.494374E+00, 0.591899E+00}, {-.503475E+00, 0.583402E+00},
            {-.512557E+00, 0.574806E+00}, {-.521611E+00, 0.566119E+00},
            {-.530626E+00, 0.557349E+00}, {-.539593E+00, 0.548504E+00},
            {-.548504E+00, 0.539593E+00}, {-.557349E+00, 0.530626E+00},
            {-.566119E+00, 0.521611E+00}, {-.574806E+00, 0.512557E+00},
            {-.583402E+00, 0.503475E+00}, {-.591899E+00, 0.494374E+00},
            {-.600288E+00, 0.485265E+00}, {-.608563E+00, 0.476156E+00},
            {-.616717E+00, 0.467060E+00}, {-.624742E+00, 0.457985E+00},
            {-.632631E+00, 0.448943E+00}, {-.640379E+00, 0.439944E+00},
            {-.647979E+00, 0.430999E+00}, {-.655425E+00, 0.422120E+00},
            {-.662713E+00, 0.413316E+00}, {-.669836E+00, 0.404599E+00},
            {-.676790E+00, 0.395980E+00}, {-.683570E+00, 0.387469E+00},
            {-.690172E+00, 0.379079E+00}, {-.696592E+00, 0.370820E+00},
            {-.702825E+00, 0.362702E+00}, {-.708869E+00, 0.354738E+00},
            {-.714720E+00, 0.346937E+00}, {-.720376E+00, 0.339311E+00},
            {-.725832E+00, 0.331869E+00}, {-.731087E+00, 0.324623E+00},
            {-.736139E+00, 0.317583E+00}, {-.740985E+00, 0.310759E+00},
            {-.745624E+00, 0.304160E+00}, {-.750054E+00, 0.297797E+00},
            {-.754273E+00, 0.291679E+00}, {-.758280E+00, 0.285815E+00},
            {-.762075E+00, 0.280214E+00}, {-.765655E+00, 0.274883E+00},
            {-.769021E+00, 0.269833E+00}, {-.772172E+00, 0.265070E+00},
            {-.775106E+00, 0.260601E+00}, {-.777824E+00, 0.256434E+00},
            {-.780326E+00, 0.252575E+00}, {-.782610E+00, 0.249031E+00},
            {-.784678E+00, 0.245807E+00}, {-.786527E+00, 0.242908E+00},
            {-.788160E+00, 0.240338E+00}, {-.789574E+00, 0.238103E+00},
            {-.790772E+00, 0.236206E+00}, {-.791751E+00, 0.234649E+00},
            {-.792513E+00, 0.233435E+00}, {-.793057E+00, 0.232567E+00},
            {-.793383E+00, 0.232046E+00}, {-.793492E+00, 0.231872E+00},
        },
        {
            {-.221787E+00, 0.797397E+00}, {-.221966E+00, 0.797286E+00},
            {-.222503E+00, 0.796954E+00}, {-.223396E+00, 0.796400E+00},
            {-.224645E+00, 0.795624E+00}, {-.226247E+00, 0.794627E+00},
            {-.228200E+00, 0.793408E+00}, {-.230500E+00, 0.791967E+00},
            {-.233144E+00, 0.790305E+00}, {-.236127E+00, 0.788421E+00},
            {-.239445E+00, 0.786315E+00}, {-.243091E+00, 0.783988E+00},
            {-.247062E+00, 0.781439E+00}, {-.251348E+00, 0.778670E+00},
            {-.255945E+00, 0.775679E+00}, {-.260845E+00, 0.772468E+00},
            {-.266040E+00, 0.769037E+00}, {-.271522E+00, 0.765386E+00},
            {-.277283E+00, 0.761517E+00}, {-.283314E+00, 0.757430E+00},
            {-.289605E+00, 0.753127E+00}, {-.296147E+00, 0.748608E+00},
            {-.302931E+00, 0.743874E+00}, {-.309947E+00, 0.738929E+00},
            {-.317184E+00, 0.733772E+00}, {-.324631E+00, 0.728407E+00},
            {-.332279E+00, 0.722836E+00}, {-.340116E+00, 0.717060E+00},
            {-.348132E+00, 0.711084E+00}, {-.356314E+00, 0.704909E+00},
            {-.364654E+00, 0.698540E+00}, {-.373138E+00, 0.691980E+00},
            {-.381755E+00, 0.685231E+00}, {-.390495E+00, 0.678300E+00},
            {-.399346E+00, 0.671190E+00}, {-.408296E+00, 0.663905E+00},
            {-.417335E+00, 0.656452E+00}, {-.426450E+00, 0.648834E+00},
            {-.435631E+00, 0.641058E+00}, {-.444867E+00, 0.633130E+00},
            {-.454146E+00, 0.625056E+00}, {-.463457E+00, 0.616842E+00},
            {-.472789E+00, 0.608495E+00}, {-.482133E+00, 0.600022E+00},
            {-.491477E+00, 0.591430E+00}, {-.500810E+00, 0.582728E+00},
            {-.510123E+00, 0.573923E+00}, {-.519406E+00, 0.565023E+00},
            {-.528648E+00, 0.556036E+00}, {-.537840E+00, 0.546972E+00},
            {-.546972E+00, 0.537840E+00}, {-.556036E+00, 0.528648E+00},
            {-.565023E+00, 0.519406E+00}, {-.573923E+00, 0.510123E+00},
            {-.582728E+00, 0.500810E+00}, {-.591430E+00, 0.491477E+00},
            {-.600022E+00, 0.482133E+00}, {-.608495E+00, 0.472789E+00},
            {-.616842E+00, 0.463457E+00}, {-.625056E+00, 0.454146E+00},
            {-.633130E+00, 0.444867E+00}, {-.641058E+00, 0.435631E+00},
            {-.648834E+00, 0.426450E+00}, {-.656452E+00, 0.417335E+00},
            {-.663905E+00, 0.408296E+00}, {-.671190E+00, 0.399346E+00},
            {-.678300E+00, 0.390495E+00}, {-.685231E+00, 0.381755E+00},
            {-.691980E+00, 0.373138E+00}, {-.698540E+00, 0.364654E+00},
            {-.704909E+00, 0.356314E+00}, {-.711084E+00, 0.348132E+00},
            {-.717060E+00, 0.340116E+00}, {-.722836E+00, 0.332279E+00},
            {-.728407E+00, 0.324631E+00}, {-.733772E+00, 0.317184E+00},
            {-.738929E+00, 0.309947E+00}, {-.743874E+00, 0.302931E+00},
            {-.748608E+00, 0.296147E+00}, {-.753127E+00, 0.289605E+00},
            {-.757430E+00, 0.283314E+00}, {-.761517E+00, 0.277283E+00},
            {-.765386E+00, 0.271522E+00}, {-.769037E+00, 0.266040E+00},
            {-.772468E+00, 0.260845E+00}, {-.775679E+00, 0.255945E+00},
            {-.778670E+00, 0.251348E+00}, {-.781439E+00, 0.247062E+00},
            {-.783988E+00, 0.243091E+00}, {-.786315E+00, 0.239445E+00},
            {-.788421E+00, 0.236127E+00}, {-.790305E+00, 0.233144E+00},
            {-.791967E+00, 0.230500E+00}, {-.793408E+00, 0.228200E+00},
            {-.794627E+00, 0.226247E+00}, {-.795624E+00, 0.224645E+00},
            {-.796400E+00, 0.223396E+00}, {-.796954E+00, 0.222503E+00},
            {-.797286E+00, 0.221966E+00}, {-.797397E+00, 0.221787E+00},
        },
        {
            {-.211491E+00, 0.801297E+00}, {-.211676E+00, 0.801184E+00},
            {-.212228E+00, 0.800846E+00}, {-.213147E+00, 0.800282E+00},
            {-.214432E+00, 0.799493E+00}, {-.216081E+00, 0.798478E+00},
            {-.218090E+00, 0.797237E+00}, {-.220456E+00, 0.795770E+00},
            {-.223176E+00, 0.794078E+00}, {-.226245E+00, 0.792160E+00},
            {-.229658E+00, 0.790016E+00}, {-.233409E+00, 0.787646E+00},
            {-.237493E+00, 0.785050E+00}, {-.241902E+00, 0.782228E+00},
            {-.246630E+00, 0.779182E+00}, {-.251669E+00, 0.775910E+00},
            {-.257012E+00, 0.772413E+00}, {-.262649E+00, 0.768692E+00},
            {-.268572E+00, 0.764748E+00}, {-.274772E+00, 0.760581E+00},
            {-.281240E+00, 0.756193E+00}, {-.287965E+00, 0.751584E+00},
            {-.294938E+00, 0.746755E+00}, {-.302148E+00, 0.741709E+00},
            {-.309585E+00, 0.736448E+00}, {-.317238E+00, 0.730972E+00},
            {-.325096E+00, 0.725285E+00}, {-.333147E+00, 0.719388E+00},
            {-.341382E+00, 0.713285E+00}, {-.349787E+00, 0.706979E+00},
            {-.358352E+00, 0.700472E+00}, {-.367064E+00, 0.693769E+00},
            {-.375913E+00, 0.686874E+00}, {-.384887E+00, 0.679790E+00},
            {-.393973E+00, 0.672521E+00}, {-.403161E+00, 0.665074E+00},
            {-.412438E+00, 0.657452E+00}, {-.421793E+00, 0.649661E+00},
            {-.431214E+00, 0.641708E+00}, {-.440690E+00, 0.633597E+00},
            {-.450210E+00, 0.625335E+00}, {-.459761E+00, 0.616929E+00},
            {-.469334E+00, 0.608386E+00}, {-.478916E+00, 0.599712E+00},
            {-.488497E+00, 0.590916E+00}, {-.498067E+00, 0.582005E+00},
            {-.507615E+00, 0.572988E+00}, {-.517130E+00, 0.563872E+00},
            {-.526602E+00, 0.554666E+00}, {-.536022E+00, 0.545380E+00},
            {-.545380E+00, 0.536022E+00}, {-.554666E+00, 0.526602E+00},
            {-.563872E+00, 0.517130E+00}, {-.572988E+00, 0.507615E+00},
            {-.582005E+00, 0.498067E+00}, {-.590916E+00, 0.488497E+00},
            {-.599712E+00, 0.478916E+00}, {-.608386E+00, 0.469334E+00},
            {-.616929E+00, 0.459761E+00}, {-.625335E+00, 0.450210E+00},
            {-.633597E+00, 0.440690E+00}, {-.641708E+00, 0.431214E+00},
            {-.649661E+00, 0.421793E+00}, {-.657452E+00, 0.412438E+00},
            {-.665074E+00, 0.403161E+00}, {-.672521E+00, 0.393973E+00},
            {-.679790E+00, 0.384887E+00}, {-.686874E+00, 0.375913E+00},
            {-.693769E+00, 0.367064E+00}, {-.700472E+00, 0.358352E+00},
            {-.706979E+00, 0.349787E+00}, {-.713285E+00, 0.341382E+00},
            {-.719388E+00, 0.333147E+00}, {-.725285E+00, 0.325096E+00},
            {-.730972E+00, 0.317238E+00}, {-.736448E+00, 0.309585E+00},
            {-.741709E+00, 0.302148E+00}, {-.746755E+00, 0.294938E+00},
            {-.751584E+00, 0.287965E+00}, {-.756193E+00, 0.281240E+00},
            {-.760581E+00, 0.274772E+00}, {-.764748E+00, 0.268572E+00},
            {-.768692E+00, 0.262649E+00}, {-.772413E+00, 0.257012E+00},
            {-.775910E+00, 0.251669E+00}, {-.779182E+00, 0.246630E+00},
            {-.782228E+00, 0.241902E+00}, {-.785050E+00, 0.237493E+00},
            {-.787646E+00, 0.233409E+00}, {-.790016E+00, 0.229658E+00},
            {-.792160E+00, 0.226245E+00}, {-.794078E+00, 0.223176E+00},
            {-.795770E+00, 0.220456E+00}, {-.797237E+00, 0.218090E+00},
            {-.798478E+00, 0.216081E+00}, {-.799493E+00, 0.214432E+00},
            {-.800282E+00, 0.213147E+00}, {-.800846E+00, 0.212228E+00},
            {-.801184E+00, 0.211676E+00}, {-.801297E+00, 0.211491E+00},
        },
        {
            {-.200977E+00, 0.805193E+00}, {-.201166E+00, 0.805079E+00},
            {-.201734E+00, 0.804734E+00}, {-.202680E+00, 0.804161E+00},
            {-.204002E+00, 0.803358E+00}, {-.205698E+00, 0.802325E+00},
            {-.207764E+00, 0.801062E+00}, {-.210199E+00, 0.799570E+00},
            {-.212996E+00, 0.797847E+00}, {-.216153E+00, 0.795895E+00},
            {-.219663E+00, 0.793712E+00}, {-.223521E+00, 0.791299E+00},
            {-.227721E+00, 0.788656E+00}, {-.232255E+00, 0.785783E+00},
            {-.237117E+00, 0.782680E+00}, {-.242298E+00, 0.779347E+00},
            {-.247790E+00, 0.775785E+00}, {-.253585E+00, 0.771993E+00},
            {-.259674E+00, 0.767974E+00}, {-.266047E+00, 0.763726E+00},
            {-.272695E+00, 0.759252E+00}, {-.279606E+00, 0.754553E+00},
            {-.286772E+00, 0.749629E+00}, {-.294181E+00, 0.744482E+00},
            {-.301822E+00, 0.739114E+00}, {-.309684E+00, 0.733526E+00},
            {-.317755E+00, 0.727722E+00}, {-.326026E+00, 0.721703E+00},
            {-.334482E+00, 0.715473E+00}, {-.343114E+00, 0.709033E+00},
            {-.351908E+00, 0.702388E+00}, {-.360854E+00, 0.695541E+00},
            {-.369938E+00, 0.688497E+00}, {-.379149E+00, 0.681258E+00},
            {-.388476E+00, 0.673830E+00}, {-.397905E+00, 0.666217E+00},
            {-.407424E+00, 0.658425E+00}, {-.417023E+00, 0.650459E+00},
            {-.426689E+00, 0.642325E+00}, {-.436409E+00, 0.634029E+00},
            {-.446173E+00, 0.625577E+00}, {-.455969E+00, 0.616977E+00},
            {-.465785E+00, 0.608235E+00}, {-.475610E+00, 0.599358E+00},
            {-.485433E+00, 0.590354E+00}, {-.495243E+00, 0.581232E+00},
            {-.505029E+00, 0.571999E+00}, {-.514780E+00, 0.562664E+00},
            {-.524487E+00, 0.553236E+00}, {-.534138E+00, 0.543724E+00},
            {-.543724E+00, 0.534138E+00}, {-.553236E+00, 0.524487E+00},
            {-.562664E+00, 0.514780E+00}, {-.571999E+00, 0.505029E+00},
            {-.581232E+00, 0.495243E+00}, {-.590354E+00, 0.485433E+00},
            {-.599358E+00, 0.475610E+00}, {-.608235E+00, 0.465785E+00},
            {-.616977E+00, 0.455969E+00}, {-.625577E+00, 0.446173E+00},
            {-.634029E+00, 0.436409E+00}, {-.642325E+00, 0.426689E+00},
            {-.650459E+00, 0.417023E+00}, {-.658425E+00, 0.407424E+00},
            {-.666217E+00, 0.397905E+00}, {-.673830E+00, 0.388476E+00},
            {-.681258E+00, 0.379149E+00}, {-.688497E+00, 0.369938E+00},
            {-.695541E+00, 0.360854E+00}, {-.702388E+00, 0.351908E+00},
            {-.709033E+00, 0.343114E+00}, {-.715473E+00, 0.334482E+00},
            {-.721703E+00, 0.326026E+00}, {-.727722E+00, 0.317755E+00},
            {-.733526E+00, 0.309684E+00}, {-.739114E+00, 0.301822E+00},
            {-.744482E+00, 0.294181E+00}, {-.749629E+00, 0.286772E+00},
            {-.754553E+00, 0.279606E+00}, {-.759252E+00, 0.272695E+00},
            {-.763726E+00, 0.266047E+00}, {-.767974E+00, 0.259674E+00},
            {-.771993E+00, 0.253585E+00}, {-.775785E+00, 0.247790E+00},
            {-.779347E+00, 0.242298E+00}, {-.782680E+00, 0.237117E+00},
            {-.785783E+00, 0.232255E+00}, {-.788656E+00, 0.227721E+00},
            {-.791299E+00, 0.223521E+00}, {-.793712E+00, 0.219663E+00},
            {-.795895E+00, 0.216153E+00}, {-.797847E+00, 0.212996E+00},
            {-.799570E+00, 0.210199E+00}, {-.801062E+00, 0.207764E+00},
            {-.802325E+00, 0.205698E+00}, {-.803358E+00, 0.204002E+00},
            {-.804161E+00, 0.202680E+00}, {-.804734E+00, 0.201734E+00},
            {-.805079E+00, 0.201166E+00}, {-.805193E+00, 0.200977E+00},
        },
        {
            {-.190234E+00, 0.809086E+00}, {-.190429E+00, 0.808970E+00},
            {-.191013E+00, 0.808620E+00}, {-.191986E+00, 0.808036E+00},
            {-.193345E+00, 0.807219E+00}, {-.195089E+00, 0.806169E+00},
            {-.197215E+00, 0.804884E+00}, {-.199718E+00, 0.803366E+00},
            {-.202595E+00, 0.801613E+00}, {-.205841E+00, 0.799626E+00},
            {-.209451E+00, 0.797405E+00}, {-.213418E+00, 0.794949E+00},
            {-.217736E+00, 0.792259E+00}, {-.222398E+00, 0.789334E+00},
            {-.227396E+00, 0.786174E+00}, {-.232722E+00, 0.782780E+00},
            {-.238368E+00, 0.779152E+00}, {-.244324E+00, 0.775290E+00},
            {-.250582E+00, 0.771194E+00}, {-.257131E+00, 0.766866E+00},
            {-.263962E+00, 0.762306E+00}, {-.271064E+00, 0.757515E+00},
            {-.278426E+00, 0.752494E+00}, {-.286037E+00, 0.747246E+00},
            {-.293886E+00, 0.741771E+00}, {-.301961E+00, 0.736071E+00},
            {-.310251E+00, 0.730148E+00}, {-.318744E+00, 0.724006E+00},
            {-.327427E+00, 0.717646E+00}, {-.336289E+00, 0.711072E+00},
            {-.345318E+00, 0.704287E+00}, {-.354500E+00, 0.697295E+00},
            {-.363824E+00, 0.690099E+00}, {-.373278E+00, 0.682704E+00},
            {-.382848E+00, 0.675114E+00}, {-.392522E+00, 0.667334E+00},
            {-.402289E+00, 0.659370E+00}, {-.412136E+00, 0.651226E+00},
            {-.422050E+00, 0.642910E+00}, {-.432019E+00, 0.634426E+00},
            {-.442032E+00, 0.625782E+00}, {-.452076E+00, 0.616984E+00},
            {-.462140E+00, 0.608040E+00}, {-.472212E+00, 0.598957E+00},
            {-.482280E+00, 0.589743E+00}, {-.492334E+00, 0.580406E+00},
            {-.502362E+00, 0.570954E+00}, {-.512353E+00, 0.561397E+00},
            {-.522297E+00, 0.551744E+00}, {-.532184E+00, 0.542003E+00},
            {-.542003E+00, 0.532184E+00}, {-.551744E+00, 0.522297E+00},
            {-.561397E+00, 0.512353E+00}, {-.570954E+00, 0.502362E+00},
            {-.580406E+00, 0.492334E+00}, {-.589743E+00, 0.482280E+00},
            {-.598957E+00, 0.472212E+00}, {-.608040E+00, 0.462140E+00},
            {-.616984E+00, 0.452076E+00}, {-.625782E+00, 0.442032E+00},
            {-.634426E+00, 0.432019E+00}, {-.642910E+00, 0.422050E+00},
            {-.651226E+00, 0.412136E+00}, {-.659370E+00, 0.402289E+00},
            {-.667334E+00, 0.392522E+00}, {-.675114E+00, 0.382848E+00},
            {-.682704E+00, 0.373278E+00}, {-.690099E+00, 0.363824E+00},
            {-.697295E+00, 0.354500E+00}, {-.704287E+00, 0.345318E+00},
            {-.711072E+00, 0.336289E+00}, {-.717646E+00, 0.327427E+00},
            {-.724006E+00, 0.318744E+00}, {-.730148E+00, 0.310251E+00},
            {-.736071E+00, 0.301961E+00}, {-.741771E+00, 0.293886E+00},
            {-.747246E+00, 0.286037E+00}, {-.752494E+00, 0.278426E+00},
            {-.757515E+00, 0.271064E+00}, {-.762306E+00, 0.263962E+00},
            {-.766866E+00, 0.257131E+00}, {-.771194E+00, 0.250582E+00},
            {-.775290E+00, 0.244324E+00}, {-.779152E+00, 0.238368E+00},
            {-.782780E+00, 0.232722E+00}, {-.786174E+00, 0.227396E+00},
            {-.789334E+00, 0.222398E+00}, {-.792259E+00, 0.217736E+00},
            {-.794949E+00, 0.213418E+00}, {-.797405E+00, 0.209451E+00},
            {-.799626E+00, 0.205841E+00}, {-.801613E+00, 0.202595E+00},
            {-.803366E+00, 0.199718E+00}, {-.804884E+00, 0.197215E+00},
            {-.806169E+00, 0.195089E+00}, {-.807219E+00, 0.193345E+00},
            {-.808036E+00, 0.191986E+00}, {-.808620E+00, 0.191013E+00},
            {-.808970E+00, 0.190429E+00}, {-.809086E+00, 0.190234E+00},
        },
        {
            {-.179253E+00, 0.812977E+00}, {-.179453E+00, 0.812858E+00},
            {-.180054E+00, 0.812503E+00}, {-.181054E+00, 0.811909E+00},
            {-.182453E+00, 0.811078E+00}, {-.184246E+00, 0.810010E+00},
            {-.186432E+00, 0.808704E+00}, {-.189006E+00, 0.807159E+00},
            {-.191964E+00, 0.805377E+00}, {-.195302E+00, 0.803356E+00},
            {-.199012E+00, 0.801096E+00}, {-.203091E+00, 0.798597E+00},
            {-.207530E+00, 0.795859E+00}, {-.212322E+00, 0.792882E+00},
            {-.217459E+00, 0.789665E+00}, {-.222933E+00, 0.786210E+00},
            {-.228736E+00, 0.782515E+00}, {-.234857E+00, 0.778582E+00},
            {-.241287E+00, 0.774410E+00}, {-.248016E+00, 0.770000E+00},
            {-.255034E+00, 0.765354E+00}, {-.262330E+00, 0.760471E+00},
            {-.269892E+00, 0.755353E+00}, {-.277710E+00, 0.750002E+00},
            {-.285771E+00, 0.744418E+00}, {-.294063E+00, 0.738605E+00},
            {-.302575E+00, 0.732563E+00}, {-.311295E+00, 0.726296E+00},
            {-.320210E+00, 0.719806E+00}, {-.329307E+00, 0.713096E+00},
            {-.338573E+00, 0.706169E+00}, {-.347997E+00, 0.699030E+00},
            {-.357565E+00, 0.691681E+00}, {-.367265E+00, 0.684127E+00},
            {-.377084E+00, 0.676374E+00}, {-.387009E+00, 0.668424E+00},
            {-.397027E+00, 0.660285E+00}, {-.407126E+00, 0.651962E+00},
            {-.417292E+00, 0.643460E+00}, {-.427515E+00, 0.634786E+00},
            {-.437781E+00, 0.625947E+00}, {-.448078E+00, 0.616949E+00},
            {-.458394E+00, 0.607800E+00}, {-.468716E+00, 0.598507E+00},
            {-.479034E+00, 0.589080E+00}, {-.489336E+00, 0.579525E+00},
            {-.499610E+00, 0.569851E+00}, {-.509846E+00, 0.560068E+00},
            {-.520031E+00, 0.550185E+00}, {-.530157E+00, 0.540211E+00},
            {-.540211E+00, 0.530157E+00}, {-.550185E+00, 0.520031E+00},
            {-.560068E+00, 0.509846E+00}, {-.569851E+00, 0.499610E+00},
            {-.579525E+00, 0.489336E+00}, {-.589080E+00, 0.479034E+00},
            {-.598507E+00, 0.468716E+00}, {-.607800E+00, 0.458394E+00},
            {-.616949E+00, 0.448078E+00}, {-.625947E+00, 0.437781E+00},
            {-.634786E+00, 0.427515E+00}, {-.643460E+00, 0.417292E+00},
            {-.651962E+00, 0.407126E+00}, {-.660285E+00, 0.397027E+00},
            {-.668424E+00, 0.387009E+00}, {-.676374E+00, 0.377084E+00},
            {-.684127E+00, 0.367265E+00}, {-.691681E+00, 0.357565E+00},
            {-.699030E+00, 0.347997E+00}, {-.706169E+00, 0.338573E+00},
            {-.713096E+00, 0.329307E+00}, {-.719806E+00, 0.320210E+00},
            {-.726296E+00, 0.311295E+00}, {-.732563E+00, 0.302575E+00},
            {-.738605E+00, 0.294063E+00}, {-.744418E+00, 0.285771E+00},
            {-.750002E+00, 0.277710E+00}, {-.755353E+00, 0.269892E+00},
            {-.760471E+00, 0.262330E+00}, {-.765354E+00, 0.255034E+00},
            {-.770000E+00, 0.248016E+00}, {-.774410E+00, 0.241287E+00},
            {-.778582E+00, 0.234857E+00}, {-.782515E+00, 0.228736E+00},
            {-.786210E+00, 0.222933E+00}, {-.789665E+00, 0.217459E+00},
            {-.792882E+00, 0.212322E+00}, {-.795859E+00, 0.207530E+00},
            {-.798597E+00, 0.203091E+00}, {-.801096E+00, 0.199012E+00},
            {-.803356E+00, 0.195302E+00}, {-.805377E+00, 0.191964E+00},
            {-.807159E+00, 0.189006E+00}, {-.808704E+00, 0.186432E+00},
            {-.810010E+00, 0.184246E+00}, {-.811078E+00, 0.182453E+00},
            {-.811909E+00, 0.181054E+00}, {-.812503E+00, 0.180054E+00},
            {-.812858E+00, 0.179453E+00}, {-.812977E+00, 0.179253E+00},
        },
        {
            {-.168024E+00, 0.816866E+00}, {-.168230E+00, 0.816745E+00},
            {-.168848E+00, 0.816384E+00}, {-.169876E+00, 0.815781E+00},
            {-.171314E+00, 0.814936E+00}, {-.173158E+00, 0.813850E+00},
            {-.175405E+00, 0.812522E+00}, {-.178051E+00, 0.810951E+00},
            {-.181093E+00, 0.809138E+00}, {-.184523E+00, 0.807083E+00},
            {-.188338E+00, 0.804784E+00}, {-.192530E+00, 0.802242E+00},
            {-.197093E+00, 0.799457E+00}, {-.202018E+00, 0.796427E+00},
            {-.207297E+00, 0.793154E+00}, {-.212923E+00, 0.789637E+00},
            {-.218885E+00, 0.785875E+00}, {-.225174E+00, 0.781870E+00},
            {-.231781E+00, 0.777621E+00}, {-.238694E+00, 0.773130E+00},
            {-.245903E+00, 0.768396E+00}, {-.253396E+00, 0.763420E+00},
            {-.261163E+00, 0.758205E+00}, {-.269191E+00, 0.752750E+00},
            {-.277468E+00, 0.747057E+00}, {-.285982E+00, 0.741129E+00},
            {-.294721E+00, 0.734967E+00}, {-.303672E+00, 0.728574E+00},
            {-.312822E+00, 0.721952E+00}, {-.322159E+00, 0.715104E+00},
            {-.331669E+00, 0.708034E+00}, {-.341338E+00, 0.700745E+00},
            {-.351155E+00, 0.693241E+00}, {-.361106E+00, 0.685527E+00},
            {-.371178E+00, 0.677607E+00}, {-.381357E+00, 0.669487E+00},
            {-.391632E+00, 0.661170E+00}, {-.401987E+00, 0.652664E+00},
            {-.412412E+00, 0.643974E+00}, {-.422892E+00, 0.635107E+00},
            {-.433415E+00, 0.626070E+00}, {-.443969E+00, 0.616869E+00},
            {-.454542E+00, 0.607512E+00}, {-.465120E+00, 0.598007E+00},
            {-.475692E+00, 0.588362E+00}, {-.486246E+00, 0.578586E+00},
            {-.496770E+00, 0.568687E+00}, {-.507254E+00, 0.558674E+00},
            {-.517685E+00, 0.548558E+00}, {-.528053E+00, 0.538348E+00},
            {-.538348E+00, 0.528053E+00}, {-.548558E+00, 0.517685E+00},
            {-.558674E+00, 0.507254E+00}, {-.568687E+00, 0.496770E+00},
            {-.578586E+00, 0.486246E+00}, {-.588362E+00, 0.475692E+00},
            {-.598007E+00, 0.465120E+00}, {-.607512E+00, 0.454542E+00},
            {-.616869E+00, 0.443969E+00}, {-.626070E+00, 0.433415E+00},
            {-.635107E+00, 0.422892E+00}, {-.643974E+00, 0.412412E+00},
            {-.652664E+00, 0.401987E+00}, {-.661170E+00, 0.391632E+00},
            {-.669487E+00, 0.381357E+00}, {-.677607E+00, 0.371178E+00},
            {-.685527E+00, 0.361106E+00}, {-.693241E+00, 0.351155E+00},
            {-.700745E+00, 0.341338E+00}, {-.708034E+00, 0.331669E+00},
            {-.715104E+00, 0.322159E+00}, {-.721952E+00, 0.312822E+00},
            {-.728574E+00, 0.303672E+00}, {-.734967E+00, 0.294721E+00},
            {-.741129E+00, 0.285982E+00}, {-.747057E+00, 0.277468E+00},
            {-.752750E+00, 0.269191E+00}, {-.758205E+00, 0.261163E+00},
            {-.763420E+00, 0.253396E+00}, {-.768396E+00, 0.245903E+00},
            {-.773130E+00, 0.238694E+00}, {-.777621E+00, 0.231781E+00},
            {-.781870E+00, 0.225174E+00}, {-.785875E+00, 0.218885E+00},
            {-.789637E+00, 0.212923E+00}, {-.793154E+00, 0.207297E+00},
            {-.796427E+00, 0.202018E+00}, {-.799457E+00, 0.197093E+00},
            {-.802242E+00, 0.192530E+00}, {-.804784E+00, 0.188338E+00},
            {-.807083E+00, 0.184523E+00}, {-.809138E+00, 0.181093E+00},
            {-.810951E+00, 0.178051E+00}, {-.812522E+00, 0.175405E+00},
            {-.813850E+00, 0.173158E+00}, {-.814936E+00, 0.171314E+00},
            {-.815781E+00, 0.169876E+00}, {-.816384E+00, 0.168848E+00},
            {-.816745E+00, 0.168230E+00}, {-.816866E+00, 0.168024E+00},
        },
        {
            {-.156536E+00, 0.820754E+00}, {-.156748E+00, 0.820632E+00},
            {-.157383E+00, 0.820264E+00}, {-.158441E+00, 0.819651E+00},
            {-.159918E+00, 0.818793E+00}, {-.161814E+00, 0.817688E+00},
            {-.164124E+00, 0.816338E+00}, {-.166844E+00, 0.814742E+00},
            {-.169970E+00, 0.812899E+00}, {-.173497E+00, 0.810809E+00},
            {-.177418E+00, 0.808472E+00}, {-.181726E+00, 0.805887E+00},
            {-.186415E+00, 0.803053E+00}, {-.191476E+00, 0.799971E+00},
            {-.196901E+00, 0.796641E+00}, {-.202681E+00, 0.793061E+00},
            {-.208806E+00, 0.789233E+00}, {-.215267E+00, 0.785155E+00},
            {-.222054E+00, 0.780829E+00}, {-.229154E+00, 0.776255E+00},
            {-.236558E+00, 0.771433E+00}, {-.244254E+00, 0.766364E+00},
            {-.252229E+00, 0.761050E+00}, {-.260472E+00, 0.755490E+00},
            {-.268970E+00, 0.749687E+00}, {-.277711E+00, 0.743643E+00},
            {-.286681E+00, 0.737359E+00}, {-.295868E+00, 0.730838E+00},
            {-.305258E+00, 0.724082E+00}, {-.314839E+00, 0.717095E+00},
            {-.324596E+00, 0.709880E+00}, {-.334517E+00, 0.702440E+00},
            {-.344587E+00, 0.694780E+00}, {-.354794E+00, 0.686903E+00},
            {-.365124E+00, 0.678815E+00}, {-.375563E+00, 0.670520E+00},
            {-.386097E+00, 0.662024E+00}, {-.396715E+00, 0.653332E+00},
            {-.407401E+00, 0.644452E+00}, {-.418144E+00, 0.635388E+00},
            {-.428930E+00, 0.626150E+00}, {-.439746E+00, 0.616742E+00},
            {-.450579E+00, 0.607174E+00}, {-.461417E+00, 0.597453E+00},
            {-.472247E+00, 0.587587E+00}, {-.483058E+00, 0.577586E+00},
            {-.493837E+00, 0.567458E+00}, {-.504573E+00, 0.557212E+00},
            {-.515254E+00, 0.546859E+00}, {-.525870E+00, 0.536408E+00},
            {-.536408E+00, 0.525870E+00}, {-.546859E+00, 0.515254E+00},
            {-.557212E+00, 0.504573E+00}, {-.567458E+00, 0.493837E+00},
            {-.577586E+00, 0.483058E+00}, {-.587587E+00, 0.472247E+00},
            {-.597453E+00, 0.461417E+00}, {-.607174E+00, 0.450579E+00},
            {-.616742E+00, 0.439746E+00}, {-.626150E+00, 0.428930E+00},
            {-.635388E+00, 0.418144E+00}, {-.644452E+00, 0.407401E+00},
            {-.653332E+00, 0.396715E+00}, {-.662024E+00, 0.386097E+00},
            {-.670520E+00, 0.375563E+00}, {-.678815E+00, 0.365124E+00},
            {-.686903E+00, 0.354794E+00}, {-.694780E+00, 0.344587E+00},
            {-.702440E+00, 0.334517E+00}, {-.709880E+00, 0.324596E+00},
            {-.717095E+00, 0.314839E+00}, {-.724082E+00, 0.305258E+00},
            {-.730838E+00, 0.295868E+00}, {-.737359E+00, 0.286681E+00},
            {-.743643E+00, 0.277711E+00}, {-.749687E+00, 0.268970E+00},
            {-.755490E+00, 0.260472E+00}, {-.761050E+00, 0.252229E+00},
            {-.766364E+00, 0.244254E+00}, {-.771433E+00, 0.236558E+00},
            {-.776255E+00, 0.229154E+00}, {-.780829E+00, 0.222054E+00},
            {-.785155E+00, 0.215267E+00}, {-.789233E+00, 0.208806E+00},
            {-.793061E+00, 0.202681E+00}, {-.796641E+00, 0.196901E+00},
            {-.799971E+00, 0.191476E+00}, {-.803053E+00, 0.186415E+00},
            {-.805887E+00, 0.181726E+00}, {-.808472E+00, 0.177418E+00},
            {-.810809E+00, 0.173497E+00}, {-.812899E+00, 0.169970E+00},
            {-.814742E+00, 0.166844E+00}, {-.816338E+00, 0.164124E+00},
            {-.817688E+00, 0.161814E+00}, {-.818793E+00, 0.159918E+00},
            {-.819651E+00, 0.158441E+00}, {-.820264E+00, 0.157383E+00},
            {-.820632E+00, 0.156748E+00}, {-.820754E+00, 0.156536E+00},
        },
        {
            {-.144778E+00, 0.824642E+00}, {-.144996E+00, 0.824518E+00},
            {-.145649E+00, 0.824144E+00}, {-.146736E+00, 0.823521E+00},
            {-.148255E+00, 0.822649E+00}, {-.150203E+00, 0.821527E+00},
            {-.152577E+00, 0.820155E+00}, {-.155373E+00, 0.818533E+00},
            {-.158586E+00, 0.816660E+00}, {-.162211E+00, 0.814535E+00},
            {-.166240E+00, 0.812159E+00}, {-.170667E+00, 0.809530E+00},
            {-.175485E+00, 0.806649E+00}, {-.180685E+00, 0.803514E+00},
            {-.186259E+00, 0.800126E+00}, {-.192197E+00, 0.796484E+00},
            {-.198489E+00, 0.792588E+00}, {-.205126E+00, 0.788438E+00},
            {-.212096E+00, 0.784034E+00}, {-.219389E+00, 0.779377E+00},
            {-.226992E+00, 0.774466E+00}, {-.234894E+00, 0.769303E+00},
            {-.243082E+00, 0.763888E+00}, {-.251544E+00, 0.758223E+00},
            {-.260268E+00, 0.752308E+00}, {-.269239E+00, 0.746147E+00},
            {-.278445E+00, 0.739739E+00}, {-.287873E+00, 0.733089E+00},
            {-.297509E+00, 0.726199E+00}, {-.307338E+00, 0.719070E+00},
            {-.317348E+00, 0.711708E+00}, {-.327525E+00, 0.704115E+00},
            {-.337854E+00, 0.696295E+00}, {-.348321E+00, 0.688253E+00},
            {-.358914E+00, 0.679994E+00}, {-.369617E+00, 0.671522E+00},
            {-.380418E+00, 0.662844E+00}, {-.391302E+00, 0.653964E+00},
            {-.402256E+00, 0.644890E+00}, {-.413266E+00, 0.635627E+00},
            {-.424318E+00, 0.626184E+00}, {-.435401E+00, 0.616567E+00},
            {-.446500E+00, 0.606784E+00}, {-.457603E+00, 0.596843E+00},
            {-.468696E+00, 0.586753E+00}, {-.479769E+00, 0.576523E+00},
            {-.490807E+00, 0.566162E+00}, {-.501800E+00, 0.555679E+00},
            {-.512735E+00, 0.545085E+00}, {-.523602E+00, 0.534389E+00},
            {-.534389E+00, 0.523602E+00}, {-.545085E+00, 0.512735E+00},
            {-.555679E+00, 0.501800E+00}, {-.566162E+00, 0.490807E+00},
            {-.576523E+00, 0.479769E+00}, {-.586753E+00, 0.468696E+00},
            {-.596843E+00, 0.457603E+00}, {-.606784E+00, 0.446500E+00},
            {-.616567E+00, 0.435401E+00}, {-.626184E+00, 0.424318E+00},
            {-.635627E+00, 0.413266E+00}, {-.644890E+00, 0.402256E+00},
            {-.653964E+00, 0.391302E+00}, {-.662844E+00, 0.380418E+00},
            {-.671522E+00, 0.369617E+00}, {-.679994E+00, 0.358914E+00},
            {-.688253E+00, 0.348321E+00}, {-.696295E+00, 0.337854E+00},
            {-.704115E+00, 0.327525E+00}, {-.711708E+00, 0.317348E+00},
            {-.719070E+00, 0.307338E+00}, {-.726199E+00, 0.297509E+00},
            {-.733089E+00, 0.287873E+00}, {-.739739E+00, 0.278445E+00},
            {-.746147E+00, 0.269239E+00}, {-.752308E+00, 0.260268E+00},
            {-.758223E+00, 0.251544E+00}, {-.763888E+00, 0.243082E+00},
            {-.769303E+00, 0.234894E+00}, {-.774466E+00, 0.226992E+00},
            {-.779377E+00, 0.219389E+00}, {-.784034E+00, 0.212096E+00},
            {-.788438E+00, 0.205126E+00}, {-.792588E+00, 0.198489E+00},
            {-.796484E+00, 0.192197E+00}, {-.800126E+00, 0.186259E+00},
            {-.803514E+00, 0.180685E+00}, {-.806649E+00, 0.175485E+00},
            {-.809530E+00, 0.170667E+00}, {-.812159E+00, 0.166240E+00},
            {-.814535E+00, 0.162211E+00}, {-.816660E+00, 0.158586E+00},
            {-.818533E+00, 0.155373E+00}, {-.820155E+00, 0.152577E+00},
            {-.821527E+00, 0.150203E+00}, {-.822649E+00, 0.148255E+00},
            {-.823521E+00, 0.146736E+00}, {-.824144E+00, 0.145649E+00},
            {-.824518E+00, 0.144996E+00}, {-.824642E+00, 0.144778E+00},
        },
        {
            {-.132738E+00, 0.828531E+00}, {-.132962E+00, 0.828404E+00},
            {-.133633E+00, 0.828025E+00}, {-.134750E+00, 0.827392E+00},
            {-.136311E+00, 0.826506E+00}, {-.138314E+00, 0.825367E+00},
            {-.140754E+00, 0.823973E+00}, {-.143627E+00, 0.822324E+00},
            {-.146929E+00, 0.820421E+00}, {-.150653E+00, 0.818262E+00},
            {-.154793E+00, 0.815846E+00}, {-.159342E+00, 0.813174E+00},
            {-.164292E+00, 0.810244E+00}, {-.169635E+00, 0.807057E+00},
            {-.175361E+00, 0.803611E+00}, {-.181460E+00, 0.799906E+00},
            {-.187924E+00, 0.795942E+00}, {-.194740E+00, 0.791719E+00},
            {-.201898E+00, 0.787236E+00}, {-.209386E+00, 0.782495E+00},
            {-.217193E+00, 0.777494E+00}, {-.225306E+00, 0.772236E+00},
            {-.233712E+00, 0.766720E+00}, {-.242398E+00, 0.760948E+00},
            {-.251352E+00, 0.754921E+00}, {-.260559E+00, 0.748640E+00},
            {-.270006E+00, 0.742108E+00}, {-.279680E+00, 0.735327E+00},
            {-.289565E+00, 0.728299E+00}, {-.299649E+00, 0.721028E+00},
            {-.309917E+00, 0.713516E+00}, {-.320354E+00, 0.705768E+00},
            {-.330947E+00, 0.697787E+00}, {-.341681E+00, 0.689577E+00},
            {-.352541E+00, 0.681144E+00}, {-.363514E+00, 0.672493E+00},
            {-.374586E+00, 0.663629E+00}, {-.385742E+00, 0.654558E+00},
            {-.396968E+00, 0.645287E+00}, {-.408250E+00, 0.635822E+00},
            {-.419575E+00, 0.626171E+00}, {-.430930E+00, 0.616340E+00},
            {-.442299E+00, 0.606339E+00}, {-.453672E+00, 0.596175E+00},
            {-.465034E+00, 0.585857E+00}, {-.476372E+00, 0.575394E+00},
            {-.487675E+00, 0.564795E+00}, {-.498929E+00, 0.554071E+00},
            {-.510124E+00, 0.543231E+00}, {-.521246E+00, 0.532286E+00},
            {-.532286E+00, 0.521246E+00}, {-.543231E+00, 0.510124E+00},
            {-.554071E+00, 0.498929E+00}, {-.564795E+00, 0.487675E+00},
            {-.575394E+00, 0.476372E+00}, {-.585857E+00, 0.465034E+00},
            {-.596175E+00, 0.453672E+00}, {-.606339E+00, 0.442299E+00},
            {-.616340E+00, 0.430930E+00}, {-.626171E+00, 0.419575E+00},
            {-.635822E+00, 0.408250E+00}, {-.645287E+00, 0.396968E+00},
            {-.654558E+00, 0.385742E+00}, {-.663629E+00, 0.374586E+00},
            {-.672493E+00, 0.363514E+00}, {-.681144E+00, 0.352541E+00},
            {-.689577E+00, 0.341681E+00}, {-.697787E+00, 0.330947E+00},
            {-.705768E+00, 0.320354E+00}, {-.713516E+00, 0.309917E+00},
            {-.721028E+00, 0.299649E+00}, {-.728299E+00, 0.289565E+00},
            {-.735327E+00, 0.279680E+00}, {-.742108E+00, 0.270006E+00},
            {-.748640E+00, 0.260559E+00}, {-.754921E+00, 0.251352E+00},
            {-.760948E+00, 0.242398E+00}, {-.766720E+00, 0.233712E+00},
            {-.772236E+00, 0.225306E+00}, {-.777494E+00, 0.217193E+00},
            {-.782495E+00, 0.209386E+00}, {-.787236E+00, 0.201898E+00},
            {-.791719E+00, 0.194740E+00}, {-.795942E+00, 0.187924E+00},
            {-.799906E+00, 0.181460E+00}, {-.803611E+00, 0.175361E+00},
            {-.807057E+00, 0.169635E+00}, {-.810244E+00, 0.164292E+00},
            {-.813174E+00, 0.159342E+00}, {-.815846E+00, 0.154793E+00},
            {-.818262E+00, 0.150653E+00}, {-.820421E+00, 0.146929E+00},
            {-.822324E+00, 0.143627E+00}, {-.823973E+00, 0.140754E+00},
            {-.825367E+00, 0.138314E+00}, {-.826506E+00, 0.136311E+00},
            {-.827392E+00, 0.134750E+00}, {-.828025E+00, 0.133633E+00},
            {-.828404E+00, 0.132962E+00}, {-.828531E+00, 0.132738E+00},
        },
        {
            {-.120402E+00, 0.832421E+00}, {-.120632E+00, 0.832292E+00},
            {-.121322E+00, 0.831907E+00}, {-.122470E+00, 0.831265E+00},
            {-.124074E+00, 0.830365E+00}, {-.126132E+00, 0.829207E+00},
            {-.128640E+00, 0.827792E+00}, {-.131593E+00, 0.826117E+00},
            {-.134985E+00, 0.824183E+00}, {-.138812E+00, 0.821989E+00},
            {-.143066E+00, 0.819535E+00}, {-.147740E+00, 0.816819E+00},
            {-.152825E+00, 0.813840E+00}, {-.158313E+00, 0.810600E+00},
            {-.164195E+00, 0.807095E+00}, {-.170459E+00, 0.803327E+00},
            {-.177097E+00, 0.799295E+00}, {-.184097E+00, 0.794998E+00},
            {-.191448E+00, 0.790436E+00}, {-.199136E+00, 0.785610E+00},
            {-.207151E+00, 0.780519E+00}, {-.215479E+00, 0.775164E+00},
            {-.224108E+00, 0.769546E+00}, {-.233023E+00, 0.763666E+00},
            {-.242212E+00, 0.757524E+00}, {-.251660E+00, 0.751123E+00},
            {-.261353E+00, 0.744465E+00}, {-.271278E+00, 0.737551E+00},
            {-.281419E+00, 0.730384E+00}, {-.291762E+00, 0.722968E+00},
            {-.302293E+00, 0.715304E+00}, {-.312997E+00, 0.707398E+00},
            {-.323859E+00, 0.699253E+00}, {-.334864E+00, 0.690873E+00},
            {-.345998E+00, 0.682264E+00}, {-.357246E+00, 0.673430E+00},
            {-.368594E+00, 0.664378E+00}, {-.380027E+00, 0.655112E+00},
            {-.391531E+00, 0.645641E+00}, {-.403091E+00, 0.635970E+00},
            {-.414694E+00, 0.626107E+00}, {-.426325E+00, 0.616060E+00},
            {-.437971E+00, 0.605836E+00}, {-.449618E+00, 0.595445E+00},
            {-.461253E+00, 0.584894E+00}, {-.472863E+00, 0.574194E+00},
            {-.484435E+00, 0.563354E+00}, {-.495956E+00, 0.552384E+00},
            {-.507415E+00, 0.541294E+00}, {-.518798E+00, 0.530095E+00},
            {-.530095E+00, 0.518798E+00}, {-.541294E+00, 0.507415E+00},
            {-.552384E+00, 0.495956E+00}, {-.563354E+00, 0.484435E+00},
            {-.574194E+00, 0.472863E+00}, {-.584894E+00, 0.461253E+00},
            {-.595445E+00, 0.449618E+00}, {-.605836E+00, 0.437971E+00},
            {-.616060E+00, 0.426325E+00}, {-.626107E+00, 0.414694E+00},
            {-.635970E+00, 0.403091E+00}, {-.645641E+00, 0.391531E+00},
            {-.655112E+00, 0.380027E+00}, {-.664378E+00, 0.368594E+00},
            {-.673430E+00, 0.357246E+00}, {-.682264E+00, 0.345998E+00},
            {-.690873E+00, 0.334864E+00}, {-.699253E+00, 0.323859E+00},
            {-.707398E+00, 0.312997E+00}, {-.715304E+00, 0.302293E+00},
            {-.722968E+00, 0.291762E+00}, {-.730384E+00, 0.281419E+00},
            {-.737551E+00, 0.271278E+00}, {-.744465E+00, 0.261353E+00},
            {-.751123E+00, 0.251660E+00}, {-.757524E+00, 0.242212E+00},
            {-.763666E+00, 0.233023E+00}, {-.769546E+00, 0.224108E+00},
            {-.775164E+00, 0.215479E+00}, {-.780519E+00, 0.207151E+00},
            {-.785610E+00, 0.199136E+00}, {-.790436E+00, 0.191448E+00},
            {-.794998E+00, 0.184097E+00}, {-.799295E+00, 0.177097E+00},
            {-.803327E+00, 0.170459E+00}, {-.807095E+00, 0.164195E+00},
            {-.810600E+00, 0.158313E+00}, {-.813840E+00, 0.152825E+00},
            {-.816819E+00, 0.147740E+00}, {-.819535E+00, 0.143066E+00},
            {-.821989E+00, 0.138812E+00}, {-.824183E+00, 0.134985E+00},
            {-.826117E+00, 0.131593E+00}, {-.827792E+00, 0.128640E+00},
            {-.829207E+00, 0.126132E+00}, {-.830365E+00, 0.124074E+00},
            {-.831265E+00, 0.122470E+00}, {-.831907E+00, 0.121322E+00},
            {-.832292E+00, 0.120632E+00}, {-.832421E+00, 0.120402E+00},
        },
        {
            {-.107757E+00, 0.836313E+00}, {-.107994E+00, 0.836183E+00},
            {-.108702E+00, 0.835792E+00}, {-.109882E+00, 0.835139E+00},
            {-.111531E+00, 0.834226E+00}, {-.113646E+00, 0.833050E+00},
            {-.116222E+00, 0.831613E+00}, {-.119256E+00, 0.829912E+00},
            {-.122742E+00, 0.827948E+00}, {-.126674E+00, 0.825719E+00},
            {-.131045E+00, 0.823225E+00}, {-.135846E+00, 0.820465E+00},
            {-.141070E+00, 0.817438E+00}, {-.146707E+00, 0.814143E+00},
            {-.152748E+00, 0.810581E+00}, {-.159182E+00, 0.806749E+00},
            {-.165999E+00, 0.802647E+00}, {-.173186E+00, 0.798276E+00},
            {-.180733E+00, 0.793634E+00}, {-.188627E+00, 0.788722E+00},
            {-.196855E+00, 0.783539E+00}, {-.205403E+00, 0.778087E+00},
            {-.214259E+00, 0.772366E+00}, {-.223409E+00, 0.766376E+00},
            {-.232838E+00, 0.760119E+00}, {-.242532E+00, 0.753596E+00},
            {-.252477E+00, 0.746809E+00}, {-.262658E+00, 0.739761E+00},
            {-.273060E+00, 0.732453E+00}, {-.283668E+00, 0.724889E+00},
            {-.294468E+00, 0.717072E+00}, {-.305443E+00, 0.709005E+00},
            {-.316580E+00, 0.700693E+00}, {-.327862E+00, 0.692141E+00},
            {-.339276E+00, 0.683352E+00}, {-.350805E+00, 0.674332E+00},
            {-.362435E+00, 0.665088E+00}, {-.374151E+00, 0.655625E+00},
            {-.385938E+00, 0.645950E+00}, {-.397782E+00, 0.636069E+00},
            {-.409667E+00, 0.625991E+00}, {-.421581E+00, 0.615722E+00},
            {-.433509E+00, 0.605272E+00}, {-.445436E+00, 0.594649E+00},
            {-.457350E+00, 0.583862E+00}, {-.469236E+00, 0.572921E+00},
            {-.481083E+00, 0.561834E+00}, {-.492876E+00, 0.550614E+00},
            {-.504603E+00, 0.539269E+00}, {-.516252E+00, 0.527811E+00},
            {-.527811E+00, 0.516252E+00}, {-.539269E+00, 0.504603E+00},
            {-.550614E+00, 0.492876E+00}, {-.561834E+00, 0.481083E+00},
            {-.572921E+00, 0.469236E+00}, {-.583862E+00, 0.457350E+00},
            {-.594649E+00, 0.445436E+00}, {-.605272E+00, 0.433509E+00},
            {-.615722E+00, 0.421581E+00}, {-.625991E+00, 0.409667E+00},
            {-.636069E+00, 0.397782E+00}, {-.645950E+00, 0.385938E+00},
            {-.655625E+00, 0.374151E+00}, {-.665088E+00, 0.362435E+00},
            {-.674332E+00, 0.350805E+00}, {-.683352E+00, 0.339276E+00},
            {-.692141E+00, 0.327862E+00}, {-.700693E+00, 0.316580E+00},
            {-.709005E+00, 0.305443E+00}, {-.717072E+00, 0.294468E+00},
            {-.724889E+00, 0.283668E+00}, {-.732453E+00, 0.273060E+00},
            {-.739761E+00, 0.262658E+00}, {-.746809E+00, 0.252477E+00},
            {-.753596E+00, 0.242532E+00}, {-.760119E+00, 0.232838E+00},
            {-.766376E+00, 0.223409E+00}, {-.772366E+00, 0.214259E+00},
            {-.778087E+00, 0.205403E+00}, {-.783539E+00, 0.196855E+00},
            {-.788722E+00, 0.188627E+00}, {-.793634E+00, 0.180733E+00},
            {-.798276E+00, 0.173186E+00}, {-.802647E+00, 0.165999E+00},
            {-.806749E+00, 0.159182E+00}, {-.810581E+00, 0.152748E+00},
            {-.814143E+00, 0.146707E+00}, {-.817438E+00, 0.141070E+00},
            {-.820465E+00, 0.135846E+00}, {-.823225E+00, 0.131045E+00},
            {-.825719E+00, 0.126674E+00}, {-.827948E+00, 0.122742E+00},
            {-.829912E+00, 0.119256E+00}, {-.831613E+00, 0.116222E+00},
            {-.833050E+00, 0.113646E+00}, {-.834226E+00, 0.111531E+00},
            {-.835139E+00, 0.109882E+00}, {-.835792E+00, 0.108702E+00},
            {-.836183E+00, 0.107994E+00}, {-.836313E+00, 0.107757E+00},
        },
        {
            {-.947884E-01, 0.840209E+00}, {-.950314E-01, 0.840077E+00},
            {-.957597E-01, 0.839680E+00}, {-.969721E-01, 0.839017E+00},
            {-.986664E-01, 0.838090E+00}, {-.100839E+00, 0.836897E+00},
            {-.103487E+00, 0.835437E+00}, {-.106604E+00, 0.833710E+00},
            {-.110186E+00, 0.831715E+00}, {-.114225E+00, 0.829451E+00},
            {-.118715E+00, 0.826918E+00}, {-.123647E+00, 0.824113E+00},
            {-.129013E+00, 0.821038E+00}, {-.134803E+00, 0.817689E+00},
            {-.141007E+00, 0.814067E+00}, {-.147615E+00, 0.810171E+00},
            {-.154614E+00, 0.806000E+00}, {-.161995E+00, 0.801553E+00},
            {-.169743E+00, 0.796830E+00}, {-.177846E+00, 0.791832E+00},
            {-.186292E+00, 0.786557E+00}, {-.195066E+00, 0.781006E+00},
            {-.204154E+00, 0.775180E+00}, {-.213544E+00, 0.769079E+00},
            {-.223218E+00, 0.762705E+00}, {-.233164E+00, 0.756058E+00},
            {-.243366E+00, 0.749141E+00}, {-.253809E+00, 0.741956E+00},
            {-.264478E+00, 0.734505E+00}, {-.275357E+00, 0.726791E+00},
            {-.286431E+00, 0.718817E+00}, {-.297684E+00, 0.710588E+00},
            {-.309102E+00, 0.702106E+00}, {-.320667E+00, 0.693378E+00},
            {-.332366E+00, 0.684406E+00}, {-.344181E+00, 0.675198E+00},
            {-.356099E+00, 0.665758E+00}, {-.368104E+00, 0.656094E+00},
            {-.380180E+00, 0.646211E+00}, {-.392313E+00, 0.636116E+00},
            {-.404488E+00, 0.625819E+00}, {-.416690E+00, 0.615325E+00},
            {-.428905E+00, 0.604644E+00}, {-.441118E+00, 0.593785E+00},
            {-.453316E+00, 0.582757E+00}, {-.465485E+00, 0.571569E+00},
            {-.477611E+00, 0.560232E+00}, {-.489681E+00, 0.548756E+00},
            {-.501683E+00, 0.537151E+00}, {-.513603E+00, 0.525430E+00},
            {-.525430E+00, 0.513603E+00}, {-.537151E+00, 0.501683E+00},
            {-.548756E+00, 0.489681E+00}, {-.560232E+00, 0.477611E+00},
            {-.571569E+00, 0.465485E+00}, {-.582757E+00, 0.453316E+00},
            {-.593785E+00, 0.441118E+00}, {-.604644E+00, 0.428905E+00},
            {-.615325E+00, 0.416690E+00}, {-.625819E+00, 0.404488E+00},
            {-.636116E+00, 0.392313E+00}, {-.646211E+00, 0.380180E+00},
            {-.656094E+00, 0.368104E+00}, {-.665758E+00, 0.356099E+00},
            {-.675198E+00, 0.344181E+00}, {-.684406E+00, 0.332366E+00},
            {-.693378E+00, 0.320667E+00}, {-.702106E+00, 0.309102E+00},
            {-.710588E+00, 0.297684E+00}, {-.718817E+00, 0.286431E+00},
            {-.726791E+00, 0.275357E+00}, {-.734505E+00, 0.264478E+00},
            {-.741956E+00, 0.253809E+00}, {-.749141E+00, 0.243366E+00},
            {-.756058E+00, 0.233164E+00}, {-.762705E+00, 0.223218E+00},
            {-.769079E+00, 0.213544E+00}, {-.775180E+00, 0.204154E+00},
            {-.781006E+00, 0.195066E+00}, {-.786557E+00, 0.186292E+00},
            {-.791832E+00, 0.177846E+00}, {-.796830E+00, 0.169743E+00},
            {-.801553E+00, 0.161995E+00}, {-.806000E+00, 0.154614E+00},
            {-.810171E+00, 0.147615E+00}, {-.814067E+00, 0.141007E+00},
            {-.817689E+00, 0.134803E+00}, {-.821038E+00, 0.129013E+00},
            {-.824113E+00, 0.123647E+00}, {-.826918E+00, 0.118715E+00},
            {-.829451E+00, 0.114225E+00}, {-.831715E+00, 0.110186E+00},
            {-.833710E+00, 0.106604E+00}, {-.835437E+00, 0.103487E+00},
            {-.836897E+00, 0.100839E+00}, {-.838090E+00, 0.986664E-01},
            {-.839017E+00, 0.969721E-01}, {-.839680E+00, 0.957597E-01},
            {-.840077E+00, 0.950314E-01}, {-.840209E+00, 0.947884E-01},
        },
        {
            {-.814802E-01, 0.844109E+00}, {-.817299E-01, 0.843975E+00},
            {-.824783E-01, 0.843571E+00}, {-.837241E-01, 0.842899E+00},
            {-.854650E-01, 0.841958E+00}, {-.876977E-01, 0.840747E+00},
            {-.904180E-01, 0.839265E+00}, {-.936210E-01, 0.837512E+00},
            {-.973007E-01, 0.835486E+00}, {-.101450E+00, 0.833187E+00},
            {-.106062E+00, 0.830614E+00}, {-.111129E+00, 0.827765E+00},
            {-.116640E+00, 0.824640E+00}, {-.122587E+00, 0.821237E+00},
            {-.128958E+00, 0.817556E+00}, {-.135743E+00, 0.813595E+00},
            {-.142931E+00, 0.809353E+00}, {-.150508E+00, 0.804830E+00},
            {-.158462E+00, 0.800026E+00}, {-.166780E+00, 0.794940E+00},
            {-.175449E+00, 0.789571E+00}, {-.184454E+00, 0.783920E+00},
            {-.193781E+00, 0.777988E+00}, {-.203415E+00, 0.771775E+00},
            {-.213341E+00, 0.765281E+00}, {-.223544E+00, 0.758509E+00},
            {-.234009E+00, 0.751460E+00}, {-.244720E+00, 0.744136E+00},
            {-.255662E+00, 0.736539E+00}, {-.266818E+00, 0.728673E+00},
            {-.278172E+00, 0.720540E+00}, {-.289709E+00, 0.712145E+00},
            {-.301413E+00, 0.703491E+00}, {-.313268E+00, 0.694582E+00},
            {-.325258E+00, 0.685425E+00}, {-.337366E+00, 0.676024E+00},
            {-.349578E+00, 0.666386E+00}, {-.361878E+00, 0.656516E+00},
            {-.374249E+00, 0.646421E+00}, {-.386678E+00, 0.636109E+00},
            {-.399148E+00, 0.625588E+00}, {-.411644E+00, 0.614865E+00},
            {-.424152E+00, 0.603949E+00}, {-.436657E+00, 0.592849E+00},
            {-.449145E+00, 0.581575E+00}, {-.461602E+00, 0.570136E+00},
            {-.474014E+00, 0.558542E+00}, {-.486367E+00, 0.546806E+00},
            {-.498649E+00, 0.534936E+00}, {-.510846E+00, 0.522946E+00},
            {-.522946E+00, 0.510846E+00}, {-.534936E+00, 0.498649E+00},
            {-.546806E+00, 0.486367E+00}, {-.558542E+00, 0.474014E+00},
            {-.570136E+00, 0.461602E+00}, {-.581575E+00, 0.449145E+00},
            {-.592849E+00, 0.436657E+00}, {-.603949E+00, 0.424152E+00},
            {-.614865E+00, 0.411644E+00}, {-.625588E+00, 0.399148E+00},
            {-.636109E+00, 0.386678E+00}, {-.646421E+00, 0.374249E+00},
            {-.656516E+00, 0.361878E+00}, {-.666386E+00, 0.349578E+00},
            {-.676024E+00, 0.337366E+00}, {-.685425E+00, 0.325258E+00},
            {-.694582E+00, 0.313268E+00}, {-.703491E+00, 0.301413E+00},
            {-.712145E+00, 0.289709E+00}, {-.720540E+00, 0.278172E+00},
            {-.728673E+00, 0.266818E+00}, {-.736539E+00, 0.255662E+00},
            {-.744136E+00, 0.244720E+00}, {-.751460E+00, 0.234009E+00},
            {-.758509E+00, 0.223544E+00}, {-.765281E+00, 0.213341E+00},
            {-.771775E+00, 0.203415E+00}, {-.777988E+00, 0.193781E+00},
            {-.783920E+00, 0.184454E+00}, {-.789571E+00, 0.175449E+00},
            {-.794940E+00, 0.166780E+00}, {-.800026E+00, 0.158462E+00},
            {-.804830E+00, 0.150508E+00}, {-.809353E+00, 0.142931E+00},
            {-.813595E+00, 0.135743E+00}, {-.817556E+00, 0.128958E+00},
            {-.821237E+00, 0.122587E+00}, {-.824640E+00, 0.116640E+00},
            {-.827765E+00, 0.111129E+00}, {-.830614E+00, 0.106062E+00},
            {-.833187E+00, 0.101450E+00}, {-.835486E+00, 0.973007E-01},
            {-.837512E+00, 0.936210E-01}, {-.839265E+00, 0.904180E-01},
            {-.840747E+00, 0.876977E-01}, {-.841958E+00, 0.854650E-01},
            {-.842899E+00, 0.837241E-01}, {-.843571E+00, 0.824783E-01},
            {-.843975E+00, 0.817299E-01}, {-.844109E+00, 0.814802E-01},
        },
        {
            {-.678158E-01, 0.848014E+00}, {-.680723E-01, 0.847877E+00},
            {-.688414E-01, 0.847468E+00}, {-.701215E-01, 0.846786E+00},
            {-.719103E-01, 0.845831E+00}, {-.742043E-01, 0.844602E+00},
            {-.769993E-01, 0.843098E+00}, {-.802900E-01, 0.841318E+00},
            {-.840704E-01, 0.839262E+00}, {-.883333E-01, 0.836928E+00},
            {-.930710E-01, 0.834314E+00}, {-.982748E-01, 0.831421E+00},
            {-.103935E+00, 0.828246E+00}, {-.110043E+00, 0.824788E+00},
            {-.116586E+00, 0.821047E+00}, {-.123553E+00, 0.817020E+00},
            {-.130932E+00, 0.812708E+00}, {-.138712E+00, 0.808108E+00},
            {-.146877E+00, 0.803221E+00}, {-.155415E+00, 0.798046E+00},
            {-.164313E+00, 0.792583E+00}, {-.173554E+00, 0.786831E+00},
            {-.183124E+00, 0.780791E+00}, {-.193009E+00, 0.774463E+00},
            {-.203193E+00, 0.767849E+00}, {-.213660E+00, 0.760949E+00},
            {-.224394E+00, 0.753765E+00}, {-.235379E+00, 0.746300E+00},
            {-.246599E+00, 0.738555E+00}, {-.258038E+00, 0.730533E+00},
            {-.269680E+00, 0.722239E+00}, {-.281507E+00, 0.713674E+00},
            {-.293504E+00, 0.704844E+00}, {-.305654E+00, 0.695753E+00},
            {-.317942E+00, 0.686407E+00}, {-.330350E+00, 0.676809E+00},
            {-.342862E+00, 0.666968E+00}, {-.355463E+00, 0.656888E+00},
            {-.368136E+00, 0.646578E+00}, {-.380866E+00, 0.636044E+00},
            {-.393638E+00, 0.625294E+00}, {-.406435E+00, 0.614337E+00},
            {-.419242E+00, 0.603181E+00}, {-.432046E+00, 0.591835E+00},
            {-.444830E+00, 0.580310E+00}, {-.457581E+00, 0.568615E+00},
            {-.470285E+00, 0.556760E+00}, {-.482927E+00, 0.544757E+00},
            {-.495494E+00, 0.532617E+00}, {-.507974E+00, 0.520352E+00},
            {-.520352E+00, 0.507974E+00}, {-.532617E+00, 0.495494E+00},
            {-.544757E+00, 0.482927E+00}, {-.556760E+00, 0.470285E+00},
            {-.568615E+00, 0.457581E+00}, {-.580310E+00, 0.444830E+00},
            {-.591835E+00, 0.432046E+00}, {-.603181E+00, 0.419242E+00},
            {-.614337E+00, 0.406435E+00}, {-.625294E+00, 0.393638E+00},
            {-.636044E+00, 0.380866E+00}, {-.646578E+00, 0.368136E+00},
            {-.656888E+00, 0.355463E+00}, {-.666968E+00, 0.342862E+00},
            {-.676809E+00, 0.330350E+00}, {-.686407E+00, 0.317942E+00},
            {-.695753E+00, 0.305654E+00}, {-.704844E+00, 0.293504E+00},
            {-.713674E+00, 0.281507E+00}, {-.722239E+00, 0.269680E+00},
            {-.730533E+00, 0.258038E+00}, {-.738555E+00, 0.246599E+00},
            {-.746300E+00, 0.235379E+00}, {-.753765E+00, 0.224394E+00},
            {-.760949E+00, 0.213660E+00}, {-.767849E+00, 0.203193E+00},
            {-.774463E+00, 0.193009E+00}, {-.780791E+00, 0.183124E+00},
            {-.786831E+00, 0.173554E+00}, {-.792583E+00, 0.164313E+00},
            {-.798046E+00, 0.155415E+00}, {-.803221E+00, 0.146877E+00},
            {-.808108E+00, 0.138712E+00}, {-.812708E+00, 0.130932E+00},
            {-.817020E+00, 0.123553E+00}, {-.821047E+00, 0.116586E+00},
            {-.824788E+00, 0.110043E+00}, {-.828246E+00, 0.103935E+00},
            {-.831421E+00, 0.982748E-01}, {-.834314E+00, 0.930710E-01},
            {-.836928E+00, 0.883333E-01}, {-.839262E+00, 0.840704E-01},
            {-.841318E+00, 0.802900E-01}, {-.843098E+00, 0.769993E-01},
            {-.844602E+00, 0.742043E-01}, {-.845831E+00, 0.719103E-01},
            {-.846786E+00, 0.701215E-01}, {-.847468E+00, 0.688414E-01},
            {-.847877E+00, 0.680723E-01}, {-.848014E+00, 0.678158E-01},
        },
        {
            {-.537773E-01, 0.851924E+00}, {-.540409E-01, 0.851786E+00},
            {-.548311E-01, 0.851371E+00}, {-.561464E-01, 0.850679E+00},
            {-.579844E-01, 0.849710E+00}, {-.603415E-01, 0.848463E+00},
            {-.632131E-01, 0.846937E+00}, {-.665940E-01, 0.845130E+00},
            {-.704777E-01, 0.843043E+00}, {-.748569E-01, 0.840673E+00},
            {-.797235E-01, 0.838020E+00}, {-.850686E-01, 0.835081E+00},
            {-.908824E-01, 0.831857E+00}, {-.971544E-01, 0.828344E+00},
            {-.103873E+00, 0.824542E+00}, {-.111027E+00, 0.820449E+00},
            {-.118604E+00, 0.816064E+00}, {-.126590E+00, 0.811387E+00},
            {-.134972E+00, 0.806416E+00}, {-.143736E+00, 0.801151E+00},
            {-.152867E+00, 0.795591E+00}, {-.162351E+00, 0.789737E+00},
            {-.172171E+00, 0.783587E+00}, {-.182313E+00, 0.777144E+00},
            {-.192760E+00, 0.770406E+00}, {-.203497E+00, 0.763377E+00},
            {-.214506E+00, 0.756056E+00}, {-.225772E+00, 0.748447E+00},
            {-.237277E+00, 0.740551E+00}, {-.249006E+00, 0.732372E+00},
            {-.260941E+00, 0.723912E+00}, {-.273065E+00, 0.715175E+00},
            {-.285362E+00, 0.706166E+00}, {-.297815E+00, 0.696888E+00},
            {-.310406E+00, 0.687348E+00}, {-.323120E+00, 0.677551E+00},
            {-.335940E+00, 0.667502E+00}, {-.348849E+00, 0.657209E+00},
            {-.361831E+00, 0.646678E+00}, {-.374869E+00, 0.635917E+00},
            {-.387948E+00, 0.624935E+00}, {-.401053E+00, 0.613738E+00},
            {-.414167E+00, 0.602337E+00}, {-.427275E+00, 0.590740E+00},
            {-.440362E+00, 0.578959E+00}, {-.453413E+00, 0.567002E+00},
            {-.466415E+00, 0.554880E+00}, {-.479352E+00, 0.542605E+00},
            {-.492212E+00, 0.530189E+00}, {-.504980E+00, 0.517643E+00},
            {-.517643E+00, 0.504980E+00}, {-.530189E+00, 0.492212E+00},
            {-.542605E+00, 0.479352E+00}, {-.554880E+00, 0.466415E+00},
            {-.567002E+00, 0.453413E+00}, {-.578959E+00, 0.440362E+00},
            {-.590740E+00, 0.427275E+00}, {-.602337E+00, 0.414167E+00},
            {-.613738E+00, 0.401053E+00}, {-.624935E+00, 0.387948E+00},
            {-.635917E+00, 0.374869E+00}, {-.646678E+00, 0.361831E+00},
            {-.657209E+00, 0.348849E+00}, {-.667502E+00, 0.335940E+00},
            {-.677551E+00, 0.323120E+00}, {-.687348E+00, 0.310406E+00},
            {-.696888E+00, 0.297815E+00}, {-.706166E+00, 0.285362E+00},
            {-.715175E+00, 0.273065E+00}, {-.723912E+00, 0.260941E+00},
            {-.732372E+00, 0.249006E+00}, {-.740551E+00, 0.237277E+00},
            {-.748447E+00, 0.225772E+00}, {-.756056E+00, 0.214506E+00},
            {-.763377E+00, 0.203497E+00}, {-.770406E+00, 0.192760E+00},
            {-.777144E+00, 0.182313E+00}, {-.783587E+00, 0.172171E+00},
            {-.789737E+00, 0.162351E+00}, {-.795591E+00, 0.152867E+00},
            {-.801151E+00, 0.143736E+00}, {-.806416E+00, 0.134972E+00},
            {-.811387E+00, 0.126590E+00}, {-.816064E+00, 0.118604E+00},
            {-.820449E+00, 0.111027E+00}, {-.824542E+00, 0.103873E+00},
            {-.828344E+00, 0.971544E-01}, {-.831857E+00, 0.908824E-01},
            {-.835081E+00, 0.850686E-01}, {-.838020E+00, 0.797235E-01},
            {-.840673E+00, 0.748569E-01}, {-.843043E+00, 0.704777E-01},
            {-.845130E+00, 0.665940E-01}, {-.846937E+00, 0.632131E-01},
            {-.848463E+00, 0.603415E-01}, {-.849710E+00, 0.579844E-01},
            {-.850679E+00, 0.561464E-01}, {-.851371E+00, 0.548311E-01},
            {-.851786E+00, 0.540409E-01}, {-.851924E+00, 0.537773E-01},
        },
        {
            {-.393454E-01, 0.855842E+00}, {-.396163E-01, 0.855702E+00},
            {-.404283E-01, 0.855281E+00}, {-.417799E-01, 0.854579E+00},
            {-.436684E-01, 0.853596E+00}, {-.460902E-01, 0.852331E+00},
            {-.490407E-01, 0.850782E+00}, {-.525142E-01, 0.848949E+00},
            {-.565040E-01, 0.846831E+00}, {-.610027E-01, 0.844425E+00},
            {-.660017E-01, 0.841732E+00}, {-.714919E-01, 0.838748E+00},
            {-.774630E-01, 0.835472E+00}, {-.839041E-01, 0.831904E+00},
            {-.908038E-01, 0.828040E+00}, {-.981495E-01, 0.823881E+00},
            {-.105929E+00, 0.819424E+00}, {-.114127E+00, 0.814668E+00},
            {-.122731E+00, 0.809612E+00}, {-.131726E+00, 0.804256E+00},
            {-.141098E+00, 0.798598E+00}, {-.150829E+00, 0.792639E+00},
            {-.160906E+00, 0.786378E+00}, {-.171311E+00, 0.779816E+00},
            {-.182028E+00, 0.772954E+00}, {-.193040E+00, 0.765792E+00},
            {-.204332E+00, 0.758332E+00}, {-.215885E+00, 0.750577E+00},
            {-.227683E+00, 0.742527E+00}, {-.239708E+00, 0.734186E+00},
            {-.251943E+00, 0.725558E+00}, {-.264371E+00, 0.716645E+00},
            {-.276975E+00, 0.707453E+00}, {-.289737E+00, 0.697985E+00},
            {-.302640E+00, 0.688248E+00}, {-.315667E+00, 0.678246E+00},
            {-.328801E+00, 0.667986E+00}, {-.342025E+00, 0.657474E+00},
            {-.355322E+00, 0.646718E+00}, {-.368676E+00, 0.635726E+00},
            {-.382070E+00, 0.624505E+00}, {-.395489E+00, 0.613064E+00},
            {-.408915E+00, 0.601412E+00}, {-.422335E+00, 0.589559E+00},
            {-.435732E+00, 0.577515E+00}, {-.449091E+00, 0.565290E+00},
            {-.462397E+00, 0.552896E+00}, {-.475636E+00, 0.540343E+00},
            {-.488794E+00, 0.527645E+00}, {-.501857E+00, 0.514812E+00},
            {-.514812E+00, 0.501857E+00}, {-.527645E+00, 0.488794E+00},
            {-.540343E+00, 0.475636E+00}, {-.552896E+00, 0.462397E+00},
            {-.565290E+00, 0.449091E+00}, {-.577515E+00, 0.435732E+00},
            {-.589559E+00, 0.422335E+00}, {-.601412E+00, 0.408915E+00},
            {-.613064E+00, 0.395489E+00}, {-.624505E+00, 0.382070E+00},
            {-.635726E+00, 0.368676E+00}, {-.646718E+00, 0.355322E+00},
            {-.657474E+00, 0.342025E+00}, {-.667986E+00, 0.328801E+00},
            {-.678246E+00, 0.315667E+00}, {-.688248E+00, 0.302640E+00},
            {-.697985E+00, 0.289737E+00}, {-.707453E+00, 0.276975E+00},
            {-.716645E+00, 0.264371E+00}, {-.725558E+00, 0.251943E+00},
            {-.734186E+00, 0.239708E+00}, {-.742527E+00, 0.227683E+00},
            {-.750577E+00, 0.215885E+00}, {-.758332E+00, 0.204332E+00},
            {-.765792E+00, 0.193040E+00}, {-.772954E+00, 0.182028E+00},
            {-.779816E+00, 0.171311E+00}, {-.786378E+00, 0.160906E+00},
            {-.792639E+00, 0.150829E+00}, {-.798598E+00, 0.141098E+00},
            {-.804256E+00, 0.131726E+00}, {-.809612E+00, 0.122731E+00},
            {-.814668E+00, 0.114127E+00}, {-.819424E+00, 0.105929E+00},
            {-.823881E+00, 0.981495E-01}, {-.828040E+00, 0.908038E-01},
            {-.831904E+00, 0.839041E-01}, {-.835472E+00, 0.774630E-01},
            {-.838748E+00, 0.714919E-01}, {-.841732E+00, 0.660017E-01},
            {-.844425E+00, 0.610027E-01}, {-.846831E+00, 0.565040E-01},
            {-.848949E+00, 0.525142E-01}, {-.850782E+00, 0.490407E-01},
            {-.852331E+00, 0.460902E-01}, {-.853596E+00, 0.436684E-01},
            {-.854579E+00, 0.417799E-01}, {-.855281E+00, 0.404283E-01},
            {-.855702E+00, 0.396163E-01}, {-.855842E+00, 0.393454E-01},
        },
        {
            {-.244998E-01, 0.859768E+00}, {-.247781E-01, 0.859625E+00},
            {-.256125E-01, 0.859199E+00}, {-.270013E-01, 0.858487E+00},
            {-.289418E-01, 0.857490E+00}, {-.314303E-01, 0.856206E+00},
            {-.344618E-01, 0.854635E+00}, {-.380305E-01, 0.852776E+00},
            {-.421295E-01, 0.850626E+00}, {-.467510E-01, 0.848185E+00},
            {-.518861E-01, 0.845450E+00}, {-.575253E-01, 0.842420E+00},
            {-.636581E-01, 0.839094E+00}, {-.702730E-01, 0.835469E+00},
            {-.773582E-01, 0.831544E+00}, {-.849008E-01, 0.827317E+00},
            {-.928874E-01, 0.822786E+00}, {-.101304E+00, 0.817950E+00},
            {-.110136E+00, 0.812808E+00}, {-.119369E+00, 0.807359E+00},
            {-.128986E+00, 0.801602E+00}, {-.138972E+00, 0.795537E+00},
            {-.149311E+00, 0.789163E+00}, {-.159986E+00, 0.782481E+00},
            {-.170980E+00, 0.775491E+00}, {-.182275E+00, 0.768195E+00},
            {-.193856E+00, 0.760593E+00}, {-.205703E+00, 0.752687E+00},
            {-.217800E+00, 0.744481E+00}, {-.230129E+00, 0.735975E+00},
            {-.242672E+00, 0.727175E+00}, {-.255411E+00, 0.718083E+00},
            {-.268329E+00, 0.708704E+00}, {-.281408E+00, 0.699041E+00},
            {-.294629E+00, 0.689102E+00}, {-.307977E+00, 0.678891E+00},
            {-.321432E+00, 0.668415E+00}, {-.334978E+00, 0.657680E+00},
            {-.348598E+00, 0.646694E+00}, {-.362275E+00, 0.635464E+00},
            {-.375991E+00, 0.623999E+00}, {-.389731E+00, 0.612308E+00},
            {-.403478E+00, 0.600400E+00}, {-.417217E+00, 0.588285E+00},
            {-.430930E+00, 0.575973E+00}, {-.444603E+00, 0.563474E+00},
            {-.458221E+00, 0.550801E+00}, {-.471769E+00, 0.537964E+00},
            {-.485233E+00, 0.524976E+00}, {-.498598E+00, 0.511850E+00},
            {-.511850E+00, 0.498598E+00}, {-.524976E+00, 0.485233E+00},
            {-.537964E+00, 0.471769E+00}, {-.550801E+00, 0.458221E+00},
            {-.563474E+00, 0.444603E+00}, {-.575973E+00, 0.430930E+00},
            {-.588285E+00, 0.417217E+00}, {-.600400E+00, 0.403478E+00},
            {-.612308E+00, 0.389731E+00}, {-.623999E+00, 0.375991E+00},
            {-.635464E+00, 0.362275E+00}, {-.646694E+00, 0.348598E+00},
            {-.657680E+00, 0.334978E+00}, {-.668415E+00, 0.321432E+00},
            {-.678891E+00, 0.307977E+00}, {-.689102E+00, 0.294629E+00},
            {-.699041E+00, 0.281408E+00}, {-.708704E+00, 0.268329E+00},
            {-.718083E+00, 0.255411E+00}, {-.727175E+00, 0.242672E+00},
            {-.735975E+00, 0.230129E+00}, {-.744481E+00, 0.217800E+00},
            {-.752687E+00, 0.205703E+00}, {-.760593E+00, 0.193856E+00},
            {-.768195E+00, 0.182275E+00}, {-.775491E+00, 0.170980E+00},
            {-.782481E+00, 0.159986E+00}, {-.789163E+00, 0.149311E+00},
            {-.795537E+00, 0.138972E+00}, {-.801602E+00, 0.128986E+00},
            {-.807359E+00, 0.119369E+00}, {-.812808E+00, 0.110136E+00},
            {-.817950E+00, 0.101304E+00}, {-.822786E+00, 0.928874E-01},
            {-.827317E+00, 0.849008E-01}, {-.831544E+00, 0.773582E-01},
            {-.835469E+00, 0.702730E-01}, {-.839094E+00, 0.636581E-01},
            {-.842420E+00, 0.575253E-01}, {-.845450E+00, 0.518861E-01},
            {-.848185E+00, 0.467510E-01}, {-.850626E+00, 0.421295E-01},
            {-.852776E+00, 0.380305E-01}, {-.854635E+00, 0.344618E-01},
            {-.856206E+00, 0.314303E-01}, {-.857490E+00, 0.289418E-01},
            {-.858487E+00, 0.270013E-01}, {-.859199E+00, 0.256125E-01},
            {-.859625E+00, 0.247781E-01}, {-.859768E+00, 0.244998E-01},
        },
        {
            {-.921795E-02, 0.863702E+00}, {-.950396E-02, 0.863558E+00},
            {-.103614E-01, 0.863125E+00}, {-.117886E-01, 0.862404E+00},
            {-.137827E-01, 0.861393E+00}, {-.163397E-01, 0.860091E+00},
            {-.194546E-01, 0.858497E+00}, {-.231213E-01, 0.856611E+00},
            {-.273326E-01, 0.854430E+00}, {-.320803E-01, 0.851952E+00},
            {-.373555E-01, 0.849176E+00}, {-.431480E-01, 0.846101E+00},
            {-.494469E-01, 0.842723E+00}, {-.562405E-01, 0.839041E+00},
            {-.635163E-01, 0.835053E+00}, {-.712611E-01, 0.830757E+00},
            {-.794610E-01, 0.826152E+00}, {-.881016E-01, 0.821235E+00},
            {-.971677E-01, 0.816006E+00}, {-.106644E+00, 0.810463E+00},
            {-.116514E+00, 0.804605E+00}, {-.126761E+00, 0.798431E+00},
            {-.137369E+00, 0.791942E+00}, {-.148321E+00, 0.785138E+00},
            {-.159598E+00, 0.778018E+00}, {-.171184E+00, 0.770584E+00},
            {-.183061E+00, 0.762837E+00}, {-.195210E+00, 0.754778E+00},
            {-.207614E+00, 0.746411E+00}, {-.220254E+00, 0.737738E+00},
            {-.233112E+00, 0.728762E+00}, {-.246170E+00, 0.719486E+00},
            {-.259409E+00, 0.709915E+00}, {-.272812E+00, 0.700054E+00},
            {-.286360E+00, 0.689908E+00}, {-.300035E+00, 0.679483E+00},
            {-.313820E+00, 0.668786E+00}, {-.327696E+00, 0.657822E+00},
            {-.341647E+00, 0.646601E+00}, {-.355654E+00, 0.635128E+00},
            {-.369700E+00, 0.623414E+00}, {-.383769E+00, 0.611467E+00},
            {-.397844E+00, 0.599297E+00}, {-.411909E+00, 0.586913E+00},
            {-.425946E+00, 0.574326E+00}, {-.439941E+00, 0.561547E+00},
            {-.453879E+00, 0.548588E+00}, {-.467743E+00, 0.535461E+00},
            {-.481519E+00, 0.522177E+00}, {-.495192E+00, 0.508750E+00},
            {-.508750E+00, 0.495192E+00}, {-.522177E+00, 0.481519E+00},
            {-.535461E+00, 0.467743E+00}, {-.548588E+00, 0.453879E+00},
            {-.561547E+00, 0.439941E+00}, {-.574326E+00, 0.425946E+00},
            {-.586913E+00, 0.411909E+00}, {-.599297E+00, 0.397844E+00},
            {-.611467E+00, 0.383769E+00}, {-.623414E+00, 0.369700E+00},
            {-.635128E+00, 0.355654E+00}, {-.646601E+00, 0.341647E+00},
            {-.657822E+00, 0.327696E+00}, {-.668786E+00, 0.313820E+00},
            {-.679483E+00, 0.300035E+00}, {-.689908E+00, 0.286360E+00},
            {-.700054E+00, 0.272812E+00}, {-.709915E+00, 0.259409E+00},
            {-.719486E+00, 0.246170E+00}, {-.728762E+00, 0.233112E+00},
            {-.737738E+00, 0.220254E+00}, {-.746411E+00, 0.207614E+00},
            {-.754778E+00, 0.195210E+00}, {-.762837E+00, 0.183061E+00},
            {-.770584E+00, 0.171184E+00}, {-.778018E+00, 0.159598E+00},
            {-.785138E+00, 0.148321E+00}, {-.791942E+00, 0.137369E+00},
            {-.798431E+00, 0.126761E+00}, {-.804605E+00, 0.116514E+00},
            {-.810463E+00, 0.106644E+00}, {-.816006E+00, 0.971677E-01},
            {-.821235E+00, 0.881016E-01}, {-.826152E+00, 0.794610E-01},
            {-.830757E+00, 0.712611E-01}, {-.835053E+00, 0.635163E-01},
            {-.839041E+00, 0.562405E-01}, {-.842723E+00, 0.494469E-01},
            {-.846101E+00, 0.431480E-01}, {-.849176E+00, 0.373555E-01},
            {-.851952E+00, 0.320803E-01}, {-.854430E+00, 0.273326E-01},
            {-.856611E+00, 0.231213E-01}, {-.858497E+00, 0.194546E-01},
            {-.860091E+00, 0.163397E-01}, {-.861393E+00, 0.137827E-01},
            {-.862404E+00, 0.117886E-01}, {-.863125E+00, 0.103614E-01},
            {-.863558E+00, 0.950396E-02}, {-.863702E+00, 0.921795E-02},
        },
        {
            {0.652373E-02, 0.867647E+00}, {0.622980E-02, 0.867501E+00},
            {0.534860E-02, 0.867062E+00}, {0.388191E-02, 0.866331E+00},
            {0.183270E-02, 0.865305E+00}, {-.794918E-03, 0.863985E+00},
            {-.399569E-02, 0.862369E+00}, {-.776326E-02, 0.860456E+00},
            {-.120902E-01, 0.858243E+00}, {-.169680E-01, 0.855729E+00},
            {-.223871E-01, 0.852912E+00}, {-.283373E-01, 0.849789E+00},
            {-.348071E-01, 0.846359E+00}, {-.417845E-01, 0.842620E+00},
            {-.492563E-01, 0.838568E+00}, {-.572091E-01, 0.834203E+00},
            {-.656282E-01, 0.829522E+00}, {-.744988E-01, 0.824523E+00},
            {-.838053E-01, 0.819205E+00}, {-.935315E-01, 0.813566E+00},
            {-.103661E+00, 0.807605E+00}, {-.114176E+00, 0.801321E+00},
            {-.125061E+00, 0.794715E+00}, {-.136296E+00, 0.787785E+00},
            {-.147865E+00, 0.780532E+00}, {-.159749E+00, 0.772958E+00},
            {-.171929E+00, 0.765063E+00}, {-.184388E+00, 0.756848E+00},
            {-.197106E+00, 0.748317E+00}, {-.210065E+00, 0.739471E+00},
            {-.223246E+00, 0.730315E+00}, {-.236631E+00, 0.720851E+00},
            {-.250200E+00, 0.711085E+00}, {-.263935E+00, 0.701020E+00},
            {-.277817E+00, 0.690663E+00}, {-.291829E+00, 0.680019E+00},
            {-.305951E+00, 0.669094E+00}, {-.320165E+00, 0.657897E+00},
            {-.334454E+00, 0.646434E+00}, {-.348799E+00, 0.634713E+00},
            {-.363184E+00, 0.622743E+00}, {-.377590E+00, 0.610534E+00},
            {-.392001E+00, 0.598094E+00}, {-.406399E+00, 0.585435E+00},
            {-.420769E+00, 0.572567E+00}, {-.435094E+00, 0.559501E+00},
            {-.449358E+00, 0.546249E+00}, {-.463546E+00, 0.532824E+00},
            {-.477642E+00, 0.519237E+00}, {-.491632E+00, 0.505502E+00},
            {-.505502E+00, 0.491632E+00}, {-.519237E+00, 0.477642E+00},
            {-.532824E+00, 0.463546E+00}, {-.546249E+00, 0.449358E+00},
            {-.559501E+00, 0.435094E+00}, {-.572567E+00, 0.420769E+00},
            {-.585435E+00, 0.406399E+00}, {-.598094E+00, 0.392001E+00},
            {-.610534E+00, 0.377590E+00}, {-.622743E+00, 0.363184E+00},
            {-.634713E+00, 0.348799E+00}, {-.646434E+00, 0.334454E+00},
            {-.657897E+00, 0.320165E+00}, {-.669094E+00, 0.305951E+00},
            {-.680019E+00, 0.291829E+00}, {-.690663E+00, 0.277817E+00},
            {-.701020E+00, 0.263935E+00}, {-.711085E+00, 0.250200E+00},
            {-.720851E+00, 0.236631E+00}, {-.730315E+00, 0.223246E+00},
            {-.739471E+00, 0.210065E+00}, {-.748317E+00, 0.197106E+00},
            {-.756848E+00, 0.184388E+00}, {-.765063E+00, 0.171929E+00},
            {-.772958E+00, 0.159749E+00}, {-.780532E+00, 0.147865E+00},
            {-.787785E+00, 0.136296E+00}, {-.794715E+00, 0.125061E+00},
            {-.801321E+00, 0.114176E+00}, {-.807605E+00, 0.103661E+00},
            {-.813566E+00, 0.935315E-01}, {-.819205E+00, 0.838053E-01},
            {-.824523E+00, 0.744988E-01}, {-.829522E+00, 0.656282E-01},
            {-.834203E+00, 0.572091E-01}, {-.838568E+00, 0.492563E-01},
            {-.842620E+00, 0.417845E-01}, {-.846359E+00, 0.348071E-01},
            {-.849789E+00, 0.283373E-01}, {-.852912E+00, 0.223871E-01},
            {-.855729E+00, 0.169680E-01}, {-.858243E+00, 0.120902E-01},
            {-.860456E+00, 0.776326E-02}, {-.862369E+00, 0.399569E-02},
            {-.863985E+00, 0.794918E-03}, {-.865305E+00, -.183270E-02},
            {-.866331E+00, -.388191E-02}, {-.867062E+00, -.534860E-02},
            {-.867501E+00, -.622980E-02}, {-.867647E+00, -.652373E-02},
        },
        {
            {0.227509E-01, 0.871603E+00}, {0.224488E-01, 0.871455E+00},
            {0.215432E-01, 0.871010E+00}, {0.200358E-01, 0.870269E+00},
            {0.179297E-01, 0.869229E+00}, {0.152293E-01, 0.867891E+00},
            {0.119401E-01, 0.866252E+00}, {0.806858E-02, 0.864311E+00},
            {0.362257E-02, 0.862066E+00}, {-.138913E-02, 0.859516E+00},
            {-.695665E-02, 0.856657E+00}, {-.130692E-01, 0.853487E+00},
            {-.197150E-01, 0.850005E+00}, {-.268814E-01, 0.846207E+00},
            {-.345549E-01, 0.842091E+00}, {-.427215E-01, 0.837655E+00},
            {-.513661E-01, 0.832897E+00}, {-.604732E-01, 0.827814E+00},
            {-.700268E-01, 0.822405E+00}, {-.800101E-01, 0.816669E+00},
            {-.904060E-01, 0.810603E+00}, {-.101197E+00, 0.804207E+00},
            {-.112365E+00, 0.797480E+00}, {-.123892E+00, 0.790423E+00},
            {-.135760E+00, 0.783035E+00}, {-.147949E+00, 0.775316E+00},
            {-.160442E+00, 0.767269E+00}, {-.173218E+00, 0.758895E+00},
            {-.186258E+00, 0.750196E+00}, {-.199544E+00, 0.741174E+00},
            {-.213057E+00, 0.731833E+00}, {-.226776E+00, 0.722177E+00},
            {-.240683E+00, 0.712210E+00}, {-.254759E+00, 0.701936E+00},
            {-.268984E+00, 0.691362E+00}, {-.283340E+00, 0.680493E+00},
            {-.297808E+00, 0.669336E+00}, {-.312369E+00, 0.657898E+00},
            {-.327005E+00, 0.646187E+00}, {-.341697E+00, 0.634212E+00},
            {-.356428E+00, 0.621980E+00}, {-.371179E+00, 0.609501E+00},
            {-.385934E+00, 0.596786E+00}, {-.400675E+00, 0.583845E+00},
            {-.415385E+00, 0.570688E+00}, {-.430048E+00, 0.557328E+00},
            {-.444647E+00, 0.543776E+00}, {-.459167E+00, 0.530045E+00},
            {-.473592E+00, 0.516147E+00}, {-.487906E+00, 0.502096E+00},
            {-.502096E+00, 0.487906E+00}, {-.516147E+00, 0.473592E+00},
            {-.530045E+00, 0.459167E+00}, {-.543776E+00, 0.444647E+00},
            {-.557328E+00, 0.430048E+00}, {-.570688E+00, 0.415385E+00},
            {-.583845E+00, 0.400675E+00}, {-.596786E+00, 0.385934E+00},
            {-.609501E+00, 0.371179E+00}, {-.621980E+00, 0.356428E+00},
            {-.634212E+00, 0.341697E+00}, {-.646187E+00, 0.327005E+00},
            {-.657898E+00, 0.312369E+00}, {-.669336E+00, 0.297808E+00},
            {-.680493E+00, 0.283340E+00}, {-.691362E+00, 0.268984E+00},
            {-.701936E+00, 0.254759E+00}, {-.712210E+00, 0.240683E+00},
            {-.722177E+00, 0.226776E+00}, {-.731833E+00, 0.213057E+00},
            {-.741174E+00, 0.199544E+00}, {-.750196E+00, 0.186258E+00},
            {-.758895E+00, 0.173218E+00}, {-.767269E+00, 0.160442E+00},
            {-.775316E+00, 0.147949E+00}, {-.783035E+00, 0.135760E+00},
            {-.790423E+00, 0.123892E+00}, {-.797480E+00, 0.112365E+00},
            {-.804207E+00, 0.101197E+00}, {-.810603E+00, 0.904060E-01},
            {-.816669E+00, 0.800101E-01}, {-.822405E+00, 0.700268E-01},
            {-.827814E+00, 0.604732E-01}, {-.832897E+00, 0.513661E-01},
            {-.837655E+00, 0.427215E-01}, {-.842091E+00, 0.345549E-01},
            {-.846207E+00, 0.268814E-01}, {-.850005E+00, 0.197150E-01},
            {-.853487E+00, 0.130692E-01}, {-.856657E+00, 0.695665E-02},
            {-.859516E+00, 0.138913E-02}, {-.862066E+00, -.362257E-02},
            {-.864311E+00, -.806858E-02}, {-.866252E+00, -.119401E-01},
            {-.867891E+00, -.152293E-01}, {-.869229E+00, -.179297E-01},
            {-.870269E+00, -.200358E-01}, {-.871010E+00, -.215432E-01},
            {-.871455E+00, -.224488E-01}, {-.871603E+00, -.227509E-01},
        },
        {
            {0.394914E-01, 0.875572E+00}, {0.391809E-01, 0.875422E+00},
            {0.382500E-01, 0.874971E+00}, {0.367006E-01, 0.874219E+00},
            {0.345359E-01, 0.873165E+00}, {0.317605E-01, 0.871809E+00},
            {0.283800E-01, 0.870147E+00}, {0.244013E-01, 0.868179E+00},
            {0.198325E-01, 0.865902E+00}, {0.146828E-01, 0.863314E+00},
            {0.896243E-02, 0.860413E+00}, {0.268263E-02, 0.857196E+00},
            {-.414437E-02, 0.853660E+00}, {-.115055E-01, 0.849803E+00},
            {-.193867E-01, 0.845622E+00}, {-.277733E-01, 0.841114E+00},
            {-.366499E-01, 0.836277E+00}, {-.460004E-01, 0.831109E+00},
            {-.558081E-01, 0.825608E+00}, {-.660557E-01, 0.819772E+00},
            {-.767257E-01, 0.813599E+00}, {-.877998E-01, 0.807088E+00},
            {-.992596E-01, 0.800239E+00}, {-.111086E+00, 0.793050E+00},
            {-.123261E+00, 0.785523E+00}, {-.135764E+00, 0.777658E+00},
            {-.148576E+00, 0.769455E+00}, {-.161678E+00, 0.760917E+00},
            {-.175050E+00, 0.752045E+00}, {-.188672E+00, 0.742843E+00},
            {-.202524E+00, 0.733313E+00}, {-.216587E+00, 0.723459E+00},
            {-.230841E+00, 0.713285E+00}, {-.245266E+00, 0.702798E+00},
            {-.259843E+00, 0.692001E+00}, {-.274552E+00, 0.680901E+00},
            {-.289375E+00, 0.669506E+00}, {-.304291E+00, 0.657821E+00},
            {-.319283E+00, 0.645856E+00}, {-.334331E+00, 0.633618E+00},
            {-.349417E+00, 0.621118E+00}, {-.364523E+00, 0.608363E+00},
            {-.379630E+00, 0.595365E+00}, {-.394723E+00, 0.582134E+00},
            {-.409782E+00, 0.568681E+00}, {-.424791E+00, 0.555018E+00},
            {-.439734E+00, 0.541158E+00}, {-.454594E+00, 0.527113E+00},
            {-.469356E+00, 0.512896E+00}, {-.484003E+00, 0.498522E+00},
            {-.498522E+00, 0.484003E+00}, {-.512896E+00, 0.469356E+00},
            {-.527113E+00, 0.454594E+00}, {-.541158E+00, 0.439734E+00},
            {-.555018E+00, 0.424791E+00}, {-.568681E+00, 0.409782E+00},
            {-.582134E+00, 0.394723E+00}, {-.595365E+00, 0.379630E+00},
            {-.608363E+00, 0.364523E+00}, {-.621118E+00, 0.349417E+00},
            {-.633618E+00, 0.334331E+00}, {-.645856E+00, 0.319283E+00},
            {-.657821E+00, 0.304291E+00}, {-.669506E+00, 0.289375E+00},
            {-.680901E+00, 0.274552E+00}, {-.692001E+00, 0.259843E+00},
            {-.702798E+00, 0.245266E+00}, {-.713285E+00, 0.230841E+00},
            {-.723459E+00, 0.216587E+00}, {-.733313E+00, 0.202524E+00},
            {-.742843E+00, 0.188672E+00}, {-.752045E+00, 0.175050E+00},
            {-.760917E+00, 0.161678E+00}, {-.769455E+00, 0.148576E+00},
            {-.777658E+00, 0.135764E+00}, {-.785523E+00, 0.123261E+00},
            {-.793050E+00, 0.111086E+00}, {-.800239E+00, 0.992596E-01},
            {-.807088E+00, 0.877998E-01}, {-.813599E+00, 0.767257E-01},
            {-.819772E+00, 0.660557E-01}, {-.825608E+00, 0.558081E-01},
            {-.831109E+00, 0.460004E-01}, {-.836277E+00, 0.366499E-01},
            {-.841114E+00, 0.277733E-01}, {-.845622E+00, 0.193867E-01},
            {-.849803E+00, 0.115055E-01}, {-.853660E+00, 0.414437E-02},
            {-.857196E+00, -.268263E-02}, {-.860413E+00, -.896243E-02},
            {-.863314E+00, -.146828E-01}, {-.865902E+00, -.198325E-01},
            {-.868179E+00, -.244013E-01}, {-.870147E+00, -.283800E-01},
            {-.871809E+00, -.317605E-01}, {-.873165E+00, -.345359E-01},
            {-.874219E+00, -.367006E-01}, {-.874971E+00, -.382500E-01},
            {-.875422E+00, -.391809E-01}, {-.875572E+00, -.394914E-01},
        },
        {
            {0.567752E-01, 0.879554E+00}, {0.564560E-01, 0.879402E+00},
            {0.554990E-01, 0.878945E+00}, {0.539062E-01, 0.878183E+00},
            {0.516811E-01, 0.877115E+00}, {0.488282E-01, 0.875740E+00},
            {0.453535E-01, 0.874055E+00}, {0.412642E-01, 0.872059E+00},
            {0.365688E-01, 0.869750E+00}, {0.312767E-01, 0.867125E+00},
            {0.253987E-01, 0.864181E+00}, {0.189465E-01, 0.860915E+00},
            {0.119327E-01, 0.857325E+00}, {0.437094E-02, 0.853408E+00},
            {-.372420E-02, 0.849161E+00}, {-.123375E-01, 0.844580E+00},
            {-.214530E-01, 0.839664E+00}, {-.310539E-01, 0.834409E+00},
            {-.411231E-01, 0.828813E+00}, {-.516427E-01, 0.822875E+00},
            {-.625945E-01, 0.816593E+00}, {-.739597E-01, 0.809964E+00},
            {-.857193E-01, 0.802989E+00}, {-.978539E-01, 0.795667E+00},
            {-.110344E+00, 0.787997E+00}, {-.123169E+00, 0.779981E+00},
            {-.136311E+00, 0.771619E+00}, {-.149747E+00, 0.762912E+00},
            {-.163459E+00, 0.753864E+00}, {-.177425E+00, 0.744475E+00},
            {-.191627E+00, 0.734751E+00}, {-.206042E+00, 0.724694E+00},
            {-.220652E+00, 0.714309E+00}, {-.235436E+00, 0.703600E+00},
            {-.250374E+00, 0.692575E+00}, {-.265445E+00, 0.681238E+00},
            {-.280632E+00, 0.669597E+00}, {-.295913E+00, 0.657659E+00},
            {-.311270E+00, 0.645433E+00}, {-.326683E+00, 0.632926E+00},
            {-.342133E+00, 0.620149E+00}, {-.357603E+00, 0.607110E+00},
            {-.373073E+00, 0.593821E+00}, {-.388526E+00, 0.580292E+00},
            {-.403943E+00, 0.566535E+00}, {-.419308E+00, 0.552562E+00},
            {-.434604E+00, 0.538385E+00}, {-.449814E+00, 0.524018E+00},
            {-.464921E+00, 0.509473E+00}, {-.479910E+00, 0.494766E+00},
            {-.494766E+00, 0.479910E+00}, {-.509473E+00, 0.464921E+00},
            {-.524018E+00, 0.449814E+00}, {-.538385E+00, 0.434604E+00},
            {-.552562E+00, 0.419308E+00}, {-.566535E+00, 0.403943E+00},
            {-.580292E+00, 0.388526E+00}, {-.593821E+00, 0.373073E+00},
            {-.607110E+00, 0.357603E+00}, {-.620149E+00, 0.342133E+00},
            {-.632926E+00, 0.326683E+00}, {-.645433E+00, 0.311270E+00},
            {-.657659E+00, 0.295913E+00}, {-.669597E+00, 0.280632E+00},
            {-.681238E+00, 0.265445E+00}, {-.692575E+00, 0.250374E+00},
            {-.703600E+00, 0.235436E+00}, {-.714309E+00, 0.220652E+00},
            {-.724694E+00, 0.206042E+00}, {-.734751E+00, 0.191627E+00},
            {-.744475E+00, 0.177425E+00}, {-.753864E+00, 0.163459E+00},
            {-.762912E+00, 0.149747E+00}, {-.771619E+00, 0.136311E+00},
            {-.779981E+00, 0.123169E+00}, {-.787997E+00, 0.110344E+00},
            {-.795667E+00, 0.978539E-01}, {-.802989E+00, 0.857193E-01},
            {-.809964E+00, 0.739597E-01}, {-.816593E+00, 0.625945E-01},
            {-.822875E+00, 0.516427E-01}, {-.828813E+00, 0.411231E-01},
            {-.834409E+00, 0.310539E-01}, {-.839664E+00, 0.214530E-01},
            {-.844580E+00, 0.123375E-01}, {-.849161E+00, 0.372420E-02},
            {-.853408E+00, -.437094E-02}, {-.857325E+00, -.119327E-01},
            {-.860915E+00, -.189465E-01}, {-.864181E+00, -.253987E-01},
            {-.867125E+00, -.312767E-01}, {-.869750E+00, -.365688E-01},
            {-.872059E+00, -.412642E-01}, {-.874055E+00, -.453535E-01},
            {-.875740E+00, -.488282E-01}, {-.877115E+00, -.516811E-01},
            {-.878183E+00, -.539062E-01}, {-.878945E+00, -.554990E-01},
            {-.879402E+00, -.564560E-01}, {-.879554E+00, -.567752E-01},
        },
        {
            {0.746346E-01, 0.883551E+00}, {0.743064E-01, 0.883397E+00},
            {0.733225E-01, 0.882934E+00}, {0.716849E-01, 0.882162E+00},
            {0.693973E-01, 0.881080E+00}, {0.664643E-01, 0.879686E+00},
            {0.628924E-01, 0.877978E+00}, {0.586890E-01, 0.875954E+00},
            {0.538627E-01, 0.873612E+00}, {0.484237E-01, 0.870949E+00},
            {0.423831E-01, 0.867962E+00}, {0.357529E-01, 0.864647E+00},
            {0.285464E-01, 0.861003E+00}, {0.207778E-01, 0.857024E+00},
            {0.124622E-01, 0.852709E+00}, {0.361527E-02, 0.848054E+00},
            {-.574629E-02, 0.843056E+00}, {-.156052E-01, 0.837713E+00},
            {-.259437E-01, 0.832021E+00}, {-.367433E-01, 0.825979E+00},
            {-.479850E-01, 0.819584E+00}, {-.596497E-01, 0.812835E+00},
            {-.717177E-01, 0.805731E+00}, {-.841690E-01, 0.798271E+00},
            {-.969833E-01, 0.790455E+00}, {-.110140E+00, 0.782284E+00},
            {-.123619E+00, 0.773757E+00}, {-.137400E+00, 0.764878E+00},
            {-.151461E+00, 0.755647E+00}, {-.165781E+00, 0.746068E+00},
            {-.180341E+00, 0.736143E+00}, {-.195119E+00, 0.725877E+00},
            {-.210094E+00, 0.715274E+00}, {-.225246E+00, 0.704339E+00},
            {-.240555E+00, 0.693078E+00}, {-.255999E+00, 0.681497E+00},
            {-.271559E+00, 0.669604E+00}, {-.287215E+00, 0.657405E+00},
            {-.302946E+00, 0.644910E+00}, {-.318734E+00, 0.632126E+00},
            {-.334559E+00, 0.619064E+00}, {-.350402E+00, 0.605733E+00},
            {-.366244E+00, 0.592145E+00}, {-.382067E+00, 0.578310E+00},
            {-.397853E+00, 0.564240E+00}, {-.413583E+00, 0.549947E+00},
            {-.429241E+00, 0.535445E+00}, {-.444810E+00, 0.520746E+00},
            {-.460273E+00, 0.505865E+00}, {-.475614E+00, 0.490816E+00},
            {-.490816E+00, 0.475614E+00}, {-.505865E+00, 0.460273E+00},
            {-.520746E+00, 0.444810E+00}, {-.535445E+00, 0.429241E+00},
            {-.549947E+00, 0.413583E+00}, {-.564240E+00, 0.397853E+00},
            {-.578310E+00, 0.382067E+00}, {-.592145E+00, 0.366244E+00},
            {-.605733E+00, 0.350402E+00}, {-.619064E+00, 0.334559E+00},
            {-.632126E+00, 0.318734E+00}, {-.644910E+00, 0.302946E+00},
            {-.657405E+00, 0.287215E+00}, {-.669604E+00, 0.271559E+00},
            {-.681497E+00, 0.255999E+00}, {-.693078E+00, 0.240555E+00},
            {-.704339E+00, 0.225246E+00}, {-.715274E+00, 0.210094E+00},
            {-.725877E+00, 0.195119E+00}, {-.736143E+00, 0.180341E+00},
            {-.746068E+00, 0.165781E+00}, {-.755647E+00, 0.151461E+00},
            {-.764878E+00, 0.137400E+00}, {-.773757E+00, 0.123619E+00},
            {-.782284E+00, 0.110140E+00}, {-.790455E+00, 0.969833E-01},
            {-.798271E+00, 0.841690E-01}, {-.805731E+00, 0.717177E-01},
            {-.812835E+00, 0.596497E-01}, {-.819584E+00, 0.479850E-01},
            {-.825979E+00, 0.367433E-01}, {-.832021E+00, 0.259437E-01},
            {-.837713E+00, 0.156052E-01}, {-.843056E+00, 0.574629E-02},
            {-.848054E+00, -.361527E-02}, {-.852709E+00, -.124622E-01},
            {-.857024E+00, -.207778E-01}, {-.861003E+00, -.285464E-01},
            {-.864647E+00, -.357529E-01}, {-.867962E+00, -.423831E-01},
            {-.870949E+00, -.484237E-01}, {-.873612E+00, -.538627E-01},
            {-.875954E+00, -.586890E-01}, {-.877978E+00, -.628924E-01},
            {-.879686E+00, -.664643E-01}, {-.881080E+00, -.693973E-01},
            {-.882162E+00, -.716849E-01}, {-.882934E+00, -.733225E-01},
            {-.883397E+00, -.743064E-01}, {-.883551E+00, -.746346E-01},
        },
        {
            {0.931052E-01, 0.887565E+00}, {0.927677E-01, 0.887409E+00},
            {0.917559E-01, 0.886940E+00}, {0.900720E-01, 0.886158E+00},
            {0.877197E-01, 0.885061E+00}, {0.847041E-01, 0.883648E+00},
            {0.810316E-01, 0.881917E+00}, {0.767102E-01, 0.879865E+00},
            {0.717488E-01, 0.877490E+00}, {0.661580E-01, 0.874788E+00},
            {0.599494E-01, 0.871757E+00}, {0.531355E-01, 0.868393E+00},
            {0.457302E-01, 0.864693E+00}, {0.377481E-01, 0.860652E+00},
            {0.292050E-01, 0.856268E+00}, {0.201171E-01, 0.851537E+00},
            {0.105019E-01, 0.846456E+00}, {0.377057E-03, 0.841022E+00},
            {-.102388E-01, 0.835231E+00}, {-.213268E-01, 0.829082E+00},
            {-.328672E-01, 0.822572E+00}, {-.448402E-01, 0.815699E+00},
            {-.572256E-01, 0.808463E+00}, {-.700026E-01, 0.800861E+00},
            {-.831506E-01, 0.792895E+00}, {-.966484E-01, 0.784564E+00},
            {-.110475E+00, 0.775869E+00}, {-.124609E+00, 0.766811E+00},
            {-.139029E+00, 0.757393E+00}, {-.153714E+00, 0.747617E+00},
            {-.168642E+00, 0.737486E+00}, {-.183792E+00, 0.727005E+00},
            {-.199143E+00, 0.716177E+00}, {-.214673E+00, 0.705008E+00},
            {-.230362E+00, 0.693504E+00}, {-.246189E+00, 0.681672E+00},
            {-.262133E+00, 0.669518E+00}, {-.278174E+00, 0.657051E+00},
            {-.294290E+00, 0.644278E+00}, {-.310463E+00, 0.631209E+00},
            {-.326673E+00, 0.617854E+00}, {-.342900E+00, 0.604223E+00},
            {-.359124E+00, 0.590326E+00}, {-.375328E+00, 0.576175E+00},
            {-.391492E+00, 0.561783E+00}, {-.407598E+00, 0.547162E+00},
            {-.423629E+00, 0.532325E+00}, {-.439567E+00, 0.517285E+00},
            {-.455395E+00, 0.502057E+00}, {-.471097E+00, 0.486656E+00},
            {-.486656E+00, 0.471097E+00}, {-.502057E+00, 0.455395E+00},
            {-.517285E+00, 0.439567E+00}, {-.532325E+00, 0.423629E+00},
            {-.547162E+00, 0.407598E+00}, {-.561783E+00, 0.391492E+00},
            {-.576175E+00, 0.375328E+00}, {-.590326E+00, 0.359124E+00},
            {-.604223E+00, 0.342900E+00}, {-.617854E+00, 0.326673E+00},
            {-.631209E+00, 0.310463E+00}, {-.644278E+00, 0.294290E+00},
            {-.657051E+00, 0.278174E+00}, {-.669518E+00, 0.262133E+00},
            {-.681672E+00, 0.246189E+00}, {-.693504E+00, 0.230362E+00},
            {-.705008E+00, 0.214673E+00}, {-.716177E+00, 0.199143E+00},
            {-.727005E+00, 0.183792E+00}, {-.737486E+00, 0.168642E+00},
            {-.747617E+00, 0.153714E+00}, {-.757393E+00, 0.139029E+00},
            {-.766811E+00, 0.124609E+00}, {-.775869E+00, 0.110475E+00},
            {-.784564E+00, 0.966484E-01}, {-.792895E+00, 0.831506E-01},
            {-.800861E+00, 0.700026E-01}, {-.808463E+00, 0.572256E-01},
            {-.815699E+00, 0.448402E-01}, {-.822572E+00, 0.328672E-01},
            {-.829082E+00, 0.213268E-01}, {-.835231E+00, 0.102388E-01},
            {-.841022E+00, -.377057E-03}, {-.846456E+00, -.105019E-01},
            {-.851537E+00, -.201171E-01}, {-.856268E+00, -.292050E-01},
            {-.860652E+00, -.377481E-01}, {-.864693E+00, -.457302E-01},
            {-.868393E+00, -.531355E-01}, {-.871757E+00, -.599494E-01},
            {-.874788E+00, -.661580E-01}, {-.877490E+00, -.717488E-01},
            {-.879865E+00, -.767102E-01}, {-.881917E+00, -.810316E-01},
            {-.883648E+00, -.847041E-01}, {-.885061E+00, -.877197E-01},
            {-.886158E+00, -.900720E-01}, {-.886940E+00, -.917559E-01},
            {-.887409E+00, -.927677E-01}, {-.887565E+00, -.931052E-01},
        },
        {
            {0.112225E+00, 0.891596E+00}, {0.111878E+00, 0.891438E+00},
            {0.110838E+00, 0.890963E+00}, {0.109106E+00, 0.890171E+00},
            {0.106687E+00, 0.889059E+00}, {0.103585E+00, 0.887627E+00},
            {0.998088E-01, 0.885873E+00}, {0.953652E-01, 0.883792E+00},
            {0.902642E-01, 0.881384E+00}, {0.845165E-01, 0.878643E+00},
            {0.781341E-01, 0.875568E+00}, {0.711305E-01, 0.872153E+00},
            {0.635197E-01, 0.868396E+00}, {0.553172E-01, 0.864292E+00},
            {0.465393E-01, 0.859838E+00}, {0.372028E-01, 0.855030E+00},
            {0.273259E-01, 0.849863E+00}, {0.169268E-01, 0.844336E+00},
            {0.602490E-02, 0.838444E+00}, {-.536023E-02, 0.832185E+00},
            {-.172084E-01, 0.825556E+00}, {-.294990E-01, 0.818556E+00},
            {-.422112E-01, 0.811183E+00}, {-.553236E-01, 0.803436E+00},
            {-.688150E-01, 0.795315E+00}, {-.826635E-01, 0.786819E+00},
            {-.968476E-01, 0.777950E+00}, {-.111345E+00, 0.768709E+00},
            {-.126135E+00, 0.759097E+00}, {-.141194E+00, 0.749118E+00},
            {-.156501E+00, 0.738774E+00}, {-.172033E+00, 0.728070E+00},
            {-.187770E+00, 0.717011E+00}, {-.203690E+00, 0.705601E+00},
            {-.219771E+00, 0.693847E+00}, {-.235991E+00, 0.681755E+00},
            {-.252329E+00, 0.669332E+00}, {-.268766E+00, 0.656587E+00},
            {-.285278E+00, 0.643529E+00}, {-.301848E+00, 0.630166E+00},
            {-.318453E+00, 0.616508E+00}, {-.335074E+00, 0.602566E+00},
            {-.351692E+00, 0.588352E+00}, {-.368287E+00, 0.573876E+00},
            {-.384840E+00, 0.559152E+00}, {-.401333E+00, 0.544191E+00},
            {-.417747E+00, 0.529009E+00}, {-.434065E+00, 0.513618E+00},
            {-.450269E+00, 0.498033E+00}, {-.466343E+00, 0.482270E+00},
            {-.482270E+00, 0.466343E+00}, {-.498033E+00, 0.450269E+00},
            {-.513618E+00, 0.434065E+00}, {-.529009E+00, 0.417747E+00},
            {-.544191E+00, 0.401333E+00}, {-.559152E+00, 0.384840E+00},
            {-.573876E+00, 0.368287E+00}, {-.588352E+00, 0.351692E+00},
            {-.602566E+00, 0.335074E+00}, {-.616508E+00, 0.318453E+00},
            {-.630166E+00, 0.301848E+00}, {-.643529E+00, 0.285278E+00},
            {-.656587E+00, 0.268766E+00}, {-.669332E+00, 0.252329E+00},
            {-.681755E+00, 0.235991E+00}, {-.693847E+00, 0.219771E+00},
            {-.705601E+00, 0.203690E+00}, {-.717011E+00, 0.187770E+00},
            {-.728070E+00, 0.172033E+00}, {-.738774E+00, 0.156501E+00},
            {-.749118E+00, 0.141194E+00}, {-.759097E+00, 0.126135E+00},
            {-.768709E+00, 0.111345E+00}, {-.777950E+00, 0.968476E-01},
            {-.786819E+00, 0.826635E-01}, {-.795315E+00, 0.688150E-01},
            {-.803436E+00, 0.553236E-01}, {-.811183E+00, 0.422112E-01},
            {-.818556E+00, 0.294990E-01}, {-.825556E+00, 0.172084E-01},
            {-.832185E+00, 0.536023E-02}, {-.838444E+00, -.602490E-02},
            {-.844336E+00, -.169268E-01}, {-.849863E+00, -.273259E-01},
            {-.855030E+00, -.372028E-01}, {-.859838E+00, -.465393E-01},
            {-.864292E+00, -.553172E-01}, {-.868396E+00, -.635197E-01},
            {-.872153E+00, -.711305E-01}, {-.875568E+00, -.781341E-01},
            {-.878643E+00, -.845165E-01}, {-.881384E+00, -.902642E-01},
            {-.883792E+00, -.953652E-01}, {-.885873E+00, -.998088E-01},
            {-.887627E+00, -.103585E+00}, {-.889059E+00, -.106687E+00},
            {-.890171E+00, -.109106E+00}, {-.890963E+00, -.110838E+00},
            {-.891438E+00, -.111878E+00}, {-.891596E+00, -.112225E+00},
        },
        {
            {0.132037E+00, 0.895647E+00}, {0.131680E+00, 0.895487E+00},
            {0.130609E+00, 0.895006E+00}, {0.128828E+00, 0.894203E+00},
            {0.126339E+00, 0.893077E+00}, {0.123149E+00, 0.891626E+00},
            {0.119265E+00, 0.889848E+00}, {0.114695E+00, 0.887739E+00},
            {0.109449E+00, 0.885296E+00}, {0.103539E+00, 0.882516E+00},
            {0.969773E-01, 0.879396E+00}, {0.897774E-01, 0.875930E+00},
            {0.819543E-01, 0.872115E+00}, {0.735240E-01, 0.867946E+00},
            {0.645035E-01, 0.863420E+00}, {0.549104E-01, 0.858532E+00},
            {0.447632E-01, 0.853278E+00}, {0.340812E-01, 0.847655E+00},
            {0.228842E-01, 0.841659E+00}, {0.111926E-01, 0.835287E+00},
            {-.972810E-03, 0.828536E+00}, {-.135907E-01, 0.821405E+00},
            {-.266396E-01, 0.813891E+00}, {-.400976E-01, 0.805994E+00},
            {-.539426E-01, 0.797713E+00}, {-.681523E-01, 0.789047E+00},
            {-.827044E-01, 0.779998E+00}, {-.975764E-01, 0.770566E+00},
            {-.112746E+00, 0.760755E+00}, {-.128190E+00, 0.750566E+00},
            {-.143887E+00, 0.740002E+00}, {-.159813E+00, 0.729068E+00},
            {-.175948E+00, 0.717769E+00}, {-.192268E+00, 0.706110E+00},
            {-.208751E+00, 0.694096E+00}, {-.225376E+00, 0.681736E+00},
            {-.242120E+00, 0.669036E+00}, {-.258963E+00, 0.656004E+00},
            {-.275884E+00, 0.642650E+00}, {-.292860E+00, 0.628983E+00},
            {-.309873E+00, 0.615013E+00}, {-.326900E+00, 0.600751E+00},
            {-.343922E+00, 0.586208E+00}, {-.360920E+00, 0.571397E+00},
            {-.377874E+00, 0.556330E+00}, {-.394765E+00, 0.541020E+00},
            {-.411574E+00, 0.525481E+00}, {-.428284E+00, 0.509728E+00},
            {-.444876E+00, 0.493775E+00}, {-.461333E+00, 0.477638E+00},
            {-.477638E+00, 0.461333E+00}, {-.493775E+00, 0.444876E+00},
            {-.509728E+00, 0.428284E+00}, {-.525481E+00, 0.411574E+00},
            {-.541020E+00, 0.394765E+00}, {-.556330E+00, 0.377874E+00},
            {-.571397E+00, 0.360920E+00}, {-.586208E+00, 0.343922E+00},
            {-.600751E+00, 0.326900E+00}, {-.615013E+00, 0.309873E+00},
            {-.628983E+00, 0.292860E+00}, {-.642650E+00, 0.275884E+00},
            {-.656004E+00, 0.258963E+00}, {-.669036E+00, 0.242120E+00},
            {-.681736E+00, 0.225376E+00}, {-.694096E+00, 0.208751E+00},
            {-.706110E+00, 0.192268E+00}, {-.717769E+00, 0.175948E+00},
            {-.729068E+00, 0.159813E+00}, {-.740002E+00, 0.143887E+00},
            {-.750566E+00, 0.128190E+00}, {-.760755E+00, 0.112746E+00},
            {-.770566E+00, 0.975764E-01}, {-.779998E+00, 0.827044E-01},
            {-.789047E+00, 0.681523E-01}, {-.797713E+00, 0.539426E-01},
            {-.805994E+00, 0.400976E-01}, {-.813891E+00, 0.266396E-01},
            {-.821405E+00, 0.135907E-01}, {-.828536E+00, 0.972810E-03},
            {-.835287E+00, -.111926E-01}, {-.841659E+00, -.228842E-01},
            {-.847655E+00, -.340812E-01}, {-.853278E+00, -.447632E-01},
            {-.858532E+00, -.549104E-01}, {-.863420E+00, -.645035E-01},
            {-.867946E+00, -.735240E-01}, {-.872115E+00, -.819543E-01},
            {-.875930E+00, -.897774E-01}, {-.879396E+00, -.969773E-01},
            {-.882516E+00, -.103539E+00}, {-.885296E+00, -.109449E+00},
            {-.887739E+00, -.114695E+00}, {-.889848E+00, -.119265E+00},
            {-.891626E+00, -.123149E+00}, {-.893077E+00, -.126339E+00},
            {-.894203E+00, -.128828E+00}, {-.895006E+00, -.130609E+00},
            {-.895487E+00, -.131680E+00}, {-.895647E+00, -.132037E+00},
        },
        {
            {0.152585E+00, 0.899719E+00}, {0.152218E+00, 0.899557E+00},
            {0.151116E+00, 0.899070E+00}, {0.149283E+00, 0.898256E+00},
            {0.146723E+00, 0.897116E+00}, {0.143441E+00, 0.895645E+00},
            {0.139445E+00, 0.893843E+00}, {0.134744E+00, 0.891705E+00},
            {0.129349E+00, 0.889228E+00}, {0.123271E+00, 0.886408E+00},
            {0.116523E+00, 0.883241E+00}, {0.109120E+00, 0.879723E+00},
            {0.101077E+00, 0.875849E+00}, {0.924110E-01, 0.871614E+00},
            {0.831396E-01, 0.867014E+00}, {0.732812E-01, 0.862044E+00},
            {0.628550E-01, 0.856701E+00}, {0.518808E-01, 0.850979E+00},
            {0.403792E-01, 0.844876E+00}, {0.283714E-01, 0.838387E+00},
            {0.158787E-01, 0.831511E+00}, {0.292324E-02, 0.824244E+00},
            {-.104728E-01, 0.816585E+00}, {-.242869E-01, 0.808532E+00},
            {-.384963E-01, 0.800085E+00}, {-.530781E-01, 0.791243E+00},
            {-.680092E-01, 0.782008E+00}, {-.832667E-01, 0.772380E+00},
            {-.988275E-01, 0.762361E+00}, {-.114668E+00, 0.751954E+00},
            {-.130766E+00, 0.741163E+00}, {-.147098E+00, 0.729991E+00},
            {-.163641E+00, 0.718443E+00}, {-.180373E+00, 0.706526E+00},
            {-.197271E+00, 0.694244E+00}, {-.214312E+00, 0.681606E+00},
            {-.231475E+00, 0.668618E+00}, {-.248737E+00, 0.655290E+00},
            {-.266077E+00, 0.641630E+00}, {-.283473E+00, 0.627648E+00},
            {-.300904E+00, 0.613355E+00}, {-.318350E+00, 0.598762E+00},
            {-.335789E+00, 0.583880E+00}, {-.353202E+00, 0.568721E+00},
            {-.370569E+00, 0.553300E+00}, {-.387870E+00, 0.537629E+00},
            {-.405087E+00, 0.521722E+00}, {-.422200E+00, 0.505595E+00},
            {-.439192E+00, 0.489262E+00}, {-.456044E+00, 0.472740E+00},
            {-.472740E+00, 0.456044E+00}, {-.489262E+00, 0.439192E+00},
            {-.505595E+00, 0.422200E+00}, {-.521722E+00, 0.405087E+00},
            {-.537629E+00, 0.387870E+00}, {-.553300E+00, 0.370569E+00},
            {-.568721E+00, 0.353202E+00}, {-.583880E+00, 0.335789E+00},
            {-.598762E+00, 0.318350E+00}, {-.613355E+00, 0.300904E+00},
            {-.627648E+00, 0.283473E+00}, {-.641630E+00, 0.266077E+00},
            {-.655290E+00, 0.248737E+00}, {-.668618E+00, 0.231475E+00},
            {-.681606E+00, 0.214312E+00}, {-.694244E+00, 0.197271E+00},
            {-.706526E+00, 0.180373E+00}, {-.718443E+00, 0.163641E+00},
            {-.729991E+00, 0.147098E+00}, {-.741163E+00, 0.130766E+00},
            {-.751954E+00, 0.114668E+00}, {-.762361E+00, 0.988275E-01},
            {-.772380E+00, 0.832667E-01}, {-.782008E+00, 0.680092E-01},
            {-.791243E+00, 0.530781E-01}, {-.800085E+00, 0.384963E-01},
            {-.808532E+00, 0.242869E-01}, {-.816585E+00, 0.104728E-01},
            {-.824244E+00, -.292324E-02}, {-.831511E+00, -.158787E-01},
            {-.838387E+00, -.283714E-01}, {-.844876E+00, -.403792E-01},
            {-.850979E+00, -.518808E-01}, {-.856701E+00, -.628550E-01},
            {-.862044E+00, -.732812E-01}, {-.867014E+00, -.831396E-01},
            {-.871614E+00, -.924110E-01}, {-.875849E+00, -.101077E+00},
            {-.879723E+00, -.109120E+00}, {-.883241E+00, -.116523E+00},
            {-.886408E+00, -.123271E+00}, {-.889228E+00, -.129349E+00},
            {-.891705E+00, -.134744E+00}, {-.893843E+00, -.139445E+00},
            {-.895645E+00, -.143441E+00}, {-.897116E+00, -.146723E+00},
            {-.898256E+00, -.149283E+00}, {-.899070E+00, -.151116E+00},
            {-.899557E+00, -.152218E+00}, {-.899719E+00, -.152585E+00},
        },
        {
            {0.173921E+00, 0.903814E+00}, {0.173543E+00, 0.903650E+00},
            {0.172409E+00, 0.903156E+00}, {0.170522E+00, 0.902332E+00},
            {0.167888E+00, 0.901177E+00}, {0.164510E+00, 0.899687E+00},
            {0.160399E+00, 0.897860E+00}, {0.155562E+00, 0.895693E+00},
            {0.150011E+00, 0.893181E+00}, {0.143758E+00, 0.890320E+00},
            {0.136818E+00, 0.887107E+00}, {0.129204E+00, 0.883535E+00},
            {0.120934E+00, 0.879600E+00}, {0.112025E+00, 0.875297E+00},
            {0.102494E+00, 0.870621E+00}, {0.923611E-01, 0.865568E+00},
            {0.816463E-01, 0.860131E+00}, {0.703703E-01, 0.854308E+00},
            {0.585541E-01, 0.848094E+00}, {0.462197E-01, 0.841485E+00},
            {0.333893E-01, 0.834478E+00}, {0.200856E-01, 0.827071E+00},
            {0.633144E-02, 0.819261E+00}, {-.784986E-02, 0.811047E+00},
            {-.224349E-01, 0.802428E+00}, {-.374002E-01, 0.793404E+00},
            {-.527220E-01, 0.783975E+00}, {-.683767E-01, 0.774143E+00},
            {-.843406E-01, 0.763909E+00}, {-.100590E+00, 0.753277E+00},
            {-.117101E+00, 0.742249E+00}, {-.133851E+00, 0.730830E+00},
            {-.150815E+00, 0.719024E+00}, {-.167971E+00, 0.706839E+00},
            {-.185296E+00, 0.694279E+00}, {-.202766E+00, 0.681352E+00},
            {-.220359E+00, 0.668066E+00}, {-.238053E+00, 0.654431E+00},
            {-.255825E+00, 0.640454E+00}, {-.273654E+00, 0.626146E+00},
            {-.291517E+00, 0.611518E+00}, {-.309393E+00, 0.596582E+00},
            {-.327263E+00, 0.581348E+00}, {-.345104E+00, 0.565831E+00},
            {-.362896E+00, 0.550043E+00}, {-.380621E+00, 0.533998E+00},
            {-.398257E+00, 0.517711E+00}, {-.415787E+00, 0.501197E+00},
            {-.433191E+00, 0.484472E+00}, {-.450452E+00, 0.467551E+00},
            {-.467551E+00, 0.450452E+00}, {-.484472E+00, 0.433191E+00},
            {-.501197E+00, 0.415787E+00}, {-.517711E+00, 0.398257E+00},
            {-.533998E+00, 0.380621E+00}, {-.550043E+00, 0.362896E+00},
            {-.565831E+00, 0.345104E+00}, {-.581348E+00, 0.327263E+00},
            {-.596582E+00, 0.309393E+00}, {-.611518E+00, 0.291517E+00},
            {-.626146E+00, 0.273654E+00}, {-.640454E+00, 0.255825E+00},
            {-.654431E+00, 0.238053E+00}, {-.668066E+00, 0.220359E+00},
            {-.681352E+00, 0.202766E+00}, {-.694279E+00, 0.185296E+00},
            {-.706839E+00, 0.167971E+00}, {-.719024E+00, 0.150815E+00},
            {-.730830E+00, 0.133851E+00}, {-.742249E+00, 0.117101E+00},
            {-.753277E+00, 0.100590E+00}, {-.763909E+00, 0.843406E-01},
            {-.774143E+00, 0.683767E-01}, {-.783975E+00, 0.527220E-01},
            {-.793404E+00, 0.374002E-01}, {-.802428E+00, 0.224349E-01},
            {-.811047E+00, 0.784986E-02}, {-.819261E+00, -.633144E-02},
            {-.827071E+00, -.200856E-01}, {-.834478E+00, -.333893E-01},
            {-.841485E+00, -.462197E-01}, {-.848094E+00, -.585541E-01},
            {-.854308E+00, -.703703E-01}, {-.860131E+00, -.816463E-01},
            {-.865568E+00, -.923611E-01}, {-.870621E+00, -.102494E+00},
            {-.875297E+00, -.112025E+00}, {-.879600E+00, -.120934E+00},
            {-.883535E+00, -.129204E+00}, {-.887107E+00, -.136818E+00},
            {-.890320E+00, -.143758E+00}, {-.893181E+00, -.150011E+00},
            {-.895693E+00, -.155562E+00}, {-.897860E+00, -.160399E+00},
            {-.899687E+00, -.164510E+00}, {-.901177E+00, -.167888E+00},
            {-.902332E+00, -.170522E+00}, {-.903156E+00, -.172409E+00},
            {-.903650E+00, -.173543E+00}, {-.903814E+00, -.173921E+00},
        },
        {
            {0.196099E+00, 0.907933E+00}, {0.195709E+00, 0.907767E+00},
            {0.194542E+00, 0.907267E+00}, {0.192600E+00, 0.906432E+00},
            {0.189888E+00, 0.905262E+00}, {0.186411E+00, 0.903752E+00},
            {0.182179E+00, 0.901901E+00}, {0.177202E+00, 0.899704E+00},
            {0.171489E+00, 0.897156E+00}, {0.165056E+00, 0.894255E+00},
            {0.157916E+00, 0.890993E+00}, {0.150084E+00, 0.887366E+00},
            {0.141578E+00, 0.883369E+00}, {0.132416E+00, 0.878997E+00},
            {0.122617E+00, 0.874243E+00}, {0.112200E+00, 0.869102E+00},
            {0.101187E+00, 0.863570E+00}, {0.895986E-01, 0.857642E+00},
            {0.774573E-01, 0.851313E+00}, {0.647856E-01, 0.844579E+00},
            {0.516064E-01, 0.837437E+00}, {0.379431E-01, 0.829884E+00},
            {0.238194E-01, 0.821918E+00}, {0.925929E-02, 0.813536E+00},
            {-.571325E-02, 0.804738E+00}, {-.210740E-01, 0.795524E+00},
            {-.367986E-01, 0.785894E+00}, {-.528627E-01, 0.775850E+00},
            {-.692421E-01, 0.765392E+00}, {-.859125E-01, 0.754525E+00},
            {-.102850E+00, 0.743251E+00}, {-.120029E+00, 0.731575E+00},
            {-.137428E+00, 0.719501E+00}, {-.155021E+00, 0.707037E+00},
            {-.172786E+00, 0.694188E+00}, {-.190698E+00, 0.680962E+00},
            {-.208735E+00, 0.667366E+00}, {-.226874E+00, 0.653411E+00},
            {-.245091E+00, 0.639105E+00}, {-.263366E+00, 0.624459E+00},
            {-.281674E+00, 0.609484E+00}, {-.299996E+00, 0.594191E+00},
            {-.318308E+00, 0.578594E+00}, {-.336591E+00, 0.562704E+00},
            {-.354823E+00, 0.546537E+00}, {-.372985E+00, 0.530105E+00},
            {-.391055E+00, 0.513424E+00}, {-.409015E+00, 0.496510E+00},
            {-.426846E+00, 0.479378E+00}, {-.444529E+00, 0.462045E+00},
            {-.462045E+00, 0.444529E+00}, {-.479378E+00, 0.426846E+00},
            {-.496510E+00, 0.409015E+00}, {-.513424E+00, 0.391055E+00},
            {-.530105E+00, 0.372985E+00}, {-.546537E+00, 0.354823E+00},
            {-.562704E+00, 0.336591E+00}, {-.578594E+00, 0.318308E+00},
            {-.594191E+00, 0.299996E+00}, {-.609484E+00, 0.281674E+00},
            {-.624459E+00, 0.263366E+00}, {-.639105E+00, 0.245091E+00},
            {-.653411E+00, 0.226874E+00}, {-.667366E+00, 0.208735E+00},
            {-.680962E+00, 0.190698E+00}, {-.694188E+00, 0.172786E+00},
            {-.707037E+00, 0.155021E+00}, {-.719501E+00, 0.137428E+00},
            {-.731575E+00, 0.120029E+00}, {-.743251E+00, 0.102850E+00},
            {-.754525E+00, 0.859125E-01}, {-.765392E+00, 0.692421E-01},
            {-.775850E+00, 0.528627E-01}, {-.785894E+00, 0.367986E-01},
            {-.795524E+00, 0.210740E-01}, {-.804738E+00, 0.571325E-02},
            {-.813536E+00, -.925929E-02}, {-.821918E+00, -.238194E-01},
            {-.829884E+00, -.379431E-01}, {-.837437E+00, -.516064E-01},
            {-.844579E+00, -.647856E-01}, {-.851313E+00, -.774573E-01},
            {-.857642E+00, -.895986E-01}, {-.863570E+00, -.101187E+00},
            {-.869102E+00, -.112200E+00}, {-.874243E+00, -.122617E+00},
            {-.878997E+00, -.132416E+00}, {-.883369E+00, -.141578E+00},
            {-.887366E+00, -.150084E+00}, {-.890993E+00, -.157916E+00},
            {-.894255E+00, -.165056E+00}, {-.897156E+00, -.171489E+00},
            {-.899704E+00, -.177202E+00}, {-.901901E+00, -.182179E+00},
            {-.903752E+00, -.186411E+00}, {-.905262E+00, -.189888E+00},
            {-.906432E+00, -.192600E+00}, {-.907267E+00, -.194542E+00},
            {-.907767E+00, -.195709E+00}, {-.907933E+00, -.196099E+00},
        },
        {
            {0.219179E+00, 0.912079E+00}, {0.218778E+00, 0.911910E+00},
            {0.217576E+00, 0.911404E+00}, {0.215576E+00, 0.910559E+00},
            {0.212783E+00, 0.909373E+00}, {0.209204E+00, 0.907844E+00},
            {0.204847E+00, 0.905968E+00}, {0.199722E+00, 0.903740E+00},
            {0.193843E+00, 0.901157E+00}, {0.187222E+00, 0.898212E+00},
            {0.179874E+00, 0.894902E+00}, {0.171816E+00, 0.891219E+00},
            {0.163065E+00, 0.887158E+00}, {0.153642E+00, 0.882713E+00},
            {0.143564E+00, 0.877879E+00}, {0.132853E+00, 0.872649E+00},
            {0.121531E+00, 0.867017E+00}, {0.109620E+00, 0.860980E+00},
            {0.971428E-01, 0.854532E+00}, {0.841224E-01, 0.847668E+00},
            {0.705828E-01, 0.840385E+00}, {0.565482E-01, 0.832680E+00},
            {0.420429E-01, 0.824551E+00}, {0.270917E-01, 0.815994E+00},
            {0.117193E-01, 0.807010E+00}, {-.404941E-02, 0.797598E+00},
            {-.201895E-01, 0.787758E+00}, {-.366759E-01, 0.777492E+00},
            {-.534838E-01, 0.766801E+00}, {-.705883E-01, 0.755689E+00},
            {-.879645E-01, 0.744158E+00}, {-.105588E+00, 0.732214E+00},
            {-.123434E+00, 0.719862E+00}, {-.141478E+00, 0.707107E+00},
            {-.159696E+00, 0.693956E+00}, {-.178064E+00, 0.680418E+00},
            {-.196559E+00, 0.666501E+00}, {-.215157E+00, 0.652213E+00},
            {-.233834E+00, 0.637565E+00}, {-.252569E+00, 0.622567E+00},
            {-.271337E+00, 0.607231E+00}, {-.290118E+00, 0.591568E+00},
            {-.308888E+00, 0.575592E+00}, {-.327627E+00, 0.559317E+00},
            {-.346314E+00, 0.542755E+00}, {-.364927E+00, 0.525922E+00},
            {-.383446E+00, 0.508832E+00}, {-.401851E+00, 0.491503E+00},
            {-.420123E+00, 0.473950E+00}, {-.438242E+00, 0.456191E+00},
            {-.456191E+00, 0.438242E+00}, {-.473950E+00, 0.420123E+00},
            {-.491503E+00, 0.401851E+00}, {-.508832E+00, 0.383446E+00},
            {-.525922E+00, 0.364927E+00}, {-.542755E+00, 0.346314E+00},
            {-.559317E+00, 0.327627E+00}, {-.575592E+00, 0.308888E+00},
            {-.591568E+00, 0.290118E+00}, {-.607231E+00, 0.271337E+00},
            {-.622567E+00, 0.252569E+00}, {-.637565E+00, 0.233834E+00},
            {-.652213E+00, 0.215157E+00}, {-.666501E+00, 0.196559E+00},
            {-.680418E+00, 0.178064E+00}, {-.693956E+00, 0.159696E+00},
            {-.707107E+00, 0.141478E+00}, {-.719862E+00, 0.123434E+00},
            {-.732214E+00, 0.105588E+00}, {-.744158E+00, 0.879645E-01},
            {-.755689E+00, 0.705883E-01}, {-.766801E+00, 0.534838E-01},
            {-.777492E+00, 0.366759E-01}, {-.787758E+00, 0.201895E-01},
            {-.797598E+00, 0.404941E-02}, {-.807010E+00, -.117193E-01},
            {-.815994E+00, -.270917E-01}, {-.824551E+00, -.420429E-01},
            {-.832680E+00, -.565482E-01}, {-.840385E+00, -.705828E-01},
            {-.847668E+00, -.841224E-01}, {-.854532E+00, -.971428E-01},
            {-.860980E+00, -.109620E+00}, {-.867017E+00, -.121531E+00},
            {-.872649E+00, -.132853E+00}, {-.877879E+00, -.143564E+00},
            {-.882713E+00, -.153642E+00}, {-.887158E+00, -.163065E+00},
            {-.891219E+00, -.171816E+00}, {-.894902E+00, -.179874E+00},
            {-.898212E+00, -.187222E+00}, {-.901157E+00, -.193843E+00},
            {-.903740E+00, -.199722E+00}, {-.905968E+00, -.204847E+00},
            {-.907844E+00, -.209204E+00}, {-.909373E+00, -.212783E+00},
            {-.910559E+00, -.215576E+00}, {-.911404E+00, -.217576E+00},
            {-.911910E+00, -.218778E+00}, {-.912079E+00, -.219179E+00},
        },
        {
            {0.243229E+00, 0.916253E+00}, {0.242816E+00, 0.916082E+00},
            {0.241578E+00, 0.915570E+00}, {0.239518E+00, 0.914714E+00},
            {0.236641E+00, 0.913513E+00}, {0.232954E+00, 0.911963E+00},
            {0.228467E+00, 0.910062E+00}, {0.223190E+00, 0.907803E+00},
            {0.217136E+00, 0.905183E+00}, {0.210320E+00, 0.902195E+00},
            {0.202756E+00, 0.898834E+00}, {0.194463E+00, 0.895093E+00},
            {0.185459E+00, 0.890967E+00}, {0.175764E+00, 0.886447E+00},
            {0.165398E+00, 0.881529E+00}, {0.154383E+00, 0.876206E+00},
            {0.142741E+00, 0.870472E+00}, {0.130495E+00, 0.864321E+00},
            {0.117670E+00, 0.857748E+00}, {0.104289E+00, 0.850749E+00},
            {0.903768E-01, 0.843320E+00}, {0.759584E-01, 0.835456E+00},
            {0.610591E-01, 0.827156E+00}, {0.457040E-01, 0.818417E+00},
            {0.299188E-01, 0.809238E+00}, {0.137290E-01, 0.799618E+00},
            {-.283982E-02, 0.789559E+00}, {-.197620E-01, 0.779061E+00},
            {-.370119E-01, 0.768126E+00}, {-.545642E-01, 0.756758E+00},
            {-.723935E-01, 0.744959E+00}, {-.904744E-01, 0.732735E+00},
            {-.108782E+00, 0.720090E+00}, {-.127291E+00, 0.707032E+00},
            {-.145978E+00, 0.693567E+00}, {-.164816E+00, 0.679704E+00},
            {-.183783E+00, 0.665450E+00}, {-.202855E+00, 0.650815E+00},
            {-.222007E+00, 0.635810E+00}, {-.241216E+00, 0.620446E+00},
            {-.260460E+00, 0.604734E+00}, {-.279715E+00, 0.588687E+00},
            {-.298959E+00, 0.572317E+00}, {-.318170E+00, 0.555639E+00},
            {-.337326E+00, 0.538668E+00}, {-.356406E+00, 0.521418E+00},
            {-.375390E+00, 0.503904E+00}, {-.394256E+00, 0.486145E+00},
            {-.412985E+00, 0.468155E+00}, {-.431557E+00, 0.449953E+00},
            {-.449953E+00, 0.431557E+00}, {-.468155E+00, 0.412985E+00},
            {-.486145E+00, 0.394256E+00}, {-.503904E+00, 0.375390E+00},
            {-.521418E+00, 0.356406E+00}, {-.538668E+00, 0.337326E+00},
            {-.555639E+00, 0.318170E+00}, {-.572317E+00, 0.298959E+00},
            {-.588687E+00, 0.279715E+00}, {-.604734E+00, 0.260460E+00},
            {-.620446E+00, 0.241216E+00}, {-.635810E+00, 0.222007E+00},
            {-.650815E+00, 0.202855E+00}, {-.665450E+00, 0.183783E+00},
            {-.679704E+00, 0.164816E+00}, {-.693567E+00, 0.145978E+00},
            {-.707032E+00, 0.127291E+00}, {-.720090E+00, 0.108782E+00},
            {-.732735E+00, 0.904744E-01}, {-.744959E+00, 0.723935E-01},
            {-.756758E+00, 0.545642E-01}, {-.768126E+00, 0.370119E-01},
            {-.779061E+00, 0.197620E-01}, {-.789559E+00, 0.283982E-02},
            {-.799618E+00, -.137290E-01}, {-.809238E+00, -.299188E-01},
            {-.818417E+00, -.457040E-01}, {-.827156E+00, -.610591E-01},
            {-.835456E+00, -.759584E-01}, {-.843320E+00, -.903768E-01},
            {-.850749E+00, -.104289E+00}, {-.857748E+00, -.117670E+00},
            {-.864321E+00, -.130495E+00}, {-.870472E+00, -.142741E+00},
            {-.876206E+00, -.154383E+00}, {-.881529E+00, -.165398E+00},
            {-.886447E+00, -.175764E+00}, {-.890967E+00, -.185459E+00},
            {-.895093E+00, -.194463E+00}, {-.898834E+00, -.202756E+00},
            {-.902195E+00, -.210320E+00}, {-.905183E+00, -.217136E+00},
            {-.907803E+00, -.223190E+00}, {-.910062E+00, -.228467E+00},
            {-.911963E+00, -.232954E+00}, {-.913513E+00, -.236641E+00},
            {-.914714E+00, -.239518E+00}, {-.915570E+00, -.241578E+00},
            {-.916082E+00, -.242816E+00}, {-.916253E+00, -.243229E+00},
        },
        {
            {0.268323E+00, 0.920458E+00}, {0.267897E+00, 0.920285E+00},
            {0.266621E+00, 0.919766E+00}, {0.264498E+00, 0.918899E+00},
            {0.261534E+00, 0.917683E+00}, {0.257735E+00, 0.916113E+00},
            {0.253112E+00, 0.914185E+00}, {0.247676E+00, 0.911895E+00},
            {0.241441E+00, 0.909237E+00}, {0.234421E+00, 0.906205E+00},
            {0.226634E+00, 0.902792E+00}, {0.218097E+00, 0.898992E+00},
            {0.208829E+00, 0.894797E+00}, {0.198852E+00, 0.890200E+00},
            {0.188186E+00, 0.885195E+00}, {0.176855E+00, 0.879775E+00},
            {0.164882E+00, 0.873933E+00}, {0.152290E+00, 0.867663E+00},
            {0.139105E+00, 0.860961E+00}, {0.125351E+00, 0.853820E+00},
            {0.111053E+00, 0.846236E+00}, {0.962384E-01, 0.838206E+00},
            {0.809318E-01, 0.829727E+00}, {0.651596E-01, 0.820796E+00},
            {0.489480E-01, 0.811413E+00}, {0.323234E-01, 0.801576E+00},
            {0.153121E-01, 0.791287E+00}, {-.205984E-02, 0.780545E+00},
            {-.197661E-01, 0.769355E+00}, {-.377805E-01, 0.757717E+00},
            {-.560772E-01, 0.745638E+00}, {-.746304E-01, 0.733120E+00},
            {-.934144E-01, 0.720170E+00}, {-.112404E+00, 0.706794E+00},
            {-.131573E+00, 0.693000E+00}, {-.150898E+00, 0.678796E+00},
            {-.170353E+00, 0.664190E+00}, {-.189914E+00, 0.649193E+00},
            {-.209556E+00, 0.633816E+00}, {-.229257E+00, 0.618069E+00},
            {-.248991E+00, 0.601965E+00}, {-.268737E+00, 0.585516E+00},
            {-.288471E+00, 0.568736E+00}, {-.308170E+00, 0.551640E+00},
            {-.327812E+00, 0.534242E+00}, {-.347377E+00, 0.516558E+00},
            {-.366841E+00, 0.498603E+00}, {-.386185E+00, 0.480396E+00},
            {-.405388E+00, 0.461952E+00}, {-.424429E+00, 0.443290E+00},
            {-.443290E+00, 0.424429E+00}, {-.461952E+00, 0.405388E+00},
            {-.480396E+00, 0.386185E+00}, {-.498603E+00, 0.366841E+00},
            {-.516558E+00, 0.347377E+00}, {-.534242E+00, 0.327812E+00},
            {-.551640E+00, 0.308170E+00}, {-.568736E+00, 0.288471E+00},
            {-.585516E+00, 0.268737E+00}, {-.601965E+00, 0.248991E+00},
            {-.618069E+00, 0.229257E+00}, {-.633816E+00, 0.209556E+00},
            {-.649193E+00, 0.189914E+00}, {-.664190E+00, 0.170353E+00},
            {-.678796E+00, 0.150898E+00}, {-.693000E+00, 0.131573E+00},
            {-.706794E+00, 0.112404E+00}, {-.720170E+00, 0.934144E-01},
            {-.733120E+00, 0.746304E-01}, {-.745638E+00, 0.560772E-01},
            {-.757717E+00, 0.377805E-01}, {-.769355E+00, 0.197661E-01},
            {-.780545E+00, 0.205984E-02}, {-.791287E+00, -.153121E-01},
            {-.801576E+00, -.323234E-01}, {-.811413E+00, -.489480E-01},
            {-.820796E+00, -.651596E-01}, {-.829727E+00, -.809318E-01},
            {-.838206E+00, -.962384E-01}, {-.846236E+00, -.111053E+00},
            {-.853820E+00, -.125351E+00}, {-.860961E+00, -.139105E+00},
            {-.867663E+00, -.152290E+00}, {-.873933E+00, -.164882E+00},
            {-.879775E+00, -.176855E+00}, {-.885195E+00, -.188186E+00},
            {-.890200E+00, -.198852E+00}, {-.894797E+00, -.208829E+00},
            {-.898992E+00, -.218097E+00}, {-.902792E+00, -.226634E+00},
            {-.906205E+00, -.234421E+00}, {-.909237E+00, -.241441E+00},
            {-.911895E+00, -.247676E+00}, {-.914185E+00, -.253112E+00},
            {-.916113E+00, -.257735E+00}, {-.917683E+00, -.261534E+00},
            {-.918899E+00, -.264498E+00}, {-.919766E+00, -.266621E+00},
            {-.920285E+00, -.267897E+00}, {-.920458E+00, -.268323E+00},
        },
        {
            {0.294542E+00, 0.924695E+00}, {0.294103E+00, 0.924520E+00},
            {0.292788E+00, 0.923995E+00}, {0.290599E+00, 0.923118E+00},
            {0.287543E+00, 0.921885E+00}, {0.283628E+00, 0.920295E+00},
            {0.278863E+00, 0.918341E+00}, {0.273262E+00, 0.916019E+00},
            {0.266838E+00, 0.913322E+00}, {0.259606E+00, 0.910244E+00},
            {0.251585E+00, 0.906777E+00}, {0.242794E+00, 0.902915E+00},
            {0.233252E+00, 0.898649E+00}, {0.222982E+00, 0.893972E+00},
            {0.212006E+00, 0.888876E+00}, {0.200348E+00, 0.883354E+00},
            {0.188031E+00, 0.877400E+00}, {0.175080E+00, 0.871006E+00},
            {0.161522E+00, 0.864166E+00}, {0.147382E+00, 0.856876E+00},
            {0.132686E+00, 0.849130E+00}, {0.117460E+00, 0.840925E+00},
            {0.101733E+00, 0.832257E+00}, {0.855296E-01, 0.823125E+00},
            {0.688776E-01, 0.813526E+00}, {0.518040E-01, 0.803461E+00},
            {0.343356E-01, 0.792929E+00}, {0.164994E-01, 0.781931E+00},
            {-.167782E-02, 0.770471E+00}, {-.201694E-01, 0.758552E+00},
            {-.389487E-01, 0.746176E+00}, {-.579895E-01, 0.733350E+00},
            {-.772654E-01, 0.720079E+00}, {-.967506E-01, 0.706369E+00},
            {-.116419E+00, 0.692230E+00}, {-.136246E+00, 0.677668E+00},
            {-.156205E+00, 0.662694E+00}, {-.176272E+00, 0.647318E+00},
            {-.196421E+00, 0.631550E+00}, {-.216630E+00, 0.615403E+00},
            {-.236872E+00, 0.598889E+00}, {-.257126E+00, 0.582021E+00},
            {-.277366E+00, 0.564813E+00}, {-.297571E+00, 0.547279E+00},
            {-.317718E+00, 0.529437E+00}, {-.337784E+00, 0.511300E+00},
            {-.357748E+00, 0.492886E+00}, {-.377587E+00, 0.474212E+00},
            {-.397282E+00, 0.455296E+00}, {-.416812E+00, 0.436156E+00},
            {-.436156E+00, 0.416812E+00}, {-.455296E+00, 0.397282E+00},
            {-.474212E+00, 0.377587E+00}, {-.492886E+00, 0.357748E+00},
            {-.511300E+00, 0.337784E+00}, {-.529437E+00, 0.317718E+00},
            {-.547279E+00, 0.297571E+00}, {-.564813E+00, 0.277366E+00},
            {-.582021E+00, 0.257126E+00}, {-.598889E+00, 0.236872E+00},
            {-.615403E+00, 0.216630E+00}, {-.631550E+00, 0.196421E+00},
            {-.647318E+00, 0.176272E+00}, {-.662694E+00, 0.156205E+00},
            {-.677668E+00, 0.136246E+00}, {-.692230E+00, 0.116419E+00},
            {-.706369E+00, 0.967506E-01}, {-.720079E+00, 0.772654E-01},
            {-.733350E+00, 0.579895E-01}, {-.746176E+00, 0.389487E-01},
            {-.758552E+00, 0.201694E-01}, {-.770471E+00, 0.167782E-02},
            {-.781931E+00, -.164994E-01}, {-.792929E+00, -.343356E-01},
            {-.803461E+00, -.518040E-01}, {-.813526E+00, -.688776E-01},
            {-.823125E+00, -.855296E-01}, {-.832257E+00, -.101733E+00},
            {-.840925E+00, -.117460E+00}, {-.849130E+00, -.132686E+00},
            {-.856876E+00, -.147382E+00}, {-.864166E+00, -.161522E+00},
            {-.871006E+00, -.175080E+00}, {-.877400E+00, -.188031E+00},
            {-.883354E+00, -.200348E+00}, {-.888876E+00, -.212006E+00},
            {-.893972E+00, -.222982E+00}, {-.898649E+00, -.233252E+00},
            {-.902915E+00, -.242794E+00}, {-.906777E+00, -.251585E+00},
            {-.910244E+00, -.259606E+00}, {-.913322E+00, -.266838E+00},
            {-.916019E+00, -.273262E+00}, {-.918341E+00, -.278863E+00},
            {-.920295E+00, -.283628E+00}, {-.921885E+00, -.287543E+00},
            {-.923118E+00, -.290599E+00}, {-.923995E+00, -.292788E+00},
            {-.924520E+00, -.294103E+00}, {-.924695E+00, -.294542E+00},
        },
        {
            {0.321979E+00, 0.928969E+00}, {0.321526E+00, 0.928792E+00},
            {0.320169E+00, 0.928260E+00}, {0.317912E+00, 0.927371E+00},
            {0.314760E+00, 0.926123E+00}, {0.310723E+00, 0.924512E+00},
            {0.305811E+00, 0.922531E+00}, {0.300036E+00, 0.920176E+00},
            {0.293414E+00, 0.917439E+00}, {0.285962E+00, 0.914313E+00},
            {0.277698E+00, 0.910791E+00}, {0.268643E+00, 0.906864E+00},
            {0.258816E+00, 0.902524E+00}, {0.248242E+00, 0.897762E+00},
            {0.236943E+00, 0.892571E+00}, {0.224944E+00, 0.886943E+00},
            {0.212270E+00, 0.880870E+00}, {0.198948E+00, 0.874344E+00},
            {0.185004E+00, 0.867361E+00}, {0.170464E+00, 0.859913E+00},
            {0.155355E+00, 0.851996E+00}, {0.139706E+00, 0.843605E+00},
            {0.123543E+00, 0.834739E+00}, {0.106894E+00, 0.825393E+00},
            {0.897874E-01, 0.815566E+00}, {0.722500E-01, 0.805259E+00},
            {0.543097E-01, 0.794470E+00}, {0.359940E-01, 0.783203E+00},
            {0.173304E-01, 0.771458E+00}, {-.165385E-02, 0.759240E+00},
            {-.209316E-01, 0.746553E+00}, {-.404759E-01, 0.733401E+00},
            {-.602599E-01, 0.719791E+00}, {-.802573E-01, 0.705731E+00},
            {-.100442E+00, 0.691228E+00}, {-.120787E+00, 0.676291E+00},
            {-.141267E+00, 0.660930E+00}, {-.161857E+00, 0.645155E+00},
            {-.182532E+00, 0.628978E+00}, {-.203266E+00, 0.612411E+00},
            {-.224035E+00, 0.595466E+00}, {-.244814E+00, 0.578159E+00},
            {-.265580E+00, 0.560503E+00}, {-.286310E+00, 0.542512E+00},
            {-.306980E+00, 0.524204E+00}, {-.327567E+00, 0.505595E+00},
            {-.348049E+00, 0.486701E+00}, {-.368404E+00, 0.467541E+00},
            {-.388610E+00, 0.448133E+00}, {-.408648E+00, 0.428495E+00},
            {-.428495E+00, 0.408648E+00}, {-.448133E+00, 0.388610E+00},
            {-.467541E+00, 0.368404E+00}, {-.486701E+00, 0.348049E+00},
            {-.505595E+00, 0.327567E+00}, {-.524204E+00, 0.306980E+00},
            {-.542512E+00, 0.286310E+00}, {-.560503E+00, 0.265580E+00},
            {-.578159E+00, 0.244814E+00}, {-.595466E+00, 0.224035E+00},
            {-.612411E+00, 0.203266E+00}, {-.628978E+00, 0.182532E+00},
            {-.645155E+00, 0.161857E+00}, {-.660930E+00, 0.141267E+00},
            {-.676291E+00, 0.120787E+00}, {-.691228E+00, 0.100442E+00},
            {-.705731E+00, 0.802573E-01}, {-.719791E+00, 0.602599E-01},
            {-.733401E+00, 0.404759E-01}, {-.746553E+00, 0.209316E-01},
            {-.759240E+00, 0.165385E-02}, {-.771458E+00, -.173304E-01},
            {-.783203E+00, -.359940E-01}, {-.794470E+00, -.543097E-01},
            {-.805259E+00, -.722500E-01}, {-.815566E+00, -.897874E-01},
            {-.825393E+00, -.106894E+00}, {-.834739E+00, -.123543E+00},
            {-.843605E+00, -.139706E+00}, {-.851996E+00, -.155355E+00},
            {-.859913E+00, -.170464E+00}, {-.867361E+00, -.185004E+00},
            {-.874344E+00, -.198948E+00}, {-.880870E+00, -.212270E+00},
            {-.886943E+00, -.224944E+00}, {-.892571E+00, -.236943E+00},
            {-.897762E+00, -.248242E+00}, {-.902524E+00, -.258816E+00},
            {-.906864E+00, -.268643E+00}, {-.910791E+00, -.277698E+00},
            {-.914313E+00, -.285962E+00}, {-.917439E+00, -.293414E+00},
            {-.920176E+00, -.300036E+00}, {-.922531E+00, -.305811E+00},
            {-.924512E+00, -.310723E+00}, {-.926123E+00, -.314760E+00},
            {-.927371E+00, -.317912E+00}, {-.928260E+00, -.320169E+00},
            {-.928792E+00, -.321526E+00}, {-.928969E+00, -.321979E+00},
        },
        {
            {0.350735E+00, 0.933281E+00}, {0.350268E+00, 0.933101E+00},
            {0.348868E+00, 0.932563E+00}, {0.346538E+00, 0.931663E+00},
            {0.343287E+00, 0.930399E+00}, {0.339121E+00, 0.928766E+00},
            {0.334054E+00, 0.926758E+00}, {0.328099E+00, 0.924368E+00},
            {0.321271E+00, 0.921590E+00}, {0.313589E+00, 0.918415E+00},
            {0.305071E+00, 0.914835E+00}, {0.295740E+00, 0.910840E+00},
            {0.285616E+00, 0.906422E+00}, {0.274725E+00, 0.901572E+00},
            {0.263091E+00, 0.896281E+00}, {0.250739E+00, 0.890539E+00},
            {0.237696E+00, 0.884340E+00}, {0.223988E+00, 0.877676E+00},
            {0.209644E+00, 0.870539E+00}, {0.194690E+00, 0.862924E+00},
            {0.179155E+00, 0.854825E+00}, {0.163067E+00, 0.846238E+00},
            {0.146454E+00, 0.837159E+00}, {0.129345E+00, 0.827586E+00},
            {0.111768E+00, 0.817518E+00}, {0.937515E-01, 0.806953E+00},
            {0.753238E-01, 0.795893E+00}, {0.565130E-01, 0.784338E+00},
            {0.373472E-01, 0.772292E+00}, {0.178542E-01, 0.759758E+00},
            {-.193819E-02, 0.746740E+00}, {-.220026E-01, 0.733245E+00},
            {-.423116E-01, 0.719277E+00}, {-.628382E-01, 0.704846E+00},
            {-.835557E-01, 0.689959E+00}, {-.104437E+00, 0.674626E+00},
            {-.125457E+00, 0.658856E+00}, {-.146588E+00, 0.642662E+00},
            {-.167806E+00, 0.626054E+00}, {-.189085E+00, 0.609045E+00},
            {-.210399E+00, 0.591649E+00}, {-.231724E+00, 0.573880E+00},
            {-.253035E+00, 0.555754E+00}, {-.274310E+00, 0.537285E+00},
            {-.295522E+00, 0.518489E+00}, {-.316651E+00, 0.499385E+00},
            {-.337672E+00, 0.479990E+00}, {-.358563E+00, 0.460322E+00},
            {-.379303E+00, 0.440399E+00}, {-.399869E+00, 0.420242E+00},
            {-.420242E+00, 0.399869E+00}, {-.440399E+00, 0.379303E+00},
            {-.460322E+00, 0.358563E+00}, {-.479990E+00, 0.337672E+00},
            {-.499385E+00, 0.316651E+00}, {-.518489E+00, 0.295522E+00},
            {-.537285E+00, 0.274310E+00}, {-.555754E+00, 0.253035E+00},
            {-.573880E+00, 0.231724E+00}, {-.591649E+00, 0.210399E+00},
            {-.609045E+00, 0.189085E+00}, {-.626054E+00, 0.167806E+00},
            {-.642662E+00, 0.146588E+00}, {-.658856E+00, 0.125457E+00},
            {-.674626E+00, 0.104437E+00}, {-.689959E+00, 0.835557E-01},
            {-.704846E+00, 0.628382E-01}, {-.719277E+00, 0.423116E-01},
            {-.733245E+00, 0.220026E-01}, {-.746740E+00, 0.193819E-02},
            {-.759758E+00, -.178542E-01}, {-.772292E+00, -.373472E-01},
            {-.784338E+00, -.565130E-01}, {-.795893E+00, -.753238E-01},
            {-.806953E+00, -.937515E-01}, {-.817518E+00, -.111768E+00},
            {-.827586E+00, -.129345E+00}, {-.837159E+00, -.146454E+00},
            {-.846238E+00, -.163067E+00}, {-.854825E+00, -.179155E+00},
            {-.862924E+00, -.194690E+00}, {-.870539E+00, -.209644E+00},
            {-.877676E+00, -.223988E+00}, {-.884340E+00, -.237696E+00},
            {-.890539E+00, -.250739E+00}, {-.896281E+00, -.263091E+00},
            {-.901572E+00, -.274725E+00}, {-.906422E+00, -.285616E+00},
            {-.910840E+00, -.295740E+00}, {-.914835E+00, -.305071E+00},
            {-.918415E+00, -.313589E+00}, {-.921590E+00, -.321271E+00},
            {-.924368E+00, -.328099E+00}, {-.926758E+00, -.334054E+00},
            {-.928766E+00, -.339121E+00}, {-.930399E+00, -.343287E+00},
            {-.931663E+00, -.346538E+00}, {-.932563E+00, -.348868E+00},
            {-.933101E+00, -.350268E+00}, {-.933281E+00, -.350735E+00},
        },
        {
            {0.380926E+00, 0.937634E+00}, {0.380443E+00, 0.937452E+00},
            {0.378998E+00, 0.936907E+00}, {0.376593E+00, 0.935996E+00},
            {0.373236E+00, 0.934715E+00}, {0.368937E+00, 0.933060E+00},
            {0.363708E+00, 0.931024E+00}, {0.357563E+00, 0.928599E+00},
            {0.350520E+00, 0.925778E+00}, {0.342597E+00, 0.922552E+00},
            {0.333815E+00, 0.918911E+00}, {0.324196E+00, 0.914845E+00},
            {0.313763E+00, 0.910345E+00}, {0.302543E+00, 0.905401E+00},
            {0.290560E+00, 0.900002E+00}, {0.277841E+00, 0.894141E+00},
            {0.264415E+00, 0.887808E+00}, {0.250307E+00, 0.880995E+00},
            {0.235548E+00, 0.873694E+00}, {0.220166E+00, 0.865900E+00},
            {0.204190E+00, 0.857607E+00}, {0.187648E+00, 0.848810E+00},
            {0.170570E+00, 0.839505E+00}, {0.152986E+00, 0.829690E+00},
            {0.134923E+00, 0.819363E+00}, {0.116412E+00, 0.808524E+00},
            {0.974814E-01, 0.797174E+00}, {0.781595E-01, 0.785313E+00},
            {0.584752E-01, 0.772946E+00}, {0.384569E-01, 0.760075E+00},
            {0.181330E-01, 0.746706E+00}, {-.246860E-02, 0.732845E+00},
            {-.233200E-01, 0.718498E+00}, {-.443937E-01, 0.703673E+00},
            {-.656624E-01, 0.688380E+00}, {-.870989E-01, 0.672627E+00},
            {-.108677E+00, 0.656426E+00}, {-.130369E+00, 0.639788E+00},
            {-.152149E+00, 0.622725E+00}, {-.173992E+00, 0.605251E+00},
            {-.195872E+00, 0.587379E+00}, {-.217763E+00, 0.569125E+00},
            {-.239641E+00, 0.550503E+00}, {-.261481E+00, 0.531531E+00},
            {-.283259E+00, 0.512224E+00}, {-.304951E+00, 0.492601E+00},
            {-.326533E+00, 0.472680E+00}, {-.347983E+00, 0.452479E+00},
            {-.369279E+00, 0.432019E+00}, {-.390398E+00, 0.411318E+00},
            {-.411318E+00, 0.390398E+00}, {-.432019E+00, 0.369279E+00},
            {-.452479E+00, 0.347983E+00}, {-.472680E+00, 0.326533E+00},
            {-.492601E+00, 0.304951E+00}, {-.512224E+00, 0.283259E+00},
            {-.531531E+00, 0.261481E+00}, {-.550503E+00, 0.239641E+00},
            {-.569125E+00, 0.217763E+00}, {-.587379E+00, 0.195872E+00},
            {-.605251E+00, 0.173992E+00}, {-.622725E+00, 0.152149E+00},
            {-.639788E+00, 0.130369E+00}, {-.656426E+00, 0.108677E+00},
            {-.672627E+00, 0.870989E-01}, {-.688380E+00, 0.656624E-01},
            {-.703673E+00, 0.443937E-01}, {-.718498E+00, 0.233200E-01},
            {-.732845E+00, 0.246860E-02}, {-.746706E+00, -.181330E-01},
            {-.760075E+00, -.384569E-01}, {-.772946E+00, -.584752E-01},
            {-.785313E+00, -.781595E-01}, {-.797174E+00, -.974814E-01},
            {-.808524E+00, -.116412E+00}, {-.819363E+00, -.134923E+00},
            {-.829690E+00, -.152986E+00}, {-.839505E+00, -.170570E+00},
            {-.848810E+00, -.187648E+00}, {-.857607E+00, -.204190E+00},
            {-.865900E+00, -.220166E+00}, {-.873694E+00, -.235548E+00},
            {-.880995E+00, -.250307E+00}, {-.887808E+00, -.264415E+00},
            {-.894141E+00, -.277841E+00}, {-.900002E+00, -.290560E+00},
            {-.905401E+00, -.302543E+00}, {-.910345E+00, -.313763E+00},
            {-.914845E+00, -.324196E+00}, {-.918911E+00, -.333815E+00},
            {-.922552E+00, -.342597E+00}, {-.925778E+00, -.350520E+00},
            {-.928599E+00, -.357563E+00}, {-.931024E+00, -.363708E+00},
            {-.933060E+00, -.368937E+00}, {-.934715E+00, -.373236E+00},
            {-.935996E+00, -.376593E+00}, {-.936907E+00, -.378998E+00},
            {-.937452E+00, -.380443E+00}, {-.937634E+00, -.380926E+00},
        },
        {
            {0.412680E+00, 0.942031E+00}, {0.412181E+00, 0.941848E+00},
            {0.410688E+00, 0.941296E+00}, {0.408204E+00, 0.940373E+00},
            {0.404737E+00, 0.939076E+00}, {0.400297E+00, 0.937398E+00},
            {0.394898E+00, 0.935332E+00}, {0.388555E+00, 0.932871E+00},
            {0.381286E+00, 0.930005E+00}, {0.373111E+00, 0.926725E+00},
            {0.364053E+00, 0.923019E+00}, {0.354134E+00, 0.918878E+00},
            {0.343380E+00, 0.914291E+00}, {0.331817E+00, 0.909246E+00},
            {0.319471E+00, 0.903733E+00}, {0.306372E+00, 0.897743E+00},
            {0.292547E+00, 0.891266E+00}, {0.278026E+00, 0.884294E+00},
            {0.262838E+00, 0.876817E+00}, {0.247013E+00, 0.868831E+00},
            {0.230580E+00, 0.860329E+00}, {0.213570E+00, 0.851305E+00},
            {0.196012E+00, 0.841757E+00}, {0.177937E+00, 0.831682E+00},
            {0.159373E+00, 0.821077E+00}, {0.140352E+00, 0.809944E+00},
            {0.120902E+00, 0.798283E+00}, {0.101052E+00, 0.786095E+00},
            {0.808331E-01, 0.773384E+00}, {0.602727E-01, 0.760154E+00},
            {0.394001E-01, 0.746410E+00}, {0.182437E-01, 0.732158E+00},
            {-.316804E-02, 0.717406E+00}, {-.248071E-01, 0.702163E+00},
            {-.466457E-01, 0.686437E+00}, {-.686563E-01, 0.670238E+00},
            {-.908115E-01, 0.653579E+00}, {-.113084E+00, 0.636470E+00},
            {-.135448E+00, 0.618926E+00}, {-.157876E+00, 0.600959E+00},
            {-.180343E+00, 0.582584E+00}, {-.202822E+00, 0.563818E+00},
            {-.225289E+00, 0.544674E+00}, {-.247718E+00, 0.525171E+00},
            {-.270083E+00, 0.505327E+00}, {-.292362E+00, 0.485158E+00},
            {-.314531E+00, 0.464684E+00}, {-.336564E+00, 0.443925E+00},
            {-.358440E+00, 0.422900E+00}, {-.380136E+00, 0.401630E+00},
            {-.401630E+00, 0.380136E+00}, {-.422900E+00, 0.358440E+00},
            {-.443925E+00, 0.336564E+00}, {-.464684E+00, 0.314531E+00},
            {-.485158E+00, 0.292362E+00}, {-.505327E+00, 0.270083E+00},
            {-.525171E+00, 0.247718E+00}, {-.544674E+00, 0.225289E+00},
            {-.563818E+00, 0.202822E+00}, {-.582584E+00, 0.180343E+00},
            {-.600959E+00, 0.157876E+00}, {-.618926E+00, 0.135448E+00},
            {-.636470E+00, 0.113084E+00}, {-.653579E+00, 0.908115E-01},
            {-.670238E+00, 0.686563E-01}, {-.686437E+00, 0.466457E-01},
            {-.702163E+00, 0.248071E-01}, {-.717406E+00, 0.316804E-02},
            {-.732158E+00, -.182437E-01}, {-.746410E+00, -.394001E-01},
            {-.760154E+00, -.602727E-01}, {-.773384E+00, -.808331E-01},
            {-.786095E+00, -.101052E+00}, {-.798283E+00, -.120902E+00},
            {-.809944E+00, -.140352E+00}, {-.821077E+00, -.159373E+00},
            {-.831682E+00, -.177937E+00}, {-.841757E+00, -.196012E+00},
            {-.851305E+00, -.213570E+00}, {-.860329E+00, -.230580E+00},
            {-.868831E+00, -.247013E+00}, {-.876817E+00, -.262838E+00},
            {-.884294E+00, -.278026E+00}, {-.891266E+00, -.292547E+00},
            {-.897743E+00, -.306372E+00}, {-.903733E+00, -.319471E+00},
            {-.909246E+00, -.331817E+00}, {-.914291E+00, -.343380E+00},
            {-.918878E+00, -.354134E+00}, {-.923019E+00, -.364053E+00},
            {-.926725E+00, -.373111E+00}, {-.930005E+00, -.381286E+00},
            {-.932871E+00, -.388555E+00}, {-.935332E+00, -.394898E+00},
            {-.937398E+00, -.400297E+00}, {-.939076E+00, -.404737E+00},
            {-.940373E+00, -.408204E+00}, {-.941296E+00, -.410688E+00},
            {-.941848E+00, -.412181E+00}, {-.942031E+00, -.412680E+00},
        },
        {
            {0.446144E+00, 0.946477E+00}, {0.445629E+00, 0.946291E+00},
            {0.444085E+00, 0.945732E+00}, {0.441517E+00, 0.944798E+00},
            {0.437934E+00, 0.943483E+00}, {0.433347E+00, 0.941782E+00},
            {0.427769E+00, 0.939686E+00}, {0.421218E+00, 0.937187E+00},
            {0.413712E+00, 0.934274E+00}, {0.405274E+00, 0.930936E+00},
            {0.395927E+00, 0.927162E+00}, {0.385696E+00, 0.922940E+00},
            {0.374606E+00, 0.918259E+00}, {0.362686E+00, 0.913106E+00},
            {0.349965E+00, 0.907470E+00}, {0.336471E+00, 0.901341E+00},
            {0.322234E+00, 0.894708E+00}, {0.307284E+00, 0.887562E+00},
            {0.291652E+00, 0.879895E+00}, {0.275369E+00, 0.871701E+00},
            {0.258465E+00, 0.862971E+00}, {0.240971E+00, 0.853703E+00},
            {0.222918E+00, 0.843891E+00}, {0.204337E+00, 0.833534E+00},
            {0.185257E+00, 0.822630E+00}, {0.165710E+00, 0.811179E+00},
            {0.145724E+00, 0.799182E+00}, {0.125331E+00, 0.786642E+00},
            {0.104561E+00, 0.773561E+00}, {0.834411E-01, 0.759944E+00},
            {0.620024E-01, 0.745797E+00}, {0.402735E-01, 0.731127E+00},
            {0.182832E-01, 0.715942E+00}, {-.393997E-02, 0.700251E+00},
            {-.263677E-01, 0.684062E+00}, {-.489721E-01, 0.667389E+00},
            {-.717252E-01, 0.650241E+00}, {-.945996E-01, 0.632632E+00},
            {-.117568E+00, 0.614576E+00}, {-.140604E+00, 0.596086E+00},
            {-.163680E+00, 0.577178E+00}, {-.186771E+00, 0.557868E+00},
            {-.209850E+00, 0.538172E+00}, {-.232891E+00, 0.518109E+00},
            {-.255870E+00, 0.497696E+00}, {-.278762E+00, 0.476952E+00},
            {-.301541E+00, 0.455897E+00}, {-.324185E+00, 0.434550E+00},
            {-.346669E+00, 0.412932E+00}, {-.368970E+00, 0.391065E+00},
            {-.391065E+00, 0.368970E+00}, {-.412932E+00, 0.346669E+00},
            {-.434550E+00, 0.324185E+00}, {-.455897E+00, 0.301541E+00},
            {-.476952E+00, 0.278762E+00}, {-.497696E+00, 0.255870E+00},
            {-.518109E+00, 0.232891E+00}, {-.538172E+00, 0.209850E+00},
            {-.557868E+00, 0.186771E+00}, {-.577178E+00, 0.163680E+00},
            {-.596086E+00, 0.140604E+00}, {-.614576E+00, 0.117568E+00},
            {-.632632E+00, 0.945996E-01}, {-.650241E+00, 0.717252E-01},
            {-.667389E+00, 0.489721E-01}, {-.684062E+00, 0.263677E-01},
            {-.700251E+00, 0.393997E-02}, {-.715942E+00, -.182832E-01},
            {-.731127E+00, -.402735E-01}, {-.745797E+00, -.620024E-01},
            {-.759944E+00, -.834411E-01}, {-.773561E+00, -.104561E+00},
            {-.786642E+00, -.125331E+00}, {-.799182E+00, -.145724E+00},
            {-.811179E+00, -.165710E+00}, {-.822630E+00, -.185257E+00},
            {-.833534E+00, -.204337E+00}, {-.843891E+00, -.222918E+00},
            {-.853703E+00, -.240971E+00}, {-.862971E+00, -.258465E+00},
            {-.871701E+00, -.275369E+00}, {-.879895E+00, -.291652E+00},
            {-.887562E+00, -.307284E+00}, {-.894708E+00, -.322234E+00},
            {-.901341E+00, -.336471E+00}, {-.907470E+00, -.349965E+00},
            {-.913106E+00, -.362686E+00}, {-.918259E+00, -.374606E+00},
            {-.922940E+00, -.385696E+00}, {-.927162E+00, -.395927E+00},
            {-.930936E+00, -.405274E+00}, {-.934274E+00, -.413712E+00},
            {-.937187E+00, -.421218E+00}, {-.939686E+00, -.427769E+00},
            {-.941782E+00, -.433347E+00}, {-.943483E+00, -.437934E+00},
            {-.944798E+00, -.441517E+00}, {-.945732E+00, -.444085E+00},
            {-.946291E+00, -.445629E+00}, {-.946477E+00, -.446144E+00},
        },
        {
            {0.481485E+00, 0.950975E+00}, {0.480952E+00, 0.950786E+00},
            {0.479355E+00, 0.950221E+00}, {0.476699E+00, 0.949274E+00},
            {0.472993E+00, 0.947942E+00}, {0.468250E+00, 0.946216E+00},
            {0.462484E+00, 0.944089E+00}, {0.455715E+00, 0.941549E+00},
            {0.447962E+00, 0.938586E+00}, {0.439248E+00, 0.935187E+00},
            {0.429599E+00, 0.931339E+00}, {0.419041E+00, 0.927030E+00},
            {0.407603E+00, 0.922246E+00}, {0.395312E+00, 0.916976E+00},
            {0.382200E+00, 0.911205E+00}, {0.368297E+00, 0.904924E+00},
            {0.353633E+00, 0.898121E+00}, {0.338241E+00, 0.890786E+00},
            {0.322151E+00, 0.882910E+00}, {0.305396E+00, 0.874488E+00},
            {0.288006E+00, 0.865510E+00}, {0.270015E+00, 0.855974E+00},
            {0.251452E+00, 0.845875E+00}, {0.232350E+00, 0.835211E+00},
            {0.212739E+00, 0.823981E+00}, {0.192650E+00, 0.812184E+00},
            {0.172114E+00, 0.799823E+00}, {0.151162E+00, 0.786899E+00},
            {0.129823E+00, 0.773418E+00}, {0.108128E+00, 0.759383E+00},
            {0.861064E-01, 0.744802E+00}, {0.637873E-01, 0.729681E+00},
            {0.412002E-01, 0.714029E+00}, {0.183740E-01, 0.697856E+00},
            {-.466248E-02, 0.681172E+00}, {-.278808E-01, 0.663988E+00},
            {-.512527E-01, 0.646318E+00}, {-.747503E-01, 0.628174E+00},
            {-.983459E-01, 0.609571E+00}, {-.122012E+00, 0.590524E+00},
            {-.145722E+00, 0.571048E+00}, {-.169448E+00, 0.551161E+00},
            {-.193164E+00, 0.530879E+00}, {-.216845E+00, 0.510222E+00},
            {-.240464E+00, 0.489207E+00}, {-.263995E+00, 0.467855E+00},
            {-.287414E+00, 0.446185E+00}, {-.310696E+00, 0.424219E+00},
            {-.333817E+00, 0.401976E+00}, {-.356753E+00, 0.379480E+00},
            {-.379480E+00, 0.356753E+00}, {-.401976E+00, 0.333817E+00},
            {-.424219E+00, 0.310696E+00}, {-.446185E+00, 0.287414E+00},
            {-.467855E+00, 0.263995E+00}, {-.489207E+00, 0.240464E+00},
            {-.510222E+00, 0.216845E+00}, {-.530879E+00, 0.193164E+00},
            {-.551161E+00, 0.169448E+00}, {-.571048E+00, 0.145722E+00},
            {-.590524E+00, 0.122012E+00}, {-.609571E+00, 0.983459E-01},
            {-.628174E+00, 0.747503E-01}, {-.646318E+00, 0.512527E-01},
            {-.663988E+00, 0.278808E-01}, {-.681172E+00, 0.466248E-02},
            {-.697856E+00, -.183740E-01}, {-.714029E+00, -.412002E-01},
            {-.729681E+00, -.637873E-01}, {-.744802E+00, -.861064E-01},
            {-.759383E+00, -.108128E+00}, {-.773418E+00, -.129823E+00},
            {-.786899E+00, -.151162E+00}, {-.799823E+00, -.172114E+00},
            {-.812184E+00, -.192650E+00}, {-.823981E+00, -.212739E+00},
            {-.835211E+00, -.232350E+00}, {-.845875E+00, -.251452E+00},
            {-.855974E+00, -.270015E+00}, {-.865510E+00, -.288006E+00},
            {-.874488E+00, -.305396E+00}, {-.882910E+00, -.322151E+00},
            {-.890786E+00, -.338241E+00}, {-.898121E+00, -.353633E+00},
            {-.904924E+00, -.368297E+00}, {-.911205E+00, -.382200E+00},
            {-.916976E+00, -.395312E+00}, {-.922246E+00, -.407603E+00},
            {-.927030E+00, -.419041E+00}, {-.931339E+00, -.429599E+00},
            {-.935187E+00, -.439248E+00}, {-.938586E+00, -.447962E+00},
            {-.941549E+00, -.455715E+00}, {-.944089E+00, -.462484E+00},
            {-.946216E+00, -.468250E+00}, {-.947942E+00, -.472993E+00},
            {-.949274E+00, -.476699E+00}, {-.950221E+00, -.479355E+00},
            {-.950786E+00, -.480952E+00}, {-.950975E+00, -.481485E+00},
        },
        {
            {0.518892E+00, 0.955528E+00}, {0.518340E+00, 0.955338E+00},
            {0.516686E+00, 0.954765E+00}, {0.513937E+00, 0.953806E+00},
            {0.510102E+00, 0.952455E+00}, {0.505195E+00, 0.950704E+00},
            {0.499232E+00, 0.948543E+00}, {0.492232E+00, 0.945961E+00},
            {0.484219E+00, 0.942943E+00}, {0.475217E+00, 0.939478E+00},
            {0.465254E+00, 0.935550E+00}, {0.454356E+00, 0.931145E+00},
            {0.442555E+00, 0.926249E+00}, {0.429880E+00, 0.920849E+00},
            {0.416363E+00, 0.914930E+00}, {0.402037E+00, 0.908480E+00},
            {0.386933E+00, 0.901488E+00}, {0.371084E+00, 0.893943E+00},
            {0.354523E+00, 0.885838E+00}, {0.337283E+00, 0.877162E+00},
            {0.319395E+00, 0.867912E+00}, {0.300892E+00, 0.858080E+00},
            {0.281806E+00, 0.847665E+00}, {0.262170E+00, 0.836663E+00},
            {0.242014E+00, 0.825074E+00}, {0.221370E+00, 0.812898E+00},
            {0.200270E+00, 0.800138E+00}, {0.178743E+00, 0.786796E+00},
            {0.156822E+00, 0.772878E+00}, {0.134535E+00, 0.758388E+00},
            {0.111914E+00, 0.743334E+00}, {0.889872E-01, 0.727723E+00},
            {0.657854E-01, 0.711566E+00}, {0.423377E-01, 0.694872E+00},
            {0.186731E-01, 0.677653E+00}, {-.517948E-02, 0.659920E+00},
            {-.291913E-01, 0.641687E+00}, {-.533341E-01, 0.622969E+00},
            {-.775796E-01, 0.603780E+00}, {-.101900E+00, 0.584136E+00},
            {-.126268E+00, 0.564053E+00}, {-.150656E+00, 0.543550E+00},
            {-.175036E+00, 0.522644E+00}, {-.199383E+00, 0.501354E+00},
            {-.223670E+00, 0.479701E+00}, {-.247871E+00, 0.457703E+00},
            {-.271960E+00, 0.435382E+00}, {-.295912E+00, 0.412760E+00},
            {-.319702E+00, 0.389858E+00}, {-.343305E+00, 0.366699E+00},
            {-.366699E+00, 0.343305E+00}, {-.389858E+00, 0.319702E+00},
            {-.412760E+00, 0.295912E+00}, {-.435382E+00, 0.271960E+00},
            {-.457703E+00, 0.247871E+00}, {-.479701E+00, 0.223670E+00},
            {-.501354E+00, 0.199383E+00}, {-.522644E+00, 0.175036E+00},
            {-.543550E+00, 0.150656E+00}, {-.564053E+00, 0.126268E+00},
            {-.584136E+00, 0.101900E+00}, {-.603780E+00, 0.775796E-01},
            {-.622969E+00, 0.533341E-01}, {-.641687E+00, 0.291913E-01},
            {-.659920E+00, 0.517948E-02}, {-.677653E+00, -.186731E-01},
            {-.694872E+00, -.423377E-01}, {-.711566E+00, -.657854E-01},
            {-.727723E+00, -.889872E-01}, {-.743334E+00, -.111914E+00},
            {-.758388E+00, -.134535E+00}, {-.772878E+00, -.156822E+00},
            {-.786796E+00, -.178743E+00}, {-.800138E+00, -.200270E+00},
            {-.812898E+00, -.221370E+00}, {-.825074E+00, -.242014E+00},
            {-.836663E+00, -.262170E+00}, {-.847665E+00, -.281806E+00},
            {-.858080E+00, -.300892E+00}, {-.867912E+00, -.319395E+00},
            {-.877162E+00, -.337283E+00}, {-.885838E+00, -.354523E+00},
            {-.893943E+00, -.371084E+00}, {-.901488E+00, -.386933E+00},
            {-.908480E+00, -.402037E+00}, {-.914930E+00, -.416363E+00},
            {-.920849E+00, -.429880E+00}, {-.926249E+00, -.442555E+00},
            {-.931145E+00, -.454356E+00}, {-.935550E+00, -.465254E+00},
            {-.939478E+00, -.475217E+00}, {-.942943E+00, -.484219E+00},
            {-.945961E+00, -.492232E+00}, {-.948543E+00, -.499232E+00},
            {-.950704E+00, -.505195E+00}, {-.952455E+00, -.510102E+00},
            {-.953806E+00, -.513937E+00}, {-.954765E+00, -.516686E+00},
            {-.955338E+00, -.518340E+00}, {-.955528E+00, -.518892E+00},
        },
        {
            {0.558582E+00, 0.960142E+00}, {0.558011E+00, 0.959949E+00},
            {0.556297E+00, 0.959369E+00}, {0.553450E+00, 0.958398E+00},
            {0.549478E+00, 0.957028E+00}, {0.544397E+00, 0.955251E+00},
            {0.538226E+00, 0.953054E+00}, {0.530985E+00, 0.950424E+00},
            {0.522699E+00, 0.947348E+00}, {0.513396E+00, 0.943809E+00},
            {0.503104E+00, 0.939792E+00}, {0.491853E+00, 0.935281E+00},
            {0.479675E+00, 0.930260E+00}, {0.466603E+00, 0.924713E+00},
            {0.452669E+00, 0.918627E+00}, {0.437908E+00, 0.911988E+00},
            {0.422352E+00, 0.904785E+00}, {0.406035E+00, 0.897005E+00},
            {0.388992E+00, 0.888641E+00}, {0.371255E+00, 0.879683E+00},
            {0.352857E+00, 0.870126E+00}, {0.333833E+00, 0.859965E+00},
            {0.314213E+00, 0.849197E+00}, {0.294032E+00, 0.837820E+00},
            {0.273320E+00, 0.825833E+00}, {0.252109E+00, 0.813238E+00},
            {0.230432E+00, 0.800037E+00}, {0.208319E+00, 0.786234E+00},
            {0.185801E+00, 0.771835E+00}, {0.162909E+00, 0.756846E+00},
            {0.139673E+00, 0.741274E+00}, {0.116123E+00, 0.725129E+00},
            {0.922903E-01, 0.708420E+00}, {0.682033E-01, 0.691159E+00},
            {0.438919E-01, 0.673358E+00}, {0.193853E-01, 0.655030E+00},
            {-.528737E-02, 0.636188E+00}, {-.300974E-01, 0.616849E+00},
            {-.550161E-01, 0.597028E+00}, {-.800153E-01, 0.576741E+00},
            {-.105067E+00, 0.556007E+00}, {-.130143E+00, 0.534843E+00},
            {-.155216E+00, 0.513269E+00}, {-.180259E+00, 0.491304E+00},
            {-.205244E+00, 0.468968E+00}, {-.230146E+00, 0.446283E+00},
            {-.254938E+00, 0.423270E+00}, {-.279593E+00, 0.399952E+00},
            {-.304087E+00, 0.376351E+00}, {-.328395E+00, 0.352491E+00},
            {-.352491E+00, 0.328395E+00}, {-.376351E+00, 0.304087E+00},
            {-.399952E+00, 0.279593E+00}, {-.423270E+00, 0.254938E+00},
            {-.446283E+00, 0.230146E+00}, {-.468968E+00, 0.205244E+00},
            {-.491304E+00, 0.180259E+00}, {-.513269E+00, 0.155216E+00},
            {-.534843E+00, 0.130143E+00}, {-.556007E+00, 0.105067E+00},
            {-.576741E+00, 0.800153E-01}, {-.597028E+00, 0.550161E-01},
            {-.616849E+00, 0.300974E-01}, {-.636188E+00, 0.528737E-02},
            {-.655030E+00, -.193853E-01}, {-.673358E+00, -.438919E-01},
            {-.691159E+00, -.682033E-01}, {-.708420E+00, -.922903E-01},
            {-.725129E+00, -.116123E+00}, {-.741274E+00, -.139673E+00},
            {-.756846E+00, -.162909E+00}, {-.771835E+00, -.185801E+00},
            {-.786234E+00, -.208319E+00}, {-.800037E+00, -.230432E+00},
            {-.813238E+00, -.252109E+00}, {-.825833E+00, -.273320E+00},
            {-.837820E+00, -.294032E+00}, {-.849197E+00, -.314213E+00},
            {-.859965E+00, -.333833E+00}, {-.870126E+00, -.352857E+00},
            {-.879683E+00, -.371255E+00}, {-.888641E+00, -.388992E+00},
            {-.897005E+00, -.406035E+00}, {-.904785E+00, -.422352E+00},
            {-.911988E+00, -.437908E+00}, {-.918627E+00, -.452669E+00},
            {-.924713E+00, -.466603E+00}, {-.930260E+00, -.479675E+00},
            {-.935281E+00, -.491853E+00}, {-.939792E+00, -.503104E+00},
            {-.943809E+00, -.513396E+00}, {-.947348E+00, -.522699E+00},
            {-.950424E+00, -.530985E+00}, {-.953054E+00, -.538226E+00},
            {-.955251E+00, -.544397E+00}, {-.957028E+00, -.549478E+00},
            {-.958398E+00, -.553450E+00}, {-.959369E+00, -.556297E+00},
            {-.959949E+00, -.558011E+00}, {-.960142E+00, -.558582E+00},
        },
        {
            {0.600809E+00, 0.964822E+00}, {0.600216E+00, 0.964627E+00},
            {0.598440E+00, 0.964040E+00}, {0.595487E+00, 0.963055E+00},
            {0.591371E+00, 0.961665E+00}, {0.586107E+00, 0.959859E+00},
            {0.579715E+00, 0.957623E+00}, {0.572221E+00, 0.954942E+00},
            {0.563651E+00, 0.951800E+00}, {0.554033E+00, 0.948179E+00},
            {0.543400E+00, 0.944061E+00}, {0.531784E+00, 0.939428E+00},
            {0.519218E+00, 0.934264E+00}, {0.505737E+00, 0.928551E+00},
            {0.491376E+00, 0.922274E+00}, {0.476170E+00, 0.915419E+00},
            {0.460153E+00, 0.907973E+00}, {0.443361E+00, 0.899925E+00},
            {0.425827E+00, 0.891266E+00}, {0.407587E+00, 0.881987E+00},
            {0.388673E+00, 0.872083E+00}, {0.369120E+00, 0.861550E+00},
            {0.348960E+00, 0.850384E+00}, {0.328226E+00, 0.838584E+00},
            {0.306951E+00, 0.826150E+00}, {0.285166E+00, 0.813085E+00},
            {0.262903E+00, 0.799392E+00}, {0.240194E+00, 0.785076E+00},
            {0.217070E+00, 0.770143E+00}, {0.193562E+00, 0.754600E+00},
            {0.169699E+00, 0.738456E+00}, {0.145514E+00, 0.721721E+00},
            {0.121035E+00, 0.704406E+00}, {0.962931E-01, 0.686523E+00},
            {0.713179E-01, 0.668085E+00}, {0.461388E-01, 0.649106E+00},
            {0.207854E-01, 0.629601E+00}, {-.471322E-02, 0.609587E+00},
            {-.303281E-01, 0.589080E+00}, {-.560305E-01, 0.568098E+00},
            {-.817918E-01, 0.546660E+00}, {-.107584E+00, 0.524783E+00},
            {-.133378E+00, 0.502490E+00}, {-.159148E+00, 0.479799E+00},
            {-.184864E+00, 0.456733E+00}, {-.210501E+00, 0.433313E+00},
            {-.236031E+00, 0.409562E+00}, {-.261427E+00, 0.385503E+00},
            {-.286663E+00, 0.361159E+00}, {-.311715E+00, 0.336555E+00},
            {-.336555E+00, 0.311715E+00}, {-.361159E+00, 0.286663E+00},
            {-.385503E+00, 0.261427E+00}, {-.409562E+00, 0.236031E+00},
            {-.433313E+00, 0.210501E+00}, {-.456733E+00, 0.184864E+00},
            {-.479799E+00, 0.159148E+00}, {-.502490E+00, 0.133378E+00},
            {-.524783E+00, 0.107584E+00}, {-.546660E+00, 0.817918E-01},
            {-.568098E+00, 0.560305E-01}, {-.589080E+00, 0.303281E-01},
            {-.609587E+00, 0.471322E-02}, {-.629601E+00, -.207854E-01},
            {-.649106E+00, -.461388E-01}, {-.668085E+00, -.713179E-01},
            {-.686523E+00, -.962931E-01}, {-.704406E+00, -.121035E+00},
            {-.721721E+00, -.145514E+00}, {-.738456E+00, -.169699E+00},
            {-.754600E+00, -.193562E+00}, {-.770143E+00, -.217070E+00},
            {-.785076E+00, -.240194E+00}, {-.799392E+00, -.262903E+00},
            {-.813085E+00, -.285166E+00}, {-.826150E+00, -.306951E+00},
            {-.838584E+00, -.328226E+00}, {-.850384E+00, -.348960E+00},
            {-.861550E+00, -.369120E+00}, {-.872083E+00, -.388673E+00},
            {-.881987E+00, -.407587E+00}, {-.891266E+00, -.425827E+00},
            {-.899925E+00, -.443361E+00}, {-.907973E+00, -.460153E+00},
            {-.915419E+00, -.476170E+00}, {-.922274E+00, -.491376E+00},
            {-.928551E+00, -.505737E+00}, {-.934264E+00, -.519218E+00},
            {-.939428E+00, -.531784E+00}, {-.944061E+00, -.543400E+00},
            {-.948179E+00, -.554033E+00}, {-.951800E+00, -.563651E+00},
            {-.954942E+00, -.572221E+00}, {-.957623E+00, -.579715E+00},
            {-.959859E+00, -.586107E+00}, {-.961665E+00, -.591371E+00},
            {-.963055E+00, -.595487E+00}, {-.964040E+00, -.598440E+00},
            {-.964627E+00, -.600216E+00}, {-.964822E+00, -.600809E+00},
        },
        {
            {0.645865E+00, 0.969573E+00}, {0.645249E+00, 0.969376E+00},
            {0.643405E+00, 0.968781E+00}, {0.640341E+00, 0.967782E+00},
            {0.636071E+00, 0.966371E+00}, {0.630613E+00, 0.964533E+00},
            {0.623991E+00, 0.962254E+00}, {0.616231E+00, 0.959515E+00},
            {0.607364E+00, 0.956297E+00}, {0.597421E+00, 0.952581E+00},
            {0.586436E+00, 0.948345E+00}, {0.574444E+00, 0.943571E+00},
            {0.561482E+00, 0.938238E+00}, {0.547586E+00, 0.932330E+00},
            {0.532793E+00, 0.925829E+00}, {0.517137E+00, 0.918721E+00},
            {0.500657E+00, 0.910993E+00}, {0.483387E+00, 0.902632E+00},
            {0.465362E+00, 0.893631E+00}, {0.446618E+00, 0.883981E+00},
            {0.427188E+00, 0.873676E+00}, {0.407107E+00, 0.862713E+00},
            {0.386407E+00, 0.851091E+00}, {0.365121E+00, 0.838808E+00},
            {0.343282E+00, 0.825866E+00}, {0.320922E+00, 0.812268E+00},
            {0.298072E+00, 0.798018E+00}, {0.274764E+00, 0.783123E+00},
            {0.251030E+00, 0.767589E+00}, {0.226899E+00, 0.751426E+00},
            {0.202404E+00, 0.734642E+00}, {0.177574E+00, 0.717250E+00},
            {0.152439E+00, 0.699261E+00}, {0.127031E+00, 0.680688E+00},
            {0.101378E+00, 0.661547E+00}, {0.755109E-01, 0.641851E+00},
            {0.494592E-01, 0.621618E+00}, {0.232525E-01, 0.600864E+00},
            {-.308006E-02, 0.579608E+00}, {-.295092E-01, 0.557867E+00},
            {-.560059E-01, 0.535662E+00}, {-.825415E-01, 0.513013E+00},
            {-.109087E+00, 0.489941E+00}, {-.135615E+00, 0.466468E+00},
            {-.162097E+00, 0.442614E+00}, {-.188504E+00, 0.418405E+00},
            {-.214810E+00, 0.393862E+00}, {-.240987E+00, 0.369011E+00},
            {-.267009E+00, 0.343874E+00}, {-.292848E+00, 0.318478E+00},
            {-.318478E+00, 0.292848E+00}, {-.343874E+00, 0.267009E+00},
            {-.369011E+00, 0.240987E+00}, {-.393862E+00, 0.214810E+00},
            {-.418405E+00, 0.188504E+00}, {-.442614E+00, 0.162097E+00},
            {-.466468E+00, 0.135615E+00}, {-.489941E+00, 0.109087E+00},
            {-.513013E+00, 0.825415E-01}, {-.535662E+00, 0.560059E-01},
            {-.557867E+00, 0.295092E-01}, {-.579608E+00, 0.308006E-02},
            {-.600864E+00, -.232525E-01}, {-.621618E+00, -.494592E-01},
            {-.641851E+00, -.755109E-01}, {-.661547E+00, -.101378E+00},
            {-.680688E+00, -.127031E+00}, {-.699261E+00, -.152439E+00},
            {-.717250E+00, -.177574E+00}, {-.734642E+00, -.202404E+00},
            {-.751426E+00, -.226899E+00}, {-.767589E+00, -.251030E+00},
            {-.783123E+00, -.274764E+00}, {-.798018E+00, -.298072E+00},
            {-.812268E+00, -.320922E+00}, {-.825866E+00, -.343282E+00},
            {-.838808E+00, -.365121E+00}, {-.851091E+00, -.386407E+00},
            {-.862713E+00, -.407107E+00}, {-.873676E+00, -.427188E+00},
            {-.883981E+00, -.446618E+00}, {-.893631E+00, -.465362E+00},
            {-.902632E+00, -.483387E+00}, {-.910993E+00, -.500657E+00},
            {-.918721E+00, -.517137E+00}, {-.925829E+00, -.532793E+00},
            {-.932330E+00, -.547586E+00}, {-.938238E+00, -.561482E+00},
            {-.943571E+00, -.574444E+00}, {-.948345E+00, -.586436E+00},
            {-.952581E+00, -.597421E+00}, {-.956297E+00, -.607364E+00},
            {-.959515E+00, -.616231E+00}, {-.962254E+00, -.623991E+00},
            {-.964533E+00, -.630613E+00}, {-.966371E+00, -.636071E+00},
            {-.967782E+00, -.640341E+00}, {-.968781E+00, -.643405E+00},
            {-.969376E+00, -.645249E+00}, {-.969573E+00, -.645865E+00},
        },
        {
            {0.694091E+00, 0.974403E+00}, {0.693451E+00, 0.974202E+00},
            {0.691534E+00, 0.973600E+00}, {0.688352E+00, 0.972586E+00},
            {0.683918E+00, 0.971151E+00}, {0.678257E+00, 0.969278E+00},
            {0.671393E+00, 0.966949E+00}, {0.663357E+00, 0.964141E+00},
            {0.654182E+00, 0.960833E+00}, {0.643906E+00, 0.957002E+00},
            {0.632563E+00, 0.952624E+00}, {0.620193E+00, 0.947678E+00},
            {0.606834E+00, 0.942142E+00}, {0.592524E+00, 0.935997E+00},
            {0.577301E+00, 0.929226E+00}, {0.561203E+00, 0.921813E+00},
            {0.544267E+00, 0.913745E+00}, {0.526529E+00, 0.905011E+00},
            {0.508024E+00, 0.895602E+00}, {0.488788E+00, 0.885511E+00},
            {0.468854E+00, 0.874733E+00}, {0.448257E+00, 0.863267E+00},
            {0.427029E+00, 0.851111E+00}, {0.405203E+00, 0.838265E+00},
            {0.382812E+00, 0.824733E+00}, {0.359887E+00, 0.810519E+00},
            {0.336459E+00, 0.795629E+00}, {0.312560E+00, 0.780071E+00},
            {0.288221E+00, 0.763852E+00}, {0.263473E+00, 0.746983E+00},
            {0.238346E+00, 0.729475E+00}, {0.212871E+00, 0.711341E+00},
            {0.187078E+00, 0.692594E+00}, {0.160998E+00, 0.673249E+00},
            {0.134660E+00, 0.653321E+00}, {0.108095E+00, 0.632827E+00},
            {0.813325E-01, 0.611785E+00}, {0.544023E-01, 0.590212E+00},
            {0.273340E-01, 0.568128E+00}, {0.157188E-03, 0.545553E+00},
            {-.270987E-01, 0.522508E+00}, {-.544045E-01, 0.499014E+00},
            {-.817310E-01, 0.475093E+00}, {-.109049E+00, 0.450768E+00},
            {-.136331E+00, 0.426062E+00}, {-.163547E+00, 0.400999E+00},
            {-.190670E+00, 0.375603E+00}, {-.217672E+00, 0.349900E+00},
            {-.244524E+00, 0.323914E+00}, {-.271200E+00, 0.297672E+00},
            {-.297672E+00, 0.271200E+00}, {-.323914E+00, 0.244524E+00},
            {-.349900E+00, 0.217672E+00}, {-.375603E+00, 0.190670E+00},
            {-.400999E+00, 0.163547E+00}, {-.426062E+00, 0.136331E+00},
            {-.450768E+00, 0.109049E+00}, {-.475093E+00, 0.817310E-01},
            {-.499014E+00, 0.544045E-01}, {-.522508E+00, 0.270987E-01},
            {-.545553E+00, -.157188E-03}, {-.568128E+00, -.273340E-01},
            {-.590212E+00, -.544023E-01}, {-.611785E+00, -.813325E-01},
            {-.632827E+00, -.108095E+00}, {-.653321E+00, -.134660E+00},
            {-.673249E+00, -.160998E+00}, {-.692594E+00, -.187078E+00},
            {-.711341E+00, -.212871E+00}, {-.729475E+00, -.238346E+00},
            {-.746983E+00, -.263473E+00}, {-.763852E+00, -.288221E+00},
            {-.780071E+00, -.312560E+00}, {-.795629E+00, -.336459E+00},
            {-.810519E+00, -.359887E+00}, {-.824733E+00, -.382812E+00},
            {-.838265E+00, -.405203E+00}, {-.851111E+00, -.427029E+00},
            {-.863267E+00, -.448257E+00}, {-.874733E+00, -.468854E+00},
            {-.885511E+00, -.488788E+00}, {-.895602E+00, -.508024E+00},
            {-.905011E+00, -.526529E+00}, {-.913745E+00, -.544267E+00},
            {-.921813E+00, -.561203E+00}, {-.929226E+00, -.577301E+00},
            {-.935997E+00, -.592524E+00}, {-.942142E+00, -.606834E+00},
            {-.947678E+00, -.620193E+00}, {-.952624E+00, -.632563E+00},
            {-.957002E+00, -.643906E+00}, {-.960833E+00, -.654182E+00},
            {-.964141E+00, -.663357E+00}, {-.966949E+00, -.671393E+00},
            {-.969278E+00, -.678257E+00}, {-.971151E+00, -.683918E+00},
            {-.972586E+00, -.688352E+00}, {-.973600E+00, -.691534E+00},
            {-.974202E+00, -.693451E+00}, {-.974403E+00, -.694091E+00},
        },
        {
            {0.745890E+00, 0.979316E+00}, {0.745224E+00, 0.979114E+00},
            {0.743231E+00, 0.978503E+00}, {0.739921E+00, 0.977473E+00},
            {0.735316E+00, 0.976011E+00}, {0.729440E+00, 0.974096E+00},
            {0.722325E+00, 0.971705E+00}, {0.714006E+00, 0.968812E+00},
            {0.704522E+00, 0.965390E+00}, {0.693911E+00, 0.961413E+00},
            {0.682215E+00, 0.956854E+00}, {0.669476E+00, 0.951688E+00},
            {0.655733E+00, 0.945894E+00}, {0.641027E+00, 0.939450E+00},
            {0.625397E+00, 0.932338E+00}, {0.608882E+00, 0.924543E+00},
            {0.591518E+00, 0.916053E+00}, {0.573342E+00, 0.906856E+00},
            {0.554390E+00, 0.896947E+00}, {0.534695E+00, 0.886318E+00},
            {0.514291E+00, 0.874966E+00}, {0.493212E+00, 0.862892E+00},
            {0.471490E+00, 0.850095E+00}, {0.449157E+00, 0.836578E+00},
            {0.426245E+00, 0.822346E+00}, {0.402784E+00, 0.807405E+00},
            {0.378806E+00, 0.791763E+00}, {0.354341E+00, 0.775429E+00},
            {0.329421E+00, 0.758413E+00}, {0.304075E+00, 0.740727E+00},
            {0.278334E+00, 0.722384E+00}, {0.252228E+00, 0.703398E+00},
            {0.225788E+00, 0.683785E+00}, {0.199044E+00, 0.663560E+00},
            {0.172025E+00, 0.642740E+00}, {0.144762E+00, 0.621344E+00},
            {0.117285E+00, 0.599391E+00}, {0.896242E-01, 0.576901E+00},
            {0.618091E-01, 0.553893E+00}, {0.338696E-01, 0.530390E+00},
            {0.583553E-02, 0.506413E+00}, {-.222633E-01, 0.481986E+00},
            {-.503975E-01, 0.457130E+00}, {-.785374E-01, 0.431871E+00},
            {-.106654E+00, 0.406233E+00}, {-.134718E+00, 0.380240E+00},
            {-.162700E+00, 0.353919E+00}, {-.190573E+00, 0.327295E+00},
            {-.218306E+00, 0.300395E+00}, {-.245873E+00, 0.273245E+00},
            {-.273245E+00, 0.245873E+00}, {-.300395E+00, 0.218306E+00},
            {-.327295E+00, 0.190573E+00}, {-.353919E+00, 0.162700E+00},
            {-.380240E+00, 0.134718E+00}, {-.406233E+00, 0.106654E+00},
            {-.431871E+00, 0.785374E-01}, {-.457130E+00, 0.503975E-01},
            {-.481986E+00, 0.222633E-01}, {-.506413E+00, -.583553E-02},
            {-.530390E+00, -.338696E-01}, {-.553893E+00, -.618091E-01},
            {-.576901E+00, -.896242E-01}, {-.599391E+00, -.117285E+00},
            {-.621344E+00, -.144762E+00}, {-.642740E+00, -.172025E+00},
            {-.663560E+00, -.199044E+00}, {-.683785E+00, -.225788E+00},
            {-.703398E+00, -.252228E+00}, {-.722384E+00, -.278334E+00},
            {-.740727E+00, -.304075E+00}, {-.758413E+00, -.329421E+00},
            {-.775429E+00, -.354341E+00}, {-.791763E+00, -.378806E+00},
            {-.807405E+00, -.402784E+00}, {-.822346E+00, -.426245E+00},
            {-.836578E+00, -.449157E+00}, {-.850095E+00, -.471490E+00},
            {-.862892E+00, -.493212E+00}, {-.874966E+00, -.514291E+00},
            {-.886318E+00, -.534695E+00}, {-.896947E+00, -.554390E+00},
            {-.906856E+00, -.573342E+00}, {-.916053E+00, -.591518E+00},
            {-.924543E+00, -.608882E+00}, {-.932338E+00, -.625397E+00},
            {-.939450E+00, -.641027E+00}, {-.945894E+00, -.655733E+00},
            {-.951688E+00, -.669476E+00}, {-.956854E+00, -.682215E+00},
            {-.961413E+00, -.693911E+00}, {-.965390E+00, -.704522E+00},
            {-.968812E+00, -.714006E+00}, {-.971705E+00, -.722325E+00},
            {-.974096E+00, -.729440E+00}, {-.976011E+00, -.735316E+00},
            {-.977473E+00, -.739921E+00}, {-.978503E+00, -.743231E+00},
            {-.979114E+00, -.745224E+00}, {-.979316E+00, -.745890E+00},
        },
        {
            {0.801743E+00, 0.984323E+00}, {0.801049E+00, 0.984118E+00},
            {0.798972E+00, 0.983498E+00}, {0.795529E+00, 0.982450E+00},
            {0.790743E+00, 0.980954E+00}, {0.784647E+00, 0.978984E+00},
            {0.777280E+00, 0.976510E+00}, {0.768682E+00, 0.973500E+00},
            {0.758898E+00, 0.969922E+00}, {0.747974E+00, 0.965744E+00},
            {0.735954E+00, 0.960936E+00}, {0.722882E+00, 0.955472E+00},
            {0.708800E+00, 0.949326E+00}, {0.693750E+00, 0.942480E+00},
            {0.677772E+00, 0.934915E+00}, {0.660903E+00, 0.926616E+00},
            {0.643179E+00, 0.917573E+00}, {0.624637E+00, 0.907778E+00},
            {0.605309E+00, 0.897225E+00}, {0.585230E+00, 0.885911E+00},
            {0.564431E+00, 0.873835E+00}, {0.542944E+00, 0.860998E+00},
            {0.520801E+00, 0.847405E+00}, {0.498031E+00, 0.833060E+00},
            {0.474666E+00, 0.817971E+00}, {0.450735E+00, 0.802145E+00},
            {0.426269E+00, 0.785593E+00}, {0.401298E+00, 0.768327E+00},
            {0.375850E+00, 0.750358E+00}, {0.349957E+00, 0.731702E+00},
            {0.323648E+00, 0.712372E+00}, {0.296953E+00, 0.692385E+00},
            {0.269901E+00, 0.671759E+00}, {0.242523E+00, 0.650510E+00},
            {0.214849E+00, 0.628659E+00}, {0.186908E+00, 0.606224E+00},
            {0.158732E+00, 0.583227E+00}, {0.130349E+00, 0.559689E+00},
            {0.101790E+00, 0.535632E+00}, {0.730852E-01, 0.511080E+00},
            {0.442649E-01, 0.486055E+00}, {0.153589E-01, 0.460581E+00},
            {-.136027E-01, 0.434684E+00}, {-.425898E-01, 0.408388E+00},
            {-.715726E-01, 0.381720E+00}, {-.100521E+00, 0.354705E+00},
            {-.129406E+00, 0.327371E+00}, {-.158198E+00, 0.299744E+00},
            {-.186868E+00, 0.271852E+00}, {-.215386E+00, 0.243723E+00},
            {-.243723E+00, 0.215386E+00}, {-.271852E+00, 0.186868E+00},
            {-.299744E+00, 0.158198E+00}, {-.327371E+00, 0.129406E+00},
            {-.354705E+00, 0.100521E+00}, {-.381720E+00, 0.715726E-01},
            {-.408388E+00, 0.425898E-01}, {-.434684E+00, 0.136027E-01},
            {-.460581E+00, -.153589E-01}, {-.486055E+00, -.442649E-01},
            {-.511080E+00, -.730852E-01}, {-.535632E+00, -.101790E+00},
            {-.559689E+00, -.130349E+00}, {-.583227E+00, -.158732E+00},
            {-.606224E+00, -.186908E+00}, {-.628659E+00, -.214849E+00},
            {-.650510E+00, -.242523E+00}, {-.671759E+00, -.269901E+00},
            {-.692385E+00, -.296953E+00}, {-.712372E+00, -.323648E+00},
            {-.731702E+00, -.349957E+00}, {-.750358E+00, -.375850E+00},
            {-.768327E+00, -.401298E+00}, {-.785593E+00, -.426269E+00},
            {-.802145E+00, -.450735E+00}, {-.817971E+00, -.474666E+00},
            {-.833060E+00, -.498031E+00}, {-.847405E+00, -.520801E+00},
            {-.860998E+00, -.542944E+00}, {-.873835E+00, -.564431E+00},
            {-.885911E+00, -.585230E+00}, {-.897225E+00, -.605309E+00},
            {-.907778E+00, -.624637E+00}, {-.917573E+00, -.643179E+00},
            {-.926616E+00, -.660903E+00}, {-.934915E+00, -.677772E+00},
            {-.942480E+00, -.693750E+00}, {-.949326E+00, -.708800E+00},
            {-.955472E+00, -.722882E+00}, {-.960936E+00, -.735954E+00},
            {-.965744E+00, -.747974E+00}, {-.969922E+00, -.758898E+00},
            {-.973500E+00, -.768682E+00}, {-.976510E+00, -.777280E+00},
            {-.978984E+00, -.784647E+00}, {-.980954E+00, -.790743E+00},
            {-.982450E+00, -.795529E+00}, {-.983498E+00, -.798972E+00},
            {-.984118E+00, -.801049E+00}, {-.984323E+00, -.801743E+00},
        },
        {
            {0.862222E+00, 0.989432E+00}, {0.861498E+00, 0.989224E+00},
            {0.859333E+00, 0.988593E+00}, {0.855750E+00, 0.987520E+00},
            {0.850782E+00, 0.985975E+00}, {0.844474E+00, 0.983921E+00},
            {0.836874E+00, 0.981318E+00}, {0.828035E+00, 0.978124E+00},
            {0.818008E+00, 0.974299E+00}, {0.806843E+00, 0.969806E+00},
            {0.794589E+00, 0.964614E+00}, {0.781291E+00, 0.958695E+00},
            {0.766991E+00, 0.952025E+00}, {0.751730E+00, 0.944586E+00},
            {0.735546E+00, 0.936362E+00}, {0.718472E+00, 0.927344E+00},
            {0.700544E+00, 0.917523E+00}, {0.681793E+00, 0.906896E+00},
            {0.662250E+00, 0.895461E+00}, {0.641946E+00, 0.883218E+00},
            {0.620910E+00, 0.870172E+00}, {0.599172E+00, 0.856326E+00},
            {0.576760E+00, 0.841689E+00}, {0.553703E+00, 0.826269E+00},
            {0.530029E+00, 0.810076E+00}, {0.505767E+00, 0.793122E+00},
            {0.480945E+00, 0.775420E+00}, {0.455592E+00, 0.756984E+00},
            {0.429736E+00, 0.737829E+00}, {0.403407E+00, 0.717972E+00},
            {0.376633E+00, 0.697431E+00}, {0.349444E+00, 0.676224E+00},
            {0.321869E+00, 0.654371E+00}, {0.293936E+00, 0.631891E+00},
            {0.265677E+00, 0.608805E+00}, {0.237121E+00, 0.585137E+00},
            {0.208298E+00, 0.560907E+00}, {0.179237E+00, 0.536141E+00},
            {0.149970E+00, 0.510860E+00}, {0.120526E+00, 0.485091E+00},
            {0.909360E-01, 0.458858E+00}, {0.612305E-01, 0.432187E+00},
            {0.314400E-01, 0.405104E+00}, {0.159478E-02, 0.377636E+00},
            {-.282745E-01, 0.349811E+00}, {-.581375E-01, 0.321655E+00},
            {-.879638E-01, 0.293198E+00}, {-.117723E+00, 0.264467E+00},
            {-.147385E+00, 0.235491E+00}, {-.176920E+00, 0.206299E+00},
            {-.206299E+00, 0.176920E+00}, {-.235491E+00, 0.147385E+00},
            {-.264467E+00, 0.117723E+00}, {-.293198E+00, 0.879638E-01},
            {-.321655E+00, 0.581375E-01}, {-.349811E+00, 0.282745E-01},
            {-.377636E+00, -.159478E-02}, {-.405104E+00, -.314400E-01},
            {-.432187E+00, -.612305E-01}, {-.458858E+00, -.909360E-01},
            {-.485091E+00, -.120526E+00}, {-.510860E+00, -.149970E+00},
            {-.536141E+00, -.179237E+00}, {-.560907E+00, -.208298E+00},
            {-.585137E+00, -.237121E+00}, {-.608805E+00, -.265677E+00},
            {-.631891E+00, -.293936E+00}, {-.654371E+00, -.321869E+00},
            {-.676224E+00, -.349444E+00}, {-.697431E+00, -.376633E+00},
            {-.717972E+00, -.403407E+00}, {-.737829E+00, -.429736E+00},
            {-.756984E+00, -.455592E+00}, {-.775420E+00, -.480945E+00},
            {-.793122E+00, -.505767E+00}, {-.810076E+00, -.530029E+00},
            {-.826269E+00, -.553703E+00}, {-.841689E+00, -.576760E+00},
            {-.856326E+00, -.599172E+00}, {-.870172E+00, -.620910E+00},
            {-.883218E+00, -.641946E+00}, {-.895461E+00, -.662250E+00},
            {-.906896E+00, -.681793E+00}, {-.917523E+00, -.700544E+00},
            {-.927344E+00, -.718472E+00}, {-.936362E+00, -.735546E+00},
            {-.944586E+00, -.751730E+00}, {-.952025E+00, -.766991E+00},
            {-.958695E+00, -.781291E+00}, {-.964614E+00, -.794589E+00},
            {-.969806E+00, -.806843E+00}, {-.974299E+00, -.818008E+00},
            {-.978124E+00, -.828035E+00}, {-.981318E+00, -.836874E+00},
            {-.983921E+00, -.844474E+00}, {-.985975E+00, -.850782E+00},
            {-.987520E+00, -.855750E+00}, {-.988593E+00, -.859333E+00},
            {-.989224E+00, -.861498E+00}, {-.989432E+00, -.862222E+00},
        },
        {
            {0.928024E+00, 0.994654E+00}, {0.927267E+00, 0.994442E+00},
            {0.925012E+00, 0.993795E+00}, {0.921298E+00, 0.992674E+00},
            {0.916184E+00, 0.991026E+00}, {0.909737E+00, 0.988790E+00},
            {0.902025E+00, 0.985907E+00}, {0.893114E+00, 0.982323E+00},
            {0.883060E+00, 0.977993E+00}, {0.871915E+00, 0.972880E+00},
            {0.859725E+00, 0.966955E+00}, {0.846530E+00, 0.960197E+00},
            {0.832364E+00, 0.952588E+00}, {0.817261E+00, 0.944120E+00},
            {0.801251E+00, 0.934786E+00}, {0.784361E+00, 0.924583E+00},
            {0.766620E+00, 0.913511E+00}, {0.748052E+00, 0.901574E+00},
            {0.728683E+00, 0.888777E+00}, {0.708538E+00, 0.875127E+00},
            {0.687643E+00, 0.860632E+00}, {0.666022E+00, 0.845305E+00},
            {0.643700E+00, 0.829156E+00}, {0.620704E+00, 0.812200E+00},
            {0.597057E+00, 0.794450E+00}, {0.572788E+00, 0.775922E+00},
            {0.547921E+00, 0.756634E+00}, {0.522483E+00, 0.736603E+00},
            {0.496502E+00, 0.715848E+00}, {0.470004E+00, 0.694388E+00},
            {0.443018E+00, 0.672244E+00}, {0.415572E+00, 0.649438E+00},
            {0.387694E+00, 0.625991E+00}, {0.359412E+00, 0.601926E+00},
            {0.330757E+00, 0.577268E+00}, {0.301757E+00, 0.552040E+00},
            {0.272443E+00, 0.526267E+00}, {0.242843E+00, 0.499974E+00},
            {0.212989E+00, 0.473188E+00}, {0.182911E+00, 0.445936E+00},
            {0.152639E+00, 0.418244E+00}, {0.122204E+00, 0.390139E+00},
            {0.916369E-01, 0.361652E+00}, {0.609690E-01, 0.332808E+00},
            {0.302312E-01, 0.303638E+00}, {-.545488E-03, 0.274171E+00},
            {-.313299E-01, 0.244436E+00}, {-.620910E-01, 0.214463E+00},
            {-.927977E-01, 0.184282E+00}, {-.123419E+00, 0.153924E+00},
            {-.153924E+00, 0.123419E+00}, {-.184282E+00, 0.927977E-01},
            {-.214463E+00, 0.620910E-01}, {-.244436E+00, 0.313299E-01},
            {-.274171E+00, 0.545488E-03}, {-.303638E+00, -.302312E-01},
            {-.332808E+00, -.609690E-01}, {-.361652E+00, -.916369E-01},
            {-.390139E+00, -.122204E+00}, {-.418244E+00, -.152639E+00},
            {-.445936E+00, -.182911E+00}, {-.473188E+00, -.212989E+00},
            {-.499974E+00, -.242843E+00}, {-.526267E+00, -.272443E+00},
            {-.552040E+00, -.301757E+00}, {-.577268E+00, -.330757E+00},
            {-.601926E+00, -.359412E+00}, {-.625991E+00, -.387694E+00},
            {-.649438E+00, -.415572E+00}, {-.672244E+00, -.443018E+00},
            {-.694388E+00, -.470004E+00}, {-.715848E+00, -.496502E+00},
            {-.736603E+00, -.522483E+00}, {-.756634E+00, -.547921E+00},
            {-.775922E+00, -.572788E+00}, {-.794450E+00, -.597057E+00},
            {-.812200E+00, -.620704E+00}, {-.829156E+00, -.643700E+00},
            {-.845305E+00, -.666022E+00}, {-.860632E+00, -.687643E+00},
            {-.875127E+00, -.708538E+00}, {-.888777E+00, -.728683E+00},
            {-.901574E+00, -.748052E+00}, {-.913511E+00, -.766620E+00},
            {-.924583E+00, -.784361E+00}, {-.934786E+00, -.801251E+00},
            {-.944120E+00, -.817261E+00}, {-.952588E+00, -.832364E+00},
            {-.960197E+00, -.846530E+00}, {-.966955E+00, -.859725E+00},
            {-.972880E+00, -.871915E+00}, {-.977993E+00, -.883060E+00},
            {-.982323E+00, -.893114E+00}, {-.985907E+00, -.902025E+00},
            {-.988790E+00, -.909737E+00}, {-.991026E+00, -.916184E+00},
            {-.992674E+00, -.921298E+00}, {-.993795E+00, -.925012E+00},
            {-.994442E+00, -.927267E+00}, {-.994654E+00, -.928024E+00},
        },
        {
            {0.100000E+01, 0.100000E+01}, {0.999496E+00, 0.999497E+00},
            {0.997986E+00, 0.997988E+00}, {0.995471E+00, 0.995474E+00},
            {0.991954E+00, 0.991957E+00}, {0.987438E+00, 0.987441E+00},
            {0.981925E+00, 0.981930E+00}, {0.975428E+00, 0.975432E+00},
            {0.967946E+00, 0.967950E+00}, {0.959492E+00, 0.959496E+00},
            {0.950069E+00, 0.950072E+00}, {0.939691E+00, 0.939694E+00},
            {0.928363E+00, 0.928371E+00}, {0.916105E+00, 0.916110E+00},
            {0.902924E+00, 0.902933E+00}, {0.888833E+00, 0.888840E+00},
            {0.873844E+00, 0.873852E+00}, {0.857979E+00, 0.857985E+00},
            {0.841248E+00, 0.841256E+00}, {0.823674E+00, 0.823681E+00},
            {0.805268E+00, 0.805275E+00}, {0.786048E+00, 0.786056E+00},
            {0.766043E+00, 0.766047E+00}, {0.745258E+00, 0.745268E+00},
            {0.723730E+00, 0.723742E+00}, {0.701471E+00, 0.701482E+00},
            {0.678504E+00, 0.678512E+00}, {0.654854E+00, 0.654864E+00},
            {0.630550E+00, 0.630557E+00}, {0.605605E+00, 0.605612E+00},
            {0.580055E+00, 0.580058E+00}, {0.553917E+00, 0.553925E+00},
            {0.527218E+00, 0.527229E+00}, {0.499998E+00, 0.500005E+00},
            {0.472268E+00, 0.472277E+00}, {0.444064E+00, 0.444072E+00},
            {0.415409E+00, 0.415418E+00}, {0.386342E+00, 0.386347E+00},
            {0.356884E+00, 0.356891E+00}, {0.327066E+00, 0.327072E+00},
            {0.296919E+00, 0.296923E+00}, {0.266471E+00, 0.266479E+00},
            {0.235751E+00, 0.235763E+00}, {0.204804E+00, 0.204812E+00},
            {0.173646E+00, 0.173653E+00}, {0.142312E+00, 0.142316E+00},
            {0.110836E+00, 0.110839E+00}, {0.792484E-01, 0.792530E-01},
            {0.475798E-01, 0.475862E-01}, {0.158645E-01, 0.158688E-01},
            {-.158676E-01, -.158652E-01}, {-.475839E-01, -.475809E-01},
            {-.792525E-01, -.792449E-01}, {-.110840E+00, -.110834E+00},
            {-.142317E+00, -.142310E+00}, {-.173652E+00, -.173646E+00},
            {-.204809E+00, -.204805E+00}, {-.235763E+00, -.235757E+00},
            {-.266475E+00, -.266471E+00}, {-.296923E+00, -.296916E+00},
            {-.327070E+00, -.327065E+00}, {-.356889E+00, -.356881E+00},
            {-.386349E+00, -.386338E+00}, {-.415418E+00, -.415409E+00},
            {-.444070E+00, -.444060E+00}, {-.472275E+00, -.472263E+00},
            {-.500002E+00, -.499995E+00}, {-.527232E+00, -.527222E+00},
            {-.553923E+00, -.553919E+00}, {-.580061E+00, -.580055E+00},
            {-.605612E+00, -.605604E+00}, {-.630557E+00, -.630550E+00},
            {-.654866E+00, -.654858E+00}, {-.678513E+00, -.678508E+00},
            {-.701480E+00, -.701472E+00}, {-.723742E+00, -.723730E+00},
            {-.745270E+00, -.745262E+00}, {-.766048E+00, -.766042E+00},
            {-.786055E+00, -.786048E+00}, {-.805275E+00, -.805268E+00},
            {-.823681E+00, -.823674E+00}, {-.841256E+00, -.841248E+00},
            {-.857985E+00, -.857979E+00}, {-.873852E+00, -.873844E+00},
            {-.888838E+00, -.888831E+00}, {-.902929E+00, -.902921E+00},
            {-.916111E+00, -.916103E+00}, {-.928372E+00, -.928366E+00},
            {-.939697E+00, -.939690E+00}, {-.950074E+00, -.950070E+00},
            {-.959496E+00, -.959492E+00}, {-.967950E+00, -.967946E+00},
            {-.975432E+00, -.975428E+00}, {-.981931E+00, -.981927E+00},
            {-.987441E+00, -.987438E+00}, {-.991957E+00, -.991954E+00},
            {-.995474E+00, -.995471E+00}, {-.997987E+00, -.997985E+00},
            {-.999497E+00, -.999496E+00}, {-.100000E+01, -.100000E+01},
        },
};

#endif /* #define RT_RIEMANN_HLL_EIGENVALUES_H */
