#!/bin/bash

# List each test that should be run
declare -a TEST_LIST=(test27cellsStars test27cellsStars_subset)

# Run same test for each executable
for TEST in "${TEST_LIST[@]}"
do
  # Test for particles with the same smoothing length
    echo ""
    
    rm -f star_brute_force_27_standard.dat swift_star_dopair_27_standard.dat

    echo "Running ./$TEST -n 6 -N 7 -r 1 -d 0 -f standard"
    ./$TEST -n 6 -N 7 -r 1 -d 0 -f standard

    if [ -e star_brute_force_27_standard.dat ]
    then
      if python3 ./difffloat.py star_brute_force_27_standard.dat swift_star_dopair_27_standard.dat ./star_tolerance_27_normal.dat 6
      then
        echo "Accuracy test passed"
      else
        echo "Accuracy test failed"
        exit 1
      fi
    else
      echo "Error Missing test output file"
      exit 1
    fi

    echo "------------"


  # Test for particles with random smoothing lengths
    echo ""

    rm -f star_brute_force_27_standard.dat swift_star_dopair_27_standard.dat

    echo "Running ./$TEST -n 6 -N 7 -r 1 -d 0 -f standard -p 1.1"
    ./$TEST -n 6 -N 7 -r 1 -d 0 -f standard -p 1.1

    if [ -e star_brute_force_27_standard.dat ]
    then
      if python3 ./difffloat.py star_brute_force_27_standard.dat swift_star_dopair_27_standard.dat ./star_tolerance_27_perturbed_h.dat 6
      then
        echo "Accuracy test passed"
      else
        echo "Accuracy test failed"
        exit 1
      fi
    else
      echo "Error Missing test output file"
      exit 1
    fi

    echo "------------"


  # Test for particles with random smoothing lengths
    echo ""

    rm -f star_brute_force_27_standard.dat swift_star_dopair_27_standard.dat

    echo "Running ./$TEST -n 6 -N 7 -r 1 -d 0 -f standard -p 1.3"
    ./$TEST -n 6 -N 7 -r 1 -d 0 -f standard -p 1.3

    if [ -e star_brute_force_27_standard.dat ]
    then
      if python3 ./difffloat.py star_brute_force_27_standard.dat swift_star_dopair_27_standard.dat ./star_tolerance_27_perturbed_h2.dat 6
      then
        echo "Accuracy test passed"
      else
        echo "Accuracy test failed"
        exit 1
      fi
    else
      echo "Error Missing test output file"
      exit 1
    fi

    echo "------------"

done

exit $?
