/*******************************************************************************
 * This file is part of SWIFT.
 * Copyright (c) 2018 Matthieu Schaller (schaller@strw.leidenuniv.nl)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/
#ifndef SWIFT_TRACERS_STRUCT_NONE_H
#define SWIFT_TRACERS_STRUCT_NONE_H

/**
 * @brief Properties of the tracers stored in the extended particle data.
 */
struct tracers_xpart_data {};

/**
 * @brief Properties of the tracers stored in the star particle data.
 *
 * Note: In this model, they are identical to the xpart data.
 */
#define tracers_spart_data tracers_xpart_data

/**
 * @brief Properties of the tracers stored in the black hole particle data.
 */
struct tracers_bpart_data {};

#endif /* SWIFT_TRACERS_STRUCT_NONE_H */
