#!/bin/bash

echo ""

rm -f brute_force_pair_active.dat swift_dopair_active.dat

echo "Running ./testActivePair -n 6 -r 1 -d 0 -f active"

./testActivePair -n 6 -r 1 -d 0 -f active
if [ $? -ne 0 ]
then
  echo "Test failed"
  exit 1
fi

python3 ./difffloat.py brute_force_pair_active.dat swift_dopair_active.dat ./tolerance_pair_active.dat
if [ $? -ne 0 ]
then
  echo "Accuracy test failed"
  exit 1
fi

python3 ./difffloat.py brute_force_dopair2_active.dat swift_dopair2_force_active.dat ./tolerance_pair_force_active.dat
if [ $? -ne 0 ]
then
  echo "Accuracy test failed"
  exit 1
fi

rm -f brute_force_pair_active.dat swift_dopair_active.dat

# Run the special case that triggered a bug. See merge request !435.
echo "Running ./testActivePair -n 6 -r 1 -d 0 -f active -s 1506434777"

./testActivePair -n 6 -r 1 -d 0 -f active -s 1506434777
if [ $? -ne 0 ]
then
  echo "Test failed"
  exit 1
fi

python3 ./difffloat.py brute_force_pair_active.dat swift_dopair_active.dat ./tolerance_pair_active.dat
if [ $? -ne 0 ]
then
  echo "Accuracy test failed"
  exit 1
fi

python3 ./difffloat.py brute_force_dopair2_active.dat swift_dopair2_force_active.dat ./tolerance_pair_force_active.dat
if [ $? -ne 0 ]
then
  echo "Accuracy test failed"
  exit 1
fi

exit $?
