/*******************************************************************************
 * This file is part of SWIFT.
 * Copyright (c) 2022 Bert Vandenbroucke (bert.vandenbroucke@gmail.com)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/
#ifndef SWIFT_TRACERS_COLIBRE_DEBUG_H
#define SWIFT_TRACERS_COLIBRE_DEBUG_H

__attribute__((always_inline)) INLINE static void tracers_debug_particle(
    const struct part* p, const struct xpart* xp) {

  if (xp != NULL) {
    warning("[PID%lld] tracers_xpart_data:", p->id);
    warning(
        "[PID%lld] "
        "maximum_temperature=%.3e, "
        "stellar_wind_momentum_received=%.3e, "
#if !defined(COOLING_CHIMES)
        "nHI_over_nH=%.3e, "
        "nHII_over_nH=%.3e, "
        "nH2_over_nH=%.3e, "
#endif
        "HIIregion_timer_gas=%.3e, "
        "HIIregion_starid=%lld, "
        "maximum_temperature_scale_factor=%.3e, "
        "last_stellar_wind_kick_scale_factor=%.3e, "
        "last_SNII_thermal_injection_scale_factor=%.3e, "
        "last_SNII_kick_scale_factor=%.3e, "
        "last_SNIa_thermal_injection_scale_factor=%.3e, "
        "last_AGN_injection_scale_factor=%.3e, "
        "density_at_last_SN_thermal_feedback_event=%.3e, "
        "density_at_last_AGN_feedback_event=%.3e, "
        "AGN_feedback_energy=%.3e, "
        "last_SNII_kick_velocity=%.3e, "
        "max_SNII_kick_velocity=%.3e",
        p->id, xp->tracers_data.maximum_temperature,
        xp->tracers_data.stellar_wind_momentum_received,
#if !defined(COOLING_CHIMES)
        xp->tracers_data.nHI_over_nH, xp->tracers_data.nHII_over_nH,
        xp->tracers_data.nH2_over_nH,
#endif
        xp->tracers_data.HIIregion_timer_gas, xp->tracers_data.HIIregion_starid,
        xp->tracers_data.maximum_temperature_scale_factor,
        xp->tracers_data.last_stellar_wind_kick_scale_factor,
        xp->tracers_data.last_SNII_thermal_injection_scale_factor,
        xp->tracers_data.last_SNII_kick_scale_factor,
        xp->tracers_data.last_SNIa_thermal_injection_scale_factor,
        xp->tracers_data.last_AGN_injection_scale_factor,
        xp->tracers_data.density_at_last_SN_thermal_feedback_event,
        xp->tracers_data.density_at_last_AGN_feedback_event,
        xp->tracers_data.AGN_feedback_energy,
        xp->tracers_data.last_SNII_kick_velocity,
        xp->tracers_data.max_SNII_kick_velocity);
  }
}

#endif /* SWIFT_TRACERS_COLIBRE_DEBUG_H */
