#ifndef SWIFT_DUST_NONE_H
#define SWIFT_DUST_NONE_H

/* #include "dust_struct.h" */

/* Config parameters. */
#include <config.h>

/* Local includes */
#include "cooling_properties.h"
#include "dust_properties.h"
#include "entropy_floor.h"
#include "parser.h"
#include "physical_constants.h"
#include "restart.h"
#include "space.h"
#include "units.h"

/**
 * @brief redistribute any dust mass back to element abundances
 * on star particle formation according to dust composition, to
 * represent astration
 *
 * Nothing here.
 *
 * @param p The gas particles.
 * @param dp Global dust parameters for initialisation.
 */
static INLINE void dust_redistribute_masses_astration(
    struct spart *sp, const struct part *p, const struct dustevo_props *dp) {}

static INLINE void dust_redistribute_masses_cooling_step(
    struct part *p, const struct dustevo_props *dp) {}

static INLINE void dustevo_print_backend(const struct dustevo_props *dp) {
  message("Running without dust evolution modelling.");
}

static INLINE void dust_evolve_part(
    const struct phys_const *phys_const, const struct unit_system *us,
    const struct cosmology *cosmo, const struct hydro_props *hydro_properties,
    const struct entropy_floor_properties *floor_props,
    const struct cooling_function_data *cooling, const struct dustevo_props *dp,
    struct part *restrict p, struct xpart *restrict xp, const float dt,
    const float dt_therm, const double time) {}

static INLINE void dustevo_props_dump(const struct dustevo_props *dp,
                                      FILE *stream) {}

static INLINE void dustevo_props_restore(struct dustevo_props *dp,
                                         struct feedback_props *fp,
                                         FILE *stream) {}

static INLINE float dust_get_local_dust_to_gas_ratio(void) {
  error("Calling a dust function in the 'None' dust model!");
  return -1.f;
}

#ifdef HAVE_HDF5
INLINE static void dust_read_depletion(hid_t id,
                                       float **log_depletion_fractions,
                                       const int table_cooling_N_redshifts,
                                       const int table_cooling_N_temperature,
                                       const int table_cooling_N_metallicity,
                                       const int table_cooling_N_density,
                                       const int table_cooling_N_elementtypes) {
}
#endif

INLINE static void depletion_correct_rates_split(
    float *cooling_array_heating_rate, float *cooling_array_cooling_rate,
    float *log_depletion_fractions, const int table_cooling_N_redshifts,
    const int table_cooling_N_temperature,
    const int table_cooling_N_metallicity, const int table_cooling_N_density,
    const int table_cooling_N_elementtypes, const int table_cooling_N_cooltypes,
    const int table_cooling_N_heattypes) {}

INLINE static void depletion_correct_rates(
    float *cooling_array_heating_rate, float *cooling_array_cooling_rate,
    float *log_depletion_fractions, const int table_cooling_N_redshifts,
    const int table_cooling_N_temperature,
    const int table_cooling_N_metallicity, const int table_cooling_N_density,
    const int table_cooling_N_elementtypes, const int table_cooling_N_cooltypes,
    const int table_cooling_N_heattypes) {}

/**
 * @brief Prepares a particle for the smooth dust calculation.
 *
 * Zeroes all the relevant arrays in preparation for the sums taking place in
 * the various smooth dust tasks
 *
 * Nothing here.
 *
 * @param p The particle to act upon
 * @param dp #chemistry_global_data containing chemistry informations.
 */
__attribute__((always_inline)) INLINE static void dust_init_part(
    struct part *restrict p, const struct dustevo_props *dp) {}

__attribute__((always_inline)) INLINE static void dust_first_init_part(
    const struct phys_const *restrict phys_const,
    const struct unit_system *restrict us,
    const struct cosmology *restrict cosmo, const struct dustevo_props *dp,
    const struct chemistry_global_data *cd, struct part *restrict p,
    struct xpart *restrict xp) {}

/**
 * @brief Initialise the dust properties of a black hole with
 * the dust properties of the gas it is born from.
 *
 * No dust
 *
 * @param bp_data The black hole data to initialise.
 * @param p_data The gas data to use.
 * @param gas_mass The mass of the gas particle.
 */
__attribute__((always_inline)) INLINE static void dust_bpart_from_part(
    struct dust_bpart_data *bp_data, const struct dust_part_data *p_data,
    const double gas_mass) {}

/**
 * @brief Add the dust data of a gas particle to a black hole.
 *
 * No dust
 *
 * @param bp_data The black hole data to add to.
 * @param p_data The gas data to use.
 * @param gas_mass The mass of the gas particle.
 */
__attribute__((always_inline)) INLINE static void dust_add_part_to_bpart(
    struct dust_bpart_data *bp_data, const struct dust_part_data *p_data,
    const double gas_mass) {}

/**
 * @brief Transfer dust data of a gas particle to a black hole.
 *
 * No dust
 *
 * @param bp_data The black hole data to add to.
 * @param p_data The gas data to use.
 * @param nibble_mass The mass to be removed from the gas particle.
 * @param nibble_fraction The fraction of the (original) mass of the gas
 *        particle that is removed.
 */
__attribute__((always_inline)) INLINE static void dust_transfer_part_to_bpart(
    struct dust_bpart_data *bp_data, struct dust_part_data *p_data,
    const double nibble_mass, const double nibble_fraction) {}

/**
 * @brief Add the dust data of a black hole to another one.
 *
 * No dust
 *
 * @param bp_data The black hole data to add to.
 * @param swallowed_data The black hole data to use.
 */
__attribute__((always_inline)) INLINE static void dust_add_bpart_to_bpart(
    struct dust_bpart_data *bp_data,
    const struct dust_bpart_data *swallowed_data) {}

/**
 * @brief Returns the total dust mass carried by a particle.
 *
 * Nothing to return here.
 */
__attribute__((always_inline)) INLINE static float dust_get_total_mass(
    const struct part *p) {
  return 0.f;
}

#define dust_check_for_NaNs(p) dust_check_for_NaNs_(p, __FUNCTION__, __LINE__);

__attribute__((always_inline)) INLINE static void dust_check_for_NaNs_(
    const struct part *p, const char *function, const int line) {}

#endif /* SWIFT_DUST_NONE_H */
