#ifndef SWIFT_DUST_T20_TABLES_H
#define SWIFT_DUST_T20_TABLES_H

/* Config parameters. */
#include <config.h>

#ifdef HAVE_HDF5
#include "parser.h"

#include <hdf5.h>
#endif

/* Avoid cyclic inclusions */
struct dustevo_props;
struct feedback_props;

/*! Number of elements considered for the SNII yields */
#define eagle_feedback_SNII_N_elements 11

/*! Number of mass bins considered for the SNII yields */
#define eagle_feedback_SNII_N_masses 17

/*! Number of metallicity bins considered for the SNII yields */
#define eagle_feedback_SNII_N_metals 6

/*! Number of elements considered for the AGB yields */
#define eagle_feedback_AGB_N_elements 13

/*! Number of mass bins considered for the AGB yields */
#define eagle_feedback_AGB_N_masses 25

/*! Number of metallicity bins considered for the AGB yields */
#define eagle_feedback_AGB_N_metals 13

/*! CC: Number of elements to be read from the yield tables */
#define enrichment_of_N_elements_from_yield_tables 9

/*! CC: Number of elements to be read from the yield tables */
#define enrichment_of_N_elements_from_AGB_yield_tables 11

/*! Number of bins used to define the IMF */
#define eagle_feedback_N_imf_bins 200

void dust_read_depletion(hid_t id, float **log_depletion_fractions,
                         const int table_cooling_N_redshifts,
                         const int table_cooling_N_temperature,
                         const int table_cooling_N_metallicity,
                         const int table_cooling_N_density,
                         const int table_cooling_N_elementtypes);

void initialise_dyield_tables(const struct feedback_props *fp,
                              struct dustevo_props *dp);

void print_dyield_tables(const struct feedback_props *fp,
                         const struct dustevo_props *dp);

void read_AGB_dyield_tables(struct dustevo_props *dp);

void resample_AGB_dyield(const struct feedback_props *fp,
                         struct dustevo_props *dp);

void compute_SNII_dyield(const struct feedback_props *fp,
                         struct dustevo_props *dp);

void compute_AGB_dyield(const struct feedback_props *fp,
                        struct dustevo_props *dp);

#endif /* SWIFT_DUST_T20_TABLES_H */
