#ifndef SWIFT_DUST_STRUCT_T20_H
#define SWIFT_DUST_STRUCT_T20_H

/**
 * @brief The individual grain species traced in the model.
 */
enum grain_species {
  dust_grain_species_graphite = 0,
  dust_grain_species_silicate,
  dust_grain_species_count
};

/**
 * @brief dust properties traced by the #part in the T20 model.
 */
struct dust_part_data {

  /*! Fraction of the particle mass in a given species of grain */
  float grain_mass_fraction[dust_grain_species_count];

  /*! Fraction of the diffused particle mass in a given species of grain */
  float dgrain_mass_fraction[dust_grain_species_count];
  /*! Fraction of the particle mass in *all* metals  <!! UNNEEDED? > */
  // float grain_mass_fraction_total;

  /*! Fraction of the dust-depleted iron mass from SNIa */
  float grain_iron_mass_fraction_from_SNIa;

  /*! Fraction of the diffused particle mass in iron depleted onto dust */
  float dgrain_iron_mass_fraction_from_SNIa;
};

/**
 * @brief dust properties traced by the #bpart in the T20 model.
 */
struct dust_bpart_data {

  /*! Mass in a given species of grain */
  float grain_mass[dust_grain_species_count];

  /*! Mass in a given species of grain */
  float grain_iron_mass_from_SNIa;

  /*! Mass in *all* grains <!! UNNEEDED?> */
  // float grain_mass_total;
};

#endif /* SWIFT_DUST_STRUCT_T20_H */
