#ifndef SWIFT_DUST_STRUCT_T20_H
#define SWIFT_DUST_STRUCT_T20_H

/**
 * @brief The individual composite grain species traced in the model.
 */
enum cgrain_species {
  dust_cgrain_species_graphite_l = 0,
  dust_cgrain_species_silicate_l,
  dust_cgrain_species_graphite_s,
  dust_cgrain_species_silicate_s,
  dust_cgrain_species_count
};

/**
 * @brief The individual unique grain species traced in the model (including
 * silicate subspecies).
 */
enum grain_species {
  dust_grain_species_graphite_l = 0,
  dust_grain_species_mgsilicate_l,
  dust_grain_species_fesilicate_l,
  dust_grain_species_graphite_s,
  dust_grain_species_mgsilicate_s,
  dust_grain_species_fesilicate_s,
  dust_grain_species_count
};

enum grain_molecule {
  dust_grain_molecule_graphite = 0,
  dust_grain_molecule_mgsilicate,
  dust_grain_molecule_fesilicate,
  dust_grain_molecule_count
};

/**
 * @brief Dust grain size bins used in the model
 */
enum dust_grain_chemistry {
  dust_grain_chemistry_graphite = 0,
  dust_grain_chemistry_silicate,
  dust_grain_chemistry_count
};

/**
 * @brief Dust silicate constituent elements
 */
enum dust_silicate_constituent {
  dust_silicate_constituent_O = 0,
  dust_silicate_constituent_Mg,
  dust_silicate_constituent_Si,
  dust_silicate_constituent_Fe,
  dust_silicate_constituent_count
};

/**
 * @brief Dust silicate constituent elements
 */
enum dust_mgsilicate_constituent {
  dust_mgsilicate_constituent_O = 0,
  dust_mgsilicate_constituent_Si,
  dust_mgsilicate_constituent_Mg,
  dust_mgsilicate_constituent_count
};

/**
 * @brief Dust silicate constituent elements
 */
enum dust_fesilicate_constituent {
  dust_fesilicate_constituent_O = 0,
  dust_fesilicate_constituent_Si,
  dust_fesilicate_constituent_Fe,
  dust_fesilicate_constituent_count
};

/**
 * @brief Dust graphite constituent elements
 */
enum dust_graphite_constistuent {
  dust_graphite_constituent_C = 0,
  dust_graphite_constituent_count
};

/**
 * @brief dust clumping factor mode select.
 */
enum clumping_mode {
  clumping_mode_constant = 0,
  clumping_mode_syncedchimes,
  clumping_mode_variable
};

/**
 * @brief dust properties traced by the #part in the T20 model.
 */
struct dust_part_data {

  /*! Fraction of the particle mass in a given species of grain */
  float grain_mass_fraction[dust_grain_species_count];

  /*! Fraction of the diffused particle mass in a given species of grain */
  float dgrain_mass_fraction[dust_grain_species_count];

  /*! Fraction of the dust-depleted iron mass from SNIa */
  float grain_iron_mass_fraction_from_SNIa;

  /*! Fraction of the diffused particle mass in iron depleted onto dust */
  float dgrain_iron_mass_fraction_from_SNIa;
};

/**
 * @brief dust properties traced by the #bpart in the T20 model.
 */
struct dust_bpart_data {

  /*! Mass in a given species of grain */
  float grain_mass[dust_grain_species_count];

  /*! Mass in a given species of grain */
  float grain_iron_mass_from_SNIa;

  /*! Mass in *all* grains <!! UNNEEDED?> */
  /* float grain_mass_total; */
};

#endif /* SWIFT_DUST_STRUCT_T20_H */
