#ifndef SWIFT_DUST_STRUCT_M16_H
#define SWIFT_DUST_STRUCT_M16_H

/**
 * @file src/dust/none/dust_struct.h
 * @brief Empty infrastructure for running without dust evolution
 */

/**
 * @brief The individual grain species traced in the model.
 */
enum grain_species {
  dust_grain_species_C = 0,
  dust_grain_species_O,
  dust_grain_species_Mg,
  dust_grain_species_Si,
  dust_grain_species_Fe,
  dust_grain_species_count
};

/**
 * @brief dust properties traced by the #part in the T20 model.
 */
struct dust_part_data {

  /*! Fraction of the particle mass in a given species of grain */
  float grain_mass_fraction[dust_grain_species_count];

  /*! Fraction of the diffused particle mass in a given species of grain */
  float dgrain_mass_fraction[dust_grain_species_count];

  /*! Fraction of the particle mass in *all* metals <!! UNNEEDED?> */
  // float grain_mass_fraction_total;
};

/**
 * @brief dust properties traced by the #bpart in the T20 model.
 */
struct dust_bpart_data {

  /*! Mass in a given species of grain */
  float grain_mass[dust_grain_species_count];

  /*! Mass in *all* grains <!! UNNEEDED?> */
  // float grain_mass_total;
};

#endif /* SWIFT_DUST_STRUCT_M16_H */
