/*******************************************************************************
 * This file is part of SWIFT.
 * Copyright (c) 2016 Matthieu Schaller (matthieu.schaller@durham.ac.uk)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/
#ifndef SWIFT_COOLING_STRUCT_CHIMES_H
#define SWIFT_COOLING_STRUCT_CHIMES_H

/**
 * @file src/cooling/CHIMES/cooling_struct.h
 * @brief Infrastructure for CHIMES cooling.
 */

#include "chimes/src/chimes_proto.h"

struct cooling_part_data {

  /*! Subgrid temperature */
  float subgrid_temp;

  /*! Subgrid density (internal units, physical frame) */
  float subgrid_dens;
};

/**
 * @brief Properties of the cooling stored in the particle data
 */
struct cooling_xpart_data {

  /* CHIMES abundance array */
  ChimesFloat chimes_abundances[CHIMES_NETWORK_SIZE];

  /* Cumulative energy radiated by the particle */
  float radiated_energy;

  /* Flag to indicate when the particle has been heated by feedback. */
  int heated_by_FB;

  /* Net cooling rate */
  float net_cooling_rate;

  /* Dust boost factor */
  float dust_boost_factor;
};

#endif /* SWIFT_COOLING_STRUCT_CHIMES_H */
